/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.DraftService;
import kd.taxc.tccit.business.draft.HznsqySeftSummaryService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.FzjgSeftSummaryPlugin;
import kd.taxc.tccit.formplugin.account.YhTaxCreditFormPlugin;

public class HznsqySeftSummaryPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    private static Log logger = LogFactory.getLog(HznsqySeftSummaryPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String ITEMNO = "itemno";
    public static final String ITEMTYPE = "itemtype";
    private static final String AMOUNT = "amount";
    private static final String TCCIT_SEFT_HZNSQY_SUMMARY = "tccit_seft_hznsqy_summary";
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final ArrayList<String> TOW_LIST = Lists.newArrayList((Object[])new String[]{"2a", "2b", "2c", "2d"});
    private static final String TCCIT_QYSDS_ZB = "tccit_qysds_zb";
    private static final String TCCIT_POLICY_CONFIRM = "tccit_policy_confirm";
    private static final String ENTRYTYPE = "fzjgsummary";
    private static final ArrayList<String> itemtypes = Lists.newArrayList((Object[])new String[]{"1", "2a", "2b", "2c", "2d", "2e", "2", "3", "3a", "3b", "3c", "3d", "4", "5"});
    private static final ArrayList<String> canAlterItemtypes = Lists.newArrayList((Object[])new String[]{"2a", "2b", "2c", "2d", "2e"});
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(128);

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        StringBuilder link = new StringBuilder("<nolink>");
        if (columnDesc.getEntryKey().equals(ENTRYENTITY) && !canAlterItemtypes.contains(d.getString(ITEMTYPE)) && AMOUNT.equals(columnDesc.getKey())) {
            BigDecimal amount = d.getBigDecimal(AMOUNT).setScale(2, 4);
            e.setFormatValue((Object)link.append(DataFormat.formatMicrometer(amount.toString())).toString());
        }
    }

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.buildForm();
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
        new FzjgSeftSummaryPlugin().calcSummery(customParams);
    }

    private void buildForm() {
        Date skssqz;
        Date skssqq;
        QFilter dateFilter;
        QFilter itemtypeFilter = new QFilter(ITEMTYPE, "in", itemtypes);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_SEFT_HZNSQY_SUMMARY, (String)" * ", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter = new QFilter(SKSSQQ, "=", (Object)(skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ))))).and(new QFilter(SKSSQZ, "=", (Object)(skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ))))))}, (String)"itemtype asc");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection entryentity = model.getEntryEntity(ENTRYENTITY);
        int rowIndex = 0;
        boolean isNew = entryentity.size() <= 0;
        for (DynamicObject object : query) {
            DynamicObject row = isNew ? entryentity.addNew() : (DynamicObject)entryentity.get(rowIndex);
            String itemType = object.getString(ITEMTYPE);
            row.set(ITEMNO, (Object)itemType);
            row.set(ITEMTYPE, (Object)itemType);
            row.set(AMOUNT, (Object)object.getBigDecimal(AMOUNT));
            ++rowIndex;
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        DraftService.clearCurrentPeriod(TCCIT_SEFT_HZNSQY_SUMMARY, orgid, skssqq, skssqz);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (String itemType : itemtypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_SEFT_HZNSQY_SUMMARY);
            dynamicObject.set(ITEMNO, (Object)itemType);
            dynamicObject.set(ITEMTYPE, (Object)itemType);
            dynamicObject.set(AMOUNT, this.calcAmount(itemType, AMOUNT, customParams));
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        Map<String, Object> result = this.checkAmountValue((List<DynamicObject>)sum, AMOUNT, ITEMNO);
        boolean success = (Boolean)result.get("success");
        if (success) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        } else {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25,\u7b2c%1$s\u884c\u6570\u636e\u8ba1\u5408\u8ba1\u7ed3\u679c\u4e3a%2$s,\u91d1\u989d\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d", (String)"HznsqySeftSummaryPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(msg, result.get(ITEMNO), result.get(AMOUNT)));
        }
    }

    private Map<String, Object> checkAmountValue(List<DynamicObject> sum, String field, String itemField) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        for (DynamicObject object : sum) {
            BigDecimal bigDecimal = object.getBigDecimal(field);
            String amountStr = String.valueOf(bigDecimal);
            String[] split = (amountStr = amountStr.replace("-", "")).split("\\.");
            if (split[0].length() <= 13) continue;
            result.put("success", false);
            result.put(field, object.getBigDecimal(field));
            result.put(itemField, object.getBigDecimal(itemField));
            return result;
        }
        return result;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get(ORGID);
        String skssqz = (String)customParams.get(SKSSQZ);
        if (name.equals(AMOUNT)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject rowDataObject = changeData.getDataEntity();
            Function<ArrayList, Object[]> idFunction = filters -> QueryServiceHelper.query((String)TCCIT_SEFT_HZNSQY_SUMMARY, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()])).stream().map(s -> s.get("id")).toArray();
            ArrayList<QFilter> qfilters = DraftService.getQfilters(this.getView().getFormShowParameter().getCustomParams());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])idFunction.apply(qfilters), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCCIT_SEFT_HZNSQY_SUMMARY));
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                Object o = changeData.getNewValue() == null ? BigDecimal.ZERO : changeData.getNewValue();
                BigDecimal o1 = o instanceof String ? new BigDecimal(String.valueOf(o)) : (BigDecimal)o;
                Map<String, DynamicObject> collect = Arrays.stream(dynamicObjects).collect(Collectors.toMap(a -> a.getString(ITEMTYPE), b -> b, (m, n) -> n));
                DynamicObject dynamicObject = collect.get(rowDataObject.getString(ITEMTYPE));
                if (dynamicObject != null) {
                    if (o1.compareTo(BigDecimal.ZERO) < 0) {
                        o1 = BigDecimal.ZERO;
                        this.getModel().setValue(AMOUNT, (Object)BigDecimal.ZERO, changeData.getRowIndex());
                    }
                    dynamicObject.set(AMOUNT, (Object)o1);
                }
                DynamicObject dynamicObject2 = collect.get("2");
                BigDecimal amount2 = BigDecimal.ZERO;
                for (String string : TOW_LIST) {
                    DynamicObject obj = collect.get(string);
                    amount2 = amount2.add(obj == null ? BigDecimal.ZERO : obj.getBigDecimal(AMOUNT));
                }
                dynamicObject2.set(AMOUNT, (Object)amount2);
                DynamicObject dynamicObject3 = collect.get("3");
                DynamicObject dynamicObject1 = collect.get("1");
                BigDecimal amount1 = dynamicObject1 == null ? BigDecimal.ZERO : dynamicObject1.getBigDecimal(AMOUNT);
                BigDecimal amount3 = amount1.subtract(amount2);
                dynamicObject3.set(AMOUNT, (Object)amount3);
                DynamicObject dynamicObject3a = collect.get("3a");
                DynamicObject dynamicObject3b = collect.get("3b");
                DynamicObject dynamicObject3c = collect.get("3c");
                DynamicObject dynamicObject3d = collect.get("3d");
                DynamicObject dynamicObject4 = collect.get("4");
                BigDecimal amount3a = amount3.multiply(this.getRate(orgid, skssqz, "zjgftbl").divide(new BigDecimal(100), 2, 4));
                BigDecimal amount3b = amount3.multiply(this.getRate(orgid, skssqz, "czjzfpbl").divide(new BigDecimal(100), 2, 4));
                BigDecimal amount3c = amount3.multiply(this.getRate(orgid, skssqz, "fzjgftbl").divide(new BigDecimal(100), 2, 4));
                dynamicObject3a.set(AMOUNT, (Object)amount3a);
                dynamicObject3b.set(AMOUNT, (Object)amount3b);
                dynamicObject3c.set(AMOUNT, (Object)amount3c);
                BigDecimal amount5 = amount3a.add(amount3a).add(dynamicObject3d.getBigDecimal(AMOUNT)).add(dynamicObject4.getBigDecimal(AMOUNT));
                DynamicObject dynamicObject5 = collect.get("5");
                dynamicObject5.set(AMOUNT, (Object)amount5);
                Object[] save = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                this.buildForm();
            }
        }
    }

    private Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        DynamicObjectCollection yjSbb;
        BigDecimal one;
        BigDecimal adjustAmount;
        BigDecimal amount = BigDecimal.ZERO;
        if ("1".equals(rowType)) {
            String skssqq = (String)customParams.get(SKSSQQ);
            String skssqz = (String)customParams.get(SKSSQZ);
            String orgid = (String)customParams.get(ORGID);
            int yearOfDate = DateUtils.getYearOfDate((Date)DateUtils.stringToDate((String)skssqq));
            QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)DateUtils.stringToDate2((String)skssqq)).and(new QFilter(SKSSQZ, "=", (Object)DateUtils.stringToDate2((String)skssqz)));
            QFilter qFilter = new QFilter("nd", "=", (Object)String.valueOf(yearOfDate)).and(ORGID, "=", (Object)Long.valueOf(orgid)).and(dateFilter);
            DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_yh_taxcredit_data", (String)"ynamount", (QFilter[])qFilter.toArray());
            BigDecimal bigDecimal = amount = object == null ? amount : object.getBigDecimal("ynamount");
        }
        if ("2".equals(rowType)) {
            amount = DraftService.getSum(TOW_LIST, columnType, this.dataMap);
        }
        if ("2a".equals(rowType)) {
            adjustAmount = this.getAdjustAmount(customParams, rowType);
            if (adjustAmount != null) {
                this.dataMap.put(DraftService.getKey(rowType, columnType), adjustAmount);
                return adjustAmount;
            }
            one = this.getOne(customParams, rowType);
            if (one != null) {
                amount = one;
            } else {
                yjSbb = this.getYjSbb((String)customParams.get(ORGID), (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ));
                if (EmptyCheckUtils.isNotEmpty((Object)yjSbb)) {
                    amount = yjSbb.stream().map(a -> a.getBigDecimal("tdywyjzsdse")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (amount.compareTo(BigDecimal.ZERO) < 0) {
                    amount = BigDecimal.ZERO;
                }
            }
        }
        if ("2b".equals(rowType)) {
            adjustAmount = this.getAdjustAmount(customParams, rowType);
            if (adjustAmount != null) {
                this.dataMap.put(DraftService.getKey(rowType, columnType), adjustAmount);
                return adjustAmount;
            }
            one = this.getOne(customParams, rowType);
            if (one != null) {
                amount = one;
            } else {
                yjSbb = this.getYjSbb((String)customParams.get(ORGID), (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ));
                if (EmptyCheckUtils.isNotEmpty((Object)yjSbb)) {
                    amount = yjSbb.stream().map(a -> a.getBigDecimal("zjgftybtsdse")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (amount.compareTo(BigDecimal.ZERO) < 0) {
                    amount = BigDecimal.ZERO;
                }
            }
        }
        if ("2c".equals(rowType)) {
            adjustAmount = this.getAdjustAmount(customParams, rowType);
            if (adjustAmount != null) {
                this.dataMap.put(DraftService.getKey(rowType, columnType), adjustAmount);
                return adjustAmount;
            }
            one = this.getOne(customParams, rowType);
            if (one != null) {
                amount = one;
            } else {
                yjSbb = this.getYjSbb((String)customParams.get(ORGID), (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ));
                if (EmptyCheckUtils.isNotEmpty((Object)yjSbb)) {
                    amount = yjSbb.stream().map(a -> a.getBigDecimal("czjzfpybtsdse")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (amount.compareTo(BigDecimal.ZERO) < 0) {
                    amount = BigDecimal.ZERO;
                }
            }
        }
        if ("2d".equals(rowType)) {
            adjustAmount = this.getAdjustAmount(customParams, rowType);
            if (adjustAmount != null) {
                this.dataMap.put(DraftService.getKey(rowType, columnType), adjustAmount);
                return adjustAmount;
            }
            one = this.getOne(customParams, rowType);
            if (one != null) {
                amount = one;
            } else {
                DynamicObjectCollection objects = OrgGroupService.queryOrgGroupDetailForCollectedOrg("qysds", (String)customParams.get(ORGID), (String)customParams.get(SKSSQZ));
                if (!CollectionUtils.isEmpty((Collection)objects)) {
                    List orgIds = objects.stream().map(s -> s.getLong(ORGID)).collect(Collectors.toList());
                    amount = orgIds.stream().flatMap(s -> {
                        DynamicObjectCollection yjSbb = this.getYjSbb(String.valueOf(s), (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ));
                        return CollectionUtils.isEmpty((Collection)yjSbb) ? new DynamicObjectCollection().stream() : yjSbb.stream();
                    }).map(a -> a.getBigDecimal("fzjgbqftybtsdse")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (amount.compareTo(BigDecimal.ZERO) < 0) {
                    amount = BigDecimal.ZERO;
                }
            }
        }
        if ("2e".equals(rowType)) {
            adjustAmount = this.getAdjustAmount(customParams, rowType);
            if (adjustAmount != null) {
                return adjustAmount;
            }
            one = this.getOne(customParams, rowType);
            if (one != null) {
                amount = one;
            } else {
                yjSbb = this.getYjSbb((String)customParams.get(ORGID), (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ));
                if (EmptyCheckUtils.isNotEmpty((Object)yjSbb)) {
                    amount = yjSbb.stream().map(a -> a.getBigDecimal("zjgztscjybmftsdse")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (amount.compareTo(BigDecimal.ZERO) < 0) {
                    amount = BigDecimal.ZERO;
                }
            }
        }
        if ("3".equals(rowType)) {
            amount = this.dataMap.get(DraftService.getKey("1", columnType)).subtract(this.dataMap.get(DraftService.getKey("2", columnType)));
        }
        if ("3a".equals(rowType)) {
            DynamicObject groupScheme = HznsqySeftSummaryService.getGroupScheme(Long.parseLong((String)customParams.get(ORGID)), DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ))));
            if (null != groupScheme && groupScheme.getBoolean("participation")) {
                String unifiedSocialCreditCode = HznsqySeftSummaryService.getUnifiedSocialCreditCode(Long.parseLong((String)customParams.get(ORGID)));
                amount = HznsqySeftSummaryService.getAmount(Long.parseLong((String)customParams.get(ORGID)), DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ))), DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ))), unifiedSocialCreditCode);
            } else {
                BigDecimal bigDecimal = this.dataMap.get(DraftService.getKey("3", columnType));
                amount = bigDecimal.multiply(this.getRate((String)customParams.get(ORGID), (String)customParams.get(SKSSQZ), "zjgftbl")).setScale(2, 4);
            }
        }
        if ("3b".equals(rowType)) {
            BigDecimal bigDecimal = this.dataMap.get(DraftService.getKey("3", columnType));
            amount = bigDecimal.multiply(this.getRate((String)customParams.get(ORGID), (String)customParams.get(SKSSQZ), "czjzfpbl")).setScale(2, 4);
        }
        if ("3c".equals(rowType)) {
            BigDecimal row3 = this.dataMap.get(DraftService.getKey("3", columnType));
            BigDecimal row3a = this.dataMap.get(DraftService.getKey("3a", columnType));
            BigDecimal row3b = this.dataMap.get(DraftService.getKey("3b", columnType));
            amount = row3.subtract(row3a).subtract(row3b).setScale(2, 4);
        }
        if ("3d".equals(rowType)) {
            ArrayList<QFilter> qfilters = DraftService.getQfilters(customParams);
            String fzjgmc = ResManager.loadKDString((String)"\uff08\u72ec\u7acb\u751f\u4ea7\u7ecf\u8425\u90e8\u95e8\uff09", (String)"HznsqySeftSummaryPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
            qfilters.add(new QFilter("entryentity.fzjgmc", "like", (Object)("%" + fzjgmc + "%")));
            DynamicObjectCollection fzjg_summary = QueryServiceHelper.query((String)"tccit_seft_fzjg_summary", (String)" id,orgid,entryentity.fpsdse ", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
            if (EmptyCheckUtils.isNotEmpty((Object)fzjg_summary) && ((DynamicObject)fzjg_summary.get(0)).get("entryentity.fpsdse") != null) {
                amount = ((DynamicObject)fzjg_summary.get(0)).getBigDecimal("entryentity.fpsdse");
            }
        }
        if ("4".equals(rowType)) {
            // empty if block
        }
        if ("5".equals(rowType)) {
            amount = DraftService.getSum(Lists.newArrayList((Object[])new String[]{"3a", "3b", "3d", "4"}), columnType, this.dataMap);
        }
        this.dataMap.put(DraftService.getKey(rowType, columnType), amount);
        return amount;
    }

    private BigDecimal getAdjustAmount(Map<String, Object> customParams, String rowType) {
        DynamicObject dynamicObject = this.getAdjust(customParams, rowType);
        if (dynamicObject != null) {
            return dynamicObject.getBigDecimal("totalamount");
        }
        return null;
    }

    private BigDecimal getAdjustOriginalAmount(Map<String, Object> customParams, String rowType) {
        DynamicObject dynamicObject = this.getAdjust(customParams, rowType);
        if (dynamicObject != null) {
            BigDecimal totalamount = dynamicObject.getBigDecimal("totalamount");
            BigDecimal adjustamount = dynamicObject.getBigDecimal("adjustamount");
            return totalamount.subtract(adjustamount);
        }
        return null;
    }

    private DynamicObject getAdjust(Map<String, Object> customParams, String rowType) {
        String itemnumber = rowType + "_" + ENTRYTYPE;
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_")));
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)ENTRYTYPE);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,totalamount,titlename,adjustexplain";
        return QueryServiceHelper.queryOne((String)"tccit_adjust_detail", (String)selectPrope, (QFilter[])filters);
    }

    private DynamicObjectCollection getYjSbb(String orgid, String skssqq, String skssqz) {
        String selectFields = "id,tdywyjzsdse,zjgftybtsdse,czjzfpybtsdse,fzjgbqftybtsdse,zjgztscjybmftsdse";
        List<Object> yjSbbids = this.getYjSbbids(orgid, skssqq, skssqz);
        if (EmptyCheckUtils.isNotEmpty(yjSbbids)) {
            QFilter qFilter = new QFilter("ewblxh", "=", (Object)"1");
            QFilter qFilter1 = new QFilter("sbbid", "in", yjSbbids);
            return QueryServiceHelper.query((String)TCCIT_QYSDS_ZB, (String)selectFields, (QFilter[])new QFilter[]{qFilter, qFilter1});
        }
        return null;
    }

    private List<Object> getYjSbbids(String orgid, String skssqq, String skssqz) {
        String taxLimit = TaxBaseDataUtils.getTaxLimit((String)"qysds", (Long)Long.valueOf(orgid));
        ArrayList<Object> arrayList = new ArrayList<Object>(16);
        if (StringUtil.equals((CharSequence)taxLimit, (CharSequence)"aysb")) {
            DynamicObjectCollection dynamicObjectCollection = YbnsrService.querySbbs((List)Lists.newArrayList((Object[])new String[]{orgid}), (String)"qysdsjb", (String)"month", (String)skssqq, (String)skssqz);
            arrayList.addAll(dynamicObjectCollection.stream().map(a -> a.getString("id")).collect(Collectors.toList()));
        } else if (StringUtil.equals((CharSequence)taxLimit, (CharSequence)"ajsb")) {
            DynamicObjectCollection dynamicObjectCollection = YbnsrService.querySbbs((List)Lists.newArrayList((Object[])new String[]{orgid}), (String)"qysdsjb", (String)"season", (String)skssqq, (String)skssqz);
            arrayList.addAll(dynamicObjectCollection.stream().map(a -> a.getString("id")).collect(Collectors.toList()));
        }
        return arrayList;
    }

    public BigDecimal getOne(Map<String, Object> customParams, String itemtype) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter itemtypeFilter = new QFilter(ITEMTYPE, "=", (Object)itemtype);
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DynamicObject one = QueryServiceHelper.queryOne((String)TCCIT_SEFT_HZNSQY_SUMMARY, (String)AMOUNT, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        return one != null ? one.getBigDecimal(AMOUNT) : null;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        DraftService.clearCurrentPeriod(TCCIT_SEFT_HZNSQY_SUMMARY, orgid, skssqq, skssqz);
    }

    private BigDecimal getRate(String orgid, String endDate, String type) {
        QFilter qFilter = new QFilter(ORGID, "=", (Object)Long.parseLong(orgid));
        QFilter qFilter1 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)endDate));
        DynamicObject dyo = QueryServiceHelper.queryOne((String)TCCIT_POLICY_CONFIRM, (String)"declaretype,zjgftbl,czjzfpbl,fzjgftbl", (QFilter[])new QFilter[]{qFilter, qFilter1});
        BigDecimal rate = new BigDecimal(0);
        if (null != dyo && "210".equals(dyo.getString("declaretype"))) {
            if ("zjgftbl".equals(type)) {
                rate = dyo.getString("zjgftbl") != null ? new BigDecimal(dyo.getString("zjgftbl")) : new BigDecimal("0.5");
            } else if ("czjzfpbl".equals(type)) {
                rate = dyo.getString("zjgftbl") != null ? new BigDecimal(dyo.getString("czjzfpbl")) : new BigDecimal("0.25");
            } else if (dyo.getString("fzjgftbl") != null) {
                rate = new BigDecimal(dyo.getString("fzjgftbl"));
            } else {
                new BigDecimal("0.25");
            }
        }
        return rate;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String rowType = (String)itemsEntity.getModel().getValue(ITEMTYPE);
        String columnType = evt.getFieldName();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        BigDecimal originalamount = this.getOne(customParams, rowType);
        BigDecimal adjustOriginalAmount = this.getAdjustOriginalAmount(customParams, rowType);
        customParams.put("columnType", columnType);
        customParams.put("entrytype", ENTRYTYPE);
        customParams.put("itemnumber", rowType + "_" + ENTRYTYPE);
        customParams.put("originalamount", adjustOriginalAmount == null ? originalamount : adjustOriginalAmount);
        customParams.put("existsRules", Boolean.FALSE);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tccit_detail_tz_dialog");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{AMOUNT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEMTYPE);
        customParams.put("entrytype", ENTRYTYPE);
        customParams.put("columnType", column);
        customParams.put("itemnumber", itemtype + "_" + ENTRYTYPE);
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(HznsqySeftSummaryPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{YhTaxCreditFormPlugin.class.getSimpleName(), FzjgSeftSummaryPlugin.class.getSimpleName()}));
            }
        };
    }
}

