/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public abstract class InComeZcCommTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ITEM_NAME = "itemname";
    public static final String RULE_ID = "ruleid";
    public static final String ZZJE = "zzje";
    public static final String TAX_AMOUNT = "taxamount";
    public static final String NSTZJE = "nstzje";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initData(String summaryEntryName, Set<String> itemTypes) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,ruleid,itemname,zzje,taxamount,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)summaryEntryName, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_NAME).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NAME));
            String ruleid = dynamicObject.getString(RULE_ID);
            dot.getProperty(RULE_ID).setValueFast((Object)data, (Object)ruleid);
            dot.getProperty(ZZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, ZZJE, ruleid));
            dot.getProperty(TAX_AMOUNT).setValueFast((Object)data, (Object)this.formatData(dynamicObject, TAX_AMOUNT, ruleid));
            dot.getProperty(NSTZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, NSTZJE, ruleid));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(DynamicObject dynamicObject, String columnType, String ruleId) {
        StringBuilder link = new StringBuilder("<nolink>");
        BigDecimal amount = dynamicObject.getBigDecimal(columnType).setScale(2, 4);
        if ("0".equals(ruleId) || StringUtil.isBlank((CharSequence)ruleId)) {
            if (columnType.equals(NSTZJE)) {
                return DataFormat.formatMicrometer(amount.toString());
            }
            return link.append(DataFormat.formatMicrometer(amount.toString())).toString();
        }
        return DataFormat.formatMicrometer(amount.toString());
    }

    public DynamicObjectCollection calc(Map<String, Object> customParams, String summaryEntryName, Set<String> itemTypes, String ruleDetailEntryName, RuleTypeEnum typeEnum) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz, summaryEntryName, itemTypes);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), typeEnum);
        sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && itemTypes.contains(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sellRuleList)) {
            return null;
        }
        int index = 0;
        for (DynamicObject dynamicObject : sellRuleList) {
            DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)summaryEntryName);
            dynamicObject2.set(ITEM_NO, (Object)(++index));
            dynamicObject2.set(ITEM_TYPE, (Object)itemTypes.stream().filter(s -> !s.equals("count")).findFirst().get());
            dynamicObject2.set(ITEM_NAME, (Object)dynamicObject.getString("name"));
            dynamicObject2.set(RULE_ID, (Object)dynamicObject.getString("id"));
            dynamicObject2.set(ZZJE, (Object)this.calcAmount(dynamicObject.getString("id"), ZZJE, customParams, ruleDetailEntryName));
            dynamicObject2.set(TAX_AMOUNT, (Object)this.calcAmount(dynamicObject.getString("id"), TAX_AMOUNT, customParams, ruleDetailEntryName));
            dynamicObject2.set(NSTZJE, (Object)this.calcAmount(dynamicObject.getString("id"), NSTZJE, customParams, ruleDetailEntryName));
            dynamicObject2.set("orgid", (Object)orgid);
            dynamicObject2.set("skssqq", (Object)skssqq);
            dynamicObject2.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject2);
        }
        this.appendRow(orgid, skssqq, skssqz, sum, index, summaryEntryName);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    protected void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz, String summaryEntryName, Set<String> itemTypes) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)summaryEntryName, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private void appendRow(Long orgid, Date skssqq, Date skssqz, DynamicObjectCollection sum, int index, String summaryEntryName) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)summaryEntryName);
        dynamicObject.set(ITEM_NO, (Object)(++index));
        dynamicObject.set(ITEM_TYPE, (Object)"count");
        dynamicObject.set(ITEM_NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InComeZcCommTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        dynamicObject.set(ZZJE, this.getSum(ZZJE));
        dynamicObject.set(TAX_AMOUNT, this.getSum(TAX_AMOUNT));
        dynamicObject.set(NSTZJE, this.getSum(NSTZJE));
        dynamicObject.set("orgid", (Object)orgid);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        sum.add((Object)dynamicObject);
    }

    private Object getSum(String columnType) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : this.dataMap.entrySet()) {
            if (!entry.getKey().endsWith(columnType)) continue;
            sum = sum.add(entry.getValue());
        }
        return sum;
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, String ruleDetailEntryName) {
        if (ZZJE.equals(columnType)) {
            BigDecimal amount = this.getAmount(rowType, customParams, columnType, ZZJE, ruleDetailEntryName);
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if (TAX_AMOUNT.equals(columnType)) {
            BigDecimal taxAmount = this.getAmount(rowType, customParams, columnType, "ssje", ruleDetailEntryName);
            this.dataMap.put(this.getKey(rowType, columnType), taxAmount);
            return taxAmount;
        }
        if (NSTZJE.equals(columnType)) {
            BigDecimal zzjeAmount = this.dataMap.get(this.getKey(rowType, ZZJE));
            BigDecimal taxAmount = this.dataMap.get(this.getKey(rowType, TAX_AMOUNT));
            BigDecimal taxIncome = BigDecimal.ZERO;
            taxIncome = "tccit_zctz_other_det".equals(ruleDetailEntryName) ? zzjeAmount.subtract(taxAmount).setScale(2, 4) : taxAmount.subtract(zzjeAmount).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), taxIncome);
            return taxIncome;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(String ruleid, Map<String, Object> customParams, String columnType, String entrytype, String ruleDetailEntryName) {
        return this.getCellAmount(customParams, columnType, entrytype, null, null, Long.valueOf(ruleid), ruleDetailEntryName);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULE_ID));
        if (ruleid.equals("0")) {
            return;
        }
        String fieldName = evt.getFieldName();
        String entrytype = fieldName.equals(ZZJE) ? ZZJE : "ssje";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", entrytype);
        customParams.put(RULE_ID, ruleid);
        customParams.put("itemnumber", ruleid);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }
}

