/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.common.enums.DraftSummaryEnum;
import kd.taxc.tccit.formplugin.account.AssetDisposeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.GyjzbdsyTZFormPlugin;
import kd.taxc.tccit.formplugin.account.IncomeOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.InvestProfitTZFormPlugin;
import kd.taxc.tccit.formplugin.account.RightsIncomeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SaleZkzrthTZFormPlugin;
import kd.taxc.tccit.formplugin.account.TzzccscbtzTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ZeroRatingFormPlugin;
import kd.taxc.tccit.formplugin.draft.AbstractSummaryPlugin;

public class IncomeAdjustFormPlugin
extends AbstractSummaryPlugin {
    private static final ArrayList<String> ARRAY_LIST = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});

    @Override
    public Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        BigDecimal result = BigDecimal.ZERO;
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        int currentYear = DateUtils.getYearOfDate((Date)skssqq);
        QFilter yearFilter = new QFilter("entryentity.year", "=", (Object)currentYear);
        ArrayList<QFilter> baseQfilters = this.getBaseQfilters(customParams);
        switch (rowType) {
            case "1": {
                ArrayList itemNoList = Lists.newArrayList((Object[])new Integer[]{2, 3, 4, 6, 7, 8, 10, 11, 12, 13});
                QFilter rowTypeFilter = new QFilter("itemno", "in", (Object)itemNoList);
                baseQfilters.add(rowTypeFilter);
                result = this.getSum(rowType, columnType, "tccit_right_income_sum", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "2": {
                baseQfilters.add(yearFilter);
                result = this.getSum(rowType, columnType, "tccit_zero_rating_summary", "sum(entryentity.incomeamount) as incomeamount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "incomeamount").multiply(new BigDecimal("-1"));
                break;
            }
            case "3": {
                baseQfilters.add(yearFilter);
                result = this.getSum(rowType, columnType, "tccit_zero_rating_summary", "sum(entryentity.expensingamount) as expensingamount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "expensingamount");
                break;
            }
            case "4": {
                baseQfilters.add(yearFilter);
                result = this.getSum(rowType, columnType, "tccit_zero_rating_summary", "sum(entryentity.includedtaxamount) as includedtaxamount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "includedtaxamount");
                break;
            }
            case "5": {
                result = this.getSum(rowType, columnType, "tccit_invest_profit_sum", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "6": {
                result = this.getSum(rowType, columnType, "tccit_asset_dispose_sum", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "7": {
                result = this.getSum(rowType, columnType, "tccit_tzzccscbtz_summary", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "8": {
                result = this.getSum(rowType, columnType, "tccit_gyjzbdsy_summary", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "9": {
                result = this.getSum(rowType, columnType, "tccit_sale_zkzrth_summary", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "10": {
                result = this.getSum(rowType, columnType, "tccit_income_other_sum", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje").divide(new BigDecimal("2"));
                break;
            }
            case "11": {
                result = this.getSum(ARRAY_LIST, "amount");
                break;
            }
        }
        return result;
    }

    @Override
    public DraftSummaryEnum getDraftSummaryEnum() {
        return DraftSummaryEnum.INCOMEADJUST;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, DraftSummaryEnum.INCOMEADJUST.getBill());
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(IncomeAdjustFormPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{RightsIncomeTZFormPlugin.class.getSimpleName(), ZeroRatingFormPlugin.class.getSimpleName(), InvestProfitTZFormPlugin.class.getSimpleName(), AssetDisposeTZFormPlugin.class.getSimpleName(), TzzccscbtzTZFormPlugin.class.getSimpleName(), GyjzbdsyTZFormPlugin.class.getSimpleName(), SaleZkzrthTZFormPlugin.class.getSimpleName(), IncomeOtherTZFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

