/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.DiscountType;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.draft.NontaxService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;
import org.apache.commons.lang3.StringUtils;

public class IncredFormPlugin
extends AbstractAccountPlugin
implements HyperLinkClickListener,
IDraftTypeObserver {
    private static final String TAXORG = "taxorg";
    private static final String ID = "id";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String TAXPAYER = "taxpayer";
    private BigDecimal wbw = new BigDecimal("5000000");
    private BigDecimal TWO_THOUSAND_W = new BigDecimal("20000000");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean readonly;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        IDataModel model = this.getModel();
        DynamicObject[] adjustAmount = this.getAdjustAmount(customParams, draftTypeObjectVo);
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getYjIncred().getNumber(), (String)"serialno,taxorg,org,skssqq,skssqz,rule,discounttype,reductratio,incredincome,incredpresent,incredtotal", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
        if (adjustAmount.length > 0) {
            genericObjects = this.mergeSaveData(genericObjects, adjustAmount);
        }
        this.getModel().deleteEntryData("entryentity");
        if (genericObjects.length > 0) {
            BigDecimal decimal = new BigDecimal(100);
            model.batchCreateNewEntryRow("entryentity", genericObjects.length);
            DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
            DynamicObjectType dot = entryentity.getDynamicObjectType();
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
                dot.getProperty("serialno").setValueFast((Object)data, dynamicObject.get("serialno"));
                dot.getProperty(TAXORG).setValueFast((Object)data, dynamicObject.get(TAXORG));
                DynamicObject taxorg = QueryServiceHelper.queryOne((String)BASTAX_TAXORG, (String)TAXPAYER, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)dynamicObject.getDynamicObject(TAXORG).getLong(ID))});
                String taxpayer = taxorg.getString(TAXPAYER);
                dot.getProperty(TAXPAYER).setValueFast((Object)data, (Object)taxpayer);
                dot.getProperty("discounttype").setValueFast((Object)data, dynamicObject.get("discounttype"));
                BigDecimal reductratio = dynamicObject.getBigDecimal("reductratio");
                dot.getProperty("reductratio").setValueFast((Object)data, (Object)(reductratio.multiply(decimal).setScale(0).toPlainString() + "%"));
                dot.getProperty("incredrule").setValueFast((Object)data, dynamicObject.get("rule"));
                dot.getProperty("incredincome").setValueFast((Object)data, dynamicObject.get("incredincome"));
                dot.getProperty("incredpresent").setValueFast((Object)data, dynamicObject.get("incredpresent"));
                dot.getProperty("incredtotal").setValueFast((Object)data, dynamicObject.get("incredtotal"));
                ++rowIndex;
            }
            this.getView().updateView("entryentity");
        }
        if (readonly = ((Boolean)this.getView().getFormShowParameter().getCustomParam("readonly")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String entrytype = evt.getFieldName();
        Object serialno = this.getModel().getValue("serialno", rowIndex);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String taxorg = String.valueOf(((DynamicObject)itemsEntity.getModel().getValue(TAXORG)).get(0));
        String ruleid = String.valueOf(((DynamicObject)this.getModel().getValue("incredrule")).get(ID));
        customParams.put(TAXORG, taxorg);
        customParams.put("columnType", entrytype);
        customParams.put("entrytype", entrytype);
        customParams.put("itemnumber", ruleid);
        customParams.put("ruleid", ruleid);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        customParams.put("entryname", draftTypeObjectVo.getYjIncred().getDetail());
        customParams.put("taxaccountserialno", serialno);
        customParams.put("draftpurpose", customParams.getOrDefault("draftpurpose", "nssb"));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParams(customParams);
        parameter.setFormId("tccit_detail_tz_dialog");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(parameter);
    }

    private DynamicObject[] mergeSaveData(DynamicObject[] dynamicObjects, DynamicObject[] adjustAmounts) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Object orgid = customParams.get("orgid");
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        Date startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter q2 = new QFilter("skssqq", ">=", (Object)startDate);
        QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)endDate));
        Map<Object, Object> lastTaxMap = new HashMap();
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        if ("season".equals(taxLimit)) {
            if (startDate.getMonth() >= 3) {
                lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 3, draftTypeObjectVo.getYjIncred().getNumber());
            }
        } else if (startDate.getMonth() >= 1) {
            lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 1, draftTypeObjectVo.getYjIncred().getNumber());
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject rule = dynamicObject.getDynamicObject("rule");
            String ruleid = dynamicObject.getString("rule_id");
            long taxorgid = dynamicObject.getLong("taxorg_id");
            DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("ruleid").equals(ruleid)).filter(s -> s.getLong(TAXORG) == taxorgid).collect(Collectors.toCollection(DynamicObjectCollection::new));
            if (CollectionUtils.isEmpty((Collection)collect)) continue;
            BigDecimal adjustAmount = collect.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            dynamicObject.set("incredincome", (Object)adjustAmount);
            Date datefield = rule.getDate("datefield");
            String discounttype = dynamicObject.getString("discounttype");
            BigDecimal reductionRatio = this.getReductionRatio(discounttype, startDate, datefield);
            BigDecimal incredpresent = this.getIncredpresent(adjustAmount, discounttype, reductionRatio);
            dynamicObject.set("incredpresent", (Object)incredpresent);
            BigDecimal lastIncredtotal = (BigDecimal)lastTaxMap.get(taxorgid + "#" + rule.getString(ID));
            dynamicObject.set("incredtotal", (Object)BigDecimalUtil.addObject((Object)incredpresent, (Object)lastIncredtotal));
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                DeleteServiceHelper.delete((String)draftTypeObjectVo.getNontaxSummaryM().getNumber(), (QFilter[])new QFilter[]{q1, q2, q3, new QFilter("type", "=", (Object)"3")});
                NontaxService.handleSummaryMiddle(Arrays.stream(dynamicObjects).collect(Collectors.toList()), "3", "incredtotal", 3, true, 1, draftTypeObjectVo.getNontaxSummaryM().getNumber());
                this.recalcRecoupDeficit(draftTypeObjectVo, "IncredEngine_summary", Arrays.stream(dynamicObjects).collect(Collectors.toList()), customParams);
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        return dynamicObjects;
    }

    private Map<String, BigDecimal> getLastPeriodBigDecimalMap(Date startDate, Date endDate, QFilter orgFilter, int monthcount, String entityName) {
        Date date = DateUtils.addMonth((Date)startDate, (int)(-monthcount));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)date);
        Date d2 = DateUtils.addMonth((Date)endDate, (int)(-monthcount));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)d2)));
        DynamicObjectCollection lastCols = QueryServiceHelper.query((String)entityName, (String)"taxorg,rule,incredtotal", (QFilter[])new QFilter[]{skssqqFilter, skssqzFilter, orgFilter});
        Map<String, BigDecimal> lastTaxMap = lastCols.stream().collect(Collectors.toMap(e -> e.getLong(TAXORG) + "#" + e.getLong("rule"), f -> f.getBigDecimal("incredtotal")));
        return lastTaxMap;
    }

    private BigDecimal getReductionRatio(String discounttype, Date startDate, Date datefield) {
        int diff = 0;
        int year = DateUtils.getYearOfDate((Date)startDate);
        if (datefield != null) {
            int year1 = DateUtils.getYearOfDate((Date)datefield);
            diff = year - year1;
        }
        BigDecimal redctionRatio = DiscountType.getRate((String)discounttype);
        switch (discounttype) {
            case "5": {
                if (diff >= 0 && diff < 3) {
                    redctionRatio = new BigDecimal("1");
                    break;
                }
                if (diff >= 3 && diff <= 5) {
                    redctionRatio = new BigDecimal("0.5");
                    break;
                }
                redctionRatio = new BigDecimal("0");
                break;
            }
            case "7": {
                if (diff >= 0 && diff < 2) {
                    redctionRatio = new BigDecimal("1");
                    break;
                }
                if (diff >= 2 && diff <= 4) {
                    redctionRatio = new BigDecimal("0.5");
                    break;
                }
                redctionRatio = new BigDecimal("0");
                break;
            }
            case "8": {
                if (diff >= 0 && diff < 5) {
                    redctionRatio = new BigDecimal("1");
                    break;
                }
                if (diff >= 5 && diff <= 9) {
                    redctionRatio = new BigDecimal("0.5");
                    break;
                }
                redctionRatio = new BigDecimal("0");
                break;
            }
            case "13": {
                if (diff < 0) {
                    redctionRatio = new BigDecimal("0");
                    break;
                }
                if (diff >= 0 && diff <= 9) {
                    redctionRatio = new BigDecimal("1");
                    break;
                }
                redctionRatio = new BigDecimal("0");
                break;
            }
        }
        return redctionRatio;
    }

    private BigDecimal getIncredpresent(BigDecimal incredincome, String discounttype, BigDecimal reductRatio) {
        BigDecimal incredpresent = null;
        incredpresent = "6".equals(discounttype) && incredincome.compareTo(this.wbw) > 0 ? incredincome.subtract(this.wbw).multiply(reductRatio).add(this.wbw) : ("12".equals(discounttype) && incredincome.compareTo(this.TWO_THOUSAND_W) > 0 ? incredincome.subtract(this.TWO_THOUSAND_W).multiply(reductRatio).add(this.TWO_THOUSAND_W) : BigDecimalUtil.multiplyObject((Object)incredincome, (Object)reductRatio, (int)2));
        return incredpresent;
    }

    private DynamicObject[] getAdjustAmount(Map<String, Object> customParams, DraftTypeObjectVo draftTypeObjectVo) {
        String ruleid = (String)customParams.get("ruleid");
        if (StringUtils.isBlank((CharSequence)ruleid)) {
            return new DynamicObject[0];
        }
        QFilter ruleIdFilter = new QFilter("ruleid", "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)ruleid).or(new QFilter("itemnumber", "=", (Object)(ruleid + "_")));
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, ruleIdFilter, itemnumberFilter};
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,totalamount,itemnumber";
        return BusinessDataServiceHelper.load((String)draftTypeObjectVo.getAdjustDetail().getNumber(), (String)selectPrope, (QFilter[])filters);
    }

    @Override
    public Set<String> adaptDraftCellName(Set<String> rowSet) {
        return Collections.singleton("incredincome");
    }

    @Override
    public Map<String, Object> createParams(DynamicObject obj) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(customParams);
        String taxorg = obj.getString("taxorg_id");
        String ruleid = obj.getString("incredrule_id");
        params.put(TAXORG, taxorg);
        params.put("entrytype", "incredincome");
        params.put("itemnumber", ruleid);
        params.put("ruleid", ruleid);
        return params;
    }
}

