/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class InsuranceTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "zzje", "non_allow", "match_pay", "002", "income_amount", "surrender", "rate", "limit", "003", "curr_year_limit", "sum_before_year_deduct", "curr_year_deduct_before", "sum_after_year_ductct", "nstzje"});
    public static final Set<String> titles = Sets.newHashSet((Object[])new String[]{"001", "002", "003"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String AMOUNT = "amount";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private static Map<String, String> projects = new HashMap<String, String>();
    private static Map<String, String> entrytypes = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,amount";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_insurance_summary", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (DynamicObject object : query) {
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            String itemType = object.getString(ITEM_TYPE);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, object.get(ITEM_NO));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)itemType);
            dot.getProperty(AMOUNT).setValueFast((Object)data, (Object)this.formatData(object.getBigDecimal(AMOUNT), itemType, AMOUNT));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(BigDecimal data, String rowtype, String columnType) {
        if (titles.contains(rowtype)) {
            return "";
        }
        StringBuilder link = new StringBuilder("<nolink>");
        String text = data.setScale(2, 4).toString();
        if (Lists.newArrayList((Object[])new String[]{"zzje", "non_allow", "income_amount", "surrender"}).contains(rowtype)) {
            return DataFormat.formatMicrometer(text);
        }
        if ("rate".equals(rowtype)) {
            return link.append(DataFormat.formatRate(text)).toString();
        }
        return link.append(DataFormat.formatMicrometer(text)).toString();
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        if (this.checkCalc(customParams)) {
            DynamicObjectCollection sum = new DynamicObjectCollection();
            int itemNo = 0;
            for (String itemType : itemTypes) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_insurance_summary");
                dynamicObject.set(ITEM_NO, (Object)(++itemNo));
                dynamicObject.set(ITEM_TYPE, (Object)itemType);
                dynamicObject.set(AMOUNT, (Object)this.calcAmount(itemType, AMOUNT, customParams));
                dynamicObject.set("orgid", (Object)orgid);
                dynamicObject.set("skssqq", (Object)skssqq);
                dynamicObject.set("skssqz", (Object)skssqz);
                sum.add((Object)dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        }
    }

    private boolean checkCalc(Map<String, Object> customParams) {
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        if (policy != null) {
            DynamicObject codeandname = QueryServiceHelper.queryOne((String)"tpo_tcvat_industrycode", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)policy.getDynamicObject("codeandname").getLong("id"))});
            String longnumber1 = codeandname.getString("longnumber");
            return policy != null && policy.getBoolean("deduct6") && longnumber1 != null && longnumber1.startsWith("322.364");
        }
        return true;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_insurance_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        if ("zzje".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "zzjeqs");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("non_allow".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "byxkcje");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("match_pay".equals(rowType)) {
            BigDecimal amount2 = this.dataMap.getOrDefault(this.getKey("zzje", columnType), BigDecimal.ZERO);
            BigDecimal amount3 = this.dataMap.getOrDefault(this.getKey("non_allow", columnType), BigDecimal.ZERO);
            BigDecimal matchPay = amount2.subtract(amount3).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), matchPay);
            return matchPay;
        }
        if ("income_amount".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "bfsr");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("surrender".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "tbje");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("rate".equals(rowType)) {
            BigDecimal rate = this.getRate(customParams);
            this.dataMap.put(this.getKey(rowType, columnType), rate);
            return rate;
        }
        if ("limit".equals(rowType)) {
            BigDecimal income_amount = this.dataMap.getOrDefault(this.getKey("income_amount", columnType), BigDecimal.ZERO);
            BigDecimal surrender = this.dataMap.getOrDefault(this.getKey("surrender", columnType), BigDecimal.ZERO);
            BigDecimal rate = this.dataMap.getOrDefault(this.getKey("rate", columnType), BigDecimal.ZERO);
            BigDecimal limit = income_amount.subtract(surrender).multiply(rate).divide(new BigDecimal("100")).setScale(2, 4);
            limit = limit.max(BigDecimal.ZERO);
            this.dataMap.put(this.getKey(rowType, columnType), limit);
            return limit;
        }
        if ("curr_year_limit".equals(rowType)) {
            BigDecimal matchPay = this.dataMap.getOrDefault(this.getKey("match_pay", columnType), BigDecimal.ZERO);
            BigDecimal limit = this.dataMap.getOrDefault(this.getKey("limit", columnType), BigDecimal.ZERO);
            BigDecimal currYearLimit = matchPay.subtract(limit).setScale(2, 4);
            currYearLimit = currYearLimit.max(BigDecimal.ZERO);
            this.dataMap.put(this.getKey(rowType, columnType), currYearLimit);
            return currYearLimit;
        }
        if ("sum_before_year_deduct".equals(rowType)) {
            return this.getOne(rowType, columnType, "tccit_qysds_a105060", "ljjzyhndkce", new QFilter[]{new QFilter("sbbid", "=", (Object)this.getPreYearSbbid(customParams))}, "ljjzyhndkce");
        }
        if ("curr_year_deduct_before".equals(rowType)) {
            BigDecimal sumBeforeYearDeduct = this.dataMap.getOrDefault(this.getKey("sum_before_year_deduct", columnType), BigDecimal.ZERO);
            BigDecimal limit = this.dataMap.getOrDefault(this.getKey("limit", columnType), BigDecimal.ZERO);
            BigDecimal matchPay = this.dataMap.getOrDefault(this.getKey("match_pay", columnType), BigDecimal.ZERO);
            BigDecimal diff = limit.subtract(matchPay).setScale(2, 4);
            BigDecimal min = sumBeforeYearDeduct.min(diff);
            BigDecimal currYearDeductBefore = min.max(BigDecimal.ZERO);
            this.dataMap.put(this.getKey(rowType, columnType), currYearDeductBefore);
            return currYearDeductBefore;
        }
        if ("sum_after_year_ductct".equals(rowType)) {
            BigDecimal currYearLimit = this.dataMap.getOrDefault(this.getKey("curr_year_limit", columnType), BigDecimal.ZERO);
            BigDecimal sumBeforeYearDeduct = this.dataMap.getOrDefault(this.getKey("sum_before_year_deduct", columnType), BigDecimal.ZERO);
            BigDecimal currYearDeductBefore = this.dataMap.getOrDefault(this.getKey("curr_year_deduct_before", columnType), BigDecimal.ZERO);
            BigDecimal sumAfterYearDuctct = currYearLimit.add(sumBeforeYearDeduct).add(currYearDeductBefore);
            this.dataMap.put(this.getKey(rowType, columnType), sumAfterYearDuctct);
            return sumAfterYearDuctct;
        }
        if ("nstzje".equals(rowType)) {
            BigDecimal matchPay = this.dataMap.getOrDefault(this.getKey("match_pay", columnType), BigDecimal.ZERO);
            BigDecimal limit = this.dataMap.getOrDefault(this.getKey("limit", columnType), BigDecimal.ZERO);
            BigDecimal noAllow = this.dataMap.getOrDefault(this.getKey("non_allow", columnType), BigDecimal.ZERO);
            BigDecimal currYearDeductBefore = this.dataMap.getOrDefault(this.getKey("curr_year_deduct_before", columnType), BigDecimal.ZERO);
            BigDecimal nstzje = matchPay.compareTo(limit) > 0 ? noAllow.add(matchPay).subtract(limit).setScale(2, 4) : noAllow.subtract(currYearDeductBefore).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), nstzje);
            return nstzje;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype) {
        String itemnumber = projects.get(columnType);
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, null, "tccit_insurance_det");
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    private BigDecimal getRate(Map<String, Object> customParams) {
        String skssqz;
        String skssqq;
        String orgId = String.valueOf(customParams.get("orgid"));
        List deductionRateList = AssistService.queryAssistParams((String)"BXQYYJSXF", (String)orgId, (String)(skssqq = String.valueOf(customParams.get("skssqq"))), (String)(skssqz = String.valueOf(customParams.get("skssqz"))));
        return CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.ZERO : new BigDecimal((String)deductionRateList.get(0));
    }

    private String getPreYearSbbid(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        return YbnsrService.queryYbnsrPre((String)orgid, (String)"qysdsnb_dg", (String)skssqq, (String)skssqz, (int)-12);
    }

    private BigDecimal getOne(String rowType, String columnType, String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObject object = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = object != null ? object.getBigDecimal(alias) : BigDecimal.ZERO;
        this.dataMap.put(this.getKey(rowType, columnType), result);
        return result;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemtype = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", entrytypes.get(itemtype));
        customParams.put("itemnumber", projects.get(evt.getFieldName()));
        customParams.put("entryname", "tccit_insurance_det");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    static {
        projects.put(AMOUNT, "3010601");
        entrytypes.put("zzje", "zzjeqs");
        entrytypes.put("non_allow", "byxkcje");
        entrytypes.put("income_amount", "bfsr");
        entrytypes.put("surrender", "tbje");
    }
}

