/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class InterestTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "001_01", "001_02", "001_03", "001_04", "002", "002_01", "002_02", "002_03", "002_04", "003", "003_01", "003_02"});
    public static final Set<String> titles = Sets.newHashSet((Object[])new String[]{"001", "002", "003"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String AMOUNT = "amount";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private static Map<String, String> projects = new HashMap<String, String>();
    private static Map<String, String> entrytypes = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemtype,amount";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_interest_summary", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (DynamicObject object : query) {
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            String itemType = object.getString(ITEM_TYPE);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)(rowIndex + 1));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)itemType);
            dot.getProperty(AMOUNT).setValueFast((Object)data, (Object)this.formatData(object.getBigDecimal(AMOUNT), itemType, AMOUNT));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(BigDecimal data, String rowtype, String columnType) {
        if (titles.contains(rowtype)) {
            return "";
        }
        StringBuilder link = new StringBuilder("<nolink>");
        String text = data.setScale(2, 4).toString();
        if (Lists.newArrayList((Object[])new String[]{"001_04", "002_04", "003_01", "003_02"}).contains(rowtype)) {
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        return DataFormat.formatMicrometer(text);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("deduct5")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int itemNo = 0;
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_interest_summary");
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(AMOUNT, (Object)this.calcAmount(itemType, AMOUNT, customParams));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_interest_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        if ("001_01".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "zmjt");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("001_02".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "sjzffjr");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("001_03".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "cgjrqydk");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("001_04".equals(rowType)) {
            BigDecimal amount3 = this.dataMap.getOrDefault(this.getKey("001_02", columnType), BigDecimal.ZERO);
            BigDecimal amount4 = this.dataMap.getOrDefault(this.getKey("001_03", columnType), BigDecimal.ZERO);
            BigDecimal subtract = amount3.subtract(amount4);
            this.dataMap.put(this.getKey(rowType, columnType), subtract);
            return subtract;
        }
        if ("002_01".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "tzwdw");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("002_02".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "zbrhbkkc");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("002_03".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "qtbkkc");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("002_04".equals(rowType)) {
            BigDecimal amount7 = this.dataMap.getOrDefault(this.getKey("002_01", columnType), BigDecimal.ZERO);
            BigDecimal amount8 = this.dataMap.getOrDefault(this.getKey("002_02", columnType), BigDecimal.ZERO);
            BigDecimal amount9 = this.dataMap.getOrDefault(this.getKey("002_03", columnType), BigDecimal.ZERO);
            BigDecimal addAmount = amount7.add(amount8).add(amount9);
            this.dataMap.put(this.getKey(rowType, columnType), addAmount);
            return addAmount;
        }
        if ("003_01".equals(rowType)) {
            BigDecimal amount5 = this.dataMap.getOrDefault(this.getKey("001_04", columnType), BigDecimal.ZERO);
            BigDecimal amount10 = this.dataMap.getOrDefault(this.getKey("002_04", columnType), BigDecimal.ZERO);
            BigDecimal nsje = amount5.subtract(amount10);
            this.dataMap.put(this.getKey(rowType, columnType), nsje);
            return nsje;
        }
        if ("003_02".equals(rowType)) {
            BigDecimal amount2 = this.dataMap.getOrDefault(this.getKey("001_01", columnType), BigDecimal.ZERO);
            BigDecimal amount12 = this.dataMap.getOrDefault(this.getKey("003_01", columnType), BigDecimal.ZERO);
            BigDecimal nstzje = amount2.subtract(amount12);
            this.dataMap.put(this.getKey(rowType, columnType), nstzje);
            return nstzje;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype) {
        String itemnumber = projects.get(columnType);
        return this.getCellAmount(customParams, columnType, entrytype, null, itemnumber, null, "tccit_interest_tz_detail");
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemtype = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", entrytypes.get(itemtype));
        customParams.put("itemnumber", projects.get(evt.getFieldName()));
        customParams.put("entryname", "tccit_interest_tz_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{AMOUNT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        customParams.put("entryname", "tccit_interest_tz_detail");
        customParams.put("entrytype", entrytypes.get(itemtype));
        customParams.put("columnType", column);
        customParams.put("itemnumber", projects.get(column));
        return customParams;
    }

    static {
        projects.put(AMOUNT, "30105");
        entrytypes.put("001_01", "zmjt");
        entrytypes.put("001_02", "sjzffjr");
        entrytypes.put("001_03", "cgjrqydk");
        entrytypes.put("002_01", "tzwdw");
        entrytypes.put("002_02", "zbrhbkkc");
        entrytypes.put("002_03", "qtbkkc");
    }
}

