/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class InvestProfitTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"6010401", "6010402", "6010403", "6010404", "6010405", "6010406", "6010407", "6010408", "6010409"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ZZJE = "zzje";
    public static final String TAXINCOME = "taxincome";
    public static final String NSTZJE = "nstzje";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        this.dataMap.clear();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,zzje,taxincome,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_invest_profit_sum", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() + 1);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_TYPE));
            dot.getProperty(ZZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal(ZZJE)));
            dot.getProperty(TAXINCOME).setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal(TAXINCOME)));
            dot.getProperty(NSTZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal(NSTZJE)));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
        this.appendCountRow(query, model, rowIndex);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex) {
        model.setValue(ITEM_NO, (Object)(query.size() + 1), rowIndex);
        model.setValue(ITEM_TYPE, (Object)"count", rowIndex);
        model.setValue(ZZJE, (Object)this.getSum(query, ZZJE), rowIndex);
        model.setValue(TAXINCOME, (Object)this.getSum(query, TAXINCOME), rowIndex);
        model.setValue(NSTZJE, (Object)this.getSum(query, NSTZJE), rowIndex);
    }

    private String formatData(BigDecimal amount) {
        String text = amount.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(text);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_invest_profit_sum", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("income3")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int itemNo = 0;
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_invest_profit_sum");
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(ZZJE, (Object)this.calcAmount(itemType, ZZJE, ZZJE, customParams));
            dynamicObject.set(TAXINCOME, (Object)this.calcAmount(itemType, TAXINCOME, "ssje", customParams));
            dynamicObject.set(NSTZJE, (Object)this.calcAmount(itemType, NSTZJE, null, customParams));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal calcAmount(String rowType, String columnType, String entrytype, Map<String, Object> customParams) {
        if (NSTZJE.equals(columnType)) {
            BigDecimal taxIncome = this.dataMap.getOrDefault(this.getKey(rowType, TAXINCOME), BigDecimal.ZERO);
            BigDecimal zzje = this.dataMap.getOrDefault(this.getKey(rowType, ZZJE), BigDecimal.ZERO);
            BigDecimal decimal = taxIncome.subtract(zzje).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), decimal);
            return decimal;
        }
        BigDecimal amount = this.getAmount(customParams, columnType, entrytype, rowType);
        this.dataMap.put(this.getKey(rowType, columnType), amount);
        return amount;
    }

    public String getSum(DynamicObjectCollection query, String columnType) {
        BigDecimal sum = query.stream().map(s -> s.getBigDecimal(columnType)).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
        String text = this.formatData(sum);
        StringBuilder link = new StringBuilder("<nolink>");
        if (NSTZJE.equals(columnType)) {
            return text;
        }
        return link.append(text).toString();
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype, String rowType) {
        String itemnumber = rowType;
        return this.getCellAmount(customParams, columnType, entrytype, rowType, itemnumber, null, "tccit_invest_profit_det");
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemtype = (String)itemsEntity.getModel().getValue(ITEM_TYPE);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        String entrytype = null;
        if (ZZJE.equals(evt.getFieldName())) {
            entrytype = ZZJE;
        } else if (TAXINCOME.equals(evt.getFieldName())) {
            entrytype = "ssje";
        }
        customParams.put("entrytype", entrytype);
        customParams.put("itemnumber", itemtype);
        customParams.put("entryname", "tccit_invest_profit_det");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_invest_profit_sum", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{ZZJE, TAXINCOME});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        customParams.put("entryname", "tccit_invest_profit_det");
        customParams.put("entrytype", ZZJE.equals(column) ? ZZJE : "ssje");
        customParams.put("columnType", itemtype);
        customParams.put("itemnumber", itemtype);
        return customParams;
    }
}

