/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.org.BastaxTaxOrgService;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.DkynssdeTZFormPlugin;

public class JmyhhzDgFormPlugin
extends AbstractEngine
implements Observer {
    private static final String TAXORGNAME = "taxorgname";
    private static final String COMPANYTYPE = "companytype";
    private static final String FTRATE = "ftrate";
    private static final String FTSDE = "ftsde";
    private static final String JMRATE = "jmrate";
    private static final String JMSE = "jmse";
    private static final String YNSSDE = "ynssde";
    private static final String POLICY_CONFIRM = "tccit_policy_confirm";
    private static final String ENTITY = "tccit_jmyhhz_summary";
    private static final String ORGID = "orgid";
    private static final String TCCIT_POLICY_CONFIRM = "tccit_policy_confirm";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        BigDecimal ynssde = this.getYnssde(orgid, skssqq, skssqz);
        this.getModel().setValue(YNSSDE, (Object)ynssde);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private DynamicObjectCollection calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        DynamicObject tccitPolicy = this.findTccitPolicy(orgid, skssqq, skssqz);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        if (tccitPolicy != null) {
            String declaretype = tccitPolicy.getString("declaretype");
            if (Lists.newArrayList((Object[])new String[]{"100", "220", "230"}).contains(declaretype)) {
                List<DynamicObject> cards = this.findCard(tccitPolicy);
                sum = this.createRow(orgid, skssqq, skssqz, orgid, this.getTaxOrgName(tccitPolicy.getDynamicObject(ORGID).getLong("id")), cards, new BigDecimal("1"));
            } else if ("210".contains(declaretype)) {
                List<DynamicObject> cards = this.findCard(tccitPolicy);
                DynamicObjectCollection apportionSummary = this.findBranchOrgId(orgid, skssqq);
                Optional<DynamicObject> org = apportionSummary.stream().filter(e -> e.getLong("taxorg") == orgid.longValue()).findFirst();
                BigDecimal rate = org.isPresent() ? (org.get().getBigDecimal("rate") != null ? org.get().getBigDecimal("rate") : BigDecimal.ZERO) : this.getRate(orgid, skssqz, "zjgftbl").add(this.getRate(orgid, skssqz, "czjzfpbl"));
                sum = this.createRow(orgid, skssqq, skssqz, orgid, this.getTaxOrgName(tccitPolicy.getDynamicObject(ORGID).getLong("id")), cards, rate);
                if (!CollectionUtils.isEmpty((Collection)apportionSummary)) {
                    List branchOrgId = apportionSummary.stream().map(s -> s.getLong("taxorg")).collect(Collectors.toList());
                    for (Long fzOrgId : branchOrgId) {
                        BigDecimal ftrate;
                        List<DynamicObject> listCard;
                        List<DynamicObject> list = listCard = fzOrgId == 0L ? this.findCard(tccitPolicy) : this.listCard(fzOrgId, skssqq, skssqz);
                        Optional<DynamicObject> optional = apportionSummary.stream().filter(s -> s.getLong("taxorg") == fzOrgId.longValue()).findFirst();
                        if (!optional.isPresent()) continue;
                        DynamicObject filterObj = optional.get();
                        String taxorgname = filterObj.getString(TAXORGNAME);
                        if (org.isPresent()) {
                            ftrate = filterObj.getBigDecimal("rate") != null ? filterObj.getBigDecimal("rate") : BigDecimal.ZERO;
                        } else {
                            ftrate = filterObj.getBigDecimal("rate") != null ? filterObj.getBigDecimal("rate").divide(new BigDecimal("2"), 10, 4) : BigDecimal.ZERO;
                            ftrate = ftrate.multiply(this.getRate(orgid, skssqz, "fzjgftbl").multiply(new BigDecimal(2)));
                        }
                        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqq);
                        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)skssqq);
                        DynamicObjectCollection fzSum = this.createRow(orgid, firstDateOfYear, lastDateOfYear, fzOrgId, taxorgname, listCard, ftrate);
                        sum.addAll((Collection)fzSum);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)sum)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        }
        return sum;
    }

    private String getTaxOrgName(Long orgId) {
        String taxOrgName = "";
        DynamicObject bastaxTaxorg = BastaxTaxOrgService.getBastaxTaxorg(orgId);
        if (bastaxTaxorg != null) {
            taxOrgName = bastaxTaxorg.getString("taxpayer");
        }
        return taxOrgName;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)ENTITY, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private DynamicObject findTccitPolicy(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter startDateFilter = new QFilter("startdate", ">=", (Object)skssqq);
        QFilter endDateFilter = new QFilter("enddate", "<=", (Object)DateUtils.getDayLast((Date)skssqz));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tccit_policy_confirm", (String)"id,orgid", (QFilter[])new QFilter[]{orgFilter, startDateFilter, endDateFilter});
        DynamicObject loadSingle = null;
        if (dynamicObject != null) {
            loadSingle = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"tccit_policy_confirm");
        }
        return loadSingle;
    }

    private DynamicObjectCollection createRow(Long orgid, Date skssqq, Date skssqz, Long taxorg, String taxorgname, List<DynamicObject> cards, BigDecimal ftrate) {
        if (CollectionUtils.isEmpty(cards)) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        DynamicObject dgEntry = null;
        int itemNo = 0;
        BigDecimal value = this.getYnssde(orgid, skssqq, skssqz);
        for (DynamicObject card : cards) {
            dgEntry = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
            dgEntry.set("itemno", (Object)itemNo);
            dgEntry.set(COMPANYTYPE, card.getDynamicObject(COMPANYTYPE).get("id"));
            dgEntry.set("taxorg", (Object)taxorg);
            dgEntry.set(TAXORGNAME, (Object)taxorgname);
            dgEntry.set(FTRATE, (Object)ftrate);
            BigDecimal ftsde = value.multiply(ftrate);
            dgEntry.set(FTSDE, (Object)ftsde);
            BigDecimal jmrate = this.getJmrate(DateUtils.getYearOfDate((Date)skssqq), card, cards);
            dgEntry.set(JMRATE, (Object)jmrate);
            dgEntry.set(ORGID, (Object)orgid);
            dgEntry.set("skssqq", (Object)skssqq);
            dgEntry.set("skssqz", (Object)skssqz);
            dgEntry.set(JMSE, (Object)ftsde.multiply(jmrate));
            ++itemNo;
            sum.add((Object)dgEntry);
        }
        return sum;
    }

    private BigDecimal getJmrate(int declareyear, DynamicObject card, List<DynamicObject> list) {
        Integer profitmYear = Integer.valueOf(StringUtils.isEmpty((Object)card.getString("profitmyear")) ? "0" : card.getString("profitmyear"));
        int diff = declareyear - profitmYear;
        DynamicObject companytype = card.getDynamicObject(COMPANYTYPE);
        if (companytype == null) {
            return BigDecimal.ZERO;
        }
        if ("FTA001".equals(companytype.getString("number"))) {
            if (list.size() == 1) {
                return new BigDecimal("0.1");
            }
            Optional<DynamicObject> first = list.stream().filter(s -> s.getDynamicObject(COMPANYTYPE).getString("number").equals("FTA002")).findFirst();
            if (first.isPresent()) {
                DynamicObject dynamicObject = first.get();
                Integer profitmYear2 = Integer.valueOf(StringUtils.isEmpty((Object)dynamicObject.getString("profitmyear")) ? "0" : dynamicObject.getString("profitmyear"));
                if (0 <= declareyear - profitmYear2 && declareyear - profitmYear2 < 2) {
                    return new BigDecimal("0");
                }
                if (2 <= declareyear - profitmYear2 && declareyear - profitmYear2 <= 4) {
                    return new BigDecimal("0.05");
                }
                return new BigDecimal("0.1");
            }
        }
        if ("FTA002".equals(companytype.getString("number"))) {
            if (0 <= diff && diff < 2) {
                return new BigDecimal("0.25");
            }
            if (2 <= diff && diff <= 4) {
                return new BigDecimal("0.125");
            }
            return BigDecimal.ZERO;
        }
        if ("FTA003".equals(companytype.getString("number"))) {
            return new BigDecimal("0.25");
        }
        if (Lists.newArrayList((Object[])new String[]{"FTA004", "FTA005", "FTA006"}).contains(companytype.getString("number"))) {
            return new BigDecimal("0.1");
        }
        return BigDecimal.ZERO;
    }

    private DynamicObjectCollection findBranchOrgId(Long orgid, Date skssqq) {
        int year = DateUtils.getYearOfDate((Date)skssqq);
        QFilter taxorgFilter = new QFilter("taxorg", "!=", (Object)orgid);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter seasonFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)(year + "-10-01"))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)(year + "-12-31"))));
        QFilter monthFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)(year + "-12-01"))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)(year + "-12-31"))));
        DynamicObjectCollection apportionSummary = QueryServiceHelper.query((String)"tccit_apportion_summary", (String)"org, taxorg,taxorgname1,taxorgname,unifiedsocialcode1,unifiedsocialcode,income,emolument,totalassets,rate,year ", (QFilter[])new QFilter[]{orgFilter, taxorgFilter, seasonFilter.or(monthFilter)});
        return apportionSummary;
    }

    private List<DynamicObject> findCard(DynamicObject dynamicObject) {
        List<DynamicObject> list = new ArrayList<DynamicObject>();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"tccit_policy_confirm");
        DynamicObjectCollection apitudeentryentity = loadSingle.getDynamicObjectCollection("apitudeentryentity");
        if (!CollectionUtils.isEmpty((Collection)apitudeentryentity)) {
            List<DynamicObject> collect = apitudeentryentity.stream().filter(s -> s.getString("apitudetype").equals("3")).filter(s -> s.getBoolean("yxsy")).collect(Collectors.toList());
            list = this.removeDuplicate(collect);
        }
        return list;
    }

    private List<DynamicObject> removeDuplicate(List<DynamicObject> collect) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        Map<String, List<DynamicObject>> companytype = collect.stream().collect(Collectors.groupingBy(s -> s.getString(COMPANYTYPE)));
        for (Map.Entry<String, List<DynamicObject>> entry : companytype.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            list.add(value.get(0));
        }
        return list;
    }

    public List<DynamicObject> listCard(Long orgId, Date startdate, Date enddate) {
        List<Object> list = new ArrayList<DynamicObject>();
        DynamicObjectCollection apitudeEntryEntity = ApitudeService.getApitudeEntryEntity(orgId);
        if (CollectionUtils.isEmpty((Collection)apitudeEntryEntity)) {
            return list;
        }
        List collect = apitudeEntryEntity.stream().filter(s -> s.getString("apitudetype").equals("3")).filter(s -> s.getBoolean("yxsy")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return list;
        }
        list = collect.stream().filter(s -> {
            Date apitudestartdate = s.getDate("apitudestartdate");
            Date apitudeenddate = s.getDate("apitudeenddate");
            if (apitudeenddate == null) {
                return !apitudestartdate.after(startdate);
            }
            return !apitudestartdate.after(startdate) && !apitudeenddate.before(enddate);
        }).collect(Collectors.toList());
        list = this.removeDuplicate(list);
        return list;
    }

    private BigDecimal getYnssde(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_dg_a100000_7_sum", (String)"zzqcurrent", (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)"id");
        return CollectionUtils.isEmpty((Collection)query) ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal("zzqcurrent");
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DynamicObjectCollection list = QueryServiceHelper.query((String)ENTITY, (String)"itemno,companytype,taxorg,taxorgname,ftrate,ftsde,jmrate,jmse", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", list.size());
        int rowIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)list.get(i);
            model.setValue(COMPANYTYPE, (Object)dynamicObject.getLong(COMPANYTYPE), rowIndex);
            if (0L == dynamicObject.getLong("taxorg")) {
                model.setValue(TAXORGNAME, (Object)dynamicObject.getString(TAXORGNAME), rowIndex);
            } else {
                QFilter qFilter = new QFilter("org", "=", (Object)dynamicObject.getLong("taxorg"));
                DynamicObjectCollection taxpayers = QueryServiceHelper.query((String)"bastax_taxorg", (String)"taxpayer", (QFilter[])new QFilter[]{qFilter});
                model.setValue(TAXORGNAME, (Object)((DynamicObject)taxpayers.get(0)).getString("taxpayer"), rowIndex);
            }
            model.setValue(FTRATE, (Object)dynamicObject.getBigDecimal(FTRATE), rowIndex);
            model.setValue(FTSDE, (Object)dynamicObject.getBigDecimal(FTSDE), rowIndex);
            model.setValue(JMRATE, (Object)dynamicObject.getBigDecimal(JMRATE), rowIndex);
            model.setValue(JMSE, (Object)dynamicObject.getBigDecimal(JMSE), rowIndex);
            ++rowIndex;
        }
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    private BigDecimal getRate(Long orgid, Date endDate, String type) {
        QFilter qFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter qFilter1 = new QFilter("enddate", "=", (Object)endDate);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"tccit_policy_confirm", (String)"zjgftbl,czjzfpbl,fzjgftbl", (QFilter[])new QFilter[]{qFilter, qFilter1});
        Optional<BigDecimal> zjgftblOptional = Optional.ofNullable(dyo).map(s -> s.getBigDecimal("zjgftbl"));
        Optional<BigDecimal> czjzfpblOptional = Optional.ofNullable(dyo).map(s -> s.getBigDecimal("czjzfpbl"));
        Optional<BigDecimal> fzjgftblOptional = Optional.ofNullable(dyo).map(s -> s.getBigDecimal("fzjgftbl"));
        if ("zjgftbl".equals(type)) {
            return zjgftblOptional.isPresent() ? zjgftblOptional.get() : new BigDecimal("0.5");
        }
        if ("czjzfpbl".equals(type)) {
            return czjzfpblOptional.isPresent() ? czjzfpblOptional.get() : new BigDecimal("0.25");
        }
        return fzjgftblOptional.isPresent() ? fzjgftblOptional.get() : new BigDecimal("0.25");
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(JmyhhzDgFormPlugin.class.getSimpleName(), Collections.singletonList(DkynssdeTZFormPlugin.class.getSimpleName()));
            }
        };
    }
}

