/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.GetReduceFormPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MbyqndksjsdgFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String ITEM_NO = "itemno";
    public static final String TCCIT_DG_B105060_SUM = "tccit_dg_b105060_sum";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = " * ";
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_DG_B105060_SUM, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject queryResult = QueryServiceHelper.queryOne((String)"tccit_dg_a100000_4_sum", (String)"lmhjnsd", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        if (queryResult != null) {
            model.setValue("bqjnynssde", (Object)queryResult.getBigDecimal("lmhjnsd"));
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() + 1);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty("billno").setValueFast((Object)data, (Object)dynamicObject.getString("billno"));
            dot.getProperty("happenyear").setValueFast((Object)data, (Object)String.valueOf(dynamicObject.getInt("happenyear")));
            dot.getProperty("losstype").setValueFast((Object)data, (Object)dynamicObject.getString("losstype"));
            dot.getProperty("name").setValueFast((Object)data, (Object)dynamicObject.getString("name"));
            dot.getProperty("yjjznx").setValueFast((Object)data, (Object)String.valueOf(dynamicObject.getInt("yjjznx")));
            dot.getProperty("ksdqnd").setValueFast((Object)data, (Object)String.valueOf(dynamicObject.getInt("ksdqnd")));
            dot.getProperty("lossmoney").setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal("lossmoney")));
            dot.getProperty("ymbksje").setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal("ymbksje")));
            dot.getProperty("flzcje").setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal("flzcje")));
            dot.getProperty("syjnsdmb").setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal("syjnsdmb")));
            dot.getProperty("bnkmbksje").setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal("bnkmbksje")));
            dot.getProperty("syjwsdmb").setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal("syjwsdmb")));
            dot.getProperty("dnkjzyhndksje").setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal("dnkjzyhndksje")));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
        this.appendCountRow(query, model, rowIndex);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex) {
        model.setValue(ITEM_NO, (Object)(query.size() + 1), rowIndex);
        model.setValue("happenyear", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"MbyqndksjsdgFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue("losstype", (Object)"*", rowIndex);
        model.setValue("name", (Object)"*", rowIndex);
        model.setValue("yjjznx", (Object)"*", rowIndex);
        model.setValue("ksdqnd", (Object)"*", rowIndex);
        model.setValue("lossmoney", (Object)this.formatData(this.getSum(query, "lossmoney")), rowIndex);
        model.setValue("flzcje", (Object)this.formatData(this.getSum(query, "flzcje")), rowIndex);
        model.setValue("ymbksje", (Object)this.formatData(this.getSum(query, "ymbksje")), rowIndex);
        model.setValue("bnkmbksje", (Object)this.formatData(this.getSum(query, "bnkmbksje")), rowIndex);
        model.setValue("syjnsdmb", (Object)this.formatData(this.getSum(query, "syjnsdmb")), rowIndex);
        model.setValue("syjwsdmb", (Object)this.formatData(this.getSum(query, "syjwsdmb")), rowIndex);
        model.setValue("dnkjzyhndksje", (Object)this.formatData(this.getSum(query, "dnkjzyhndksje")), rowIndex);
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String formatData(BigDecimal data) {
        String text = data.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(text);
    }

    private DynamicObjectCollection calc(Map<String, Object> customParams) {
        BigDecimal syjnsdmb;
        DynamicObject dynamicObject;
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter orgIdFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter expireFilter = new QFilter("ksdqnd", ">=", (Object)skssqq);
        QFilter happenFilter = new QFilter("happenyear", "<", (Object)skssqq);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        QFilter[] qfilters = new QFilter[]{orgFilter, expireFilter, happenFilter};
        Function<QFilter[], Object[]> idFunction = filters -> QueryServiceHelper.query((String)"tccit_mbyqks_acc", (String)"id", (QFilter[])filters).stream().map(s -> s.get("id")).toArray();
        DynamicObject[] tccitMbyqksAccs = BusinessDataServiceHelper.load((Object[])idFunction.apply(qfilters), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tccit_mbyqks_acc"));
        tccitMbyqksAccs = (DynamicObject[])Arrays.stream(tccitMbyqksAccs).sorted(Comparator.comparing(s -> s.getDate("ksdqnd")).thenComparing(b -> b.getDate("happenyear"))).toArray(DynamicObject[]::new);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int yearOfskssqq = DateUtils.getYearOfDate((Date)skssqq);
        DynamicObject query = QueryServiceHelper.queryOne((String)"tccit_dg_a100000_4_sum", (String)"lmhjnsd", (QFilter[])new QFilter[]{orgIdFilter, dateFilter});
        BigDecimal jmhjnsd = query == null ? BigDecimal.ZERO : query.getBigDecimal("lmhjnsd");
        BigDecimal orgJmhjnsd = query == null ? BigDecimal.ZERO : query.getBigDecimal("lmhjnsd");
        BigDecimal flzcjesum = BigDecimal.ZERO;
        for (int i = 0; i < tccitMbyqksAccs.length; ++i) {
            DynamicObject sourceAcc = tccitMbyqksAccs[i];
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_DG_B105060_SUM);
            dynamicObject.set(ITEM_NO, (Object)(i + 1));
            dynamicObject.set("orgid", sourceAcc.get("org.id"));
            dynamicObject.set("billno", sourceAcc.get("billno"));
            dynamicObject.set("happenyear", (Object)DateUtils.getYearOfDate((Date)sourceAcc.getDate("happenyear")));
            dynamicObject.set("losstype", sourceAcc.get("losstype"));
            dynamicObject.set("lossqiyetype", sourceAcc.get("lossqiyetype"));
            dynamicObject.set("name", (Object)BusinessDataServiceHelper.loadSingle((Object)sourceAcc.get("lossqiyetype.id"), (String)"tpo_tccit_bizdef_entry").getString("projectname"));
            dynamicObject.set("number", (Object)BusinessDataServiceHelper.loadSingle((Object)sourceAcc.get("lossqiyetype.id"), (String)"tpo_tccit_bizdef_entry").getString("number"));
            dynamicObject.set("yjjznx", sourceAcc.get("yjjznx"));
            Date ksdqnd = sourceAcc.getDate("ksdqnd");
            dynamicObject.set("ksdqnd", (Object)DateUtils.getYearOfDate((Date)ksdqnd));
            dynamicObject.set("lossmoney", sourceAcc.get("lossmoney"));
            DynamicObjectCollection entryentityList = sourceAcc.getDynamicObjectCollection("entryentity");
            BigDecimal flzcje = BigDecimal.ZERO;
            BigDecimal ymbksje = BigDecimal.ZERO;
            for (DynamicObject entryentity : entryentityList) {
                if (entryentity.get("mbnd") == null || entryentity.get("mbkslx") == null || entryentity.get("mbzcksje") == null) continue;
                if ("flzc".equals(entryentity.getString("mbkslx")) && yearOfskssqq > DateUtils.getYearOfDate((Date)entryentity.getDate("mbnd"))) {
                    flzcje = flzcje.add(entryentity.getBigDecimal("mbzcksje"));
                }
                if (!"mbks".equals(entryentity.getString("mbkslx")) || yearOfskssqq <= DateUtils.getYearOfDate((Date)entryentity.getDate("mbnd"))) continue;
                ymbksje = ymbksje.add(entryentity.getBigDecimal("mbzcksje"));
            }
            flzcjesum = flzcjesum.add(flzcje);
            dynamicObject.set("flzcje", (Object)flzcje);
            dynamicObject.set("ymbksje", (Object)ymbksje);
            dynamicObject.set("bnkmbksje", (Object)ymbksje.add(flzcje).add(sourceAcc.getBigDecimal("lossmoney")));
            syjnsdmb = dynamicObject.getBigDecimal("bnkmbksje").abs().compareTo(jmhjnsd) > 0 ? jmhjnsd : dynamicObject.getBigDecimal("bnkmbksje").abs();
            syjnsdmb = BigDecimal.ZERO.compareTo(syjnsdmb) > 0 ? BigDecimal.ZERO : syjnsdmb;
            dynamicObject.set("syjnsdmb", (Object)syjnsdmb);
            jmhjnsd = jmhjnsd.subtract(syjnsdmb);
            dynamicObject.set("syjwsdmb", (Object)BigDecimal.ZERO);
            BigDecimal dnkjzyhndksje = BigDecimal.ZERO;
            if (yearOfskssqq != DateUtils.getYearOfDate((Date)ksdqnd)) {
                dnkjzyhndksje = dynamicObject.getBigDecimal("bnkmbksje").abs().subtract(dynamicObject.getBigDecimal("syjnsdmb")).subtract(dynamicObject.getBigDecimal("syjwsdmb"));
            }
            dynamicObject.set("dnkjzyhndksje", (Object)dnkjzyhndksje);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_DG_B105060_SUM);
        dynamicObject.set(ITEM_NO, (Object)(tccitMbyqksAccs.length + 1));
        dynamicObject.set("orgid", (Object)orgid);
        dynamicObject.set("happenyear", (Object)yearOfskssqq);
        dynamicObject.set("losstype", (Object)"jnsd");
        String mbkstype = "100";
        if (policy != null && StringUtils.isNotEmpty((CharSequence)policy.getString("mbkstype"))) {
            mbkstype = policy.getString("mbkstype");
        }
        DynamicObject bizdefObj = QueryServiceHelper.queryOne((String)"tpo_tccit_bizdef", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"BKQYLX")});
        QFilter bizdefFilter = new QFilter("bizdef", "=", bizdefObj.get("id"));
        QFilter numberFilter = new QFilter("number", "=", (Object)mbkstype);
        DynamicObject bizdefEntryObj = QueryServiceHelper.queryOne((String)"tpo_tccit_bizdef_entry", (String)"id,projectname,number", (QFilter[])new QFilter[]{bizdefFilter, numberFilter});
        dynamicObject.set("lossqiyetype", bizdefEntryObj.get("id"));
        dynamicObject.set("name", bizdefEntryObj.get("projectname"));
        dynamicObject.set("number", bizdefEntryObj.get("number"));
        int bndkmbnx = 5;
        if ("200".equals(mbkstype) || "300".equals(mbkstype) || "400".equals(mbkstype)) {
            bndkmbnx = 10;
        }
        if (("500".equals(mbkstype) || "600".equals(mbkstype)) && yearOfskssqq == 2020) {
            bndkmbnx = 8;
        }
        dynamicObject.set("yjjznx", (Object)bndkmbnx);
        dynamicObject.set("ksdqnd", (Object)(yearOfskssqq + bndkmbnx));
        dynamicObject.set("lossmoney", (Object)(orgJmhjnsd.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO : orgJmhjnsd));
        dynamicObject.set("flzcje", (Object)BigDecimal.ZERO);
        dynamicObject.set("ymbksje", (Object)BigDecimal.ZERO);
        dynamicObject.set("bnkmbksje", (Object)dynamicObject.getBigDecimal("ymbksje").add(dynamicObject.getBigDecimal("flzcje")).add(dynamicObject.getBigDecimal("lossmoney")));
        syjnsdmb = dynamicObject.getBigDecimal("bnkmbksje").abs().compareTo(jmhjnsd) > 0 ? jmhjnsd : dynamicObject.getBigDecimal("bnkmbksje").abs();
        syjnsdmb = BigDecimal.ZERO.compareTo(syjnsdmb) > 0 ? BigDecimal.ZERO : syjnsdmb;
        dynamicObject.set("syjnsdmb", (Object)syjnsdmb);
        dynamicObject.set("syjwsdmb", (Object)BigDecimal.ZERO);
        dynamicObject.set("dnkjzyhndksje", (Object)dynamicObject.getBigDecimal("bnkmbksje").abs().subtract(dynamicObject.getBigDecimal("syjnsdmb")).subtract(dynamicObject.getBigDecimal("syjwsdmb")));
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        sum.add((Object)dynamicObject);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DG_B105060_SUM, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(MbyqndksjsdgFormPlugin.class.getSimpleName(), Collections.singletonList(GetReduceFormPlugin.class.getSimpleName()));
            }
        };
    }
}

