/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.AddDeductionService;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.AddDeductionScene;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.enums.YjAccountSelectEnum;

public class NewAccountSelectFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String TREEVIEW = "treeviewap";
    public static final String DECLARETYPE = "declaretype";

    public void initialize() {
        super.initialize();
        String parentformid = this.getView().getFormShowParameter().getParentFormId();
        if ("tccit_declare_show".equals(parentformid)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"data_flex"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TreeView tv1 = (TreeView)this.getView().getControl(TREEVIEW);
        this.constructorData(tv1);
    }

    private void constructorData(TreeView tv1) {
        String rootId = "0";
        TreeNode rootNode = new TreeNode(null, "0", "0", true);
        rootNode.setIsOpened(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String declaretype = String.valueOf(customParams.getOrDefault(DECLARETYPE, this.getDeclaretype()));
        ArrayList<YjAccountSelectEnum> nodelist = this.getYjAccountSelectEnums(declaretype, customParams);
        String levytype = customParams.getOrDefault("levytype", "czzs");
        if ("hdzs".equals(levytype)) {
            nodelist.removeIf(s -> !Lists.newArrayList((Object[])new YjAccountSelectEnum[]{YjAccountSelectEnum.ASSETSDATA, YjAccountSelectEnum.TAXPAYDETAIL, YjAccountSelectEnum.ZERORATINGIN, YjAccountSelectEnum.NONTAX}).contains(s));
        }
        if (nodelist.isEmpty()) {
            return;
        }
        for (YjAccountSelectEnum singlenode : nodelist) {
            TreeNode tn = new TreeNode("0", singlenode.getName(), singlenode.getName(), false);
            rootNode.addChild(tn);
        }
        tv1.addNode(rootNode);
        tv1.focusNode(rootNode.getTreeNode(nodelist.get(0).getName(), 1));
        this.matchNode(nodelist.get(0).getName());
    }

    private ArrayList<YjAccountSelectEnum> getYjAccountSelectEnums(String declaretype, Map<String, Object> customParams) {
        ArrayList<Object> nodelist = new ArrayList(16);
        String endDate = (String)customParams.get("skssqz");
        String orgid = (String)customParams.get("orgid");
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        Boolean isAjsb = DeadlineService.getDeadline(orgid);
        if ("100".equals(declaretype)) {
            nodelist = this.excuteNodeAdd(Boolean.FALSE);
            nodelist.add((Object)YjAccountSelectEnum.ASSETSDATA);
            nodelist.add((Object)YjAccountSelectEnum.YJQYYH);
        } else if ("210".equals(declaretype) || "220".equals(declaretype) || "230".equals(declaretype)) {
            nodelist = this.excuteNodeAdd(Boolean.TRUE);
            nodelist.add((Object)YjAccountSelectEnum.ASSETSDATA);
            nodelist.add((Object)YjAccountSelectEnum.YJQYYH);
        } else if ("311".equals(declaretype)) {
            nodelist.add((Object)YjAccountSelectEnum.APPORTION);
        }
        if (AddDeductionScene.nodisplay_noclac != AddDeductionService.isSuitEndDate(draftpurpose, isAjsb, DateUtils.stringToDate((String)endDate))) {
            nodelist.add((Object)YjAccountSelectEnum.ADD_DEDUCTION);
        }
        nodelist.sort(Comparator.comparing(YjAccountSelectEnum::getOrder));
        return nodelist;
    }

    private ArrayList<YjAccountSelectEnum> excuteNodeAdd(Boolean issummary) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong(customParams.get("orgid").toString());
        ArrayList<Long> allorg = new ArrayList<Long>();
        allorg.add(orgid);
        if (issummary.booleanValue()) {
            QFilter q1 = new QFilter("orgrow.parentid", "=", (Object)orgid);
            DynamicObjectCollection orglist = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.orgid as orgid", (QFilter[])new QFilter[]{q1});
            for (DynamicObject org : orglist) {
                allorg.add(org.getLong("orgid"));
            }
        }
        boolean ishouseexists = RuleService.getSharingAndOrgRules(allorg, RuleTypeEnum.YJ_OTHER).size() > 0;
        List<DynamicObject> yhxmAllRules = RuleService.getSharingAndOrgRules(allorg, RuleTypeEnum.INCOME);
        boolean isnotaxexists = false;
        boolean istreducedexists = false;
        boolean istechtransexists = false;
        boolean isincredexists = false;
        if (yhxmAllRules.size() > 0) {
            for (DynamicObject rule : yhxmAllRules) {
                String rulenumber = (String)rule.getDynamicObject("itemchoicename").get("number");
                if (rulenumber.startsWith("MSSR")) {
                    isnotaxexists = true;
                    continue;
                }
                if (rulenumber.startsWith("JJSR")) {
                    istreducedexists = true;
                    continue;
                }
                if (rulenumber.equals("SD041") || rulenumber.equals("SD042")) {
                    istechtransexists = true;
                    continue;
                }
                isincredexists = true;
            }
        }
        boolean isassertexists = RuleService.getSharingAndOrgRules(allorg, RuleTypeEnum.DEPRECIATE).size() > 0;
        ArrayList<YjAccountSelectEnum> nodelist = new ArrayList<YjAccountSelectEnum>();
        nodelist.add(YjAccountSelectEnum.TAXPAYDETAIL);
        if (ishouseexists) {
            nodelist.add(YjAccountSelectEnum.HOUSEPROJECT);
        }
        nodelist.add(YjAccountSelectEnum.ZERORATINGIN);
        if (isnotaxexists) {
            nodelist.add(YjAccountSelectEnum.NONTAX);
        }
        if (istreducedexists) {
            nodelist.add(YjAccountSelectEnum.TREDUCED);
        }
        if (isincredexists) {
            nodelist.add(YjAccountSelectEnum.INCRED);
        }
        if (istechtransexists) {
            nodelist.add(YjAccountSelectEnum.TECH_TRANS);
        }
        if (issummary.booleanValue()) {
            nodelist.add(YjAccountSelectEnum.APPORTION);
        }
        if (isassertexists) {
            nodelist.add(YjAccountSelectEnum.ASSERT_ACCE_DEPRE);
        }
        nodelist.add(YjAccountSelectEnum.RECOUP_DEFICIT);
        return nodelist;
    }

    private void showFormInnerTabPage(String pageName, String nodename) {
        IPageCache parCache;
        String flag = "loadtb-" + nodename;
        FormShowParameter parameter = new FormShowParameter();
        String pageId = parameter.getPageId();
        parameter.setFormId(pageName);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("data_flex");
        parameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        this.getView().showForm(parameter);
        this.getPageCache().put(flag, pageId);
        if (this.getView().getParentView() != null && (parCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class)) != null) {
            parCache.put("declarepageid", pageId);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)TREEVIEW)) {
            String nodeId = (String)evt.getNodeId();
            this.matchNode(nodeId);
        }
    }

    private void matchNode(String selectNodename) {
        YjAccountSelectEnum yjAccountSelectEnum = YjAccountSelectEnum.getEnum(selectNodename);
        this.showFormInnerTabPage(yjAccountSelectEnum.getListTab(), selectNodename);
    }

    private String getDeclaretype() {
        String orgId = this.getPageCache().get("orgid");
        String enddate = this.getPageCache().get("skssqz");
        String declaretype = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgId, (String)enddate);
        return declaretype;
    }
}

