/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class NonInsuranceTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String NAME = "name";
    public static final String RULE_ID = "ruleid";
    public static final String ZZJE = "zzje";
    public static final String NON_ALLOW_AMOUNT = "nonallowamount";
    public static final String LIMIT_BASE = "limitbase";
    public static final String RATE = "rate";
    public static final String DEDUCT_AMOUNT = "deductamount";
    public static final String TAX_AMOUNT = "taxincome";
    public static final String NSTZJE = "nstzje";
    public static final Set<String> itemTypes = Sets.newHashSet((Object[])new String[]{"3010602", "3010603", "count"});
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,ruleid,name,zzje,nonallowamount,limitbase,rate,deductamount,taxincome,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_non_insurance_sum", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(NAME).setValueFast((Object)data, (Object)dynamicObject.getString(NAME));
            String ruleid = dynamicObject.getString(RULE_ID);
            dot.getProperty(RULE_ID).setValueFast((Object)data, (Object)ruleid);
            dot.getProperty(ZZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, ZZJE, ruleid));
            dot.getProperty(TAX_AMOUNT).setValueFast((Object)data, (Object)this.formatData(dynamicObject, TAX_AMOUNT, ruleid));
            dot.getProperty(NSTZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, NSTZJE, ruleid));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(DynamicObject dynamicObject, String columnType, String ruleId) {
        StringBuilder link = new StringBuilder("<nolink>");
        BigDecimal amount = dynamicObject.getBigDecimal(columnType).setScale(2, 4);
        String itemtype = dynamicObject.getString(ITEM_TYPE);
        if ("count".equals(itemtype)) {
            if (NSTZJE.equals(columnType)) {
                return DataFormat.formatMicrometer(amount.toString());
            }
            return link.append(DataFormat.formatMicrometer(amount.toString())).toString();
        }
        return DataFormat.formatMicrometer(amount.toString());
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        if (this.checkCalc(customParams)) {
            DynamicObjectCollection sum = new DynamicObjectCollection();
            List orglist = (List)customParams.get("orglist");
            List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.REMAJUST);
            if (CollectionUtils.isEmpty(sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && itemTypes.contains(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList()))) {
                return;
            }
            int index = 0;
            for (DynamicObject dynamicObject : sellRuleList) {
                DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)"tccit_non_insurance_sum");
                String number = dynamicObject.getDynamicObject("item").getString("number");
                dynamicObject2.set(ITEM_NO, (Object)(++index));
                dynamicObject2.set(ITEM_TYPE, (Object)number);
                dynamicObject2.set(NAME, (Object)dynamicObject.getString(NAME));
                dynamicObject2.set(RULE_ID, (Object)dynamicObject.getString("id"));
                dynamicObject2.set(ZZJE, (Object)this.calcAmount(dynamicObject.getString("id"), ZZJE, customParams, number));
                dynamicObject2.set(TAX_AMOUNT, (Object)this.calcAmount(dynamicObject.getString("id"), TAX_AMOUNT, customParams, number));
                dynamicObject2.set(NSTZJE, (Object)this.calcAmount(dynamicObject.getString("id"), NSTZJE, customParams, number));
                dynamicObject2.set("orgid", (Object)orgid);
                dynamicObject2.set("skssqq", (Object)skssqq);
                dynamicObject2.set("skssqz", (Object)skssqz);
                sum.add((Object)dynamicObject2);
            }
            this.appendRow(orgid, skssqq, skssqz, sum, index);
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        }
    }

    private boolean checkCalc(Map<String, Object> customParams) {
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        if (policy != null) {
            DynamicObject codeandname = QueryServiceHelper.queryOne((String)"tpo_tcvat_industrycode", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)policy.getDynamicObject("codeandname").getLong("id"))});
            String longnumber1 = codeandname.getString("longnumber");
            return policy != null && policy.getBoolean("deduct6") && longnumber1 != null && !longnumber1.startsWith("322.364");
        }
        return true;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_non_insurance_sum", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private void appendRow(Long orgid, Date skssqq, Date skssqz, DynamicObjectCollection sum, int index) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_non_insurance_sum");
        dynamicObject.set(ITEM_NO, (Object)(++index));
        dynamicObject.set(ITEM_TYPE, (Object)"count");
        dynamicObject.set(NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"NonInsuranceTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        dynamicObject.set(ZZJE, this.getSum(ZZJE));
        dynamicObject.set(TAX_AMOUNT, this.getSum(TAX_AMOUNT));
        dynamicObject.set(NSTZJE, this.getSum(NSTZJE));
        dynamicObject.set("orgid", (Object)orgid);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        sum.add((Object)dynamicObject);
    }

    private Object getSum(String columnType) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : this.dataMap.entrySet()) {
            if (!entry.getKey().endsWith(columnType)) continue;
            sum = sum.add(entry.getValue());
        }
        return sum;
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, String itemNumber) {
        if (ZZJE.equals(columnType)) {
            BigDecimal amount = this.getAmount(rowType, customParams, columnType, "zzjeqs");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if (TAX_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getAmount(rowType, customParams, columnType, "ssjeqs");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if (NSTZJE.equals(columnType)) {
            BigDecimal zzjeAmount = this.dataMap.get(this.getKey(rowType, ZZJE));
            BigDecimal taxIncome = this.dataMap.get(this.getKey(rowType, TAX_AMOUNT));
            BigDecimal nstzje = zzjeAmount.subtract(taxIncome);
            this.dataMap.put(this.getKey(rowType, columnType), nstzje);
            return nstzje;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(String ruleid, Map<String, Object> customParams, String columnType, String entrytype) {
        return this.getCellAmount(customParams, columnType, entrytype, null, null, Long.valueOf(ruleid), "tccit_non_insurance_det");
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULE_ID));
        String fieldName = evt.getFieldName();
        String entrytype = this.getEntryType(fieldName);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", entrytype);
        customParams.put(RULE_ID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", "tccit_non_insurance_det");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private String getEntryType(String fieldName) {
        String entrytype = "";
        if (ZZJE.equals(fieldName)) {
            entrytype = "zzjeqs";
        } else if (TAX_AMOUNT.equals(fieldName)) {
            entrytype = "ssjeqs";
        }
        return entrytype;
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{ZZJE, TAX_AMOUNT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULE_ID);
        customParams.put("entryname", "tccit_non_insurance_det");
        customParams.put("entrytype", this.getEntryType(column));
        customParams.put("columnType", column);
        customParams.put(RULE_ID, ruleid);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }
}

