/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class OtherFreeTaxFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String TCCIT_DG_B105038_SUM = "tccit_dg_b105038_sum";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"1", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.6.1", "1.6.2", "2", "2.1", "2.2", "2.3", "2.4", "2.5", "2.6", "2.7", "3", "3.1", "3.2", "3.3", "3.3.1", "3.3.2", "3.3.3", "4"});
    public static final List<String> itemTypesCalc = Lists.newArrayList((Object[])new String[]{"1.1", "1.2", "1.3", "1.4", "1.5", "1.6.1", "1.6.2", "2.1", "2.2", "2.3", "2.4", "2.5", "2.6", "2.7", "3.1", "3.2", "3.3.1", "3.3.2", "3.3.3", "3.3", "1.6", "1", "2", "3", "4"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_NAME = "name";
    public static final String ZZJE = "zzje";
    public static final String SSYHBL = "ssyhbl";
    public static final String SSYHJE = "ssyhje";
    public static final String ITEMNUMBER = "itemnumber";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initData() {
        Date skssqz;
        Date skssqq;
        QFilter dateFilter;
        String selectFields = "itemno,name,itemnumber,zzje,ssyhbl,ssyhje";
        QFilter itemtypeFilter = new QFilter(ITEM_NO, "in", itemTypes);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_DG_B105038_SUM, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter = new QFilter("skssqq", "=", (Object)(skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq"))))).and(new QFilter("skssqz", "=", (Object)(skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz"))))))}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", itemTypes.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < itemTypes.size(); ++i) {
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            String itemNo = itemTypes.get(i);
            DynamicObject object = query.stream().filter(s -> s.getString(ITEM_NO).equals(itemNo)).findFirst().get();
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)itemNo);
            dot.getProperty(ITEM_NAME).setValueFast((Object)data, (Object)itemNo);
            dot.getProperty(ITEMNUMBER).setValueFast((Object)data, (Object)object.getString(ITEMNUMBER));
            if ("1.1".equals(itemNo) && BigDecimal.ZERO.compareTo(object.getBigDecimal(ZZJE)) < 0) {
                DynamicObjectCollection apitudeentryentity;
                boolean exists;
                TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong((String)customParams.get("orgid")));
                if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u5e74\u5ea6\u7533\u62a5\u7684\u3010\u975e\u8425\u5229\u6027\u7ec4\u7ec7\u3011\u7684\u8d44\u8d28\u6709\u6548\u6027", (String)"OtherFreeTaxFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                }
                if (!(exists = (apitudeentryentity = ((DynamicObject)result.getData()).getDynamicObjectCollection("apitudeentryentity")).stream().anyMatch(d -> d.getDate("apitudestartdate").before(DateUtils.stringToDate((String)((String)customParams.get("skssqq")))) && (d.getDate("apitudeenddate") == null || d.getDate("apitudeenddate").after(DateUtils.stringToDate((String)((String)customParams.get("skssqz"))))) && d.getLong("companytype.id") == 1073030898875677709L))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u5e74\u5ea6\u7533\u62a5\u7684\u3010\u975e\u8425\u5229\u6027\u7ec4\u7ec7\u3011\u7684\u8d44\u8d28\u6709\u6548\u6027", (String)"OtherFreeTaxFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                }
            }
            dot.getProperty(ZZJE).setValueFast((Object)data, (Object)this.getFormatData(itemNo, object.getBigDecimal(ZZJE), ZZJE));
            dot.getProperty(SSYHBL).setValueFast((Object)data, (Object)this.getFormatData(itemNo, object.getBigDecimal(SSYHBL), SSYHBL));
            dot.getProperty(SSYHJE).setValueFast((Object)data, (Object)this.getFormatData(itemNo, object.getBigDecimal(SSYHJE), SSYHJE));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String getFormatData(String rowType, BigDecimal data, String columnType) {
        data = data.setScale(2, 4);
        StringBuilder link = new StringBuilder("<nolink>");
        if ((rowType.length() == 1 || "3.1".equals(rowType) || "1.6".equals(rowType) || "3.3".equals(rowType)) && ZZJE.equals(columnType)) {
            return link.append(DataFormat.formatMicrometer(data.toString())).toString();
        }
        if ((rowType.length() == 1 || "1.6".equals(rowType) || "3.3".equals(rowType)) && SSYHBL.equals(columnType)) {
            return "<nolink>*";
        }
        if (SSYHBL.equals(columnType)) {
            return link.append(DataFormat.formatRate(data.toString())).toString();
        }
        return DataFormat.formatMicrometer(data.toString());
    }

    public void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DG_B105038_SUM, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("yhsx4")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (int i = 0; i < itemTypesCalc.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_DG_B105038_SUM);
            dynamicObject.set(ITEM_NO, (Object)itemTypesCalc.get(i));
            dynamicObject.set(ITEM_NAME, (Object)itemTypesCalc.get(i));
            dynamicObject.set(ZZJE, (Object)this.calcAmount(itemTypesCalc.get(i), ZZJE, customParams, dynamicObject));
            dynamicObject.set(SSYHBL, (Object)this.calcAmount(itemTypesCalc.get(i), SSYHBL, customParams, dynamicObject));
            dynamicObject.set(SSYHJE, (Object)this.calcAmount(itemTypesCalc.get(i), SSYHJE, customParams, dynamicObject));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, DynamicObject dynamicObject) {
        BigDecimal fylzzsr;
        BigDecimal amount;
        if ("1".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount2 = this.dataMap.get("1.1zzje").add(this.dataMap.get("1.2zzje")).add(this.dataMap.get("1.3zzje")).add(this.dataMap.get("1.4zzje")).add(this.dataMap.get("1.5zzje")).add(this.dataMap.get("1.6zzje"));
                this.dataMap.put(rowType + columnType, amount2);
                return amount2;
            }
            if (SSYHBL.equals(columnType)) {
                return BigDecimal.ZERO;
            }
            BigDecimal amount3 = this.dataMap.get("1.1ssyhje").add(this.dataMap.get("1.2ssyhje")).add(this.dataMap.get("1.3ssyhje")).add(this.dataMap.get("1.4ssyhje")).add(this.dataMap.get("1.5ssyhje")).add(this.dataMap.get("1.6ssyhje"));
            this.dataMap.put(rowType + columnType, amount3);
            return amount3;
        }
        if ("2".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount4 = this.dataMap.get("2.1zzje").add(this.dataMap.get("2.2zzje")).add(this.dataMap.get("2.3zzje")).add(this.dataMap.get("2.4zzje")).add(this.dataMap.get("2.5zzje")).add(this.dataMap.get("2.6zzje")).add(this.dataMap.get("2.7zzje"));
                this.dataMap.put(rowType + columnType, amount4);
                return amount4;
            }
            if (SSYHBL.equals(columnType)) {
                return BigDecimal.ZERO;
            }
            BigDecimal amount5 = this.dataMap.get("2.1ssyhje").add(this.dataMap.get("2.2ssyhje")).add(this.dataMap.get("2.3ssyhje")).add(this.dataMap.get("2.4ssyhje")).add(this.dataMap.get("2.5ssyhje")).add(this.dataMap.get("2.6ssyhje")).add(this.dataMap.get("2.7ssyhje"));
            this.dataMap.put(rowType + columnType, amount5);
            return amount5;
        }
        if ("3".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount6 = this.dataMap.get("3.1zzje").add(this.dataMap.get("3.2zzje")).add(this.dataMap.get("3.3zzje"));
                this.dataMap.put(rowType + columnType, amount6);
                return amount6;
            }
            if (SSYHBL.equals(columnType)) {
                return BigDecimal.ZERO;
            }
            BigDecimal amount7 = this.dataMap.get("3.1ssyhje").add(this.dataMap.get("3.2ssyhje")).add(this.dataMap.get("3.3ssyhje"));
            this.dataMap.put(rowType + columnType, amount7);
            return amount7;
        }
        if ("4".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount8 = this.dataMap.get("1zzje").add(this.dataMap.get("2zzje")).add(this.dataMap.get("3zzje"));
                this.dataMap.put(rowType + columnType, amount8);
                return amount8;
            }
            if (SSYHBL.equals(columnType)) {
                return BigDecimal.ZERO;
            }
            BigDecimal amount9 = this.dataMap.get("1ssyhje").add(this.dataMap.get("2ssyhje")).add(this.dataMap.get("3ssyhje"));
            this.dataMap.put(rowType + columnType, amount9);
            return amount9;
        }
        if ("1.6".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount10 = this.dataMap.get("1.6.1zzje").add(this.dataMap.get("1.6.2zzje"));
                this.dataMap.put(rowType + columnType, amount10);
                return amount10;
            }
            if (SSYHBL.equals(columnType)) {
                return BigDecimal.ZERO;
            }
            BigDecimal amount11 = this.dataMap.get("1.6.1ssyhje").add(this.dataMap.get("1.6.2ssyhje"));
            this.dataMap.put(rowType + columnType, amount11);
            return amount11;
        }
        if ("3.3".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount12 = this.dataMap.get("3.3.1zzje").add(this.dataMap.get("3.3.2zzje")).add(this.dataMap.get("3.3.3zzje"));
                this.dataMap.put(rowType + columnType, amount12);
                return amount12;
            }
            if (SSYHBL.equals(columnType)) {
                return BigDecimal.ZERO;
            }
            BigDecimal amount13 = this.dataMap.get("3.3.1ssyhje").add(this.dataMap.get("3.3.2ssyhje")).add(this.dataMap.get("3.3.3ssyhje"));
            this.dataMap.put(rowType + columnType, amount13);
            return amount13;
        }
        if (SSYHJE.equals(columnType) && rowType.length() > 1) {
            BigDecimal ssyhbl = this.dataMap.get(rowType + ZZJE).multiply(this.dataMap.get(rowType + SSYHBL)).divide(BigDecimal.valueOf(100L), 2, 4);
            this.dataMap.put(rowType + columnType, ssyhbl);
            return ssyhbl;
        }
        if ("1.1".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount14 = this.getAmount(customParams, columnType, "501");
                this.dataMap.put(rowType + columnType, amount14);
                dynamicObject.set(ITEMNUMBER, (Object)"501");
                return amount14;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr2 = this.getAssistData(customParams, "FYLZZSR");
                this.dataMap.put(rowType + columnType, fylzzsr2);
                return fylzzsr2;
            }
        }
        if ("1.2".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount15 = this.getAmount(customParams, columnType, "502");
                this.dataMap.put(rowType + columnType, amount15);
                dynamicObject.set(ITEMNUMBER, (Object)"502");
                return amount15;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr3 = this.getAssistData(customParams, "QJFZJZJZSR");
                this.dataMap.put(rowType + columnType, fylzzsr3);
                return fylzzsr3;
            }
        }
        if ("1.3".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount16 = this.getAmount(customParams, columnType, "503");
                this.dataMap.put(rowType + columnType, amount16);
                dynamicObject.set(ITEMNUMBER, (Object)"503");
                return amount16;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr4 = this.getAssistData(customParams, "BXBZJJSR");
                this.dataMap.put(rowType + columnType, fylzzsr4);
                return fylzzsr4;
            }
        }
        if ("1.4".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount17 = this.getAmount(customParams, columnType, "504");
                this.dataMap.put(rowType + columnType, amount17);
                dynamicObject.set(ITEMNUMBER, (Object)"504");
                return amount17;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr5 = this.getAssistData(customParams, "AWHQDDAZWSR");
                this.dataMap.put(rowType + columnType, fylzzsr5);
                return fylzzsr5;
            }
        }
        if ("1.5".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount18 = this.getAmount(customParams, columnType, "505");
                this.dataMap.put(rowType + columnType, amount18);
                dynamicObject.set(ITEMNUMBER, (Object)"505");
                return amount18;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr6 = this.getAssistData(customParams, "CAHQDBJDAZWSR");
                this.dataMap.put(rowType + columnType, fylzzsr6);
                return fylzzsr6;
            }
        }
        if ("1.6.1".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount19 = this.getAmount(customParams, columnType, "507");
                this.dataMap.put(rowType + columnType, amount19);
                dynamicObject.set(ITEMNUMBER, (Object)"507");
                return amount19;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr7 = this.getAssistData(customParams, "JCYJZJSR");
                this.dataMap.put(rowType + columnType, fylzzsr7);
                return fylzzsr7;
            }
        }
        if ("1.6.2".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount20 = this.getAmount(customParams, columnType, "506");
                this.dataMap.put(rowType + columnType, amount20);
                dynamicObject.set(ITEMNUMBER, (Object)"506");
                return amount20;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr8 = this.getAssistData(customParams, "QT");
                this.dataMap.put(rowType + columnType, fylzzsr8);
                return fylzzsr8;
            }
        }
        if ("2.1".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount21 = this.getAmount(customParams, columnType, "601");
                this.dataMap.put(rowType + columnType, amount21);
                dynamicObject.set(ITEMNUMBER, (Object)"601");
                return amount21;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr9 = this.getAssistData(customParams, "ZHLYZYSCSR");
                this.dataMap.put(rowType + columnType, fylzzsr9);
                return fylzzsr9;
            }
        }
        if ("2.2".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount22 = this.getAmount(customParams, columnType, "60201");
                this.dataMap.put(rowType + columnType, amount22);
                dynamicObject.set(ITEMNUMBER, (Object)"60201");
                return amount22;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr10 = this.getAssistData(customParams, "JRJGSNDKLX");
                this.dataMap.put(rowType + columnType, fylzzsr10);
                return fylzzsr10;
            }
        }
        if ("2.3".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount23 = this.getAmount(customParams, columnType, "60202");
                this.dataMap.put(rowType + columnType, amount23);
                dynamicObject.set(ITEMNUMBER, (Object)"60202");
                return amount23;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr11 = this.getAssistData(customParams, "BXJGSNBFSR");
                this.dataMap.put(rowType + columnType, fylzzsr11);
                return fylzzsr11;
            }
        }
        if ("2.4".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount24 = this.getAmount(customParams, columnType, "60203");
                this.dataMap.put(rowType + columnType, amount24);
                dynamicObject.set(ITEMNUMBER, (Object)"60203");
                return amount24;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr12 = this.getAssistData(customParams, "XEDKGSSNDK");
                this.dataMap.put(rowType + columnType, fylzzsr12);
                return fylzzsr12;
            }
        }
        if ("2.5".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount25 = this.getAmount(customParams, columnType, "603");
                this.dataMap.put(rowType + columnType, amount25);
                dynamicObject.set(ITEMNUMBER, (Object)"603");
                return amount25;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr13 = this.getAssistData(customParams, "TLLXZQSR");
                this.dataMap.put(rowType + columnType, fylzzsr13);
                return fylzzsr13;
            }
        }
        if ("2.6".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount26 = this.getAmount(customParams, columnType, "60401");
                this.dataMap.put(rowType + columnType, amount26);
                dynamicObject.set(ITEMNUMBER, (Object)"60401");
                return amount26;
            }
            if (SSYHBL.equals(columnType)) {
                BigDecimal fylzzsr14 = this.getAssistData(customParams, "SQJTFWSR");
                this.dataMap.put(rowType + columnType, fylzzsr14);
                return fylzzsr14;
            }
        }
        if ("2.7".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                BigDecimal amount27 = this.getAmount(customParams, columnType, "60402");
                this.dataMap.put(rowType + columnType, amount27);
                dynamicObject.set(ITEMNUMBER, (Object)"60402");
                return amount27;
            }
            if (SSYHBL.equals(columnType)) {
                this.dataMap.put(rowType + columnType, BigDecimal.ZERO);
                return BigDecimal.ZERO;
            }
        }
        if ("3.1".equals(rowType)) {
            QFilter q4;
            QFilter q3;
            QFilter q2;
            Object orgid = customParams.get("orgid");
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
            DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_develop_jjkc", (String)"yxkcyffydjtssr as row8,dnxsyfzjxccpdclbf as row9,yqxsyfzjxccpdclbf as row10,jjkcbl as row11", (QFilter[])new QFilter[]{q1, q2 = new QFilter("year", "=", (Object)DateUtils.getFirstDateOfYear((Date)skssqq)), q3 = new QFilter("declaretype", "=", (Object)"2"), q4 = new QFilter("deductiontype", "=", (Object)"3")});
            if (object != null) {
                BigDecimal row8 = object.getBigDecimal("row8");
                BigDecimal row9 = object.getBigDecimal("row9");
                BigDecimal row10 = object.getBigDecimal("row10");
                BigDecimal row11 = object.getBigDecimal("row11");
                BigDecimal subtract = row8.subtract(row9).subtract(row10);
                if (ZZJE.equals(columnType)) {
                    this.dataMap.put(rowType + columnType, subtract);
                    return subtract;
                }
                if (SSYHBL.equals(columnType)) {
                    this.dataMap.put(rowType + columnType, row11);
                    return row11;
                }
                BigDecimal amount28 = subtract.multiply(row11).divide(new BigDecimal("100"), 2, 4);
                this.dataMap.put(rowType + columnType, amount28);
                return amount28;
            }
        }
        if ("3.2".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                amount = this.getAmount(customParams, columnType, "701");
                this.dataMap.put(rowType + columnType, amount);
                return amount;
            }
            if (SSYHBL.equals(columnType)) {
                fylzzsr = this.getAssistData(customParams, "CJRYGGZ");
                this.dataMap.put(rowType + columnType, fylzzsr);
                dynamicObject.set(ITEMNUMBER, (Object)"701");
                return fylzzsr;
            }
        }
        if ("3.3.1".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                amount = this.getAmount(customParams, columnType, "704");
                this.dataMap.put(rowType + columnType, amount);
                dynamicObject.set(ITEMNUMBER, (Object)"704");
                return amount;
            }
            if (SSYHBL.equals(columnType)) {
                fylzzsr = this.getAssistData(customParams, "QYTRJCYJZC");
                this.dataMap.put(rowType + columnType, fylzzsr);
                return fylzzsr;
            }
        }
        if ("3.3.2".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                amount = this.getAmount(customParams, columnType, "705");
                this.dataMap.put(rowType + columnType, amount);
                dynamicObject.set(ITEMNUMBER, (Object)"705");
                return amount;
            }
            if (SSYHBL.equals(columnType)) {
                fylzzsr = this.getAssistData(customParams, "GXJSQYSBQJ");
                this.dataMap.put(rowType + columnType, fylzzsr);
                return fylzzsr;
            }
        }
        if ("3.3.3".equals(rowType)) {
            if (ZZJE.equals(columnType)) {
                amount = this.getAmount(customParams, columnType, "702");
                this.dataMap.put(rowType + columnType, amount);
                dynamicObject.set(ITEMNUMBER, (Object)"702");
                return amount;
            }
            if (SSYHBL.equals(columnType)) {
                this.dataMap.put(rowType + columnType, BigDecimal.ZERO);
                return BigDecimal.ZERO;
            }
        }
        this.dataMap.put(rowType + columnType, BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAssistData(Map<String, Object> customParams, String assistCode) {
        List assistList = AssistService.queryAssistParams((String)assistCode, (String)String.valueOf(customParams.get("orgid")), (String)String.valueOf(customParams.get("skssqq")), (String)String.valueOf(customParams.get("skssqz")));
        return CollectionUtils.isEmpty((Collection)assistList) ? BigDecimal.valueOf(0.0) : new BigDecimal((String)assistList.get(0)).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, String itemnumber) {
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, null, "tccit_dg_b105038_det");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (SSYHBL.equals(fieldName)) {
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemnumber = (String)itemsEntity.getModel().getValue(ITEMNUMBER);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", ZZJE);
        customParams.put(ITEMNUMBER, itemnumber);
        customParams.put("entryname", "tccit_dg_b105038_det");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DG_B105038_SUM, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{ZZJE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemnumber = row.getString(ITEMNUMBER);
        customParams.put("entryname", "tccit_dg_b105038_det");
        customParams.put("entrytype", ZZJE);
        customParams.put("columnType", column);
        customParams.put(ITEMNUMBER, itemnumber);
        return customParams;
    }
}

