/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import org.apache.commons.collections.CollectionUtils;

public class OtherHighTechFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    private static final String TCCIT_A301010201_LEVEL = "tccit_a301010201_level";
    private static final String TCCIT_A301010201_INCOME = "tccit_a301010201_income";
    private static final String TCCIT_A301010201_PEOPLE = "tccit_a301010201_people";
    private static final String TCCIT_A301010201_DEVELOP = "tccit_a301010201_develop";
    private static final String TCCIT_DG_A301010201_DET = "tccit_dg_a301010201_det";
    private static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String ITEM_NUMBER = "itemnumber";
    public static final String ORGID = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    private static final List<String> DG_NAMES = Lists.newArrayList((Object[])new String[]{"tccit_a301010201_level", "tccit_a301010201_income", "tccit_a301010201_people", "tccit_a301010201_develop"});
    private static final List<String> DELETE_TABLE = Lists.newArrayList((Object[])new String[]{"tccit_a301010201_income", "tccit_a301010201_people", "tccit_a301010201_develop"});
    private static final String LEVEL_ENTRYENTITY = "levelentryentity";
    private static final String INCOME_ENTRYENTITY = "incomeentryentity";
    private static final String PEOPLE_ENTRYENTITY = "peopleentryentity";
    private static final String DEVELOP_ENTRYENTITY = "developentryentity";
    private static final List<String> ENTRY_NAMES = Lists.newArrayList((Object[])new String[]{"levelentryentity", "incomeentryentity", "peopleentryentity", "developentryentity"});
    private Map<String, List<String>> ENTRY_COLUMNS_MAPPING = new HashMap<String, List<String>>();
    private Map<String, String> developMapping = new HashMap<String, String>();
    private LinkedHashMap<String, String> incomeMapping = new LinkedHashMap();
    private LinkedHashMap<String, String> peopleMapping = new LinkedHashMap();
    private Map<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>();
    private List<String> incomeItemList = new ArrayList<String>();
    private List<String> developItemList = new ArrayList<String>();
    private List<String> peopleItemList = new ArrayList<String>();
    private Map<String, String> developDeclareItemList = new HashMap<String, String>();
    private static final List<String> calcItem = Arrays.asList("incomeamount_1", "incomeamount_4", "incomeamount_7", "peopleamount_3", "curryear_14", "curryear_11", "curryear_10", "curryear_2", "curryear_1");
    private static final List<String> calcSumItem = Arrays.asList("curryear_1", "curryear_10", "curryear_11", "curryear_2", "curryear_14");
    private List<String> incomeNolinkFiledList = Arrays.asList("1", "4");
    private List<String> developNolinkFiledList = Arrays.asList("1", "2", "10", "11", "14");

    public OtherHighTechFormPlugin() {
        this.incomeItemList.addAll(Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7"}));
        this.peopleItemList.addAll(Lists.newArrayList((Object[])new String[]{"1", "2", "3"}));
        this.developItemList.addAll(Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"}));
        this.ENTRY_COLUMNS_MAPPING.put(LEVEL_ENTRYENTITY, Lists.newArrayList((Object[])new String[]{"leveltype", "leveldesc"}));
        this.ENTRY_COLUMNS_MAPPING.put(INCOME_ENTRYENTITY, Lists.newArrayList((Object[])new String[]{"incometype", "incomeamount", "incomeitemtype", "incomeitemnumber"}));
        this.ENTRY_COLUMNS_MAPPING.put(PEOPLE_ENTRYENTITY, Lists.newArrayList((Object[])new String[]{"peopletype", "peopleamount", "peopleitemtype", "peopleitemnumber"}));
        this.ENTRY_COLUMNS_MAPPING.put(DEVELOP_ENTRYENTITY, Lists.newArrayList((Object[])new String[]{"developtype", "curryear", "preoneyear", "pretwoyear", "sumamount", "developitemtype", "developitemnumber"}));
        this.developMapping.put("1", "1");
        this.developMapping.put("2", "2");
        this.developMapping.put("3", "1300301");
        this.developMapping.put("4", "1300302");
        this.developMapping.put("5", "1300303");
        this.developMapping.put("6", "1300304");
        this.developMapping.put("7", "1300305");
        this.developMapping.put("8", "1300306");
        this.developMapping.put("9", "1300307");
        this.developMapping.put("10", "10");
        this.developMapping.put("11", "11");
        this.developMapping.put("12", "1300308");
        this.developMapping.put("13", "1300309");
        this.developMapping.put("14", "14");
        this.developMapping.put("15", "1300310");
        this.developMapping.put("16", "16");
        this.developDeclareItemList.put("1", "15");
        this.developDeclareItemList.put("2", "16");
        this.developDeclareItemList.put("3", "17");
        this.developDeclareItemList.put("4", "18");
        this.developDeclareItemList.put("5", "19");
        this.developDeclareItemList.put("6", "20");
        this.developDeclareItemList.put("7", "21");
        this.developDeclareItemList.put("8", "22");
        this.developDeclareItemList.put("9", "23");
        this.developDeclareItemList.put("10", "24");
        this.developDeclareItemList.put("11", "25");
        this.developDeclareItemList.put("12", "26");
        this.developDeclareItemList.put("13", "27");
        this.developDeclareItemList.put("14", "28");
        this.developDeclareItemList.put("15", "29");
        this.developDeclareItemList.put("16", "30");
        this.incomeMapping.put("2", "1300101");
        this.incomeMapping.put("3", "1300102");
        this.incomeMapping.put("5", "1300103");
        this.incomeMapping.put("6", "1300104");
        this.incomeMapping.put("1", "1");
        this.incomeMapping.put("4", "2");
        this.incomeMapping.put("7", "7");
        this.peopleMapping.put("1", "1300201");
        this.peopleMapping.put("2", "1300202");
        this.peopleMapping.put("3", "3");
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(INCOME_ENTRYENTITY);
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl(PEOPLE_ENTRYENTITY);
        entryGrid2.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
        entryGrid2.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid3 = (EntryGrid)this.getControl(DEVELOP_ENTRYENTITY);
        entryGrid3.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
        entryGrid3.addHyperClickListener((HyperLinkClickListener)this);
        TextEdit leveldesc = (TextEdit)this.getControl("leveldesc");
        leveldesc.addClickListener((ClickListener)this);
    }

    private void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        StringBuilder link = new StringBuilder("<nolink>");
        if (columnDesc.getEntryKey().equals(INCOME_ENTRYENTITY)) {
            if (this.incomeNolinkFiledList.contains(d.getString("incometype")) && "incomeamount".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)link.append(DataFormat.formatMicrometer(d.get("incomeamount").toString())).toString());
            }
            if (d.getInt("incometype") == 7 && "incomeamount".equals(columnDesc.getKey())) {
                BigDecimal multiply = d.getBigDecimal("incomeamount").multiply(new BigDecimal("100")).setScale(2, 4);
                e.setFormatValue((Object)link.append(DataFormat.formatRate(multiply.toString())).toString());
            }
        } else if (columnDesc.getEntryKey().equals(PEOPLE_ENTRYENTITY)) {
            if (d.getInt("peopletype") == 3 && "peopleamount".equals(columnDesc.getKey())) {
                BigDecimal multiply = d.getBigDecimal("peopleamount").multiply(new BigDecimal("100")).setScale(2, 4);
                e.setFormatValue((Object)link.append(DataFormat.formatRate(multiply.toString())).toString());
            } else if (d.getInt("peopletype") != 3 && "peopleamount".equals(columnDesc.getKey())) {
                BigDecimal peopleamount = d.getBigDecimal("peopleamount").setScale(0, 4);
                e.setFormatValue((Object)peopleamount.toString());
            }
        } else if (columnDesc.getEntryKey().equals(DEVELOP_ENTRYENTITY)) {
            if (d.getInt("developtype") == 16 && "sumamount".equals(columnDesc.getKey())) {
                BigDecimal multiply = d.getBigDecimal("sumamount").multiply(new BigDecimal("100")).setScale(2, 4);
                e.setFormatValue((Object)DataFormat.formatRate(multiply.toString()));
            } else if (d.getInt("developtype") == 16 && Lists.newArrayList((Object[])new String[]{"preoneyear", "pretwoyear"}).contains(columnDesc.getKey())) {
                e.setFormatValue((Object)"\u2014\u2014");
            }
            if (this.developNolinkFiledList.contains(d.getString("developtype")) && "curryear".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)link.append(DataFormat.formatMicrometer(d.get("curryear").toString())).toString());
            }
            if (d.getInt("developtype") == 16 && "curryear".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)link.append("\u2014\u2014").toString());
            }
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof TextEdit && "leveldesc".equals(((TextEdit)source).getKey())) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tpo_tccit_bizdefen_tree", (boolean)false);
            listShowParameter.getTreeFilterParameter().setQFilters(Collections.singletonList(new QFilter("mainid", "=", (Object)1067889017892113408L)));
            listShowParameter.getListFilterParameter().setFilter(new QFilter("mainid", "=", (Object)1067889017892113408L));
            listShowParameter.getListFilterParameter().setFilter(new QFilter("isleaf", "=", (Object)"1"));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "leveldesc"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgidFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        if ("leveldesc".equals(closedCallBackEvent.getActionId()) && EmptyCheckUtils.isNotEmpty((Object)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            HashMap<String, String> result = new HashMap<String, String>();
            this.getLevelNameMap((Long)returnData.get(0).getPrimaryKeyValue(), result);
            List<DynamicObject> dynamicObjectList = this.querySummeryData(TCCIT_A301010201_LEVEL, orgidFilter, dateFilter);
            for (int i = 1; i <= 3; ++i) {
                this.getModel().setValue("leveldesc", result.get(String.valueOf(i)), i - 1);
                dynamicObjectList.get(i - 1).set("leveldesc", result.get(String.valueOf(i)));
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
        this.setEnable();
    }

    private void setEnable() {
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"leveldesc"});
        this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{"leveldesc"});
    }

    private Map<String, List<DynamicObject>> queryData(Long orgid, Date skssqq, Date skssqz) {
        HashMap<String, List<DynamicObject>> resultDatas = new HashMap<String, List<DynamicObject>>(16);
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        List<DynamicObject> levelData = this.querySummeryData(TCCIT_A301010201_LEVEL, orgFilter, dateFilter);
        List<DynamicObject> incomeData = this.querySummeryData(TCCIT_A301010201_INCOME, orgFilter, dateFilter);
        List<DynamicObject> peopleData = this.querySummeryData(TCCIT_A301010201_PEOPLE, orgFilter, dateFilter);
        List<DynamicObject> developData = this.querySummeryData(TCCIT_A301010201_DEVELOP, orgFilter, dateFilter);
        resultDatas.put(LEVEL_ENTRYENTITY, levelData);
        resultDatas.put(INCOME_ENTRYENTITY, incomeData);
        resultDatas.put(PEOPLE_ENTRYENTITY, peopleData);
        resultDatas.put(DEVELOP_ENTRYENTITY, developData);
        return resultDatas;
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        Map<String, List<DynamicObject>> savedatas = this.queryData(orgid, skssqq, skssqz);
        IDataModel model = this.getModel();
        for (String entryname : ENTRY_NAMES) {
            model.deleteEntryData(entryname);
            model.batchCreateNewEntryRow(entryname, savedatas.get(entryname).size());
            DynamicObjectCollection entryentity = model.getEntryEntity(entryname);
            DynamicObjectType dot = entryentity.getDynamicObjectType();
            int rowIndex = 0;
            for (DynamicObject dynamicObject : savedatas.get(entryname)) {
                DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
                for (String filed : this.ENTRY_COLUMNS_MAPPING.get(entryname)) {
                    dot.getProperty(filed).setValueFast((Object)data, dynamicObject.get(this.getKey(filed)));
                }
                ++rowIndex;
            }
            this.getView().updateView(entryname);
        }
    }

    private String getKey(String filed) {
        if (filed.contains(ITEM_NUMBER)) {
            return ITEM_NUMBER;
        }
        if (filed.contains(ITEM_TYPE)) {
            return ITEM_TYPE;
        }
        if (filed.contains(ITEM_NO)) {
            return ITEM_NO;
        }
        return filed;
    }

    private void calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgidFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DELETE_TABLE.forEach(name -> DeleteServiceHelper.delete((String)name, (QFilter[])new QFilter[]{orgidFilter, dateFilter}));
        DynamicObjectCollection perDeclareData = this.getPerDeclareData(customParams);
        DynamicObject highTechAccount = this.getHighTechAccount(customParams);
        DynamicObjectCollection levelSum = new DynamicObjectCollection();
        levelSum.addAll(this.querySummeryData(TCCIT_A301010201_LEVEL, orgidFilter, dateFilter));
        if (CollectionUtils.isEmpty((Collection)levelSum)) {
            this.calLevelData(highTechAccount, perDeclareData, orgid, skssqq, skssqz, orgFilter, dateFilter, levelSum);
        }
        DynamicObjectCollection incomeSum = new DynamicObjectCollection();
        for (String string : this.incomeItemList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_A301010201_INCOME);
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            String number = this.incomeMapping.get(string);
            dynamicObject.set(ITEM_TYPE, (Object)number);
            dynamicObject.set(ITEM_NUMBER, (Object)number);
            dynamicObject.set(ITEM_NO, (Object)string);
            BigDecimal amount = this.getAmount(customParams, number, "zzje");
            dynamicObject.set("incometype", (Object)string);
            dynamicObject.set("incomeamount", (Object)amount);
            incomeSum.add((Object)dynamicObject);
            this.dataMap.put("incomeamount_" + string, dynamicObject);
        }
        DynamicObjectCollection peopleSum = new DynamicObjectCollection();
        for (String string : this.peopleItemList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_A301010201_PEOPLE);
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            String number = this.peopleMapping.get(string);
            dynamicObject.set(ITEM_TYPE, (Object)number);
            dynamicObject.set(ITEM_NUMBER, (Object)number);
            dynamicObject.set(ITEM_NO, (Object)string);
            BigDecimal amount = this.getAmount(customParams, number, "zzje");
            dynamicObject.set("peopletype", (Object)string);
            dynamicObject.set("peopleamount", (Object)amount);
            peopleSum.add((Object)dynamicObject);
            this.dataMap.put("peopleamount_" + string, dynamicObject);
        }
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (String item : this.developItemList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_A301010201_DEVELOP);
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            String number = this.developMapping.get(item);
            dynamicObject.set(ITEM_TYPE, (Object)number);
            dynamicObject.set(ITEM_NUMBER, (Object)number);
            dynamicObject.set(ITEM_NO, (Object)item);
            BigDecimal amount = this.getAmount(customParams, number, "zzje");
            dynamicObject.set("developtype", (Object)item);
            dynamicObject.set("curryear", (Object)amount);
            String key = this.developDeclareItemList.get(item);
            BigDecimal preoneyearAmount = this.getPreoneyearAmount(perDeclareData, key);
            dynamicObject.set("preoneyear", (Object)preoneyearAmount);
            BigDecimal pretwoyearAmount = this.getPretwoyearAmount(perDeclareData, key);
            dynamicObject.set("pretwoyear", (Object)pretwoyearAmount);
            dynamicObject.set("sumamount", (Object)amount.add(preoneyearAmount).add(pretwoyearAmount));
            dynamicObjectCollection.add((Object)dynamicObject);
            this.dataMap.put("curryear_" + item, dynamicObject);
        }
        for (String item : calcItem) {
            this.calcAmount(item);
        }
        for (String item : calcSumItem) {
            this.calcSumAmount(item);
        }
        this.calcAmount("curryear_16");
        DynamicObject[] dynamicObjectArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])levelSum.toArray((Object[])new DynamicObject[0])));
        DynamicObject[] incomedatas = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])incomeSum.toArray((Object[])new DynamicObject[0])));
        DynamicObject[] peopledatas = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])peopleSum.toArray((Object[])new DynamicObject[0])));
        DynamicObject[] developdatas = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[0])));
    }

    private List<DynamicObject> querySummeryData(String entityName, QFilter orgidFilter, QFilter dateFilter) {
        DynamicObjectCollection ids = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{dateFilter, orgidFilter});
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            DynamicObject[] levelData = BusinessDataServiceHelper.load((Object[])ids.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
            return Arrays.asList(levelData);
        }
        return new ArrayList<DynamicObject>();
    }

    private void calLevelData(DynamicObject highTechAccount, DynamicObjectCollection perDeclareData, Long orgid, Date skssqq, Date skssqz, QFilter orgFilter, QFilter dateFilter, DynamicObjectCollection levelSum) {
        HashMap<String, String> result = new HashMap<String, String>();
        String detailId = this.getDetailTable(orgFilter, dateFilter);
        if (StringUtil.isNotBlank((CharSequence)detailId)) {
            this.getLevelNameMap(Long.parseLong(detailId), result);
        } else if (highTechAccount != null && highTechAccount.getDynamicObject("hightechscope") != null) {
            DynamicObject hightechscope = highTechAccount.getDynamicObject("hightechscope");
            this.getLevelNameMap(hightechscope.getLong("id"), result);
        } else if (CollectionUtils.isNotEmpty((Collection)perDeclareData)) {
            result.put("1", perDeclareData.stream().filter(e -> "1".equals(e.getString("ewblxh"))).map(e -> e.getString("territory")).findFirst().orElse(""));
            result.put("2", perDeclareData.stream().filter(e -> "2".equals(e.getString("ewblxh"))).map(e -> e.getString("territory")).findFirst().orElse(""));
            result.put("3", perDeclareData.stream().filter(e -> "3".equals(e.getString("ewblxh"))).map(e -> e.getString("territory")).findFirst().orElse(""));
        }
        for (int i = 1; i <= 3; ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_A301010201_LEVEL);
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            dynamicObject.set("leveltype", (Object)String.valueOf(i));
            dynamicObject.set("leveldesc", result.get(String.valueOf(i)));
            levelSum.add((Object)dynamicObject);
        }
    }

    private String getDetailTable(QFilter orgFilter, QFilter dateFilter) {
        QFilter templatetypeFilter = new QFilter("templatetype", "=", (Object)"rdesd_gxqyyhmx");
        DynamicObject query = QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"id", (QFilter[])new QFilter[]{orgFilter, dateFilter, templatetypeFilter});
        if (query != null) {
            QFilter entryIdFilter = new QFilter("entryid", "=", (Object)query.getLong("id"));
            QFilter cellnumberFilter = new QFilter("cellnumber", "=", (Object)"gxqyyhmxb_sjly#gxqyyhmxb_jczl");
            DynamicObject detail = QueryServiceHelper.queryOne((String)"tpo_declare_detail_tsd", (String)"value", (QFilter[])new QFilter[]{entryIdFilter, cellnumberFilter});
            if (detail != null) {
                return detail.getString("value");
            }
        }
        return "";
    }

    private void calcSumAmount(String item) {
        DynamicObject object = this.dataMap.get(item);
        BigDecimal curryear = object.getBigDecimal("curryear");
        BigDecimal preoneyear = object.getBigDecimal("preoneyear");
        BigDecimal pretwoyear = object.getBigDecimal("pretwoyear");
        object.set("sumamount", (Object)curryear.add(preoneyear).add(pretwoyear));
    }

    private BigDecimal getPretwoyearAmount(DynamicObjectCollection perDeclareData, String item) {
        if (perDeclareData == null) {
            return BigDecimal.ZERO;
        }
        Optional<DynamicObject> ewblxh = perDeclareData.stream().filter(e -> item.equals(e.getString("ewblxh"))).findFirst();
        if (ewblxh.isPresent()) {
            return ewblxh.get().getBigDecimal("qynd");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getPreoneyearAmount(DynamicObjectCollection perDeclareData, String item) {
        if (perDeclareData == null) {
            return BigDecimal.ZERO;
        }
        Optional<DynamicObject> ewblxh = perDeclareData.stream().filter(e -> item.equals(e.getString("ewblxh"))).findFirst();
        if (ewblxh.isPresent()) {
            return ewblxh.get().getBigDecimal("bnd");
        }
        return BigDecimal.ZERO;
    }

    private DynamicObjectCollection getPerDeclareData(Map<String, Object> customParams) {
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date date = DateUtils.addMonth((Date)skssqq, (int)-12);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)date);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)date);
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)firstDateOfYear);
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)lastDateOfYear);
        QFilter typeFilter = new QFilter("type", "=", (Object)"qysdsnb");
        DynamicObject query = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, typeFilter});
        if (query != null) {
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)query.getString("id"));
            return QueryServiceHelper.query((String)"tccit_qysds_a107041", (String)"ewblxh,bnd,qynd,territory", (QFilter[])new QFilter[]{sbbidFilter});
        }
        return new DynamicObjectCollection();
    }

    private void calcAmount(String item) {
        DynamicObject dyo = this.dataMap.get(item);
        CalcAmountEnum calcAmountEnum = CalcAmountEnum.byKey(item);
        if (calcAmountEnum != null) {
            String[] amountFileds;
            String filed = calcAmountEnum.filed;
            for (String amountFiled : amountFileds = filed.split(",")) {
                if ("incomeamount_7".equals(item) || "peopleamount_3".equals(item)) {
                    dyo.set(amountFiled, (Object)this.divideItemAmount(amountFiled, calcAmountEnum.items));
                    continue;
                }
                if ("curryear_10".equals(item)) {
                    dyo.set(amountFiled, (Object)this.acurryear10ItemAmount(amountFiled, calcAmountEnum.items));
                    continue;
                }
                if ("curryear_11".equals(item)) {
                    dyo.set(amountFiled, (Object)this.acurryear11ItemAmount(amountFiled, calcAmountEnum.items));
                    continue;
                }
                if ("curryear_14".equals(item)) {
                    dyo.set(amountFiled, (Object)this.acurryear14ItemAmount(amountFiled, calcAmountEnum.items));
                    continue;
                }
                if ("curryear_16".equals(item)) {
                    dyo.set(amountFiled, (Object)this.acurryear16ItemAmount());
                    continue;
                }
                dyo.set(amountFiled, (Object)this.addAllItemAmount(amountFiled, calcAmountEnum.items));
            }
        }
    }

    private BigDecimal acurryear10ItemAmount(String amountFiled, String[] items) {
        BigDecimal curryear_9;
        BigDecimal bigDecimal = this.addAllItemAmount(amountFiled, items);
        BigDecimal divide = bigDecimal.multiply(BigDecimal.valueOf(0.2)).divide(BigDecimal.valueOf(0.8), 2, RoundingMode.HALF_UP);
        return divide.compareTo(curryear_9 = this.dataMap.get("curryear_9").getBigDecimal(amountFiled)) < 0 ? divide : curryear_9;
    }

    private BigDecimal acurryear11ItemAmount(String amountFiled, String[] items) {
        BigDecimal bigDecimal = this.addAllItemAmount(amountFiled, items);
        return bigDecimal.multiply(BigDecimal.valueOf(0.8));
    }

    private BigDecimal acurryear14ItemAmount(String amountFiled, String[] items) {
        BigDecimal curryear_13;
        BigDecimal bigDecimal = this.addAllItemAmount(amountFiled, items);
        BigDecimal divide = bigDecimal.multiply(BigDecimal.valueOf(0.4)).divide(BigDecimal.valueOf(0.6), 2, RoundingMode.HALF_UP);
        return divide.compareTo(curryear_13 = this.dataMap.get("curryear_13").getBigDecimal(amountFiled)) < 0 ? divide : curryear_13;
    }

    private BigDecimal acurryear16ItemAmount() {
        BigDecimal curryear_1 = this.dataMap.get("curryear_1").getBigDecimal("sumamount");
        BigDecimal curryear_15 = this.dataMap.get("curryear_15").getBigDecimal("sumamount");
        return curryear_15.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : curryear_1.divide(curryear_15, 4, RoundingMode.HALF_UP);
    }

    private BigDecimal divideItemAmount(String amountFiled, String[] items) {
        Optional<String> first = Stream.of(items).filter(e -> this.dataMap.get(e).getBigDecimal(amountFiled).compareTo(BigDecimal.ZERO) == 0).findFirst();
        if (first.isPresent()) {
            return BigDecimal.ZERO;
        }
        return this.dataMap.get(items[0]).getBigDecimal(amountFiled).divide(this.dataMap.get(items[1]).getBigDecimal(amountFiled), 2, RoundingMode.HALF_UP);
    }

    private BigDecimal addAllItemAmount(String amountFiled, String ... items) {
        return Stream.of(items).map(item -> {
            BigDecimal amount;
            if (item.startsWith("-")) {
                String key = item.substring(1);
                amount = this.dataMap.get(key).getBigDecimal(amountFiled).negate();
            } else {
                amount = this.dataMap.get(item).getBigDecimal(amountFiled);
            }
            return amount;
        }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String itemnumber, String entrytype) {
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, null, TCCIT_DG_A301010201_DET);
    }

    private DynamicObject filter(DynamicObjectCollection accountDevelopEntity, String type, String filterType) {
        Optional<DynamicObject> developtype = accountDevelopEntity.stream().filter(s -> s.getString(type).equals(filterType)).findFirst();
        return developtype.orElseGet(() -> new DynamicObject());
    }

    private void getLevelNameMap(Long id, Map<String, String> result) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tpo_tccit_bizdefen_tree");
        result.put(dynamicObject.getString("level"), dynamicObject.getString("projectname"));
        DynamicObject parent = (DynamicObject)dynamicObject.get("parent");
        if (parent != null) {
            this.getLevelNameMap(parent.getLong("id"), result);
        }
    }

    private DynamicObject getHighTechAccount(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter yearFilter = new QFilter("year", "=", (Object)skssqq);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tccit_high_tech_account", (String)"id", (QFilter[])new QFilter[]{orgFilter, yearFilter});
        if (dynamicObject == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"tccit_high_tech_account");
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DG_NAMES.forEach(name -> DeleteServiceHelper.delete((String)name, (QFilter[])new QFilter[]{orgFilter, dateFilter}));
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String entryKey = itemsEntity.getEntryKey();
        String itemnumberkey = entryKey.replace("entryentity", ITEM_NUMBER);
        String itemnumber = String.valueOf(itemsEntity.getModel().getValue(itemnumberkey));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", "zzje");
        customParams.put(ITEM_NUMBER, itemnumber);
        customParams.put("entryname", TCCIT_DG_A301010201_DET);
        this.showForm(customParams);
    }

    private void showForm(Map<String, Object> customParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(TCCIT_DETAIL_TZ_DIALOG);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TCCIT_DETAIL_TZ_DIALOG);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private static enum CalcAmountEnum {
        incomeamount_1("incomeamount_1", "incomeamount", "incomeamount_2", "incomeamount_3"),
        incomeamount_4("incomeamount_4", "incomeamount", "incomeamount_5", "-incomeamount_6"),
        incomeamount_7("incomeamount_7", "incomeamount", "incomeamount_1", "incomeamount_4"),
        peopleamount_3("peopleamount_3", "peopleamount", "peopleamount_1", "peopleamount_2"),
        curryear_1("curryear_1", "curryear", "curryear_2", "curryear_11"),
        curryear_2("curryear_2", "curryear", "curryear_3", "curryear_4", "curryear_5", "curryear_6", "curryear_7", "curryear_8", "curryear_10"),
        curryear_10("curryear_10", "curryear", "curryear_3", "curryear_4", "curryear_5", "curryear_6", "curryear_7", "curryear_8"),
        curryear_11("curryear_11", "curryear", "curryear_12", "curryear_14"),
        curryear_14("curryear_14", "curryear", "curryear_3", "curryear_4", "curryear_5", "curryear_6", "curryear_7", "curryear_8", "curryear_9", "curryear_12"),
        curryear_16("curryear_16", "sumamount", "curryear_1", "curryear_15");

        private String key;
        private String filed;
        private String[] items;

        private CalcAmountEnum(String key, String filed, String ... items) {
            this.key = key;
            this.filed = filed;
            this.items = items;
        }

        static CalcAmountEnum byKey(String key) {
            return Stream.of(CalcAmountEnum.values()).filter(e -> e.key.equals(key)).findAny().orElse(null);
        }
    }
}

