/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.common.dto.DraftAmountDto;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import org.apache.commons.lang3.StringUtils;

public class ProfitFeesTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String SELL_COST = "sellcost";
    public static final String SELL_OUTSIDE = "selloutside";
    public static final String MANAGE_COST = "managecost";
    public static final String MANAGE_OUTSIDE = "manageoutside";
    public static final String FINANCE_COST = "financecost";
    public static final String FINANCE_OUTSIDE = "financeoutside";
    private static Map<String, String> projects = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemtype,sellcost,selloutside,managecost,manageoutside,financecost,financeoutside";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_profit_fees_summary", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", itemTypes.size());
        int rowIndex = 0;
        for (String itemType : itemTypes) {
            DynamicObject object = query.stream().filter(s -> s.getString(ITEM_TYPE).equals(itemType)).findFirst().get();
            model.setValue(ITEM_NO, (Object)(rowIndex + 1), rowIndex);
            model.setValue(ITEM_TYPE, (Object)object.getString(ITEM_TYPE), rowIndex);
            model.setValue(SELL_COST, (Object)this.formatData(object.getBigDecimal(SELL_COST), itemType, SELL_COST), rowIndex);
            model.setValue(SELL_OUTSIDE, (Object)this.formatData(object.getBigDecimal(SELL_OUTSIDE), itemType, SELL_OUTSIDE), rowIndex);
            model.setValue(MANAGE_COST, (Object)this.formatData(object.getBigDecimal(MANAGE_COST), itemType, MANAGE_COST), rowIndex);
            model.setValue(MANAGE_OUTSIDE, (Object)this.formatData(object.getBigDecimal(MANAGE_OUTSIDE), itemType, MANAGE_OUTSIDE), rowIndex);
            model.setValue(FINANCE_COST, (Object)this.formatData(object.getBigDecimal(FINANCE_COST), itemType, FINANCE_COST), rowIndex);
            model.setValue(FINANCE_OUTSIDE, (Object)this.formatData(object.getBigDecimal(FINANCE_OUTSIDE), itemType, FINANCE_OUTSIDE), rowIndex);
            ++rowIndex;
        }
    }

    private String formatData(BigDecimal data, String rowtype, String columnType) {
        StringBuilder link = new StringBuilder("<nolink>");
        String itemNumber = projects.get(ProfitFeesTZFormPlugin.getKey(rowtype, columnType));
        if (StringUtils.isBlank((CharSequence)itemNumber)) {
            if ("26".equals(rowtype)) {
                return link.append(DataFormat.formatMicrometer(data.setScale(2, 4).toString())).toString();
            }
            return link.append('*').toString();
        }
        return DataFormat.formatMicrometer(data.setScale(2, 4).toString());
    }

    private void calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int itemNo = 0;
        List<String> columnTypeList = Arrays.asList(SELL_COST, SELL_OUTSIDE, MANAGE_COST, MANAGE_OUTSIDE, FINANCE_COST, FINANCE_OUTSIDE);
        ArrayList<String> itemNumberList = new ArrayList<String>(16);
        for (String itemType : itemTypes) {
            for (String columnType : columnTypeList) {
                String itemNumber = projects.get(ProfitFeesTZFormPlugin.getKey(itemType, columnType));
                if (!StringUtil.isNotBlank((CharSequence)itemNumber)) continue;
                itemNumberList.add(itemNumber);
                itemNumberList.add(itemNumber + "_");
            }
        }
        List<DraftAmountDto> amountList = this.getCellAmountList(customParams, Collections.singletonList("profit"), itemNumberList, null, "tccit_profit_fees_detail");
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_profit_fees_summary");
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(SELL_COST, (Object)this.calcAmount(itemType, SELL_COST, customParams, sum, amountList));
            dynamicObject.set(SELL_OUTSIDE, (Object)this.calcAmount(itemType, SELL_OUTSIDE, customParams, sum, amountList));
            dynamicObject.set(MANAGE_COST, (Object)this.calcAmount(itemType, MANAGE_COST, customParams, sum, amountList));
            dynamicObject.set(MANAGE_OUTSIDE, (Object)this.calcAmount(itemType, MANAGE_OUTSIDE, customParams, sum, amountList));
            dynamicObject.set(FINANCE_COST, (Object)this.calcAmount(itemType, FINANCE_COST, customParams, sum, amountList));
            dynamicObject.set(FINANCE_OUTSIDE, (Object)this.calcAmount(itemType, FINANCE_OUTSIDE, customParams, sum, amountList));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_profit_fees_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, DynamicObjectCollection sum, List<DraftAmountDto> amountList) {
        if ("26".equals(rowType)) {
            return sum.stream().map(s -> s.getBigDecimal(columnType)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        String itemNumber = projects.get(ProfitFeesTZFormPlugin.getKey(rowType, columnType));
        if (StringUtils.isBlank((CharSequence)itemNumber) || CollectionUtils.isEmpty(amountList)) {
            return BigDecimal.ZERO;
        }
        return amountList.stream().filter(e -> itemNumber.equals(e.getItemnumber()) || e.getItemnumber().equals(itemNumber + "_")).map(s -> s.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String rowType) {
        String itemnumber = projects.get(ProfitFeesTZFormPlugin.getKey(rowType, columnType));
        return this.getCellAmount(customParams, columnType, "profit", rowType, itemnumber, null, "tccit_profit_fees_detail");
    }

    private static String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemtype = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", "profit");
        customParams.put("itemnumber", projects.get(ProfitFeesTZFormPlugin.getKey(itemtype, evt.getFieldName())));
        customParams.put("entryname", "tccit_profit_fees_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{SELL_COST, SELL_OUTSIDE, MANAGE_COST, MANAGE_OUTSIDE, FINANCE_COST, FINANCE_OUTSIDE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        customParams.put("columnType", itemtype);
        customParams.put("entrytype", "profit");
        customParams.put("itemnumber", projects.get(ProfitFeesTZFormPlugin.getKey(itemtype, column)));
        customParams.put("entryname", "tccit_profit_fees_detail");
        return customParams;
    }

    static {
        projects.put(ProfitFeesTZFormPlugin.getKey("1", SELL_COST), "2010101");
        projects.put(ProfitFeesTZFormPlugin.getKey("2", SELL_COST), "2010102");
        projects.put(ProfitFeesTZFormPlugin.getKey("3", SELL_COST), "2010103");
        projects.put(ProfitFeesTZFormPlugin.getKey("4", SELL_COST), "2010104");
        projects.put(ProfitFeesTZFormPlugin.getKey("5", SELL_COST), "2010105");
        projects.put(ProfitFeesTZFormPlugin.getKey("6", SELL_COST), "2010106");
        projects.put(ProfitFeesTZFormPlugin.getKey("7", SELL_COST), "2010107");
        projects.put(ProfitFeesTZFormPlugin.getKey("8", SELL_COST), "2010108");
        projects.put(ProfitFeesTZFormPlugin.getKey("9", SELL_COST), "2010109");
        projects.put(ProfitFeesTZFormPlugin.getKey("10", SELL_COST), "2010110");
        projects.put(ProfitFeesTZFormPlugin.getKey("11", SELL_COST), "2010111");
        projects.put(ProfitFeesTZFormPlugin.getKey("12", SELL_COST), "2010112");
        projects.put(ProfitFeesTZFormPlugin.getKey("13", SELL_COST), "2010113");
        projects.put(ProfitFeesTZFormPlugin.getKey("14", SELL_COST), "2010114");
        projects.put(ProfitFeesTZFormPlugin.getKey("15", SELL_COST), "2010115");
        projects.put(ProfitFeesTZFormPlugin.getKey("16", SELL_COST), "2010116");
        projects.put(ProfitFeesTZFormPlugin.getKey("17", SELL_COST), "2010117");
        projects.put(ProfitFeesTZFormPlugin.getKey("18", SELL_COST), "2010118");
        projects.put(ProfitFeesTZFormPlugin.getKey("19", SELL_COST), "2010119");
        projects.put(ProfitFeesTZFormPlugin.getKey("20", SELL_COST), "2010120");
        projects.put(ProfitFeesTZFormPlugin.getKey("25", SELL_COST), "2010121");
        projects.put(ProfitFeesTZFormPlugin.getKey("2", SELL_OUTSIDE), "2010201");
        projects.put(ProfitFeesTZFormPlugin.getKey("3", SELL_OUTSIDE), "2010202");
        projects.put(ProfitFeesTZFormPlugin.getKey("11", SELL_OUTSIDE), "2010203");
        projects.put(ProfitFeesTZFormPlugin.getKey("15", SELL_OUTSIDE), "2010204");
        projects.put(ProfitFeesTZFormPlugin.getKey("16", SELL_OUTSIDE), "2010205");
        projects.put(ProfitFeesTZFormPlugin.getKey("18", SELL_OUTSIDE), "2010206");
        projects.put(ProfitFeesTZFormPlugin.getKey("19", SELL_OUTSIDE), "2010207");
        projects.put(ProfitFeesTZFormPlugin.getKey("25", SELL_OUTSIDE), "2010208");
        projects.put(ProfitFeesTZFormPlugin.getKey("6", SELL_OUTSIDE), "2010209");
        projects.put(ProfitFeesTZFormPlugin.getKey("1", MANAGE_COST), "2010301");
        projects.put(ProfitFeesTZFormPlugin.getKey("2", MANAGE_COST), "2010302");
        projects.put(ProfitFeesTZFormPlugin.getKey("3", MANAGE_COST), "2010303");
        projects.put(ProfitFeesTZFormPlugin.getKey("4", MANAGE_COST), "2010304");
        projects.put(ProfitFeesTZFormPlugin.getKey("5", MANAGE_COST), "2010305");
        projects.put(ProfitFeesTZFormPlugin.getKey("6", MANAGE_COST), "2010306");
        projects.put(ProfitFeesTZFormPlugin.getKey("7", MANAGE_COST), "2010307");
        projects.put(ProfitFeesTZFormPlugin.getKey("8", MANAGE_COST), "2010308");
        projects.put(ProfitFeesTZFormPlugin.getKey("9", MANAGE_COST), "2010309");
        projects.put(ProfitFeesTZFormPlugin.getKey("10", MANAGE_COST), "2010310");
        projects.put(ProfitFeesTZFormPlugin.getKey("11", MANAGE_COST), "2010311");
        projects.put(ProfitFeesTZFormPlugin.getKey("12", MANAGE_COST), "2010312");
        projects.put(ProfitFeesTZFormPlugin.getKey("13", MANAGE_COST), "2010313");
        projects.put(ProfitFeesTZFormPlugin.getKey("14", MANAGE_COST), "2010314");
        projects.put(ProfitFeesTZFormPlugin.getKey("15", MANAGE_COST), "2010315");
        projects.put(ProfitFeesTZFormPlugin.getKey("16", MANAGE_COST), "2010316");
        projects.put(ProfitFeesTZFormPlugin.getKey("17", MANAGE_COST), "2010317");
        projects.put(ProfitFeesTZFormPlugin.getKey("18", MANAGE_COST), "2010318");
        projects.put(ProfitFeesTZFormPlugin.getKey("19", MANAGE_COST), "2010319");
        projects.put(ProfitFeesTZFormPlugin.getKey("20", MANAGE_COST), "2010320");
        projects.put(ProfitFeesTZFormPlugin.getKey("24", MANAGE_COST), "2010321");
        projects.put(ProfitFeesTZFormPlugin.getKey("25", MANAGE_COST), "2010322");
        projects.put(ProfitFeesTZFormPlugin.getKey("2", MANAGE_OUTSIDE), "2010401");
        projects.put(ProfitFeesTZFormPlugin.getKey("3", MANAGE_OUTSIDE), "2010402");
        projects.put(ProfitFeesTZFormPlugin.getKey("11", MANAGE_OUTSIDE), "2010403");
        projects.put(ProfitFeesTZFormPlugin.getKey("15", MANAGE_OUTSIDE), "2010404");
        projects.put(ProfitFeesTZFormPlugin.getKey("16", MANAGE_OUTSIDE), "2010405");
        projects.put(ProfitFeesTZFormPlugin.getKey("18", MANAGE_OUTSIDE), "2010406");
        projects.put(ProfitFeesTZFormPlugin.getKey("19", MANAGE_OUTSIDE), "2010407");
        projects.put(ProfitFeesTZFormPlugin.getKey("25", MANAGE_OUTSIDE), "2010408");
        projects.put(ProfitFeesTZFormPlugin.getKey("6", MANAGE_OUTSIDE), "2010409");
        projects.put(ProfitFeesTZFormPlugin.getKey("6", FINANCE_COST), "2010501");
        projects.put(ProfitFeesTZFormPlugin.getKey("21", FINANCE_COST), "2010502");
        projects.put(ProfitFeesTZFormPlugin.getKey("22", FINANCE_COST), "2010503");
        projects.put(ProfitFeesTZFormPlugin.getKey("23", FINANCE_COST), "2010504");
        projects.put(ProfitFeesTZFormPlugin.getKey("25", FINANCE_COST), "2010505");
        projects.put(ProfitFeesTZFormPlugin.getKey("6", FINANCE_OUTSIDE), "2010601");
        projects.put(ProfitFeesTZFormPlugin.getKey("21", FINANCE_OUTSIDE), "2010602");
        projects.put(ProfitFeesTZFormPlugin.getKey("22", FINANCE_OUTSIDE), "2010603");
        projects.put(ProfitFeesTZFormPlugin.getKey("25", FINANCE_OUTSIDE), "2010604");
    }
}

