/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.cal.CalculateService;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public abstract class ProfitIncomeCostCommFormPlugin
extends AbstractEngine
implements HyperLinkClickListener {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String AMOUNT = "amount";
    public static Map<String, String> cacheLevel1Map = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initData(String summaryEntryName, List<String> itemTypes) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemtype,amount";
        DynamicObjectCollection query = QueryServiceHelper.query((String)summaryEntryName, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", itemTypes.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (String itemType : itemTypes) {
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            DynamicObject object = query.stream().filter(s -> s.getString(ITEM_TYPE).equals(itemType)).findFirst().get();
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)(rowIndex + 1));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)object.getString(ITEM_TYPE));
            dot.getProperty(AMOUNT).setValueFast((Object)data, (Object)this.formatData(object.getBigDecimal(AMOUNT), itemType, AMOUNT));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(BigDecimal data, String rowtype, String columnType) {
        StringBuilder link = new StringBuilder("<nolink>");
        String text = DataFormat.formatMicrometer(data.setScale(2, 4).toString());
        if (this.getTitles().contains(rowtype)) {
            return link.append(text).toString();
        }
        return text;
    }

    public void calc(Map<String, Object> customParams, List<String> itemTypes, String summaryEntryName, String ruleDetailEntryName) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz, itemTypes, summaryEntryName);
        if (this.checkCalData(customParams)) {
            DynamicObjectCollection sum = new DynamicObjectCollection();
            for (String itemType : itemTypes) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)summaryEntryName);
                dynamicObject.set(ITEM_NO, (Object)(itemTypes.indexOf(itemType) + 1));
                dynamicObject.set(ITEM_TYPE, (Object)itemType);
                dynamicObject.set(AMOUNT, (Object)this.calcAmount("{Q[" + itemType + "]}", customParams, AMOUNT, ruleDetailEntryName));
                dynamicObject.set("orgid", (Object)orgid);
                dynamicObject.set("skssqq", (Object)skssqq);
                dynamicObject.set("skssqz", (Object)skssqz);
                sum.add((Object)dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        }
    }

    protected void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz, List<String> itemTypes, String summaryEntryName) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)summaryEntryName, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private String calcAmount(String calExpression, Map<String, Object> customParams, String columnType, String ruleDetailEntryName) {
        List expList = ParseUtils.parseformula((String)calExpression);
        for (String exp : expList) {
            Object amount;
            String currentRowType = exp.replace("{Q[", "").replace("]}", "");
            String key = ProfitIncomeCostCommFormPlugin.getKey(currentRowType, columnType);
            if (this.getCalExpression(currentRowType, customParams) != null) {
                amount = this.calcAmount(this.getCalExpression(currentRowType, customParams), customParams, columnType, ruleDetailEntryName);
                if ("003".equals(currentRowType) || "002".equals(currentRowType)) {
                    cacheLevel1Map.put("originalamount_" + currentRowType, (String)amount);
                    DynamicObjectCollection results = this.getSDTZOriginalAmount(customParams, currentRowType, this.getEntrytype(customParams));
                    if (results.size() > 0) {
                        DynamicObject itemObj = (DynamicObject)results.get(0);
                        BigDecimal adjustamount = itemObj.getBigDecimal("adjustamount");
                        BigDecimal itemAmount = new BigDecimal((String)amount).add(adjustamount);
                        amount = itemAmount.toString();
                    }
                }
                calExpression = calExpression.replace(exp, (CharSequence)amount);
                continue;
            }
            if (this.dataMap.get(key) == null) {
                amount = this.getAmount(customParams, columnType, currentRowType, ruleDetailEntryName);
                this.dataMap.put(key, (BigDecimal)amount);
            }
            calExpression = calExpression.replace(exp, this.dataMap.get(key).toPlainString());
        }
        return CalculateService.calculate((String)calExpression);
    }

    protected DynamicObjectCollection getSDTZOriginalAmount(Map<String, Object> customParams, String itemnumber, String entrytype) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        qFilters.add(new QFilter("org", "=", (Object)Long.parseLong((String)orgid)));
        qFilters.add(new QFilter("skssqq", "=", (Object)skssqq));
        qFilters.add(new QFilter("skssqz", "=", (Object)skssqz));
        qFilters.add(new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_"))));
        qFilters.add(new QFilter("entrytype", "=", (Object)entrytype));
        return QueryServiceHelper.query((String)"tccit_adjust_detail", (String)"id,amount,totalamount,adjustamount", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
    }

    protected BigDecimal getAmount(Map<String, Object> customParams, String columnType, String rowType, String ruleDetailEntryName) {
        String itemnumber = "tccit_dg_a100000_1_det".equals(ruleDetailEntryName) && "002".equals(rowType) ? "110" : rowType;
        return this.getCellAmount(customParams, columnType, this.getEntrytype(customParams), rowType, itemnumber, null, ruleDetailEntryName);
    }

    private static String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String formId = itemsEntity.getView().getFormShowParameter().getFormId();
        String itemtype = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isExists110Rules = customParams.getOrDefault("isExists110Rules", Boolean.FALSE);
        itemtype = "tccit_dg_a100000_1_list".equals(formId) && "002".equals(itemtype) && isExists110Rules != false ? "110" : itemtype;
        customParams.put("columnType", evt.getFieldName());
        customParams.put("itemnumber", itemtype);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    public abstract String getCalExpression(String var1, Map<String, Object> var2);

    public abstract Set<String> getTitles();

    public abstract boolean checkCalData(Map<String, Object> var1);

    public abstract String getEntrytype(Map<String, Object> var1);
}

