/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.org.OrgWithFinanceService;
import kd.taxc.tccit.formplugin.account.ProfitIncomeCostCommFormPlugin;

public class ProfitIncomeTZFormPlugin
extends ProfitIncomeCostCommFormPlugin
implements Observer {
    public static final String SUMMARY_ENTRY_NAME = "tccit_profit_income_sum";
    public static final String RULE_DETAIL_ENTRY_NAME = "tccit_profit_income_det";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "001_01", "1010101", "1010102", "1010103", "1010104", "1010105", "1010106", "001_02", "1010107", "1010108", "1010109", "1010110", "1010111", "1010112", "002", "1010201", "1010202", "1010203", "1010204", "1010205", "1010206", "1010207", "1010208", "1010209", "1010210"});
    private static final Map<String, String> CALC_RELATION = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("001", "{Q[001_01]}+{Q[001_02]}");
            this.put("001_01", "{Q[1010101]}+{Q[1010103]}+{Q[1010104]}+{Q[1010105]}+{Q[1010106]}");
            this.put("001_02", "{Q[1010107]}+{Q[1010109]}+{Q[1010110]}+{Q[1010111]}+{Q[1010112]}");
            this.put("002", "{Q[1010201]}+{Q[1010202]}+{Q[1010203]}+{Q[1010204]}+{Q[1010205]}+{Q[1010206]}+{Q[1010207]}+{Q[1010208]}+{Q[1010209]}+{Q[1010210]}");
        }
    };

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams, itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
        }
        this.initData(SUMMARY_ENTRY_NAME, itemTypes);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        super.hyperLinkClick(evt);
    }

    @Override
    public String getCalExpression(String rowType, Map<String, Object> customParams) {
        return CALC_RELATION.get(rowType);
    }

    @Override
    public Set<String> getTitles() {
        return CALC_RELATION.keySet();
    }

    @Override
    public boolean checkCalData(Map<String, Object> customParams) {
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        if (policy == null) {
            return true;
        }
        return OrgWithFinanceService.isYbqy(policy);
    }

    @Override
    public String getEntrytype(Map<String, Object> customParams) {
        return "general-income";
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams, itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, itemTypes, SUMMARY_ENTRY_NAME);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{"amount"});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString("itemtype");
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        customParams.put("columnType", column);
        customParams.put("itemnumber", itemtype);
        return customParams;
    }
}

