/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import org.apache.commons.collections.CollectionUtils;

public class QshczzyqrdgxsdtzdgFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DG_B105036_SUM = "tccit_dg_b105036_sum";
    public static final String TCCIT_INVEST_DISPOSE = "tccit_invest_dispose";
    public static final String TCCIT_NEW_INVEST_ASSET = "tccit_new_invest_asset";
    private static Log logger = LogFactory.getLog(QshczzyqrdgxsdtzdgFormPlugin.class);
    public static final String ITEM_NO = "itemno";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData(true);
    }

    private void calc(Map<String, Object> customParams) {
        int i;
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter deleteOrgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DG_B105036_SUM, (QFilter[])new QFilter[]{deleteOrgFilter, dateFilter});
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("other5")) {
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter tranTypeFilter = new QFilter("tccit_invest_cz_ent.transtype", "in", (Object)Lists.newArrayList((Object[])new Long[]{1057207478795995141L, 1057207478795995142L}));
        QFilter investTypeFilter = new QFilter("investtype", "=", (Object)1057197557899680768L);
        String selectFiles = "billno,name,investtype,tccit_invest_cz_ent.transtype,tccit_invest_cz_ent.zcczsr,tccit_invest_cz_ent.czsl,tccit_invest_cz_ent.qshczgxhlsr";
        QFilter skssqqFilter = new QFilter("tccit_invest_cz_ent.bussidate", ">=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("tccit_invest_cz_ent.bussidate", "<=", (Object)DateUtils.getDayLast((Date)skssqz));
        DynamicObjectCollection investDisposes = QueryServiceHelper.query((String)TCCIT_INVEST_DISPOSE, (String)selectFiles, (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, tranTypeFilter, investTypeFilter});
        if (CollectionUtils.isEmpty((Collection)investDisposes)) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (i = 0; i < investDisposes.size(); ++i) {
            DynamicObject sourceObject = (DynamicObject)investDisposes.get(i);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_DG_B105036_SUM);
            dynamicObject.set(ITEM_NO, (Object)(i + 1));
            dynamicObject.set("billno", sourceObject.get("billno"));
            dynamicObject.set("tzbdname", BusinessDataServiceHelper.loadSingle((Object)sourceObject.get("name"), (String)"tccit_new_invest_asset_bs", (String)"name").get("name"));
            dynamicObject.set("investtype", (Object)ResManager.loadKDString((String)"\u76f4\u63a5\u6295\u8d44\u5c45\u6c11\u4f01\u4e1a", (String)"QshczzyqrdgxsdtzdgFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            QFilter billnoFilter = new QFilter("billno", "=", sourceObject.get("billno"));
            String transtype = BusinessDataServiceHelper.loadSingle((Object)sourceObject.get("tccit_invest_cz_ent.transtype"), (String)"tpo_tccit_bizdefen_tree", (String)"projectname").getString("projectname");
            dynamicObject.set("transtype", (Object)transtype);
            DynamicObjectCollection investAssets = QueryServiceHelper.query((String)TCCIT_NEW_INVEST_ASSET, (String)"taxpayerid,tccit_new_invest_detail.taxbase,tccit_new_invest_detail.tzbl", (QFilter[])new QFilter[]{orgFilter, billnoFilter});
            dynamicObject.set("taxpayerid", ((DynamicObject)investAssets.get(0)).get("taxpayerid"));
            BigDecimal incost = this.getSum(investAssets, "tccit_new_invest_detail.taxbase");
            dynamicObject.set("incost", (Object)incost);
            BigDecimal numorrate = this.getSum(investAssets, "tccit_new_invest_detail.tzbl");
            dynamicObject.set("numorrate", (Object)numorrate);
            BigDecimal qddbtzzc = sourceObject.getBigDecimal("tccit_invest_cz_ent.zcczsr");
            dynamicObject.set("qddbtzzc", sourceObject.get("tccit_invest_cz_ent.zcczsr"));
            BigDecimal ljwfplr = sourceObject.getBigDecimal("tccit_invest_cz_ent.qshczgxhlsr");
            dynamicObject.set("ljwfplr", (Object)ljwfplr);
            if (ResManager.loadKDString((String)"\u64a4\u8d44", (String)"QshczzyqrdgxsdtzdgFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]).equals(transtype)) {
                dynamicObject.set("czjstzbl", (Object)sourceObject.getBigDecimal("tccit_invest_cz_ent.czsl").setScale(2, 4).toString());
                try {
                    BigDecimal czshcstzcb = incost.multiply(sourceObject.getBigDecimal("tccit_invest_cz_ent.czsl")).setScale(2, 4);
                    dynamicObject.set("czshcstzcb", (Object)czshcstzcb);
                    BigDecimal czqdzczcg = sourceObject.getBigDecimal("tccit_invest_cz_ent.zcczsr").subtract(czshcstzcb);
                    dynamicObject.set("czqdzczcg", (Object)czqdzczcg);
                    dynamicObject.set("xsmsyhdje", (Object)(ljwfplr.compareTo(czqdzczcg) > 0 ? czqdzczcg : ljwfplr));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            } else {
                dynamicObject.set("xsmsyhdje", (Object)(ljwfplr.compareTo(qddbtzzc) > 0 ? qddbtzzc : ljwfplr));
            }
            dynamicObject.set("tzmsje", (Object)BigDecimal.ZERO);
            dynamicObject.set("tzhdmsyhje", (Object)dynamicObject.getBigDecimal("xsmsyhdje").add(dynamicObject.getBigDecimal("tzmsje")));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        i = 1;
        int j = 10;
        for (DynamicObject object : sum) {
            if (ResManager.loadKDString((String)"\u64a4\u8d44", (String)"QshczzyqrdgxsdtzdgFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]).equals(object.get("transtype"))) {
                object.set("lebel", (Object)j);
                ++j;
                continue;
            }
            object.set("lebel", (Object)i);
            ++i;
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void initData(boolean isNew) {
        String selectFields = " * ";
        ArrayList<QFilter> qfilters = this.getQfilters();
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_DG_B105036_SUM, (String)selectFields, (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]), (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() + 1);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, dynamicObject.get(ITEM_NO));
            dot.getProperty("billno").setValueFast((Object)data, dynamicObject.get("billno"));
            dot.getProperty("tzbdname").setValueFast((Object)data, dynamicObject.get("tzbdname"));
            dot.getProperty("investtype").setValueFast((Object)data, dynamicObject.get("investtype"));
            dot.getProperty("taxpayerid").setValueFast((Object)data, dynamicObject.get("taxpayerid"));
            dot.getProperty("numorrate").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("numorrate")));
            dot.getProperty("incost").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("incost")));
            dot.getProperty("transtype").setValueFast((Object)data, dynamicObject.get("transtype"));
            dot.getProperty("qddbtzzc").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("qddbtzzc")));
            dot.getProperty("czjstzbl").setValueFast((Object)data, (Object)dynamicObject.getString("czjstzbl"));
            if (ResManager.loadKDString((String)"\u64a4\u8d44", (String)"QshczzyqrdgxsdtzdgFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]).equals(dynamicObject.getString("transtype"))) {
                dot.getProperty("czshcstzcb").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("czshcstzcb")));
                dot.getProperty("czqdzczcg").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("czqdzczcg")));
            } else {
                dot.getProperty("czshcstzcb").setValueFast((Object)data, (Object)"*");
                dot.getProperty("czqdzczcg").setValueFast((Object)data, (Object)"*");
            }
            dot.getProperty("ljwfplr").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("ljwfplr")));
            dot.getProperty("xsmsyhdje").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("xsmsyhdje")));
            dot.getProperty("tzmsje").setValueFast((Object)data, (Object)dynamicObject.getBigDecimal("tzmsje"));
            dot.getProperty("tzhdmsyhje").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("tzhdmsyhje")));
            ++rowIndex;
        }
        this.appendCountRow(entryentity, isNew, query, model, rowIndex);
        this.getView().updateView("entryentity");
    }

    private ArrayList<QFilter> getQfilters() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        return Lists.newArrayList((Object[])new QFilter[]{orgFilter, dateFilter});
    }

    private void appendCountRow(DynamicObjectCollection entryentity, boolean isNew, DynamicObjectCollection query, IDataModel model, int rowIndex) {
        model.setValue(ITEM_NO, (Object)(query.size() + 1), rowIndex);
        model.setValue("billno", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"QshczzyqrdgxsdtzdgFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue("tzbdname", (Object)"*", rowIndex);
        model.setValue("investtype", (Object)"*", rowIndex);
        model.setValue("taxpayerid", (Object)"*", rowIndex);
        model.setValue("numorrate", (Object)this.getFormatData(this.getSum(query, "numorrate")), rowIndex);
        model.setValue("incost", (Object)this.getFormatData(this.getSum(query, "incost")), rowIndex);
        model.setValue("transtype", (Object)"*", rowIndex);
        model.setValue("qddbtzzc", (Object)this.getFormatData(this.getSum(query, "qddbtzzc")), rowIndex);
        model.setValue("czjstzbl", (Object)"*");
        model.setValue("czshcstzcb", (Object)this.getFormatData(this.getSum(query, "czshcstzcb")), rowIndex);
        model.setValue("czqdzczcg", (Object)this.getFormatData(this.getSum(query, "czqdzczcg")), rowIndex);
        model.setValue("ljwfplr", (Object)this.getFormatData(this.getSum(query, "ljwfplr")), rowIndex);
        model.setValue("xsmsyhdje", (Object)this.getFormatData(this.getSum(query, "xsmsyhdje")), rowIndex);
        model.setValue("tzmsje", (Object)this.getSum(query, "tzmsje"), rowIndex);
        model.setValue("tzhdmsyhje", (Object)this.getFormatData(this.getSum(query, "tzhdmsyhje")), rowIndex);
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"tzmsje"});
    }

    private String getFormatData(BigDecimal data) {
        return DataFormat.formatMicrometer(data.setScale(2, 4).toString());
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.equals("tzmsje")) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject rowDataObject = changeData.getDataEntity();
            ArrayList<QFilter> qfilters = this.getQfilters();
            qfilters.add(new QFilter(ITEM_NO, "=", (Object)rowDataObject.getInt(ITEM_NO)));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)TCCIT_DG_B105036_SUM, (String)"id,itemno,orgid,skssqq,skssqz,billno,investtype,taxpayerid,numorrate,incost,transtype,xsmsyhdje,tzmsje,tzhdmsyhje,tzbdname,czshcstzcb,czqdzczcg,ljwfplr,qddbtzzc,czjstzbl,lebel", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
            if (dynamicObject != null) {
                BigDecimal o1;
                Object o = changeData.getNewValue() == null ? BigDecimal.ZERO : changeData.getNewValue();
                BigDecimal bigDecimal = o1 = o instanceof String ? new BigDecimal(String.valueOf(o)) : (BigDecimal)o;
                if (o1.compareTo(dynamicObject.getBigDecimal("tzmsje")) == 0) {
                    return;
                }
                BigDecimal tzhdmsyhje = dynamicObject.getBigDecimal("xsmsyhdje").add(o1);
                if (tzhdmsyhje.compareTo(BigDecimal.ZERO) < 0) {
                    this.getModel().setValue("tzmsje", (Object)BigDecimal.ZERO, changeData.getRowIndex());
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u7684\u514d\u7a0e\u4f18\u60e0\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"QshczzyqrdgxsdtzdgFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.initData(false);
                } else {
                    dynamicObject.set("tzmsje", (Object)o1);
                    dynamicObject.set("tzhdmsyhje", (Object)tzhdmsyhje);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    this.initData(false);
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter deleteOrgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DG_B105036_SUM, (QFilter[])new QFilter[]{deleteOrgFilter, dateFilter});
    }
}

