/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.common.enums.DraftSummaryEnum;
import kd.taxc.tccit.formplugin.account.OtherOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.OtherSpecTZFormPlugin;
import kd.taxc.tccit.formplugin.draft.AbstractSummaryPlugin;

public class QttzHzdgSummaryPlugin
extends AbstractSummaryPlugin {
    private static final ArrayList<String> ARRAY_LIST = Lists.newArrayList((Object[])new String[]{"1", "2"});

    @Override
    public DraftSummaryEnum getDraftSummaryEnum() {
        return DraftSummaryEnum.QTTZ;
    }

    @Override
    public Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        ArrayList<QFilter> baseQfilters = this.getBaseQfilters(customParams);
        BigDecimal amount = BigDecimal.ZERO;
        if ("1".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "=", (Object)"count"));
            amount = this.getOne(rowType, columnType, "tccit_other_spec_sum", "id,nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
        }
        if ("2".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "=", (Object)"count"));
            amount = this.getOne(rowType, columnType, "tccit_other_other_sum", "id,nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
        }
        if ("3".equals(rowType) && "amount".equals(columnType)) {
            amount = this.getSum(ARRAY_LIST, "amount");
        }
        return amount;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, DraftSummaryEnum.QTTZ.getBill());
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(QttzHzdgSummaryPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{OtherSpecTZFormPlugin.class.getSimpleName(), OtherOtherTZFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

