/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.engine.YearAccEngine;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class QyczjdynsTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String RULE_ID = "ruleid";
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_NAME = "itemname";
    public static final String TSCZLX = "tsczlx";
    public static final String TSCZLXNUMBER = "tsczlxnumber";
    public static final String YBSWCLZZJE = "ybswclzzje";
    public static final String YBSWCLSSJE = "ybswclssje";
    public static final String YBSWCLNSTZJE = "ybswclnstzje";
    public static final String TSSWCLZZJE = "tsswclzzje";
    public static final String TSSWCLSSJE = "tsswclssje";
    public static final String TSSWCLNSTZJE = "tsswclnstzje";
    public static final String NSTZHJJE = "nstzhjje";
    private static final String TCCIT_QYCZJDYNS_SUMMARY = "tccit_qyczjdyns_summary";
    private static final String TCCIT_QYCZJDYNS_TZ_DETAIL = "tccit_qyczjdyns_tz_detail";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_QYCZJDYNS_SUMMARY, (String)"id,itemno,itemname,ybswclzzje,tsczlx,ybswclssje,ybswclnstzje,tsswclzzje,tsswclssje,tsswclnstzje,nstzhjje,orgid,skssqq,skssqz,ruleid,tsczlxnumber", (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)"id");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (DynamicObject dynamicObject : query) {
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_NAME).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NAME));
            String ruleid = dynamicObject.getString(RULE_ID);
            dot.getProperty(RULE_ID).setValueFast((Object)data, (Object)ruleid);
            dot.getProperty(TSCZLX).setValueFast((Object)data, (Object)dynamicObject.getString(TSCZLX));
            dot.getProperty(TSCZLXNUMBER).setValueFast((Object)data, (Object)dynamicObject.getString(TSCZLXNUMBER));
            dot.getProperty(YBSWCLZZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, YBSWCLZZJE, ruleid));
            dot.getProperty(YBSWCLSSJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, YBSWCLSSJE, ruleid));
            dot.getProperty(YBSWCLNSTZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, YBSWCLNSTZJE));
            dot.getProperty(TSSWCLZZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, TSSWCLZZJE, ruleid));
            dot.getProperty(TSSWCLSSJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, TSSWCLSSJE, ruleid));
            dot.getProperty(TSSWCLNSTZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, TSSWCLNSTZJE));
            dot.getProperty(NSTZHJJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, NSTZHJJE));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(DynamicObject dynamicObject, String columnType, String ruleId) {
        StringBuilder link = new StringBuilder("<nolink>");
        BigDecimal amount = dynamicObject.getBigDecimal(columnType).setScale(2, 4);
        if ("0".equals(ruleId) || StringUtil.isBlank((CharSequence)ruleId)) {
            return link.append(DataFormat.formatMicrometer(amount.toString())).toString();
        }
        return DataFormat.formatMicrometer(amount.toString());
    }

    private String formatData(DynamicObject dynamicObject, String columnType) {
        BigDecimal amount = dynamicObject.getBigDecimal(columnType).setScale(2, 4);
        return DataFormat.formatMicrometer(amount.toString());
    }

    private DynamicObjectCollection calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List<String> itemNumbers = YearAccEngine.getEntityItemMapping().get(TCCIT_QYCZJDYNS_TZ_DETAIL);
        List orglist = (List)customParams.get("orglist");
        List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.TSSX);
        sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && itemNumbers.contains(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sellRuleList)) {
            return null;
        }
        int index = 0;
        for (DynamicObject dynamicObject : sellRuleList) {
            DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_QYCZJDYNS_SUMMARY);
            dynamicObject2.set(ITEM_NO, (Object)(++index));
            dynamicObject2.set(ITEM_NAME, (Object)dynamicObject.getString("name"));
            String ruleId = dynamicObject.getString("id");
            dynamicObject2.set(RULE_ID, (Object)ruleId);
            if (dynamicObject.get("item") == null) continue;
            DynamicObject item = dynamicObject.getDynamicObject("item");
            String itemName = item.getString("name");
            String itemNumber = item.getString("number");
            dynamicObject2.set(TSCZLX, (Object)itemName);
            dynamicObject2.set(TSCZLXNUMBER, (Object)itemNumber);
            dynamicObject2.set(YBSWCLZZJE, (Object)this.calcAmount(ruleId, YBSWCLZZJE, customParams, itemNumber));
            dynamicObject2.set(YBSWCLSSJE, (Object)this.calcAmount(ruleId, YBSWCLSSJE, customParams, itemNumber));
            dynamicObject2.set(YBSWCLNSTZJE, (Object)this.calcAmount(ruleId, YBSWCLNSTZJE, customParams, itemNumber));
            dynamicObject2.set(TSSWCLZZJE, (Object)this.calcAmount(ruleId, TSSWCLZZJE, customParams, itemNumber));
            dynamicObject2.set(TSSWCLSSJE, (Object)this.calcAmount(ruleId, TSSWCLSSJE, customParams, itemNumber));
            dynamicObject2.set(TSSWCLNSTZJE, (Object)this.calcAmount(ruleId, TSSWCLNSTZJE, customParams, itemNumber));
            dynamicObject2.set(NSTZHJJE, (Object)this.calcAmount(ruleId, NSTZHJJE, customParams, itemNumber));
            dynamicObject2.set("orgid", (Object)orgid);
            dynamicObject2.set("skssqq", (Object)skssqq);
            dynamicObject2.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject2);
        }
        this.appendRow(orgid, skssqq, skssqz, sum, index);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_QYCZJDYNS_SUMMARY, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private void appendRow(Long orgid, Date skssqq, Date skssqz, DynamicObjectCollection sum, int index) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_QYCZJDYNS_SUMMARY);
        dynamicObject.set(ITEM_NO, (Object)(++index));
        dynamicObject.set(ITEM_NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"QyczjdynsTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        dynamicObject.set(TSCZLX, (Object)"*");
        dynamicObject.set(YBSWCLZZJE, this.getSum(YBSWCLZZJE));
        dynamicObject.set(YBSWCLSSJE, this.getSum(YBSWCLSSJE));
        dynamicObject.set(YBSWCLNSTZJE, this.getSum(YBSWCLNSTZJE));
        dynamicObject.set(TSSWCLZZJE, this.getSum(TSSWCLZZJE));
        dynamicObject.set(TSSWCLSSJE, this.getSum(TSSWCLSSJE));
        dynamicObject.set(TSSWCLNSTZJE, this.getSum(TSSWCLNSTZJE));
        dynamicObject.set(NSTZHJJE, this.getSum(NSTZHJJE));
        dynamicObject.set("orgid", (Object)orgid);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        sum.add((Object)dynamicObject);
    }

    private Object getSum(String columnType) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : this.dataMap.entrySet()) {
            if (!entry.getKey().endsWith(columnType)) continue;
            sum = sum.add(entry.getValue());
        }
        return sum;
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, String itemNumber) {
        if (YBSWCLZZJE.equals(columnType) || YBSWCLSSJE.equals(columnType) || TSSWCLZZJE.equals(columnType) || TSSWCLSSJE.equals(columnType)) {
            BigDecimal amount = this.getAmount(rowType, customParams, columnType, itemNumber);
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if (YBSWCLNSTZJE.equals(columnType)) {
            BigDecimal zzje = this.dataMap.get(this.getKey(rowType, YBSWCLZZJE));
            BigDecimal ssje = this.dataMap.get(this.getKey(rowType, YBSWCLSSJE));
            BigDecimal nstzje = ssje.subtract(zzje);
            this.dataMap.put(this.getKey(rowType, columnType), nstzje);
            return nstzje;
        }
        if (TSSWCLNSTZJE.equals(columnType)) {
            BigDecimal zzje = this.dataMap.get(this.getKey(rowType, TSSWCLZZJE));
            BigDecimal ssje = this.dataMap.get(this.getKey(rowType, TSSWCLSSJE));
            BigDecimal nstzje = ssje.subtract(zzje);
            this.dataMap.put(this.getKey(rowType, columnType), nstzje);
            return nstzje;
        }
        if (NSTZHJJE.equals(columnType)) {
            BigDecimal ybswcl = this.dataMap.get(this.getKey(rowType, YBSWCLNSTZJE));
            BigDecimal tsswcl = this.dataMap.get(this.getKey(rowType, TSSWCLNSTZJE));
            BigDecimal nstzhjje = tsswcl.add(ybswcl);
            this.dataMap.put(this.getKey(rowType, columnType), nstzhjje);
            return nstzhjje;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(String ruleid, Map<String, Object> customParams, String entrytype, String itemNumber) {
        return this.getCellAmount(customParams, null, entrytype, null, null, Long.valueOf(ruleid), TCCIT_QYCZJDYNS_TZ_DETAIL);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULE_ID));
        if (ruleid.equals("0")) {
            return;
        }
        String fieldName = evt.getFieldName();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", fieldName);
        customParams.put(RULE_ID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", TCCIT_QYCZJDYNS_TZ_DETAIL);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{YBSWCLZZJE, YBSWCLSSJE, YBSWCLNSTZJE, TSSWCLZZJE, TSSWCLSSJE, TSSWCLNSTZJE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULE_ID);
        customParams.put("entryname", TCCIT_QYCZJDYNS_TZ_DETAIL);
        customParams.put("entrytype", column);
        customParams.put("columnType", column);
        customParams.put(RULE_ID, ruleid);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }
}

