/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;

public class RealEstateSpeBizFormPlugin
extends AbstractAccountPlugin
implements HyperLinkClickListener,
IDraftTypeObserver {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid nstzentity = (EntryGrid)this.getControl("nstzentity");
        nstzentity.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid mleentity = (EntryGrid)this.getControl("mleentity");
        mleentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        this.initNstzEntity(orgFilter, startFilter, endFilter, readonly, draftTypeObjectVo);
        this.initMleEntity(orgFilter, startFilter, endFilter, readonly, draftTypeObjectVo);
    }

    private void initNstzEntity(QFilter orgFilter, QFilter startFilter, QFilter endFilter, boolean readonly, DraftTypeObjectVo draftTypeObjectVo) {
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getFdctdywNstz().getNumber(), (String)"id,itemnumber,bqje,bnljje,sqbnljje", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}, (String)"itemnumber");
        if (genericObjects.length > 0) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow("nstzentity", genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                this.getModel().setValue("nstzid", dynamicObject.get("id"), rowIndex);
                this.getModel().setValue("nstzitem", dynamicObject.get("itemnumber"), rowIndex);
                this.formatBqje(dynamicObject.getBigDecimal("bqje"), rowIndex);
                this.getModel().setValue("bnljje", dynamicObject.get("bnljje"), rowIndex);
                this.getModel().setValue("sqbnljje", dynamicObject.get("sqbnljje"), rowIndex);
                ++rowIndex;
            }
            this.getModel().endInit();
            this.getView().updateView("nstzentity");
        }
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"nstzentity"});
        }
    }

    private void formatBqje(BigDecimal bqje, int rowIndex) {
        String text = DataFormat.formatMicrometer(bqje.setScale(2, 4).toString());
        if (rowIndex != 2 && rowIndex != 6) {
            StringBuilder link = new StringBuilder("<nolink>");
            link.append(text);
            this.getModel().setValue("bqje", (Object)link.toString(), rowIndex);
        } else {
            this.getModel().setValue("bqje", (Object)text, rowIndex);
        }
    }

    private void initMleEntity(QFilter orgFilter, QFilter startFilter, QFilter endFilter, boolean readonly, DraftTypeObjectVo draftTypeObjectVo) {
        QFilter qFilter = new QFilter("itemnumber", "=", (Object)"30101");
        QFilter qFilter1 = new QFilter("itemnumber", "=", (Object)"30103");
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getFdctdywMle().getNumber(), (String)"id,ruleid,itemnumber,entrytype,bqsrje,mll,yjbqmle,taxorg", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, qFilter.or(qFilter1)}, (String)"itemnumber");
        if (genericObjects.length > 0) {
            this.getModel().batchCreateNewEntryRow("mleentity", genericObjects.length);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("mleentity");
            DynamicObjectType dot = entryentity.getDynamicObjectType();
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
                dot.getProperty("mleid").setValueFast((Object)data, dynamicObject.get("id"));
                dot.getProperty("ruleid").setValueFast((Object)data, dynamicObject.get("ruleid"));
                dot.getProperty("mleitem").setValueFast((Object)data, dynamicObject.get("itemnumber"));
                dot.getProperty("bqsrje").setValueFast((Object)data, dynamicObject.get("bqsrje"));
                dot.getProperty("mll").setValueFast((Object)data, dynamicObject.get("mll"));
                dot.getProperty("yjbqmle").setValueFast((Object)data, dynamicObject.get("yjbqmle"));
                dot.getProperty("org").setValueFast((Object)data, dynamicObject.get("taxorg"));
                ++rowIndex;
            }
            this.getView().updateView("mleentity");
        }
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mleentity"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(this.getView().getFormShowParameter().getCustomParams());
        try {
            if ("bqsrje".equals(name)) {
                BigDecimal bqsrje = this.toBigDecimal(e.getChangeSet()[0].getNewValue());
                BigDecimal mll = this.toBigDecimal(this.getModel().getValue("mll", rowIndex));
                BigDecimal yjbqmle = BigDecimalUtil.multiplyObject((Object)bqsrje, (Object)mll, (int)2);
                this.getModel().setValue("yjbqmle", (Object)yjbqmle, rowIndex);
                Long id = (Long)this.getModel().getValue("mleid", rowIndex);
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)draftTypeObjectVo.getFdctdywMle().getNumber());
                object.set("bqsrje", (Object)bqsrje);
                object.set("yjbqmle", (Object)yjbqmle);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                this.formatBqje(this.filterSum("30101", "bqsrje"), 0);
                this.formatBqje(this.filterSum("30103", "bqsrje"), 4);
            } else if ("mll".equals(name)) {
                BigDecimal bqsrje = this.toBigDecimal(this.getModel().getValue("bqsrje", rowIndex));
                BigDecimal mll = this.toBigDecimal(e.getChangeSet()[0].getNewValue());
                BigDecimal yjbqmle = BigDecimalUtil.multiplyObject((Object)bqsrje, (Object)mll, (int)2);
                this.getModel().setValue("yjbqmle", (Object)yjbqmle, rowIndex);
                Long id = (Long)this.getModel().getValue("mleid", rowIndex);
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)draftTypeObjectVo.getFdctdywMle().getNumber());
                object.set("mll", (Object)mll);
                object.set("yjbqmle", (Object)yjbqmle);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            } else if ("yjbqmle".equals(name)) {
                this.formatBqje(this.filterSum("30101", "yjbqmle"), 1);
                this.formatBqje(this.filterSum("30103", "yjbqmle"), 5);
            } else if ("bqje".equals(name)) {
                int index = e.getChangeSet()[0].getRowIndex();
                if (index == 0 || index == 1 || index == 2 || index == 5 || index == 6 || index == 7) {
                    BigDecimal bqje = this.toBigDecimal(e.getChangeSet()[0].getNewValue());
                    BigDecimal sqbnljje = this.toBigDecimal(this.getModel().getValue("sqbnljje", index));
                    BigDecimal bnljje = BigDecimalUtil.addObject((Object)bqje, (Object)sqbnljje);
                    this.getModel().setValue("bnljje", (Object)bnljje, index);
                    Long id = (Long)this.getModel().getValue("nstzid", index);
                    DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)draftTypeObjectVo.getFdctdywNstz().getNumber());
                    object.set("bqje", (Object)bqje);
                    object.set("bnljje", (Object)bnljje);
                    if (this.checkAmountValue(Collections.singletonList(object), "bnljje")) {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                    } else {
                        String msg = ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25,\u91d1\u989d\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d", (String)"RealEstateSpeBizFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
                        this.getView().showErrorNotification(msg);
                    }
                }
                if (index == 1 || index == 2) {
                    Long id3 = (Long)this.getModel().getValue("nstzid", 3);
                    DynamicObject object3 = BusinessDataServiceHelper.loadSingle((Object)id3, (String)draftTypeObjectVo.getFdctdywNstz().getNumber());
                    BigDecimal bqje1 = this.toBigDecimal(this.getModel().getValue("bqje", 1));
                    BigDecimal bqje2 = this.toBigDecimal(this.getModel().getValue("bqje", 2));
                    BigDecimal bnljje1 = this.toBigDecimal(this.getModel().getValue("bnljje", 1));
                    BigDecimal bnljje2 = this.toBigDecimal(this.getModel().getValue("bnljje", 2));
                    BigDecimal bqje3 = BigDecimalUtil.subtractObject((Object)bqje1, (Object)bqje2);
                    object3.set("bqje", (Object)bqje3);
                    BigDecimal bnljje3 = BigDecimalUtil.subtractObject((Object)bnljje1, (Object)bnljje2);
                    object3.set("bnljje", (Object)bnljje3);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object3});
                    this.formatBqje(bqje3, 3);
                    this.getModel().setValue("bnljje", (Object)bnljje3, 3);
                }
                if (index == 5 || index == 6) {
                    Long id7 = (Long)this.getModel().getValue("nstzid", 7);
                    DynamicObject object7 = BusinessDataServiceHelper.loadSingle((Object)id7, (String)draftTypeObjectVo.getFdctdywNstz().getNumber());
                    BigDecimal bqje5 = this.toBigDecimal(this.getModel().getValue("bqje", 5));
                    BigDecimal bqje6 = this.toBigDecimal(this.getModel().getValue("bqje", 6));
                    BigDecimal bnljje5 = this.toBigDecimal(this.getModel().getValue("bnljje", 5));
                    BigDecimal bnljje6 = this.toBigDecimal(this.getModel().getValue("bnljje", 6));
                    BigDecimal bqje7 = BigDecimalUtil.subtractObject((Object)bqje5, (Object)bqje6);
                    object7.set("bqje", (Object)bqje7);
                    BigDecimal bnljje7 = BigDecimalUtil.subtractObject((Object)bnljje5, (Object)bnljje6);
                    object7.set("bnljje", (Object)bnljje7);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object7});
                    this.formatBqje(bqje7, 7);
                    this.getModel().setValue("bnljje", (Object)bnljje7, 7);
                }
                if (index == 1 || index == 2 || index == 5 || index == 6) {
                    Long id8 = (Long)this.getModel().getValue("nstzid", 8);
                    DynamicObject object8 = BusinessDataServiceHelper.loadSingle((Object)id8, (String)draftTypeObjectVo.getFdctdywNstz().getNumber());
                    BigDecimal bqje3 = this.toBigDecimal(this.getModel().getValue("bqje", 3));
                    BigDecimal bqje7 = this.toBigDecimal(this.getModel().getValue("bqje", 7));
                    BigDecimal bnljje3 = this.toBigDecimal(this.getModel().getValue("bnljje", 3));
                    BigDecimal bnljje7 = this.toBigDecimal(this.getModel().getValue("bnljje", 7));
                    BigDecimal bqje8 = BigDecimalUtil.subtractObject((Object)bqje3, (Object)bqje7);
                    object8.set("bqje", (Object)bqje8);
                    BigDecimal bnljje8 = BigDecimalUtil.subtractObject((Object)bnljje3, (Object)bnljje7);
                    object8.set("bnljje", (Object)bnljje8);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object8});
                    this.formatBqje(bqje8, 8);
                    this.getModel().setValue("bnljje", (Object)bnljje8, 8);
                    Map customParams = this.getView().getFormShowParameter().getCustomParams();
                    Object orgid = customParams.get("orgid");
                    QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
                    Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
                    QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
                    Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
                    QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
                    DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getFdctdywNstz().getNumber(), (String)"id,itemnumber,bqje,bnljje,sqbnljje", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}, (String)"itemnumber");
                    this.recalcRecoupDeficit(draftTypeObjectVo, "RealEstateSpeBizEngine_summary1", Arrays.stream(genericObjects).collect(Collectors.toList()), customParams);
                }
            }
        }
        catch (Exception ex) {
            if (ex.getCause().toString().contains("10^13")) {
                String msg = ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25,\u5e95\u7a3f\u8ba1\u7b97\u4e2d\u5b58\u5728\u8d85\u8fc713\u4f4d\u6574\u6570\u7684\u91d1\u989d\u503c", (String)"RealEstateSpeBizFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
            throw ex;
        }
    }

    private BigDecimal filterSum(String number, String column) {
        Predicate<DynamicObject> predicate = s1 -> number.equals(Optional.ofNullable(s1.getDynamicObject("ruleid")).map(s -> s.getDynamicObject("item")).map(s -> s.getString("number")).orElseGet(() -> ""));
        List mleentity = this.getModel().getEntryEntity("mleentity").stream().filter(s -> predicate.test((DynamicObject)s)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(mleentity)) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = mleentity.stream().map(s -> this.toBigDecimal(s.getBigDecimal(column))).reduce(BigDecimal.ZERO, BigDecimal::add);
        return total;
    }

    private BigDecimal toBigDecimal(Object value) {
        if (value instanceof String) {
            String replace = StringUtil.replace((String)((String)value), (String)"<nolink>", (String)"").replace(",", "");
            return BigDecimalUtil.toBigDecimal((Object)replace);
        }
        if (value instanceof BigDecimal) {
            return BigDecimalUtil.toBigDecimal((Object)value);
        }
        return BigDecimal.ZERO;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        String actionId = closedCallBackEvent.getActionId();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(this.getView().getFormShowParameter().getCustomParams());
        if ("adjust_details".equals(actionId) && (returnData = (Map)closedCallBackEvent.getReturnData()) != null) {
            Object total = returnData.get("adjustsumamount");
            String columnType = (String)returnData.get("columnType");
            int rowIndex = (Integer)returnData.get("rowIndex");
            this.getModel().setValue(columnType, total, rowIndex);
            this.setEntryName("nstzentity");
            this.markEditCells(this.getEntryName(), draftTypeObjectVo.getAdjustRecord().getNumber());
            this.setEntryName("mleentity");
            this.markEditCells(this.getEntryName(), draftTypeObjectVo.getAdjustRecord().getNumber());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", key);
        customParams.put("rowIndex", rowIndex);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        customParams.put("entrytype", "yjother");
        customParams.put("entryname", draftTypeObjectVo.getFdctdywNstz().getDetail());
        if ("bqje".equals(key)) {
            if (2 == evt.getRowIndex()) {
                customParams.put("itemnumber", "30102");
            } else {
                customParams.put("itemnumber", "30104");
            }
        } else if ("bqsrje".equals(key)) {
            String ruleid = String.valueOf(this.getModel().getValue("ruleid_id", rowIndex));
            String orgId = String.valueOf(this.getModel().getValue("org_id", rowIndex));
            customParams.put("ruleid", ruleid);
            customParams.put("itemnumber", orgId + "-" + ruleid);
            customParams.put("isByRule", "true");
            customParams.put("taxorg", orgId);
        }
        customParams.put("closecallback", "closecallback");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "adjust_details");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    @Override
    public Set<String> adaptDraftCellName(Set<String> rowSet) {
        if ("nstzentity".equals(this.getEntryName())) {
            return Collections.singleton("bqje");
        }
        if ("mleentity".equals(this.getEntryName())) {
            return Collections.singleton("bqsrje");
        }
        return Collections.emptySet();
    }

    @Override
    public Map<String, Object> createParams(DynamicObject obj) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(customParams);
        params.put("entrytype", "yjother");
        String entryName = this.getEntryName();
        if ("nstzentity".equals(entryName)) {
            if ("003".equals(obj.getString("nstzitem"))) {
                params.put("itemnumber", "30102");
            }
            if ("007".equals(obj.getString("nstzitem"))) {
                params.put("itemnumber", "30104");
            }
        } else if ("mleentity".equals(entryName)) {
            String ruleid = obj.getString("ruleid_id");
            params.put("ruleid", ruleid);
            params.put("isByRule", "true");
            params.put("taxorg", obj.getString("org_id"));
            params.put("itemnumber", ruleid);
        }
        return params;
    }

    @Override
    public void afterBindData(EventObject e) {
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(this.getView().getFormShowParameter().getCustomParams());
        this.setEntryName("nstzentity");
        this.markEditCells(this.getEntryName(), draftTypeObjectVo.getAdjustRecord().getNumber());
        this.setEntryName("mleentity");
        this.markEditCells(this.getEntryName(), draftTypeObjectVo.getAdjustRecord().getNumber());
    }
}

