/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.utils.DataFormat;

public class RecoupDeficitFormPlugin
extends AbstractFormPlugin
implements IDraftTypeObserver,
HyperLinkClickListener {
    private static final String fields = "id,item,amount,amountresource";
    private static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private static final String RECOUP_DEFICIT_AMOUNT = "recoup_deficit_amount";
    private static final String ORIGNALAMOUNT = "orignalamount";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        StringBuilder link = new StringBuilder("<nolink>");
        if (!"item8".equals(d.getString("item")) && "amount".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)link.append(DataFormat.formatMicrometer(d.get("amount").toString())).toString());
        }
    }

    public void afterCreateNewData(EventObject e) {
        boolean readonly;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        IDataModel model = this.getModel();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getRecoupDeficit().getNumber(), (String)fields, (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter}, (String)"id");
        DynamicObject adjustAmount = this.getAdjustAmount(customParams, draftTypeObjectVo);
        if (adjustAmount != null && dynamicObjects.length > 0) {
            this.mergeSaveData(dynamicObjects, adjustAmount);
            this.getPageCache().put(ORIGNALAMOUNT, String.valueOf(adjustAmount.getBigDecimal("totalamount").subtract(adjustAmount.getBigDecimal("adjustAmount"))));
        }
        model.deleteEntryData("entryentity");
        if (dynamicObjects.length > 0) {
            model.batchCreateNewEntryRow("entryentity", dynamicObjects.length);
            DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
            DynamicObjectType dot = entryentity.getDynamicObjectType();
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
                for (String field : fields.split(",")) {
                    Object o = dynamicObject.get(field);
                    dot.getProperty(field).setValueFast((Object)data, o);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{field});
                }
                ++rowIndex;
            }
            this.getView().updateView("entryentity");
        }
        if (readonly = ((Boolean)this.getView().getFormShowParameter().getCustomParam("readonly")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    private DynamicObject[] mergeSaveData(DynamicObject[] dynamicObjects, DynamicObject adjustAmount) {
        BigDecimal totalamount;
        BigDecimal amount8 = Arrays.stream(dynamicObjects).filter(e -> "item8".equals(e.getString("item"))).map(e -> e.getBigDecimal("amount")).findFirst().orElse(BigDecimal.ZERO);
        if (amount8.compareTo(totalamount = adjustAmount.getBigDecimal("totalamount")) == 0) {
            return dynamicObjects;
        }
        Arrays.stream(dynamicObjects).forEach(e -> {
            if ("item8".equals(e.getString("item"))) {
                e.set("amount", (Object)totalamount);
            }
        });
        BigDecimal amount7 = Arrays.stream(dynamicObjects).filter(e -> "item7".equals(e.getString("item"))).map(e -> e.getBigDecimal("amount")).findFirst().orElse(BigDecimal.ZERO);
        Arrays.stream(dynamicObjects).forEach(e -> {
            if ("item9".equals(e.getString("item"))) {
                e.set("amount", (Object)(amount7.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : amount7.min(totalamount)));
            }
            if ("item10".equals(e.getString("item"))) {
                e.set("amount", (Object)amount7.subtract(amount7.min(totalamount)));
            }
        });
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        return dynamicObjects;
    }

    private DynamicObject getAdjustAmount(Map<String, Object> customParams, DraftTypeObjectVo draftTypeObjectVo) {
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)RECOUP_DEFICIT_AMOUNT);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter};
        String selectPrope = "adjustamount,totalamount";
        return BusinessDataServiceHelper.loadSingle((String)draftTypeObjectVo.getAdjustDetail().getNumber(), (String)selectPrope, (QFilter[])filters);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", RECOUP_DEFICIT_AMOUNT);
        customParams.put("existsRules", false);
        customParams.put("entryname", "tccit_recoup_deficit");
        String orignalamount = this.getPageCache().get(ORIGNALAMOUNT);
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", evt.getRowIndex());
        String amountresource = (String)this.getModel().getValue("amountresource", evt.getRowIndex());
        customParams.put("originalamount", StringUtil.isBlank((CharSequence)orignalamount) ? amount : new BigDecimal(orignalamount));
        if ("lastdeclare".equals(amountresource)) {
            customParams.put("tip", "labelap");
            customParams.put("tipContent", ResManager.loadKDString((String)"\u539f\u6570\u503c\u4e3a\u4e0a\u4e00\u7eb3\u7a0e\u5e74\u5ea6\u53ef\u7ed3\u8f6c\u4ee5\u540e\u5e74\u5ea6\u5f25\u8865\u4e8f\u635f\u989d", (String)"RecoupDeficitFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        if ("lastdraft".equals(amountresource)) {
            customParams.put("tip", "labelap");
            customParams.put("tipContent", ResManager.loadKDString((String)"\u539f\u6570\u503c\u4e3a\u4e0a\u671f\u8ba1\u7a0e\u5e95\u7a3f\u91d1\u989d", (String)"RecoupDeficitFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        this.showForm(customParams);
    }

    private void showForm(Map<String, Object> customParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(TCCIT_DETAIL_TZ_DIALOG);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TCCIT_DETAIL_TZ_DIALOG);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }
}

