/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class RightsIncomeTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "001_01", "001_02", "001_03", "002", "002_01", "002_02", "002_03", "003", "003_01", "003_02", "003_03", "004"});
    public static final Set<String> titles = Sets.newHashSet((Object[])new String[]{"001", "002", "003"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String SIGN_AMOUNT = "signamount";
    public static final String ZZJE_CURRENT = "zzjecurrent";
    public static final String ZZJE_SUM = "zzjesum";
    public static final String TAX_INCOME_CURRENT = "taxincomecurrent";
    public static final String TAX_INCOME_SUM = "taxincomesum";
    public static final String NSTZJE = "nstzje";
    public static final ArrayList<String> WAZZList = Lists.newArrayList((Object[])new String[]{"002_01", "002_02", "002_03", "003_01", "003_02", "003_03", "004"});
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private static Map<String, String> projects = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        this.dataMap.clear();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,signamount,zzjecurrent,zzjesum,taxincomecurrent,taxincomesum,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_right_income_sum", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)"id");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String itemType = dynamicObject.getString(ITEM_TYPE);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)itemType);
            dot.getProperty(SIGN_AMOUNT).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, SIGN_AMOUNT));
            dot.getProperty(ZZJE_CURRENT).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, ZZJE_CURRENT));
            dot.getProperty(ZZJE_SUM).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, ZZJE_SUM));
            dot.getProperty(TAX_INCOME_CURRENT).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, TAX_INCOME_CURRENT));
            dot.getProperty(TAX_INCOME_SUM).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, TAX_INCOME_SUM));
            dot.getProperty(NSTZJE).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, NSTZJE));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(String itemType, DynamicObject dynamicObject, String columnType) {
        if (titles.contains(itemType)) {
            return "";
        }
        String text = DataFormat.formatMicrometer(dynamicObject.getBigDecimal(columnType).setScale(2, 4).toString());
        return text;
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_right_income_sum", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("income2")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int itemNo = 0;
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_right_income_sum");
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(ZZJE_CURRENT, (Object)this.calcAmount(itemType, ZZJE_CURRENT, customParams, "bnzzje"));
            dynamicObject.set(ZZJE_SUM, (Object)this.calcAmount(itemType, ZZJE_SUM, customParams, "ljzzje"));
            dynamicObject.set(TAX_INCOME_CURRENT, (Object)this.calcAmount(itemType, TAX_INCOME_CURRENT, customParams, "bnssje"));
            dynamicObject.set(TAX_INCOME_SUM, (Object)this.calcAmount(itemType, TAX_INCOME_SUM, customParams, "ljssje"));
            dynamicObject.set(NSTZJE, (Object)this.calcAmount(itemType, NSTZJE, customParams, null));
            dynamicObject.set(SIGN_AMOUNT, (Object)this.calcAmount(itemType, SIGN_AMOUNT, customParams, null));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, String entrytype) {
        if (Lists.newArrayList((Object[])new String[]{"001_01", "001_02", "001_03"}).contains(rowType) || WAZZList.contains(rowType)) {
            if (SIGN_AMOUNT.equals(columnType)) {
                BigDecimal signAmount = this.dataMap.getOrDefault(this.getKey(rowType, TAX_INCOME_SUM), BigDecimal.ZERO);
                this.dataMap.put(this.getKey(rowType, columnType), signAmount);
                return signAmount;
            }
            if (NSTZJE.equals(columnType)) {
                BigDecimal taxIncomeCurrent = this.dataMap.getOrDefault(this.getKey(rowType, TAX_INCOME_CURRENT), BigDecimal.ZERO);
                BigDecimal zzjeCurrent = this.dataMap.getOrDefault(this.getKey(rowType, ZZJE_CURRENT), BigDecimal.ZERO);
                BigDecimal subtract = taxIncomeCurrent.subtract(zzjeCurrent);
                this.dataMap.put(this.getKey(rowType, columnType), subtract);
                return subtract;
            }
            BigDecimal amount = this.getAmount(customParams, columnType, entrytype, rowType);
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype, String rowType) {
        return this.getCellAmount(customParams, columnType, entrytype, rowType, projects.get(rowType), null, "tccit_rights_income_det");
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String rowType = (String)itemsEntity.getModel().getValue(ITEM_TYPE);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", this.geEntryType(evt));
        customParams.put("itemnumber", projects.get(rowType));
        customParams.put("entryname", "tccit_rights_income_det");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private Object geEntryType(HyperLinkClickEvent evt) {
        String columnType = evt.getFieldName();
        Map<String, String> columnMapping = this.getColumnEntryType();
        return columnMapping.get(columnType);
    }

    private Map<String, String> getColumnEntryType() {
        HashMap<String, String> columnMapping = new HashMap<String, String>(16);
        columnMapping.put(SIGN_AMOUNT, "ljssje");
        columnMapping.put(ZZJE_CURRENT, "bnzzje");
        columnMapping.put(ZZJE_SUM, "ljzzje");
        columnMapping.put(TAX_INCOME_CURRENT, "bnssje");
        columnMapping.put(TAX_INCOME_SUM, "ljssje");
        return columnMapping;
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_right_income_sum", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{SIGN_AMOUNT, ZZJE_CURRENT, ZZJE_SUM, TAX_INCOME_CURRENT, TAX_INCOME_SUM, NSTZJE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        customParams.put("entryname", "tccit_rights_income_det");
        customParams.put("entrytype", this.getColumnEntryType().get(column));
        customParams.put("columnType", itemtype);
        customParams.put("itemnumber", projects.get(itemtype));
        return customParams;
    }

    static {
        projects.put("001_01", "6010101");
        projects.put("001_02", "6010102");
        projects.put("001_03", "6010103");
        projects.put("002_01", "6010201");
        projects.put("002_02", "6010202");
        projects.put("002_03", "6010203");
        projects.put("003_01", "6010204");
        projects.put("003_02", "6010205");
        projects.put("003_03", "6010206");
        projects.put("004", "6010207");
    }
}

