/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class SalaryTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"zzje", "sjje", "sjjebeforetax", "taxamount", "nstzje"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String SALARY = "salary";
    public static final String STOCK = "stock";
    public static final String INSURANCE = "insurance";
    public static final String COMM_RESERVE = "commreserve";
    public static final String SUM_AMOUNT = "sumamount";
    public static final String SALARY_STOCK = "salarystock";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private static Map<String, String> projects = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", (Object)Lists.newArrayList((Object[])new String[]{SALARY_STOCK, SALARY, STOCK, INSURANCE, COMM_RESERVE, SUM_AMOUNT}));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemtype,zzje,sjje,sjjebeforetax,taxamount,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_salary_summary", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        HashMap<String, BigDecimal> toMap = new HashMap<String, BigDecimal>();
        for (DynamicObject object : query) {
            toMap.put(this.getKey("zzje", object.getString(ITEM_TYPE)), object.getBigDecimal("zzje"));
            toMap.put(this.getKey("sjje", object.getString(ITEM_TYPE)), object.getBigDecimal("sjje"));
            toMap.put(this.getKey("sjjebeforetax", object.getString(ITEM_TYPE)), object.getBigDecimal("sjjebeforetax"));
            toMap.put(this.getKey("taxamount", object.getString(ITEM_TYPE)), object.getBigDecimal("taxamount"));
            toMap.put(this.getKey("nstzje", object.getString(ITEM_TYPE)), object.getBigDecimal("nstzje"));
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", itemTypes.size());
        int rowIndex = 0;
        for (String itemType : itemTypes) {
            model.setValue(ITEM_NO, (Object)(rowIndex + 1), rowIndex);
            model.setValue(ITEM_TYPE, (Object)itemType, rowIndex);
            model.setValue(SALARY_STOCK, (Object)this.formatData((BigDecimal)toMap.get(this.getKey(itemType, SALARY_STOCK)), itemType, SALARY_STOCK), rowIndex);
            model.setValue(SALARY, (Object)this.formatData((BigDecimal)toMap.get(this.getKey(itemType, SALARY)), itemType, SALARY), rowIndex);
            model.setValue(STOCK, (Object)this.formatData((BigDecimal)toMap.get(this.getKey(itemType, STOCK)), itemType, STOCK), rowIndex);
            model.setValue(INSURANCE, (Object)this.formatData((BigDecimal)toMap.get(this.getKey(itemType, INSURANCE)), itemType, INSURANCE), rowIndex);
            model.setValue(COMM_RESERVE, (Object)this.formatData((BigDecimal)toMap.get(this.getKey(itemType, COMM_RESERVE)), itemType, COMM_RESERVE), rowIndex);
            model.setValue(SUM_AMOUNT, toMap.get(this.getKey(itemType, SUM_AMOUNT)), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private String formatData(BigDecimal data, String rowtype, String columnType) {
        StringBuilder link = new StringBuilder("<nolink>");
        String text = data.setScale(2, 4).toString();
        if (!SALARY_STOCK.equals(columnType) && ("taxamount".equals(rowtype) || "nstzje".equals(rowtype))) {
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        return DataFormat.formatMicrometer(text);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(16);
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        for (String itemType : itemTypes) {
            BigDecimal salary = this.calcAmount(itemType, SALARY, customParams);
            BigDecimal stock = this.calcAmount(itemType, STOCK, customParams);
            result.put(this.getKey(itemType, SALARY_STOCK), salary.add(stock));
            result.put(this.getKey(itemType, SALARY), salary);
            result.put(this.getKey(itemType, STOCK), stock);
            result.put(this.getKey(itemType, INSURANCE), this.calcAmount(itemType, INSURANCE, customParams));
            result.put(this.getKey(itemType, COMM_RESERVE), this.calcAmount(itemType, COMM_RESERVE, customParams));
            result.put(this.getKey(itemType, SUM_AMOUNT), this.sumAmount(itemType));
        }
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        this.saveCurrentPeriod(result, orgid, skssqq, skssqz);
    }

    private void saveCurrentPeriod(Map<String, BigDecimal> result, Long orgid, Date skssqq, Date skssqz) {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{SALARY_STOCK, SALARY, STOCK, INSURANCE, COMM_RESERVE, SUM_AMOUNT});
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int itemNo = 0;
        for (String column : columns) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_salary_summary");
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            dynamicObject.set(ITEM_TYPE, (Object)column);
            dynamicObject.set("zzje", (Object)result.get(this.getKey("zzje", column)));
            dynamicObject.set("sjje", (Object)result.get(this.getKey("sjje", column)));
            dynamicObject.set("sjjebeforetax", (Object)result.get(this.getKey("sjjebeforetax", column)));
            dynamicObject.set("taxamount", (Object)result.get(this.getKey("taxamount", column)));
            dynamicObject.set("nstzje", (Object)result.get(this.getKey("nstzje", column)));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", (Object)Lists.newArrayList((Object[])new String[]{SALARY_STOCK, SALARY, STOCK, INSURANCE, COMM_RESERVE, SUM_AMOUNT}));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_salary_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private BigDecimal sumAmount(String rowType) {
        BigDecimal salaryAmount = Arrays.asList(SALARY, STOCK, INSURANCE, COMM_RESERVE).stream().map(s -> this.dataMap.getOrDefault(this.getKey(rowType, (String)s), BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.dataMap.put(this.getKey(rowType, SUM_AMOUNT), salaryAmount);
        return salaryAmount;
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        if ("zzje".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "zzje");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("sjje".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "sjje");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("sjjebeforetax".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "bksqlzje");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("taxamount".equals(rowType)) {
            BigDecimal amount002 = this.dataMap.get(this.getKey("sjje", columnType));
            BigDecimal amount003 = this.dataMap.get(this.getKey("sjjebeforetax", columnType));
            BigDecimal taxIncome = amount002.subtract(amount003);
            this.dataMap.put(this.getKey(rowType, columnType), taxIncome);
            return taxIncome;
        }
        if ("nstzje".equals(rowType)) {
            BigDecimal amount001 = this.dataMap.get(this.getKey("zzje", columnType));
            BigDecimal amount004 = this.dataMap.get(this.getKey("taxamount", columnType));
            BigDecimal adjustAmount = amount001.subtract(amount004);
            this.dataMap.put(this.getKey(rowType, columnType), adjustAmount);
            return adjustAmount;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype) {
        String itemnumber = projects.get(columnType);
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, null, "tccit_salary_tz_detail");
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > 2) {
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemtype = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        String entrytype = itemtype.equals("sjjebeforetax") ? "bksqlzje" : itemtype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", entrytype);
        customParams.put("itemnumber", projects.get(evt.getFieldName()));
        customParams.put("entryname", "tccit_salary_tz_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{SALARY, STOCK, INSURANCE, COMM_RESERVE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        customParams.put("entryname", "tccit_salary_tz_detail");
        customParams.put("entrytype", itemtype.equals("sjjebeforetax") ? "bksqlzje" : itemtype);
        customParams.put("columnType", column);
        customParams.put("itemnumber", projects.get(column));
        return customParams;
    }

    static {
        projects.put(SALARY, "3010101");
        projects.put(INSURANCE, "3010102");
        projects.put(COMM_RESERVE, "3010103");
        projects.put(STOCK, "3010110");
    }
}

