/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class SaleZkzrthTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ITEM_NO = "itemno";
    public static final String NAME = "name";
    public static final String JRDQSYJE = "jrdqsyje";
    public static final String KSQKCJE = "ksqkcje";
    public static final String NSTZJE = "nstzje";
    public static final String ORGID = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String RULEID = "ruleid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        String selectFields = "itemno,ruleid,name,jrdqsyje,ksqkcje,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_sale_zkzrth_summary", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            model.setValue(RULEID, (Object)dynamicObject.getLong(RULEID), rowIndex);
            model.setValue(NAME, (Object)dynamicObject.getString(NAME), rowIndex);
            model.setValue(JRDQSYJE, (Object)dynamicObject.getString(JRDQSYJE), rowIndex);
            model.setValue(KSQKCJE, (Object)dynamicObject.getString(KSQKCJE), rowIndex);
            model.setValue(NSTZJE, (Object)dynamicObject.getString(NSTZJE), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private DynamicObjectCollection calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("income5")) {
            return null;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<DynamicObject> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.INCOME_ADJUST);
        sellRuleList.removeIf(r -> !"60103".equals(r.getDynamicObject("item").getString("number")));
        int index = 0;
        for (DynamicObject rule : sellRuleList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_sale_zkzrth_summary");
            dynamicObject.set(ITEM_NO, (Object)(++index));
            dynamicObject.set(NAME, (Object)rule.getString(NAME));
            dynamicObject.set(RULEID, (Object)rule.getLong("id"));
            BigDecimal jrdqsyje = this.getAmount(customParams, "zzje", rule.getString("id"));
            dynamicObject.set(JRDQSYJE, (Object)jrdqsyje);
            BigDecimal ksqkcje = this.getAmount(customParams, "swkjje", rule.getString("id"));
            dynamicObject.set(KSQKCJE, (Object)ksqkcje);
            dynamicObject.set(NSTZJE, (Object)BigDecimalUtil.subtractObject((Object)jrdqsyje, (Object)ksqkcje));
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_sale_zkzrth_summary", (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, String ruleid) {
        return this.getCellAmount(customParams, null, entrytype, null, null, Long.valueOf(ruleid), "tccit_zkzrth_tz_detail");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULEID));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (JRDQSYJE.equals(evt.getFieldName())) {
            customParams.put("entrytype", "zzje");
        } else if (KSQKCJE.equals(evt.getFieldName())) {
            customParams.put("entrytype", "swkjje");
        }
        customParams.put("columnType", evt.getFieldName());
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", "tccit_zkzrth_tz_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{JRDQSYJE, KSQKCJE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULEID);
        customParams.put("entryname", "tccit_zkzrth_tz_detail");
        customParams.put("entrytype", JRDQSYJE.equals(column) ? "zzje" : "swkjje");
        customParams.put("columnType", column);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }
}

