/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.common.enums.DraftSummaryEnum;
import kd.taxc.tccit.formplugin.account.DeductPreferentialSummaryPlugin;
import kd.taxc.tccit.formplugin.account.DkynssdeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.HznsqySeftSummaryPlugin;
import kd.taxc.tccit.formplugin.account.YhTaxCreditFormPlugin;
import kd.taxc.tccit.formplugin.draft.AbstractSummaryPlugin;

public class SejsSetzSummaryPlugin
extends AbstractSummaryPlugin {
    @Override
    public DraftSummaryEnum getDraftSummaryEnum() {
        return DraftSummaryEnum.SEJS;
    }

    @Override
    protected void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        String rowKey = d.getString("itemtype");
        String columnDescKey = columnDesc.getKey();
        if (columnDescKey.equals("amount") && "2".equals(rowKey)) {
            Object formatValue1 = e.getFormatValue();
            BigDecimal formatValue = BigDecimal.ZERO;
            if (formatValue1 instanceof BigDecimal) {
                formatValue = (BigDecimal)formatValue1;
            } else if (formatValue1 instanceof String) {
                formatValue = new BigDecimal(String.valueOf(formatValue1));
            }
            BigDecimal divide = formatValue.multiply(new BigDecimal(100)).setScale(2, 4);
            e.setFormatValue((Object)(divide + "%"));
        }
    }

    @Override
    public Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        Object yjLastSbbid;
        BigDecimal amount2;
        BigDecimal amount1;
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList<QFilter> baseQfilters = this.getBaseQfilters(customParams);
        if ("1".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "=", (Object)"0"));
            amount = this.getOne(rowType, columnType, "tccit_dg_a100000_7_sum", "zzqcurrent", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "zzqcurrent");
        }
        if ("2".equals(rowType) && "amount".equals(columnType)) {
            amount = BigDecimal.valueOf(0.25);
        }
        if ("3".equals(rowType) && "amount".equals(columnType) && (amount = (amount1 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("1", columnType), BigDecimal.ZERO)).multiply(amount2 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("2", columnType), BigDecimal.ZERO)).setScale(2, 4)).compareTo(BigDecimal.ZERO) < 0) {
            amount = BigDecimal.ZERO;
        }
        if ("4".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "in", (Object)Lists.newArrayList((Object[])new String[]{"4", "5", "6"})));
            DynamicObjectCollection tccit_setz_jmyhhz_summary = QueryServiceHelper.query((String)"tccit_setz_jmyhhz_summary", (String)"itemtype,amountorratio", (QFilter[])baseQfilters.toArray(new QFilter[baseQfilters.size()]));
            Map<String, DynamicObject> collect = tccit_setz_jmyhhz_summary.stream().collect(Collectors.toMap(a -> a.getString("itemtype"), b -> b, (v1, v2) -> v1));
            BigDecimal amount4 = collect.get("4") == null ? BigDecimal.ZERO : collect.get("4").getBigDecimal("amountorratio");
            BigDecimal amount5 = collect.get("5") == null ? BigDecimal.ZERO : collect.get("5").getBigDecimal("amountorratio");
            BigDecimal amount6 = collect.get("6") == null ? BigDecimal.ZERO : collect.get("6").getBigDecimal("amountorratio");
            amount = amount4.subtract(amount5).add(amount6);
            BigDecimal bigDecimal3 = (BigDecimal)this.dataMap.get(SejsSetzSummaryPlugin.getKey("3", columnType));
            BigDecimal bigDecimal = bigDecimal3 = bigDecimal3 == null ? BigDecimal.ZERO : bigDecimal3;
            if (amount.compareTo(BigDecimal.ZERO) < 0) {
                amount = BigDecimal.ZERO;
            } else if (amount.compareTo(bigDecimal3) > 0) {
                amount = bigDecimal3;
            }
        }
        if ("5".equals(rowType) && "amount".equals(columnType)) {
            QFilter qFilter1;
            BigDecimal amount22;
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            Long orgid = Long.parseLong((String)customParams.get("orgid"));
            int yearOfDate = DateUtils.getYearOfDate((Date)skssqq);
            ArrayList<String> years = new ArrayList<String>(8);
            for (int i = 0; i <= 5; ++i) {
                years.add(String.valueOf(yearOfDate - i));
            }
            QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
            QFilter qFilter = new QFilter("nd", "in", years).and("orgid", "=", (Object)orgid).and(dateFilter);
            BigDecimal amount12 = this.getSum(rowType, columnType, "tccit_yh_taxcredit_data", "sum(bnsjdmdgndse) as bnsjdmdgndse", qFilter.toArray(), "bnsjdmdgndse");
            BigDecimal bigDecimal = amount = amount12.compareTo(amount22 = this.getOne(rowType, columnType, "tccit_yh_taxcredit_data", "bndmqynse", (qFilter1 = new QFilter("nd", "=", (Object)String.valueOf(yearOfDate)).and("orgid", "=", (Object)orgid).and(dateFilter)).toArray(), "bndmqynse")) > 0 ? amount22 : amount12;
        }
        if ("6".equals(rowType) && "amount".equals(columnType)) {
            BigDecimal amount3 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("3", columnType), BigDecimal.ZERO);
            BigDecimal amount4 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("4", columnType), BigDecimal.ZERO);
            BigDecimal amount5 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("5", columnType), BigDecimal.ZERO);
            amount = amount3.subtract(amount4).subtract(amount5);
        }
        if (!"7".equals(rowType) || "amount".equals(columnType)) {
            // empty if block
        }
        if (!"8".equals(rowType) || "amount".equals(columnType)) {
            // empty if block
        }
        if ("9".equals(rowType) && "amount".equals(columnType)) {
            BigDecimal amount6 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("6", columnType), BigDecimal.ZERO);
            BigDecimal amount7 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("7", columnType), BigDecimal.ZERO);
            BigDecimal amount8 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("8", columnType), BigDecimal.ZERO);
            amount = amount6.add(amount7).subtract(amount8);
            if (amount.compareTo(BigDecimal.ZERO) < 0) {
                amount = BigDecimal.ZERO;
            }
        }
        if ("10".equals(rowType) && "amount".equals(columnType) && (yjLastSbbid = this.getYjLastSbbid((String)customParams.get("orgid"), (String)customParams.get("skssqq"), (String)customParams.get("skssqz"))) != null) {
            QFilter qFilter = new QFilter("ewblxh", "=", (Object)"1");
            QFilter qFilter1 = new QFilter("sbbid", "=", (Object)String.valueOf(yjLastSbbid));
            amount = this.getOne(rowType, columnType, "tccit_qysds_zb", "sum(sjyyjsdse+tdywyjzsdse+ybtsdse) as resamount", new QFilter[]{qFilter, qFilter1}, "resamount");
        }
        if ("11".equals(rowType) && "amount".equals(columnType)) {
            BigDecimal amount9 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("9", columnType), BigDecimal.ZERO);
            BigDecimal amount10 = this.dataMap.getOrDefault(SejsSetzSummaryPlugin.getKey("10", columnType), BigDecimal.ZERO);
            amount = amount9.subtract(amount10);
        }
        if ("12".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "in", (Object)Lists.newArrayList((Object[])new String[]{"3a", "4"})));
            amount = this.getSum(rowType, columnType, "tccit_seft_hznsqy_summary", "sum(amount) as amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
        }
        if ("13".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "=", (Object)"3b"));
            amount = this.getOne(rowType, columnType, "tccit_seft_hznsqy_summary", "amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
        }
        if ("14".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "=", (Object)"3d"));
            amount = this.getOne(rowType, columnType, "tccit_seft_hznsqy_summary", "amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
        }
        return amount;
    }

    private Object getYjLastSbbid(String orgid, String skssqq, String skssqz) {
        String taxLimit = TaxBaseDataUtils.getTaxLimit((String)"qysds", (Long)Long.valueOf(orgid));
        Date start = DateUtils.stringToDate((String)skssqq);
        Date end = DateUtils.stringToDate((String)skssqz);
        if (StringUtil.equals((CharSequence)taxLimit, (CharSequence)"ajsb")) {
            start = DateUtils.getFirstDateOfSeason((Date)end);
        } else if (StringUtil.equals((CharSequence)taxLimit, (CharSequence)"aysb")) {
            start = DateUtils.getFirstDateOfMonth((Date)end);
        }
        DynamicObject dynamicObject = YbnsrService.queryYbnsr((String)orgid, (String)"qysdsjb", (String)DateUtils.format((Date)start), (String)skssqz, null);
        return dynamicObject == null ? null : dynamicObject.get("id");
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, DraftSummaryEnum.SEJS.getBill());
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(SejsSetzSummaryPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{DkynssdeTZFormPlugin.class.getSimpleName(), DeductPreferentialSummaryPlugin.class.getSimpleName(), YhTaxCreditFormPlugin.class.getSimpleName(), HznsqySeftSummaryPlugin.class.getSimpleName()}));
            }
        };
    }
}

