/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.common.enums.NssbDraftTypeEnum;
import kd.taxc.tccit.common.enums.XwqyyhDgMsgEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.common.utils.LocalDateUtils;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.DkynssdeTZFormPlugin;

public class SmallEnterprisesTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String ROW1 = "1";
    public static final String ROW2 = "2";
    public static final String ROW3 = "3";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"1", "2", "3"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String QUARTER_1 = "quarter1";
    public static final String QUARTER_2 = "quarter2";
    public static final String QUARTER_3 = "quarter3";
    public static final String QUARTER_4 = "quarter4";
    public static final String YEAR_AVG = "yearavg";
    public static final String MATCH = "match";
    public static final Set<String> QUARTERS = Sets.newHashSet((Object[])new String[]{"quarter1", "quarter2", "quarter3", "quarter4"});
    private static final String TCCIT_QYSDS_JDTBXX = "tccit_qysds_jdtbxx";
    private static final String SBBID = "sbbid";
    private static final String EWBLXH = "ewblxh";
    private static final BigDecimal LEVEL_1 = new BigDecimal("300");
    private static final BigDecimal LEVEL_2 = new BigDecimal("5000");
    private static final BigDecimal LEVEL_3 = new BigDecimal("3000000");
    private static final String ENTRYENTITY = "entryentity";
    private static final String TCCIT_SMALL_LIST = "tccit_small_list";
    private static final String ITEMNUMBER_PREFIX = "xwqyyhdg_";
    private static Map<String, List<String>> filterMap = new HashMap<String, List<String>>();
    private Map<String, Object> dataMap;
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private static final String TCCIT_ADJUST_DETAIL = "tccit_adjust_detail";

    public SmallEnterprisesTZFormPlugin() {
        filterMap.put(QUARTER_1, Lists.newArrayList((Object[])new String[]{ROW1, ROW2}));
        filterMap.put(QUARTER_2, Lists.newArrayList((Object[])new String[]{ROW3, "4"}));
        filterMap.put(QUARTER_3, Lists.newArrayList((Object[])new String[]{"5", "6"}));
        filterMap.put(QUARTER_4, Lists.newArrayList((Object[])new String[]{"7", "8"}));
        this.dataMap = new HashMap<String, Object>();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData(true);
    }

    private void initData(boolean isnew) {
        Date skssqz;
        Date skssqq;
        QFilter dateFilter;
        String selectFields = "smalltype,smalldeductamount,entryentity.itemtype as itemtype,entryentity.people as people,entryentity.totalamount as totalamount,entryentity.taxyearamount as taxyearamount";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_small_summary", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter = new QFilter("skssqq", "=", (Object)(skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq"))))).and(new QFilter("skssqz", "=", (Object)(skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz"))))))});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        HashMap<String, BigDecimal> toMap = new HashMap<String, BigDecimal>();
        for (DynamicObject object : query) {
            toMap.put(this.getKey(ROW1, object.getString(ITEM_TYPE)), object.getBigDecimal("people"));
            toMap.put(this.getKey(ROW2, object.getString(ITEM_TYPE)), object.getBigDecimal("totalamount"));
            toMap.put(this.getKey(ROW3, object.getString(ITEM_TYPE)), object.getBigDecimal("taxyearamount"));
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        int rowIndex = 0;
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject1 = isnew ? entryEntity.addNew() : (DynamicObject)entryEntity.get(rowIndex);
            dynamicObject1.set(ITEM_NO, (Object)(rowIndex + 1));
            dynamicObject1.set(ITEM_TYPE, (Object)itemType);
            dynamicObject1.set(QUARTER_1, (Object)this.getFormatData(itemType, QUARTER_1, (BigDecimal)toMap.get(this.getKey(itemType, QUARTER_1))));
            dynamicObject1.set(QUARTER_2, (Object)this.getFormatData(itemType, QUARTER_2, (BigDecimal)toMap.get(this.getKey(itemType, QUARTER_2))));
            dynamicObject1.set(QUARTER_3, (Object)this.getFormatData(itemType, QUARTER_3, (BigDecimal)toMap.get(this.getKey(itemType, QUARTER_3))));
            dynamicObject1.set(QUARTER_4, (Object)this.getFormatData(itemType, QUARTER_4, (BigDecimal)toMap.get(this.getKey(itemType, QUARTER_4))));
            dynamicObject1.set(YEAR_AVG, (Object)this.getFormatData(itemType, YEAR_AVG, (BigDecimal)toMap.get(this.getKey(itemType, YEAR_AVG))));
            dynamicObject1.set(MATCH, (Object)this.getFormatData(itemType, MATCH, (BigDecimal)toMap.get(this.getKey(itemType, MATCH))));
            ++rowIndex;
        }
        this.getModel().setValue("smalltype", (Object)((DynamicObject)query.get(0)).getString("smalltype"));
        this.getModel().setValue("smalldeductamount", (Object)((DynamicObject)query.get(0)).getBigDecimal("smalldeductamount"));
        this.getView().updateView(ENTRYENTITY);
    }

    private String getFormatData(String rowType, String columnType, BigDecimal data) {
        if (data == null) {
            return "";
        }
        if (ROW1.equals(rowType)) {
            String text = data.setScale(0, 4).toString();
            return DataFormat.formatMicrometer(text);
        }
        if (ROW3.equals(rowType) && QUARTERS.contains(columnType)) {
            return "<nolink>*";
        }
        if (MATCH.equals(columnType)) {
            return String.valueOf(data.intValue());
        }
        String text = data.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(text);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        for (String itemType : itemTypes) {
            result.put(this.getKey(itemType, QUARTER_1), this.calcAmount(itemType, QUARTER_1, customParams));
            result.put(this.getKey(itemType, QUARTER_2), this.calcAmount(itemType, QUARTER_2, customParams));
            result.put(this.getKey(itemType, QUARTER_3), this.calcAmount(itemType, QUARTER_3, customParams));
            result.put(this.getKey(itemType, QUARTER_4), this.calcAmount(itemType, QUARTER_4, customParams));
            result.put(this.getKey(itemType, YEAR_AVG), this.calcAmount(itemType, YEAR_AVG, customParams));
            result.put(this.getKey(itemType, MATCH), this.calcAmount(itemType, MATCH, customParams));
        }
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        this.saveCurrentPeriod(customParams, result, orgid, skssqq, skssqz);
    }

    private void saveCurrentPeriod(Map<String, Object> customParams, Map<String, Object> result, Long orgid, Date skssqq, Date skssqz) {
        DynamicObjectCollection sum = new DynamicObjectCollection();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{QUARTER_1, QUARTER_2, QUARTER_3, QUARTER_4, YEAR_AVG, MATCH});
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_small_summary");
        Boolean smallType = this.getSmallType(customParams, this.dataMap);
        dynamicObject.set("orgid", (Object)orgid);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        dynamicObject.set("smalltype", (Object)String.valueOf(smallType));
        dynamicObject.set("smalldeductamount", (Object)this.getSmallDeductAmount(smallType, this.dataMap, orgid, skssqq));
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        for (String column : columns) {
            DynamicObject entity = entryEntity.addNew();
            entity.set("people", result.get(this.getKey(ROW1, column)));
            entity.set("totalamount", result.get(this.getKey(ROW2, column)));
            entity.set("taxyearamount", result.get(this.getKey(ROW3, column)));
            entity.set(ITEM_TYPE, (Object)column);
        }
        sum.add((Object)dynamicObject);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal getRate(String orgId, String code, Date year) {
        String lastDateOfYear;
        String firstDateOfYear = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)year));
        List deductionRateList = AssistService.queryAssistParams((String)code, (String)orgId, (String)firstDateOfYear, (String)(lastDateOfYear = DateUtils.format((Date)DateUtils.getLastDateOfYear((Date)year))));
        return CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.ZERO : new BigDecimal((String)deductionRateList.get(0));
    }

    private BigDecimal getSmallDeductAmount(Boolean smallType, Map<String, Object> dataMap, Long orgid, Date skssqq) {
        BigDecimal decimal = (BigDecimal)dataMap.get(this.getKey(ROW3, YEAR_AVG));
        BigDecimal calc = BigDecimal.ZERO;
        BigDecimal million = new BigDecimal("1000000");
        BigDecimal xxwRate = this.getRate(String.valueOf(orgid), "XXWQYYHSL", skssqq);
        BigDecimal xwRate = this.getRate(String.valueOf(orgid), "XWQYYHSL", skssqq);
        if (smallType.booleanValue() && decimal.compareTo(BigDecimal.ZERO) > 0 && decimal.compareTo(new BigDecimal("3000000")) <= 0) {
            calc = decimal.compareTo(million) <= 0 ? decimal.multiply(new BigDecimal("0.25").subtract(xxwRate)).setScale(2, 4) : decimal.multiply(new BigDecimal("0.25")).subtract(decimal.subtract(million).multiply(xwRate)).subtract(million.multiply(xxwRate)).setScale(2, 4);
        }
        return calc;
    }

    private Boolean getSmallType(Map<String, Object> customParams, Map<String, Object> dataMap) {
        Boolean row1Match = (Boolean)dataMap.get(this.getKey(ROW1, MATCH));
        Boolean row2Match = (Boolean)dataMap.get(this.getKey(ROW2, MATCH));
        Boolean row3Match = (Boolean)dataMap.get(this.getKey(ROW3, MATCH));
        return this.getIllegal(customParams) == false && row1Match != false && row2Match != false && row3Match != false;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter("entryentity.itemtype", "in", (Object)Lists.newArrayList((Object[])new String[]{QUARTER_1, QUARTER_2, QUARTER_3, QUARTER_4, YEAR_AVG, MATCH}));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_small_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        if (ROW1.equals(rowType)) {
            if (QUARTERS.contains(columnType)) {
                BigDecimal divide;
                String itemnumber = ITEMNUMBER_PREFIX + rowType;
                DynamicObjectCollection results = this.getSDTZOriginalAmount(customParams, itemnumber, ITEMNUMBER_PREFIX + columnType);
                if (results.size() > 0) {
                    divide = results.stream().map(a -> a.getBigDecimal("totalamount")).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                } else {
                    QFilter sbbIdFilter = new QFilter(SBBID, "=", (Object)this.getCurrentYearSbbId(customParams));
                    QFilter itemFilter = new QFilter(EWBLXH, "in", filterMap.get(columnType));
                    BigDecimal sum = this.querySum(TCCIT_QYSDS_JDTBXX, "sum(cyrs) as cyrs", new QFilter[]{sbbIdFilter, itemFilter}, "cyrs");
                    divide = this.divide(sum, 2, 0);
                }
                this.dataMap.put(this.getKey(rowType, columnType), divide);
                return divide;
            }
            if (YEAR_AVG.equals(columnType)) {
                BigDecimal sum = this.getSum(rowType, QUARTERS);
                BigDecimal divide = this.divide(sum, 4, 0);
                this.dataMap.put(this.getKey(rowType, columnType), divide);
                return divide;
            }
            if (MATCH.equals(columnType)) {
                BigDecimal decimal = (BigDecimal)this.dataMap.getOrDefault(this.getKey(rowType, YEAR_AVG), BigDecimal.ZERO);
                Boolean match = this.compareAmount(decimal, LEVEL_1);
                this.dataMap.put(this.getKey(rowType, columnType), match);
                return match;
            }
        }
        if (ROW2.equals(rowType)) {
            if (QUARTERS.contains(columnType)) {
                BigDecimal divide;
                String itemnumber = ITEMNUMBER_PREFIX + rowType;
                DynamicObjectCollection results = this.getSDTZOriginalAmount(customParams, itemnumber, ITEMNUMBER_PREFIX + columnType);
                if (results.size() > 0) {
                    divide = results.stream().map(a -> a.getBigDecimal("totalamount")).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                } else {
                    QFilter sbbIdFilter = new QFilter(SBBID, "=", (Object)this.getCurrentYearSbbId(customParams));
                    QFilter itemFilter = new QFilter(EWBLXH, "in", filterMap.get(columnType));
                    BigDecimal sum = this.querySum(TCCIT_QYSDS_JDTBXX, "sum(zcze) as zcze", new QFilter[]{sbbIdFilter, itemFilter}, "zcze");
                    divide = this.divide(sum, 2, 2);
                }
                this.dataMap.put(this.getKey(rowType, columnType), divide);
                return divide;
            }
            if (YEAR_AVG.equals(columnType)) {
                BigDecimal sum = this.getSum(rowType, QUARTERS);
                BigDecimal divide = this.divide(sum, 4, 2);
                this.dataMap.put(this.getKey(rowType, columnType), divide);
                return divide;
            }
            if (MATCH.equals(columnType)) {
                BigDecimal decimal = (BigDecimal)this.dataMap.getOrDefault(this.getKey(rowType, YEAR_AVG), BigDecimal.ZERO);
                Boolean match = this.compareAmount(decimal, LEVEL_2);
                this.dataMap.put(this.getKey(rowType, columnType), match);
                return match;
            }
        }
        if (ROW3.equals(rowType)) {
            if (YEAR_AVG.equals(columnType)) {
                BigDecimal ynssde = this.getYnssde(customParams);
                this.dataMap.put(this.getKey(rowType, columnType), ynssde);
                return ynssde;
            }
            if (MATCH.equals(columnType)) {
                BigDecimal decimal = (BigDecimal)this.dataMap.getOrDefault(this.getKey(rowType, YEAR_AVG), BigDecimal.ZERO);
                Boolean match = this.compareAmount(decimal, LEVEL_3);
                this.dataMap.put(this.getKey(rowType, columnType), match);
                return match;
            }
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getYnssde(Map<String, Object> customParams) {
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgid.toString()));
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"0");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_dg_a100000_7_sum", (String)"zzqcurrent", (QFilter[])new QFilter[]{orgFilter, dateFilter, itemtypeFilter}, (String)"id");
        return CollectionUtils.isEmpty((Collection)query) ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal("zzqcurrent");
    }

    private Boolean compareAmount(BigDecimal decimal, BigDecimal amount) {
        Function<BigDecimal, Boolean> bigDecimalBigDecimalFunction = a -> a.compareTo(amount) <= 0 ? Boolean.TRUE : Boolean.FALSE;
        return bigDecimalBigDecimalFunction.apply(decimal);
    }

    private BigDecimal divide(BigDecimal sum, int divisor, int newScale) {
        return sum.divide(new BigDecimal(divisor)).setScale(newScale, 4);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        BigDecimal originalamount;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int rowIndex = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        String itemtype = (String)this.getModel().getValue(ITEM_TYPE, rowIndex);
        String entrytype = ITEMNUMBER_PREFIX + evt.getFieldName();
        String itemnumber = ITEMNUMBER_PREFIX + itemtype;
        customParams.put("entrytype", entrytype);
        customParams.put("itemnumber", itemnumber);
        customParams.put("entryname", "");
        customParams.put("righttype", ROW2);
        customParams.put("qsy", ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u5e74\u4efd\u7684\u6700\u540e\u4e00\u671f\u9884\u7f34\u7533\u62a5\u8868", (String)"SmallEnterprisesTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        customParams.put("sjlx", ResManager.loadKDString((String)"\u56db\u820d\u4e94\u5165\u53d6\u6574\u6570", (String)"SmallEnterprisesTZFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        customParams.put("jslj", XwqyyhDgMsgEnum.getMsg("jslj", itemtype, fieldName));
        DynamicObjectCollection results = this.getSDTZOriginalAmount(customParams, itemnumber, entrytype);
        if (results.size() == 0) {
            Object value = this.getModel().getValue(fieldName, rowIndex);
            String s = value == null ? "0" : String.valueOf(value);
            originalamount = new BigDecimal(s.replace(",", ""));
        } else {
            originalamount = results.stream().map(a -> a.getBigDecimal("amount")).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
        }
        customParams.put("originalamount", originalamount.setScale(2));
        customParams.put("closecallback", "closecallback");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(TCCIT_DETAIL_TZ_DIALOG);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TCCIT_SMALL_LIST);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (TCCIT_SMALL_LIST.equals(closedCallBackEvent.getActionId())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.calc(customParams);
            this.initData(false);
            this.markEditCells(this.getEntryName(), NssbDraftTypeEnum.ADJUST_RECORD.getNumber());
        }
    }

    private DynamicObjectCollection getSDTZOriginalAmount(Map<String, Object> customParams, String itemnumber, String entrytype) {
        List<QFilter> qFilters = this.getTzQFilters(customParams, itemnumber, entrytype);
        return QueryServiceHelper.query((String)TCCIT_ADJUST_DETAIL, (String)"id,amount,totalamount", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
    }

    private List<QFilter> getTzQFilters(Map<String, Object> customParams, String itemnumber, String entrytype) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        qFilters.add(new QFilter("org", "=", (Object)Long.parseLong((String)orgid)));
        qFilters.add(new QFilter("skssqq", "=", (Object)skssqq));
        qFilters.add(new QFilter("skssqz", "=", (Object)skssqz));
        qFilters.add(new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_"))));
        qFilters.add(new QFilter("entrytype", "=", (Object)entrytype));
        return qFilters;
    }

    private String getCurrentYearSbbId(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        int yearOfDate = DateUtils.getYearOfDate((Date)skssqq);
        Date lastYearBegin = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 1));
        Date lastYearEnd = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 31));
        Date lastQuarterBegin = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 10, 1));
        Date lastQuarterEnd = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 31));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter monthFilter = new QFilter("skssqq", "=", (Object)lastYearBegin).and(new QFilter("skssqz", "=", (Object)lastYearEnd));
        QFilter quarterFilter = new QFilter("skssqq", "=", (Object)lastQuarterBegin).and(new QFilter("skssqz", "=", (Object)lastQuarterEnd));
        QFilter typeFilter = new QFilter("type", "=", (Object)"qysdsjb");
        QFilter declareStatusFilter = new QFilter("declarestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"editing", "declared"}));
        DynamicObjectCollection temp = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)" * ", (QFilter[])new QFilter[]{orgFilter, monthFilter.or(quarterFilter), typeFilter, declareStatusFilter});
        if (CollectionUtils.isEmpty((Collection)temp)) {
            return "";
        }
        temp.stream().sorted(Comparator.comparing(s -> s.getDate("modifytime")).reversed());
        return ((DynamicObject)temp.get(0)).getString("id");
    }

    private BigDecimal querySum(String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = query == null || query.size() == 0 ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal(alias);
        return result;
    }

    private BigDecimal getSum(String rowType, Set<String> columns) {
        return columns.stream().map(s -> (BigDecimal)this.dataMap.get(this.getKey(rowType, (String)s))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Boolean getIllegal(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        DynamicObjectCollection policyConfirm = QueryServiceHelper.query((String)"tccit_policy_confirm", (String)"illegal", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        if (CollectionUtils.isEmpty((Collection)policyConfirm)) {
            return Boolean.FALSE;
        }
        return ((DynamicObject)policyConfirm.get(0)).getBoolean("illegal");
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{QUARTER_1, QUARTER_2, QUARTER_3, QUARTER_4});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        String entrytype = ITEMNUMBER_PREFIX + column;
        String itemnumber = ITEMNUMBER_PREFIX + itemtype;
        customParams.put("entrytype", entrytype);
        customParams.put("columnType", column);
        customParams.put("itemnumber", itemnumber);
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(SmallEnterprisesTZFormPlugin.class.getSimpleName(), Collections.singletonList(DkynssdeTZFormPlugin.class.getSimpleName()));
            }
        };
    }
}

