/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.DkynssdeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SonGetReduceFormPlugin;
import org.apache.commons.collections.CollectionUtils;

public class SoftIcTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ITEM_NAME = "itemname";
    private static final String JESL = "jesl";
    private static final String JMFS = "jmfs";
    private static final String JMFSNUM = "jmfsnumber";
    private static final String JMFSNAME = "jmfsname";
    private static final String HLND = "hlnd";
    public static final String ORGID = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    private static final String SOFTTYPE = "softtype";
    private static final String PROJECTNAME = "projectname";
    private static final String SYYHZC = "syyhzc";
    private static final String HAVE_FIRST_LINE = "havefirstline";
    private static final String FIRST_LINE_NUMBER = "firstlinenumber";
    private static final String TCCIT_GETREDUCE_ACC = "tccit_getreduce_acc";
    private static final String SOFTWARE_PROFIT_MAP = "tpo_software_profit_map";
    private static final String GETREDU_SUM = "tccit_getredu_sum";
    private static final String JBXX_ENTITY = "jbxxentity";
    private static final String YGQK_ENTITY = "ygqkentity";
    private static final String SOFT_IC_SUM = "tccit_soft_ic_summary";
    private static final String SOFT_IC_JB_SUM = "tccit_soft_ic_jb_summary";
    private static final String SOFT_IC_YG_SUM = "tccit_soft_ic_yg_summary";
    private static final Map<String, Integer[]> profitYearDiffMap = new HashMap<String, Integer[]>();
    private static final List<String> itemType = Arrays.asList("ryzb", "bnypjzgzrs", "jydxzkysxlzgrs", "yjkfryrs", "yffyzb", "yffyze", "jnyffyje", "srzb", "qysrze", "fhtjdxssr", "qtzb", "qtzb1", "qtzb2", "qtzb3", "ynsde", "jmbl", "jmse");
    private static final Set<String> titles = Sets.newHashSet((Object[])new String[]{"ryzb", "yffyzb", "srzb", "qtzb"});
    private static final Set<String> qtzbItem = Sets.newHashSet((Object[])new String[]{"qtzb1", "qtzb2", "qtzb3"});
    private static final Set<String> item208 = Sets.newHashSet((Object[])new String[]{"ynsde", "jmbl", "jmse"});
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    public void initialize() {
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (SYYHZC.equals(name)) {
            ChangeData[] changeSet = args.getChangeSet();
            String newValue = (String)changeSet[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newValue)) {
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long orgid = Long.parseLong((String)customParams.get(ORGID));
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
            QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
            QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)SOFT_IC_SUM, (String)"id,orgid,skssqq,skssqz,syyhzc", (QFilter[])new QFilter[]{orgFilter, dateFilter});
            if (dyo == null) {
                dyo = BusinessDataServiceHelper.newDynamicObject((String)SOFT_IC_SUM);
            }
            dyo.set(ORGID, (Object)orgid);
            dyo.set(SKSSQQ, (Object)skssqq);
            dyo.set(SKSSQZ, (Object)skssqz);
            dyo.set(SYYHZC, (Object)newValue);
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)dyo.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                this.getView().showOperationResult(result);
            }
        }
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        this.initSyyhzc(new QFilter[]{orgFilter, dateFilter});
        this.initJbxx(new QFilter[]{orgFilter, dateFilter});
        this.initYgqk(new QFilter[]{orgFilter, dateFilter}, customParams);
    }

    private void initJbxx(QFilter[] filters) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)SOFT_IC_JB_SUM, (String)"id,itemno,orgid,skssqq,skssqz,jmfs,hlnd,jmfsnumber,jmfsname,jmfs_id", (QFilter[])filters, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(JBXX_ENTITY);
        model.batchCreateNewEntryRow(JBXX_ENTITY, query.size());
        int count = model.getEntryRowCount(JBXX_ENTITY);
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            DynamicObject dyo = (DynamicObject)query.get(rowIndex);
            model.setValue(ITEM_NO, dyo.get(ITEM_NO), rowIndex);
            String jmfs = dyo.getString(JMFSNUM) + " " + dyo.getString(JMFSNAME);
            model.setValue(JMFS, (Object)jmfs, rowIndex);
            model.setValue(HLND, (Object)DateUtils.format((Date)dyo.getDate(HLND), (String)"yyyy"), rowIndex);
        }
        model.endInit();
        this.getView().updateView(JBXX_ENTITY);
    }

    private void initYgqk(QFilter[] filters, Map<String, Object> customParams) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)SOFT_IC_YG_SUM, (String)"id,orgid,skssqq,skssqz,itemno,itemtype,jesl,itemname", (QFilter[])filters, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(YGQK_ENTITY);
        model.batchCreateNewEntryRow(YGQK_ENTITY, query.size());
        int count = model.getEntryRowCount(YGQK_ENTITY);
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            DynamicObject dyo = (DynamicObject)query.get(rowIndex);
            model.setValue("itemno1", dyo.get(ITEM_NO), rowIndex);
            String itemType = dyo.getString(ITEM_TYPE);
            if (qtzbItem.contains(itemType)) {
                model.setValue(ITEM_TYPE, (Object)dyo.getString(ITEM_NAME), rowIndex);
            } else {
                model.setValue(ITEM_TYPE, (Object)itemType, rowIndex);
            }
            String haveFirstLine = (String)customParams.get(HAVE_FIRST_LINE);
            if (item208.contains(itemType) && (haveFirstLine == null || !"true".equals(haveFirstLine))) {
                model.setValue(JESL, null, rowIndex);
                continue;
            }
            if (titles.contains(itemType)) {
                model.setValue(JESL, null, rowIndex);
                continue;
            }
            model.setValue(JESL, (Object)this.formatData(dyo.getBigDecimal(JESL)), rowIndex);
        }
        model.endInit();
        this.getView().updateView(YGQK_ENTITY);
    }

    private void initSyyhzc(QFilter[] filters) {
        DynamicObject query = QueryServiceHelper.queryOne((String)SOFT_IC_SUM, (String)"id,orgid,skssqq,skssqz,syyhzc", (QFilter[])filters);
        if (query == null) {
            return;
        }
        String syyhzc = query.getString(SYYHZC);
        this.getModel().setValue(SYYHZC, (Object)syyhzc);
    }

    private String formatData(BigDecimal data) {
        String text = data.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(text);
    }

    protected void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        DynamicObject dyo = this.calcSyyhzc(customParams);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
        this.calcJbxx(customParams);
        this.calcYgqk(customParams);
    }

    private DynamicObject calcSyyhzc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)SOFT_IC_SUM, (String)"id,orgid,skssqq,skssqz,syyhzc", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        if (dyo == null) {
            dyo = BusinessDataServiceHelper.newDynamicObject((String)SOFT_IC_SUM);
        }
        dyo.set(ORGID, (Object)orgid);
        dyo.set(SKSSQQ, (Object)skssqq);
        dyo.set(SKSSQZ, (Object)skssqz);
        String syyhzc = (String)customParams.get(SYYHZC);
        if (StringUtil.isNotBlank((CharSequence)syyhzc)) {
            dyo.set(SYYHZC, (Object)syyhzc);
        }
        return dyo;
    }

    private void calcJbxx(Map<String, Object> customParams) {
        DynamicObject[] reduceCollect;
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter startDateFilter = new QFilter("startdate", "=", (Object)skssqq);
        QFilter endDateFilter = new QFilter("enddate", "=", (Object)skssqz);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        DynamicObject policy = QueryServiceHelper.queryOne((String)"tccit_policy_confirm", (String)SOFTTYPE, (QFilter[])new QFilter[]{orgFilter, startDateFilter, endDateFilter});
        int itemNo = 1;
        if (policy != null && StringUtil.isNotBlank((CharSequence)policy.getString(SOFTTYPE))) {
            DynamicObject suitOne;
            DynamicObjectCollection apitudeEntryEntity = ApitudeService.getApitudeEntryEntity(orgid);
            DynamicObjectCollection softEntity = new DynamicObjectCollection();
            apitudeEntryEntity.stream().filter(s -> "1".equals(s.getString("apitudetype"))).forEach(arg_0 -> ((DynamicObjectCollection)softEntity).add(arg_0));
            if (!CollectionUtils.isEmpty((Collection)softEntity) && (suitOne = this.findSuitOne(softEntity, skssqq)) != null) {
                DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)SOFT_IC_JB_SUM);
                dyo.set(ITEM_NO, (Object)itemNo);
                String profitmyear = suitOne.getString("profitmyear");
                dyo.set(HLND, (Object)DateUtils.stringToDate((String)profitmyear, (String)"yyyy"));
                DynamicObject companytype = suitOne.getDynamicObject("companytype");
                String profittype = suitOne.getString("profittype");
                long companytypeId = companytype.getLong("id");
                QFilter startdateFilter = new QFilter("startdate", "<=", (Object)skssqq);
                QFilter enddateFilter = new QFilter("enddate", "is null", null).or("enddate", ">=", (Object)skssqz);
                QFilter companynumberFilter = new QFilter("treeentryentity.companynumber", "=", (Object)companytypeId);
                QFilter profittypeFilter = new QFilter("treeentryentity.profittypenumber.projectname", "=", (Object)profittype);
                DynamicObject reliefcode = BusinessDataServiceHelper.loadSingle((String)SOFTWARE_PROFIT_MAP, (String)"treeentryentity.codes", (QFilter[])new QFilter[]{startdateFilter, enddateFilter, companynumberFilter, profittypeFilter});
                if (reliefcode != null) {
                    DynamicObjectCollection reliefCodeCollection = ((DynamicObject)reliefcode.getDynamicObjectCollection("treeentryentity").get(0)).getDynamicObjectCollection("codes");
                    DynamicObject jmfsDyo = this.getJmfsDynamicObject(reliefCodeCollection, profitmyear, skssqq);
                    if (jmfsDyo != null) {
                        customParams.put(HAVE_FIRST_LINE, "true");
                        customParams.put(FIRST_LINE_NUMBER, jmfsDyo.getString("number"));
                        dyo.set(JMFS, (Object)jmfsDyo);
                        dyo.set(JMFSNUM, (Object)jmfsDyo.getString("number"));
                        dyo.set(JMFSNAME, (Object)jmfsDyo.getString(PROJECTNAME));
                    }
                    dyo.set(ORGID, (Object)orgid);
                    dyo.set(SKSSQQ, (Object)skssqq);
                    dyo.set(SKSSQZ, (Object)skssqz);
                    sum.add((Object)dyo);
                    ++itemNo;
                }
            }
        }
        QFilter skssqqFilter = new QFilter(SKSSQQ, ">=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter(SKSSQZ, "<=", (Object)DateUtils.getDayLast((Date)skssqz));
        QFilter jmxmlxFilter = new QFilter("reducename", "in", Arrays.asList(1119507313238005760L, 1119510373058271232L, 1119510373058271233L, 1119522899774986240L));
        for (DynamicObject reduce : reduceCollect = BusinessDataServiceHelper.load((String)GETREDU_SUM, (String)"reducename,billno,dnyhbl", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, jmxmlxFilter}, (String)"xmsde")) {
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)SOFT_IC_JB_SUM);
            dyo.set(ITEM_NO, (Object)itemNo++);
            long reducetype = reduce.getLong("reducename");
            String dnyhbl = reduce.getString("dnyhbl");
            String yhbl = this.getYhbl(dnyhbl);
            if (1119507313238005760L == reducetype) {
                if ("100%".equals(yhbl)) {
                    dyo.set(JMFSNUM, (Object)"510");
                    dyo.set(JMFSNAME, (Object)ResManager.loadKDString((String)"\u9879\u76ee\u6240\u5f97\u51cf\u514d\u4e8c\u514d\u4e09\u51cf\u534a\uff08\u514d\u7a0e\uff09", (String)"SoftIcTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                } else if ("50%".equals(yhbl)) {
                    dyo.set(JMFSNUM, (Object)"520");
                    dyo.set(JMFSNAME, (Object)ResManager.loadKDString((String)"\u9879\u76ee\u6240\u5f97\u51cf\u514d\u4e8c\u514d\u4e09\u51cf\u534a\uff08\u51cf\u534a\u5f81\u6536\uff09", (String)"SoftIcTZFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                }
            } else if (1119510373058271232L == reducetype || 1119510373058271233L == reducetype) {
                if ("100%".equals(yhbl)) {
                    dyo.set(JMFSNUM, (Object)"610");
                    dyo.set(JMFSNAME, (Object)ResManager.loadKDString((String)"\u9879\u76ee\u6240\u5f97\u51cf\u514d\u4e94\u514d\u4e94\u51cf\u534a\uff08\u514d\u7a0e\uff09", (String)"SoftIcTZFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
                } else if ("50%".equals(yhbl)) {
                    dyo.set(JMFSNUM, (Object)"620");
                    dyo.set(JMFSNAME, (Object)ResManager.loadKDString((String)"\u9879\u76ee\u6240\u5f97\u51cf\u514d\u4e94\u514d\u4e94\u51cf\u534a\uff08\u51cf\u534a\u5f81\u6536\uff09", (String)"SoftIcTZFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                }
            } else if (1119522899774986240L == reducetype && "100%".equals(yhbl)) {
                dyo.set(JMFSNUM, (Object)"700");
                dyo.set(JMFSNAME, (Object)ResManager.loadKDString((String)"\u9879\u76ee\u6240\u5f97\u5341\u514d\uff08\u514d\u7a0e\uff09", (String)"SoftIcTZFormPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
            }
            String billno = reduce.getString("billno");
            DynamicObject acc = BusinessDataServiceHelper.loadSingle((String)TCCIT_GETREDUCE_ACC, (String)"firstyear", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            Date firstyear = acc.getDate("firstyear");
            dyo.set(HLND, (Object)firstyear);
            dyo.set(ORGID, (Object)orgid);
            dyo.set(SKSSQQ, (Object)skssqq);
            dyo.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dyo);
        }
        if (CollectionUtils.isNotEmpty((Collection)sum)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        }
    }

    private void calcYgqk(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqq);
        Date lastDateOfYear = DateUtils.getLastDateOfYear1((Date)skssqq);
        QFilter yearFilter = new QFilter("year", ">=", (Object)firstDateOfYear).and(new QFilter("year", "<=", (Object)lastDateOfYear));
        DynamicObjectCollection sum = new DynamicObjectCollection();
        DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_soft_ic_qyyh", (String)"id", (QFilter[])new QFilter[]{orgFilter, yearFilter});
        int itemNo = 1;
        if (object != null) {
            DynamicObject tzxx = BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"tccit_soft_ic_qyyh");
            DynamicObjectCollection qtzbCard = tzxx.getDynamicObjectCollection("entryentity");
            for (String item : itemType) {
                DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)SOFT_IC_YG_SUM);
                dyo.set(ITEM_NO, (Object)itemNo);
                if (qtzbItem.contains(item)) {
                    this.calcQtzb(item, qtzbCard, dyo);
                } else if (item208.contains(item)) {
                    dyo.set(ITEM_TYPE, (Object)item);
                    this.calcItem208(orgid, item, dyo, skssqq, skssqz, customParams);
                } else {
                    dyo.set(ITEM_TYPE, (Object)item);
                    this.setJesl(item, tzxx, dyo);
                }
                dyo.set(ORGID, (Object)orgid);
                dyo.set(SKSSQQ, (Object)skssqq);
                dyo.set(SKSSQZ, (Object)skssqz);
                sum.add((Object)dyo);
                ++itemNo;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)sum)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        }
    }

    private String getYhbl(String dnyhbl) {
        if (StringUtils.isBlank((CharSequence)dnyhbl)) {
            return "";
        }
        String yhbl = "";
        if ("0.5".equals(dnyhbl)) {
            yhbl = "50%";
        } else if ("1".equals(dnyhbl)) {
            yhbl = "100%";
        }
        return yhbl;
    }

    private DynamicObject getJmfsDynamicObject(DynamicObjectCollection collection, String profitmyear, Date skssqq) {
        int profitYear = Integer.parseInt(profitmyear);
        Calendar cal = Calendar.getInstance();
        cal.setTime(skssqq);
        int skYear = cal.get(1);
        int yearDiff = skYear - profitYear;
        return collection.stream().map(dyo -> dyo.getDynamicObject(1)).filter(dyo -> {
            String number = dyo.getString("number");
            Integer[] diff = profitYearDiffMap.get(number);
            if (diff != null && diff.length == 2) {
                return yearDiff >= diff[0] && yearDiff <= diff[1];
            }
            return false;
        }).findFirst().orElse(null);
    }

    private void setJesl(String item, DynamicObject tzxx, DynamicObject dyo) {
        if (!titles.contains(item)) {
            dyo.set(JESL, tzxx.get(item));
        }
    }

    private void calcItem208(Long orgid, String item, DynamicObject dyo, Date skssqq, Date skssqz, Map<String, Object> customParams) {
        String haveFirstLine = (String)customParams.get(HAVE_FIRST_LINE);
        if (haveFirstLine != null && "true".equals(haveFirstLine)) {
            if ("ynsde".equals(item)) {
                QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", DkynssdeTZFormPlugin.itemTypes);
                QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
                QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
                DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_dg_a100000_7_sum", (String)"zzqcurrent", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)"id");
                BigDecimal ynsde = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty((Collection)query)) {
                    ynsde = ((DynamicObject)query.get(0)).getBigDecimal("zzqcurrent");
                }
                dyo.set(JESL, (Object)ynsde);
                this.dataMap.put(this.getKey(item), ynsde);
            } else if ("jmbl".equals(item)) {
                String flnum = (String)customParams.get(FIRST_LINE_NUMBER);
                QFilter numberFilter = new QFilter("number", "=", (Object)flnum);
                QFilter dateFilter = new QFilter("entryentity.startdate", "<=", (Object)skssqq).and(new QFilter("entryentity.enddate", "is null", null).or("entryentity.enddate", ">=", (Object)skssqz));
                DynamicObject assist = BusinessDataServiceHelper.loadSingle((String)"tpo_tcvat_assist", (String)"entryentity.fvalue1", (QFilter[])new QFilter[]{numberFilter, dateFilter});
                BigDecimal jmbl = BigDecimal.ZERO;
                if (assist != null && assist.getDynamicObjectCollection("entryentity").size() > 0) {
                    jmbl = ((DynamicObject)assist.getDynamicObjectCollection("entryentity").get(0)).getBigDecimal("fvalue1");
                }
                dyo.set(JESL, (Object)jmbl);
                this.dataMap.put(this.getKey(item), jmbl);
            } else if ("jmse".equals(item)) {
                BigDecimal ynsde = this.dataMap.getOrDefault(this.getKey("ynsde"), BigDecimal.ZERO);
                BigDecimal jmbl = this.dataMap.getOrDefault(this.getKey("jmbl"), BigDecimal.ZERO);
                dyo.set(JESL, (Object)ynsde.multiply(jmbl));
            }
        }
    }

    private String getKey(String rowType) {
        return rowType + "&" + JESL;
    }

    private void calcQtzb(String item, DynamicObjectCollection qtzbCard, DynamicObject dyo) {
        DynamicObject card = null;
        if (qtzbCard.size() == 3) {
            switch (item) {
                case "qtzb1": {
                    card = (DynamicObject)qtzbCard.get(0);
                    break;
                }
                case "qtzb2": {
                    card = (DynamicObject)qtzbCard.get(1);
                    break;
                }
                case "qtzb3": {
                    card = (DynamicObject)qtzbCard.get(2);
                }
            }
        }
        if (card != null && StringUtils.isNotBlank((CharSequence)card.getString("zbname"))) {
            dyo.set(ITEM_TYPE, (Object)item);
            dyo.set(ITEM_NAME, card.get("zbname"));
            dyo.set(JESL, card.get("zbz"));
        }
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)SOFT_IC_JB_SUM, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        DeleteServiceHelper.delete((String)SOFT_IC_YG_SUM, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private DynamicObject findSuitOne(DynamicObjectCollection entryEntity, Date startdate) {
        Date declareLastMonth = DateUtils.getLastDateOfYear((Date)startdate);
        Date fdom = DateUtils.getFirstDateOfMonth((Date)declareLastMonth);
        Optional<DynamicObject> anyOne = entryEntity.stream().filter(s -> {
            Date apitudestartdate = s.getDate("apitudestartdate");
            Date apitudeenddate = s.getDate("apitudeenddate");
            return apitudestartdate.before(DateUtils.getLastDateOfYear((Date)declareLastMonth)) && (apitudeenddate == null || DateUtils.isEffectiveDate((Date)apitudeenddate, (Date)fdom, (Date)declareLastMonth));
        }).findAny();
        return anyOne.orElse(null);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void deleteData(EngineModel model) {
        this.clearCurrentPeriod(Long.parseLong(model.getOrgId()), DateUtils.stringToDate2((String)model.getStartDate()), DateUtils.stringToDate2((String)model.getEndDate()));
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        customParams.put(SYYHZC, "1");
        this.calc(customParams);
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(SoftIcTZFormPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{SonGetReduceFormPlugin.class.getSimpleName(), DkynssdeTZFormPlugin.class.getSimpleName()}));
            }
        };
    }

    static {
        profitYearDiffMap.put("110", new Integer[]{0, 1});
        profitYearDiffMap.put("120", new Integer[]{2, 4});
        profitYearDiffMap.put("210", new Integer[]{0, 4});
        profitYearDiffMap.put("220", new Integer[]{5, 9});
        profitYearDiffMap.put("800", new Integer[]{0, 4});
        profitYearDiffMap.put("300", new Integer[]{5, Integer.MAX_VALUE});
        profitYearDiffMap.put("900", new Integer[]{0, 9});
    }
}

