/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import org.apache.commons.collections.CollectionUtils;

public class SonGetReduceFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String ITEM_NO = "itemno";
    public static final String ORGID = "orgid";
    public static final String PARENT_ORGID = "parentorgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String TCCIT_GETREDUCE_ACC = "tccit_getreduce_acc";
    public static final String ENTRYENTITY = "entryentity";
    public static final LinkedHashSet<String> needDeal = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"reducetype", "reducename", "reduceway", "dnyhbl"}));
    public static final Set<Long> techId = Sets.newHashSet((Object[])new Long[]{1064511039091315712L, 1119482547752284160L});
    private String sheetname;

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.sheetname = (String)customParams.get("sheetname");
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams, true);
        }
        this.initData();
    }

    public SonGetReduceFormPlugin() {
    }

    public SonGetReduceFormPlugin(String sheetname) {
        this.sheetname = sheetname;
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        String projectname = d.getString("projectname");
        String key = columnDesc.getKey();
        if (ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SonGetReduceFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]).equals(projectname) && needDeal.contains(key)) {
            e.setFormatValue((Object)"\u2014\u2014");
        }
    }

    private void initData() {
        QFilter sheetFilter;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String sheetname = (String)customParams.get("sheetname");
        QFilter orgFilter = new QFilter(PARENT_ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_getredu_sum", (String)"*", (QFilter[])new QFilter[]{orgFilter, dateFilter, sheetFilter = "B105050".equals(sheetname) ? new QFilter("reducename", "in", techId) : new QFilter("reducename", "not in", techId)}, (String)"reducename,xmsde desc");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY);
        model.batchCreateNewEntryRow(ENTRYENTITY, query.size() + 1);
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            model.setValue("sheetname", (Object)dynamicObject.getString("sheetname"), rowIndex);
            model.setValue(ITEM_NO, (Object)(rowIndex + 1), rowIndex);
            model.setValue("projectname", (Object)dynamicObject.getString("projectname"), rowIndex);
            model.setValue("reducename", dynamicObject.get("reducename"), rowIndex);
            model.setValue("income", (Object)this.formatData(dynamicObject.getBigDecimal("income")), rowIndex);
            model.setValue("cost", (Object)this.formatData(dynamicObject.getBigDecimal("cost")), rowIndex);
            model.setValue("relaxtax", (Object)this.formatData(dynamicObject.getBigDecimal("relaxtax")), rowIndex);
            model.setValue("qjfyfte", (Object)this.formatData(dynamicObject.getBigDecimal("qjfyfte")), rowIndex);
            model.setValue("nstz", (Object)this.formatData(dynamicObject.getBigDecimal("nstz")), rowIndex);
            model.setValue("xmsde", (Object)this.formatData(dynamicObject.getBigDecimal("xmsde")), rowIndex);
            if ("B105050".equals(sheetname)) {
                model.setValue("qzmssd", (Object)"\u2014\u2014", rowIndex);
                model.setValue("qzjbsd", (Object)"\u2014\u2014", rowIndex);
                model.setValue("jmsde", (Object)"\u2014\u2014", rowIndex);
            } else {
                model.setValue("dnyhbl", (Object)dynamicObject.getString("dnyhbl"), rowIndex);
                model.setValue("jmsde", (Object)this.formatData(dynamicObject.getBigDecimal("jmsde")), rowIndex);
            }
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
        this.appendCountRow(query, model, rowIndex, sheetname);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex, String sheetname) {
        model.setValue("sheetname", (Object)sheetname, rowIndex);
        model.setValue(ITEM_NO, (Object)(rowIndex + 1), rowIndex);
        model.setValue("projectname", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SonGetReduceFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue("income", (Object)this.formatData(this.getSum((List<DynamicObject>)query, "income")), rowIndex);
        model.setValue("cost", (Object)this.formatData(this.getSum((List<DynamicObject>)query, "cost")), rowIndex);
        model.setValue("relaxtax", (Object)this.formatData(this.getSum((List<DynamicObject>)query, "relaxtax")), rowIndex);
        model.setValue("qjfyfte", (Object)this.formatData(this.getSum((List<DynamicObject>)query, "qjfyfte")), rowIndex);
        model.setValue("nstz", (Object)this.formatData(this.getSum((List<DynamicObject>)query, "nstz")), rowIndex);
        BigDecimal xmsde = this.getSum((List<DynamicObject>)query, "xmsde");
        model.setValue("xmsde", (Object)this.formatData(xmsde), rowIndex);
        if ("B105050".equals(sheetname)) {
            String yhfs = ((DynamicObject)query.get(0)).getString("yhfs");
            BigDecimal fiveOrTwenty = ResManager.loadKDString((String)"500\u4e07\u4ee5\u5185100%,\u8d85500\u4e07\u90e8\u520650%", (String)"SonGetReduceFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]).equals(yhfs) ? BigDecimal.valueOf(5000000L) : BigDecimal.valueOf(20000000L);
            String qzmssd = "0.00";
            String qzjbsd = "0.00";
            String jmsde = "0.00";
            if (BigDecimal.ZERO.compareTo(xmsde) < 0) {
                BigDecimal subtract = xmsde.subtract(fiveOrTwenty);
                if (subtract.compareTo(BigDecimal.ZERO) <= 0) {
                    qzmssd = this.formatData(xmsde);
                    jmsde = this.formatData(xmsde);
                } else {
                    qzmssd = this.formatData(fiveOrTwenty);
                    qzjbsd = this.formatData(subtract);
                    jmsde = this.formatData(subtract.multiply(BigDecimal.valueOf(0.5)).add(fiveOrTwenty));
                }
            }
            model.setValue("qzmssd", (Object)qzmssd, rowIndex);
            model.setValue("qzjbsd", (Object)qzjbsd, rowIndex);
            model.setValue("jmsde", (Object)jmsde, rowIndex);
        } else {
            model.setValue("jmsde", (Object)this.formatData(this.getSum((List<DynamicObject>)query, "jmsde")), rowIndex);
        }
    }

    private BigDecimal getSum(List<DynamicObject> value, String name) {
        return value.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String formatData(BigDecimal data) {
        String text = data.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(text);
    }

    protected DynamicObjectCollection calc(Map<String, Object> customParams, boolean needCalc) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.clearCurrentPeriod(orgid, skssqq, this.sheetname);
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        if (policy != null && !policy.getBoolean("yhsx1") && !policy.getBoolean("yhsx2")) {
            return null;
        }
        QFilter orgFilter = new QFilter("org", "in", OrgGroupService.getOrgIds(orgid, skssqq, skssqz));
        QFilter dateFilter = new QFilter("entryentity.year", "=", (Object)DateUtils.getFirstDateOfYear((Date)skssqq));
        QFilter yhblFilter = new QFilter("entryentity.dnyhbl", "!=", (Object)"\u2014\u2014");
        QFilter reduceFilter = "B105050".equals(this.sheetname) ? new QFilter("entryentity.nreducename", "in", techId) : new QFilter("entryentity.nreducename", "not in", techId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_GETREDUCE_ACC, (String)"org,projectname,billno,entryentity.*,entryentity.nreducename", (QFilter[])new QFilter[]{orgFilter, dateFilter, reduceFilter, yhblFilter});
        Map<String, List<DynamicObject>> biilno = query.stream().collect(Collectors.groupingBy(i -> i.getString("billno")));
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (Map.Entry<String, List<DynamicObject>> stringListEntry : biilno.entrySet()) {
            List<DynamicObject> value = stringListEntry.getValue();
            Map<Date, List<DynamicObject>> collect = value.stream().collect(Collectors.groupingBy(i -> i.getDate("entryentity.year")));
            for (Map.Entry<Date, List<DynamicObject>> dateListEntry : collect.entrySet()) {
                List<DynamicObject> value1 = dateListEntry.getValue();
                DynamicObject newdyo = BusinessDataServiceHelper.newDynamicObject((String)"tccit_getredu_sum");
                String billnoStr = stringListEntry.getKey();
                newdyo.set("billno", (Object)billnoStr);
                this.setProperty(orgid, value1, newdyo, this.sheetname, skssqq, skssqz);
                sum.add((Object)newdyo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)sum)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        }
        return sum;
    }

    private void setProperty(Long parentOrgId, List<DynamicObject> value1, DynamicObject newdyo, String sheetname, Date skssqq, Date skssqz) {
        DynamicObject dynamicObject = value1.get(0);
        Object reducename = dynamicObject.get("entryentity.nreducename");
        newdyo.set(ORGID, dynamicObject.get("org"));
        newdyo.set(PARENT_ORGID, (Object)parentOrgId);
        newdyo.set("year", dynamicObject.get("entryentity.year"));
        newdyo.set("projectname", dynamicObject.get("projectname"));
        newdyo.set("reducename", reducename);
        newdyo.set("income", (Object)this.getSum(value1, "entryentity.income"));
        newdyo.set("cost", (Object)this.getSum(value1, "entryentity.cost"));
        newdyo.set("relaxtax", (Object)this.getSum(value1, "entryentity.relaxtax"));
        newdyo.set("qjfyfte", (Object)this.getSum(value1, "entryentity.qjfyfte"));
        newdyo.set("nstz", (Object)this.getSum(value1, "entryentity.nstz"));
        BigDecimal sumxmsde = this.getSum(value1, "entryentity.xmsde");
        newdyo.set("xmsde", (Object)sumxmsde);
        newdyo.set(SKSSQQ, (Object)skssqq);
        newdyo.set(SKSSQZ, (Object)skssqz);
        if (reducename == null || "0".equals(reducename.toString())) {
            return;
        }
        DynamicObject tpoDiscountTree = BusinessDataServiceHelper.loadSingle((Object)reducename, (String)"tpo_discount_tree");
        newdyo.set("yhsxmc", (Object)tpoDiscountTree.getString("name"));
        String objectString = dynamicObject.getString("entryentity.dnyhbl");
        if ("0.5".equals(objectString)) {
            newdyo.set("yhfs", (Object)ResManager.loadKDString((String)"\u51cf\u534a\u5f81\u6536", (String)"SonGetReduceFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
        } else if ("1".equals(objectString)) {
            newdyo.set("yhfs", (Object)ResManager.loadKDString((String)"\u514d\u7a0e", (String)"SonGetReduceFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
        } else if ("0.5or1".equals(objectString)) {
            newdyo.set("yhfs", (Object)ResManager.loadKDString((String)"500\u4e07\u4ee5\u5185100%,\u8d85500\u4e07\u90e8\u520650%", (String)"SonGetReduceFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        } else {
            newdyo.set("yhfs", (Object)ResManager.loadKDString((String)"2000\u4e07\u4ee5\u5185100%\uff0c\u8d852000\u4e07\u90e8\u520650%", (String)"SonGetReduceFormPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        newdyo.set("sheetname", (Object)sheetname);
        if (!techId.contains(reducename)) {
            String dnyhbl = dynamicObject.getString("entryentity.dnyhbl");
            newdyo.set("dnyhbl", (Object)dnyhbl);
            BigDecimal xmsde = sumxmsde.multiply(new BigDecimal(dynamicObject.getString("entryentity.dnyhbl")));
            newdyo.set("jmsde", (Object)(xmsde.compareTo(BigDecimal.ZERO) > 0 ? xmsde.setScale(2, 4) : BigDecimal.ZERO));
        }
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, String sheetname) {
        QFilter orgFilter = new QFilter(PARENT_ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter("year", "=", (Object)skssqq);
        QFilter sheetFilter = new QFilter("sheetname", "=", (Object)sheetname);
        DeleteServiceHelper.delete((String)"tccit_getredu_sum", (QFilter[])new QFilter[]{orgFilter, dateFilter, sheetFilter});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        String startDate = model.getStartDate();
        this.clearCurrentPeriod(Long.parseLong(orgId), DateUtils.stringToDate2((String)startDate), this.sheetname);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams, true);
    }
}

