/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.draft.TaxPayService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;

public class TaxpayFormPlugin
extends AbstractAccountPlugin
implements HyperLinkClickListener,
IDraftTypeObserver {
    private static final String CACHE_KEY = "jd";
    private String fields = "id,type,bqfse,bqlje";
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private static final Map<String, String> MAP = new LinkedHashMap<String, String>();

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void packageData(PackageDataEvent e) {
        String draftpurpose;
        String enddate;
        String startdate;
        Object source = e.getSource();
        Map customParams = ((FieldEdit)source).getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        boolean b = this.hideColumn(orgid, startdate = (String)customParams.get("skssqq"), enddate = (String)customParams.get("skssqz"), draftpurpose = (String)customParams.get("draftpurpose"));
        if (b) {
            e.setNoLinkKey(Collections.singletonList("bqfse"));
        } else {
            e.setNoLinkKey(Collections.singletonList("bqlje"));
        }
    }

    public boolean hideColumn(String orgId, String startdate, String enddate, String draftpurpose) {
        DynamicObject policy = SeasonalPolicyService.getPolicy(Long.parseLong(orgId), DateUtils.stringToDate2((String)startdate), DateUtils.stringToDate2((String)enddate), draftpurpose);
        if (policy != null) {
            String levytype = policy.getString("levytype");
            String residenttype = policy.getString("residenttype");
            String yjprofitslogic = policy.getString("yjprofitslogic");
            boolean a = "jmqy".equals(residenttype) && "czzs".equals(levytype) && "bnlje".equals(yjprofitslogic);
            boolean b = "hdzs".equals(levytype) && "bnlje".equals(yjprofitslogic);
            return a || b;
        }
        return false;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        String draftpurpose = (String)customParams.get("draftpurpose");
        boolean b = this.hideColumn(orgid, startdate, enddate, draftpurpose);
        this.getView().setVisible(Boolean.valueOf(!b), new String[]{"bqfse"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        String isConfirmSave = (String)customParams.get("isConfirmSave");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        DynamicObject[] adjustAmount = this.getAdjustAmount(customParams);
        IDataModel model = this.getModel();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getYjProfits().getNumber(), (String)"id,type,bqfse,bqlje,sqfse,sqlje", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter}, (String)"type");
        if (adjustAmount.length > 0 && "true".equals(isConfirmSave)) {
            dynamicObjects = this.mergeSaveData(dynamicObjects, adjustAmount, draftTypeObjectVo, customParams);
        }
        int month = DateUtils.getMonthOfDate((Date)skssqq);
        int jd = (month + 2) / 3;
        this.getPageCache().put(CACHE_KEY, String.valueOf(jd));
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (dynamicObjects.length > 0) {
            model.batchCreateNewEntryRow("entryentity", dynamicObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                for (String field : this.fields.split(",")) {
                    model.setValue(field, dynamicObject.get(field), rowIndex);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{field});
                }
                ++rowIndex;
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    private DynamicObject[] mergeSaveData(DynamicObject[] dynamicObjects, DynamicObject[] adjustAmounts, DraftTypeObjectVo draftTypeObjectVo, Map<String, Object> customParams) {
        String entrytype = adjustAmounts[0].getString("entrytype");
        String orgId = (String)customParams.get("orgid");
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        DynamicObject policy = SeasonalPolicyService.getPolicy(Long.parseLong(orgId), DateUtils.stringToDate2((String)startdate), DateUtils.stringToDate2((String)enddate), draftpurpose);
        for (DynamicObject dynamicObject : dynamicObjects) {
            BigDecimal adjustAmount;
            String type = MAP.get(dynamicObject.getString("type"));
            DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("itemnumber").equals(type) || s.getString("itemnumber").equals(type + "_")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            if ("profits".equals(entrytype)) {
                if (!CollectionUtils.isEmpty((Collection)collect)) {
                    adjustAmount = collect.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    dynamicObject.set("bqfse", (Object)adjustAmount);
                }
                BigDecimal bqlje = TaxPayService.getBqlje(policy, type, dynamicObject.getBigDecimal("bqfse"), dynamicObject.getBigDecimal("sqlje"), draftpurpose);
                dynamicObject.set("bqlje", (Object)bqlje);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)collect)) continue;
            adjustAmount = collect.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            dynamicObject.set("bqlje", (Object)adjustAmount);
        }
        this.recalcRecoupDeficit(draftTypeObjectVo, "TaxpayEngine_summary", Arrays.stream(dynamicObjects).collect(Collectors.toList()), customParams);
        if (this.checkAmountValue(Arrays.asList(dynamicObjects), "bqlje")) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        } else {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25,\u91d1\u989d\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d", (String)"TaxpayFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
        return dynamicObjects;
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (fieldName.equals("bqfse") || fieldName.equals("bqlje")) {
            String key = ((Control)evt.getSource()).getKey();
            EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
            String type = String.valueOf(itemsEntity.getModel().getValue("type"));
            String entrytype = evt.getFieldName();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("columnType", evt.getFieldName());
            customParams.put("entrytype", fieldName.equals("bqfse") ? "profits" : "profits-bqlje");
            customParams.put("itemnumber", MAP.get(type));
            DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
            customParams.put("entryname", draftTypeObjectVo.getYjProfits().getDetail());
            this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
        }
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private DynamicObject[] getAdjustAmount(Map<String, Object> customParams) {
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter entrytypeFilter = new QFilter("entrytype", "in", (Object)Lists.newArrayList((Object[])new String[]{"profits", "profits-bqlje"}));
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter};
        String selectPrope = "ruleid,entrytype,adjustamount,totalamount,itemnumber";
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        DynamicObject[] adjustDetails = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getAdjustDetail().getNumber(), (String)selectPrope, (QFilter[])filters);
        return adjustDetails;
    }

    @Override
    public Set<String> adaptDraftCellName(Set<String> rowSet) {
        if (rowSet != null && rowSet.size() != 0) {
            String entrytype = (String)rowSet.stream().findFirst().get();
            if ("profits".equals(entrytype)) {
                return Collections.singleton("bqfse");
            }
            return Collections.singleton("bqlje");
        }
        return Collections.emptySet();
    }

    @Override
    public Map<String, Object> createParams(DynamicObject obj) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(customParams);
        params.put("entrytype", "profits,profits-bqlje");
        params.put("itemnumber", MAP.get(obj.get("type")));
        return params;
    }

    static {
        MAP.put("income", "011");
        MAP.put("jcost", "012");
        MAP.put("profit", "013");
        MAP.put("grossincome", "011");
        MAP.put("totalcost", "012");
    }
}

