/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.draft.NontaxService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;
import org.apache.commons.lang3.StringUtils;

public class TechTransFormPlugin
extends AbstractAccountPlugin
implements HyperLinkClickListener,
IDraftTypeObserver {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        IDataModel model = this.getModel();
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getNontaxSummaryM().getNumber(), (String)"discounttype,rulename,nontaxtotal", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
        this.setAmountAndVisible("10", objects);
        this.setAmountAndVisible("12", objects);
        DynamicObject[] adjustAmount = this.getAdjustAmount(customParams, draftTypeObjectVo);
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getYjTechtrans().getNumber(), (String)"serialno,taxorg,org,skssqq,skssqz,rule,itemtype,discounttype,incredpresent,incredtotal", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
        if (adjustAmount.length > 0) {
            genericObjects = this.mergeSaveData(genericObjects, adjustAmount);
        }
        this.getModel().deleteEntryData("entryentity");
        if (genericObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("taxorg", dynamicObject.get("taxorg"), rowIndex);
                model.setValue("incredrule", dynamicObject.get("rule"), rowIndex);
                model.setValue("itemtype", dynamicObject.get("itemtype"), rowIndex);
                model.setValue("discounttype", dynamicObject.get("discounttype"), rowIndex);
                model.setValue("incredpresent", dynamicObject.get("incredpresent"), rowIndex);
                model.setValue("incredtotal", dynamicObject.get("incredtotal"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void setAmountAndVisible(String type, DynamicObject[] objects) {
        Boolean contains = Boolean.FALSE;
        for (DynamicObject object : objects) {
            if (!type.equals(object.getString("discounttype"))) continue;
            contains = Boolean.TRUE;
            this.getModel().setValue("amount" + type, object.get("nontaxtotal"));
            this.getModel().setValue("name" + type, object.get("rulename"));
        }
        this.getView().setVisible(contains, new String[]{"flex" + type});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String entrytype = evt.getFieldName();
        Object serialno = this.getModel().getValue("serialno", rowIndex);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String taxorg = String.valueOf(((DynamicObject)itemsEntity.getModel().getValue("taxorg")).get(0));
        String ruleid = String.valueOf(((DynamicObject)this.getModel().getValue("incredrule")).get("id"));
        customParams.put("taxorg", taxorg);
        customParams.put("columnType", entrytype);
        customParams.put("entrytype", entrytype);
        customParams.put("itemnumber", ruleid);
        customParams.put("ruleid", ruleid);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        customParams.put("entryname", draftTypeObjectVo.getYjTechtrans().getDetail());
        customParams.put("taxaccountserialno", serialno);
        customParams.put("draftpurpose", customParams.getOrDefault("draftpurpose", "nssb"));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParams(customParams);
        parameter.setFormId("tccit_detail_tz_dialog");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(parameter);
    }

    private DynamicObject[] mergeSaveData(DynamicObject[] dynamicObjects, DynamicObject[] adjustAmounts) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Object orgid = customParams.get("orgid");
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        Date startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter q2 = new QFilter("skssqq", ">=", (Object)startDate);
        QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)endDate));
        Map<Object, Object> lastTaxMap = new HashMap();
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        if ("season".equals(taxLimit)) {
            if (startDate.getMonth() >= 3) {
                lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 3, draftTypeObjectVo.getYjTechtrans().getNumber());
            }
        } else if (startDate.getMonth() >= 1) {
            lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 1, draftTypeObjectVo.getYjTechtrans().getNumber());
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject rule = dynamicObject.getDynamicObject("rule");
            String ruleid = dynamicObject.getString("rule_id");
            long taxorgid = dynamicObject.getLong("taxorg_id");
            DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("ruleid").equals(ruleid)).filter(s -> s.getLong("taxorg") == taxorgid).collect(Collectors.toCollection(DynamicObjectCollection::new));
            if (CollectionUtils.isEmpty((Collection)collect)) continue;
            BigDecimal adjustAmount = collect.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            dynamicObject.set("incredpresent", (Object)adjustAmount);
            BigDecimal lastIncredtotal = (BigDecimal)lastTaxMap.get(taxorgid + "#" + rule.getLong("id"));
            BigDecimal incredtotal = BigDecimalUtil.addObject((Object)adjustAmount, (Object)lastIncredtotal);
            dynamicObject.set("incredtotal", (Object)incredtotal);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                DeleteServiceHelper.delete((String)draftTypeObjectVo.getNontaxSummaryM().getNumber(), (QFilter[])new QFilter[]{q1, q2, q3, new QFilter("type", "=", (Object)"4")});
                NontaxService.handleSummaryMiddle(Arrays.stream(dynamicObjects).collect(Collectors.toList()), "4", "incredtotal", 2, dynamicObjects.length + 1, draftTypeObjectVo.getNontaxSummaryM().getNumber());
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        return dynamicObjects;
    }

    private Map<String, BigDecimal> getLastPeriodBigDecimalMap(Date startDate, Date endDate, QFilter orgFilter, int monthcount, String entityName) {
        Date date = DateUtils.addMonth((Date)startDate, (int)(-monthcount));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)date);
        Date d2 = DateUtils.addMonth((Date)endDate, (int)(-monthcount));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)d2)));
        DynamicObjectCollection lastCols = QueryServiceHelper.query((String)entityName, (String)"taxorg,rule,incredtotal", (QFilter[])new QFilter[]{skssqqFilter, skssqzFilter, orgFilter});
        Map<String, BigDecimal> lastTaxMap = lastCols.stream().collect(Collectors.toMap(e -> e.getLong("taxorg") + "#" + e.getLong("rule"), f -> f.getBigDecimal("incredtotal")));
        return lastTaxMap;
    }

    private DynamicObject[] getAdjustAmount(Map<String, Object> customParams, DraftTypeObjectVo draftTypeObjectVo) {
        String ruleid = (String)customParams.get("ruleid");
        if (StringUtils.isBlank((CharSequence)ruleid)) {
            return new DynamicObject[0];
        }
        QFilter ruleIdFilter = new QFilter("ruleid", "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)ruleid).or(new QFilter("itemnumber", "=", (Object)(ruleid + "_")));
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, ruleIdFilter, itemnumberFilter};
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,totalamount,itemnumber";
        return BusinessDataServiceHelper.load((String)draftTypeObjectVo.getAdjustDetail().getNumber(), (String)selectPrope, (QFilter[])filters);
    }

    @Override
    public Set<String> adaptDraftCellName(Set<String> rowSet) {
        return Collections.singleton("incredpresent");
    }

    @Override
    public Map<String, Object> createParams(DynamicObject obj) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(customParams);
        String taxorg = obj.getString("taxorg_id");
        String ruleid = obj.getString("incredrule_id");
        params.put("taxorg", taxorg);
        params.put("entrytype", "incredpresent");
        params.put("itemnumber", ruleid);
        params.put("ruleid", ruleid);
        return params;
    }
}

