/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class ThinkOfSellFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String NAME = "name";
    public static final String PRODUCTTYPE = "producttype";
    public static final String INCOME = "income";
    public static final String COST = "cost";
    public static final String ADJUSTAMOUNT = "adjustamount";
    public static final String ORGID = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String RULEID = "ruleid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        String selectFields = "itemno,ruleid,name,itemtype,producttype,income,cost,adjustamount";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_thinkofsell_summary", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() + 1);
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            model.setValue(ITEM_NO, (Object)dynamicObject.getString(ITEM_NO), rowIndex);
            model.setValue(RULEID, (Object)dynamicObject.getLong(RULEID), rowIndex);
            model.setValue(NAME, (Object)dynamicObject.getString(NAME), rowIndex);
            model.setValue(ITEM_TYPE, (Object)dynamicObject.getString(ITEM_TYPE), rowIndex);
            model.setValue(PRODUCTTYPE, (Object)dynamicObject.getString(PRODUCTTYPE), rowIndex);
            model.setValue(INCOME, (Object)this.formatData(dynamicObject.getLong(RULEID), INCOME, dynamicObject.getBigDecimal(INCOME)), rowIndex);
            model.setValue(COST, (Object)this.formatData(dynamicObject.getLong(RULEID), COST, dynamicObject.getBigDecimal(COST)), rowIndex);
            model.setValue(ADJUSTAMOUNT, (Object)this.formatData(dynamicObject.getLong(RULEID), ADJUSTAMOUNT, dynamicObject.getBigDecimal(ADJUSTAMOUNT)), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.appendCountRow(query, model, rowIndex);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex) {
        model.setValue(ITEM_NO, (Object)(query.size() + 1), rowIndex);
        model.setValue(RULEID, (Object)0L, rowIndex);
        model.setValue(NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ThinkOfSellFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue(ITEM_TYPE, (Object)"", rowIndex);
        model.setValue(PRODUCTTYPE, (Object)"", rowIndex);
        model.setValue(INCOME, (Object)this.formatData(0L, INCOME, this.getSum(query, INCOME)), rowIndex);
        model.setValue(COST, (Object)this.formatData(0L, COST, this.getSum(query, COST)), rowIndex);
        model.setValue(ADJUSTAMOUNT, (Object)this.formatData(0L, ADJUSTAMOUNT, this.getSum(query, ADJUSTAMOUNT)), rowIndex);
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String formatData(Long ruleId, String columnType, BigDecimal data) {
        StringBuilder link = new StringBuilder("<nolink>");
        String text = data.setScale(2, 4).toString();
        if (ruleId == 0L) {
            if (ADJUSTAMOUNT.equals(columnType)) {
                return DataFormat.formatMicrometer(text);
            }
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        return DataFormat.formatMicrometer(text);
    }

    private DynamicObjectCollection calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("income1")) {
            return null;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<DynamicObject> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.THINKSELL);
        int index = 0;
        for (DynamicObject rule : sellRuleList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_thinkofsell_summary");
            dynamicObject.set(ITEM_NO, (Object)(++index));
            dynamicObject.set(NAME, (Object)rule.getString(NAME));
            dynamicObject.set(RULEID, (Object)rule.getLong("id"));
            dynamicObject.set(ITEM_TYPE, (Object)rule.getDynamicObject("item").getString("number"));
            dynamicObject.set(PRODUCTTYPE, (Object)rule.getString("spap"));
            BigDecimal income = this.getAmount(customParams, "stxs_sr", rule.getDynamicObject("item").getString("number"), rule.getString("id"));
            dynamicObject.set(INCOME, (Object)income);
            BigDecimal cost = this.getAmount(customParams, "stxs_cb", rule.getDynamicObject("item").getString("number"), rule.getString("id"));
            dynamicObject.set(COST, (Object)cost);
            dynamicObject.set(ADJUSTAMOUNT, (Object)income.subtract(cost));
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_thinkofsell_summary", (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, String itemnumber, String ruleid) {
        return this.getCellAmount(customParams, null, entrytype, null, null, Long.valueOf(ruleid), "tccit_thinkofsell_detail");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULEID));
        String itemnumber = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (INCOME.equals(evt.getFieldName())) {
            customParams.put("entrytype", "stxs_sr");
        } else if (COST.equals(evt.getFieldName())) {
            customParams.put("entrytype", "stxs_cb");
        }
        customParams.put("columnType", evt.getFieldName());
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", "tccit_thinkofsell_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{INCOME, COST});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULEID);
        customParams.put("entryname", "tccit_thinkofsell_detail");
        customParams.put("entrytype", INCOME.equals(column) ? "stxs_sr" : "stxs_cb");
        customParams.put("columnType", column);
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }
}

