/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.common.enums.DraftSummaryEnum;
import kd.taxc.tccit.formplugin.account.DksszbjTZFormPlugin;
import kd.taxc.tccit.formplugin.account.HhqyhhrTZFormPlugin;
import kd.taxc.tccit.formplugin.account.QyczjdynsTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SpecOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.draft.AbstractSummaryPlugin;
import kd.taxc.tccit.formplugin.year.dg.sdtz.B105093_DGFormPlugin;

public class TssxHzdgSummaryPlugin
extends AbstractSummaryPlugin {
    private static final ArrayList<String> ARRAY_LIST = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"});

    @Override
    public DraftSummaryEnum getDraftSummaryEnum() {
        return DraftSummaryEnum.TSSXTZ;
    }

    @Override
    public Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList<QFilter> baseQfilters = this.getBaseQfilters(customParams);
        if ("1".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("tsczlx", "=", (Object)"*"));
            amount = this.getOne(rowType, columnType, "tccit_qyczjdyns_summary", "id,nstzhjje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzhjje");
        }
        if ("2".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "=", (Object)"10"));
            amount = this.getOne(rowType, columnType, "tccit_dksszbj_sum", "id,nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
        }
        if ("6".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "=", (Object)"003"));
            amount = this.getSum(rowType, columnType, "tccit_dg_b105093nstz_sum", "sum(amount) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
        }
        if ("8".equals(rowType) && "amount".equals(columnType)) {
            amount = this.getSum(rowType, columnType, "tccit_hhqyhhr_summary", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
        }
        if ("9".equals(rowType) && "amount".equals(columnType)) {
            baseQfilters.add(new QFilter("itemtype", "=", (Object)"count"));
            amount = this.getOne(rowType, columnType, "tccit_spec_other_sum", "nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
        }
        if ("10".equals(rowType) && "amount".equals(columnType)) {
            amount = this.getSum(ARRAY_LIST, "amount");
        }
        return amount;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, DraftSummaryEnum.TSSXTZ.getBill());
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(TssxHzdgSummaryPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{QyczjdynsTZFormPlugin.class.getSimpleName(), DksszbjTZFormPlugin.class.getSimpleName(), B105093_DGFormPlugin.class.getSimpleName(), HhqyhhrTZFormPlugin.class.getSimpleName(), SpecOtherTZFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

