/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.common.utils.LocalDateUtils;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A100000_1_DGFormPlugin;
import org.apache.commons.collections.CollectionUtils;

public class XekcgyxFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "6a", "6b", "6c", "7", "8", "9", "10", "11", "12", "13", "14", "14a", "14b", "14c", "15", "16", "17", "17a", "17b", "17c"});
    public final List<String> calcOrder = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6a", "6b", "6c", "6", "7", "8", "9", "10", "11", "12", "13", "14a", "14b", "14c", "14", "15", "16", "17a", "17b", "17c", "17"});
    public static final Set<String> level1 = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"});
    public static final Set<String> level2 = Sets.newHashSet((Object[])new String[]{"6a", "6b", "6c", "14a", "14b", "14c", "17a", "17b", "17c"});
    private static final String ENTITY_NAME = "treeentryentity";
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_NAME = "name";
    private static final String MONEY = "money";
    private static final String MYPARENTID = "myparentid";
    private static final String MYPKID = "mypkid";
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ITEM_TYPE = "itemtype";
    private static Pattern pattern = Pattern.compile("[^0-9]");
    private Map<String, Long> keyIds = new HashMap<String, Long>();
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    Map<String, String> mapRef = new HashMap(){
        {
            this.put("6a", "5");
            this.put("6b", "6");
            this.put("6c", "7");
        }
    };
    Map<String, String> ITEMNO_ENTRYTYPE_MAPPER = new HashMap(){
        {
            this.put("2", XekcgyxFormPlugin.ZZJE);
            this.put("3", "sjzcje");
            this.put("4", "wqdhgpj");
            this.put("6a", "xekc_6a");
            this.put("6b", "xekc_6b");
            this.put("6c", "xekc_6c");
        }
    };
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ZZJE = "zzje";
    public static final String TCCIT_B105021_SUM = "tccit_dg_b105021_sum";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTITY_NAME);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("deduct11")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (String itemType : this.calcOrder) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_B105021_SUM);
            dynamicObject.set(ITEM_NO, (Object)itemType);
            dynamicObject.set(ITEM_NAME, (Object)itemType);
            dynamicObject.set(MONEY, (Object)this.calcCell(itemType, MONEY, customParams));
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            dynamicObject.set(ITEM_TYPE, (Object)"3010401");
            sum.add((Object)dynamicObject);
        }
        this.buildTree(this.itemTypes, sum);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_B105021_SUM, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private void buildTree(List<String> showItems, DynamicObjectCollection sum) {
        for (String itemType : showItems) {
            DynamicObject dynamicObject1 = sum.stream().filter(s -> s.getString(ITEM_NO).equals(itemType)).findFirst().get();
            dynamicObject1.set(MYPARENTID, (Object)this.getParentId(itemType));
            dynamicObject1.set(MYPKID, (Object)this.getPkId(itemType));
        }
    }

    private BigDecimal calcCell(String rowType, String columnType, Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        BigDecimal result = BigDecimal.ZERO;
        if ("2".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal zzje = this.getAmount(customParams, ZZJE);
            this.dataMap.put(this.getKey(rowType, columnType), zzje);
            return zzje;
        }
        if ("3".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal sjzcje = this.getAmount(customParams, "sjzcje");
            this.dataMap.put(this.getKey(rowType, columnType), sjzcje);
            return sjzcje;
        }
        if ("4".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal wqdhgpj = this.getAmount(customParams, "wqdhgpj");
            this.dataMap.put(this.getKey(rowType, columnType), wqdhgpj);
            return wqdhgpj;
        }
        if ("5".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal bigDecimal5 = this.dataMap.get(this.getKey("3", columnType)).subtract(this.dataMap.get(this.getKey("4", columnType)));
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal5);
            return bigDecimal5;
        }
        if ("6".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal deduct = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"6a", "6b", "6c"}));
            this.dataMap.put(this.getKey(rowType, columnType), deduct);
            return deduct;
        }
        if (Lists.newArrayList((Object[])new String[]{"6a", "6b", "6c"}).contains(rowType) && MONEY.equals(columnType)) {
            DynamicObject object = this.getAdjustAmount(customParams, "3010401", this.ITEMNO_ENTRYTYPE_MAPPER.get(rowType));
            BigDecimal sbbAmount = object == null ? this.getSixAbc(rowType, columnType, customParams) : object.getBigDecimal("totalamount");
            this.dataMap.put(this.getKey(rowType, columnType), sbbAmount);
            return sbbAmount;
        }
        if ("7".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal sumCurYearAmount = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"5", "6"}));
            this.dataMap.put(this.getKey(rowType, columnType), sumCurYearAmount);
            return sumCurYearAmount;
        }
        if ("9".equals(rowType) && MONEY.equals(columnType)) {
            QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ))));
            QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ))));
            QFilter typeFilter = new QFilter(ITEM_TYPE, "=", (Object)"003");
            return this.getOne(rowType, columnType, "tccit_dg_a100000_1_sum", "amount", new QFilter[]{orgFilter, startFilter, endFilter, typeFilter}, "amount");
        }
        if ("10".equals(rowType) && MONEY.equals(columnType)) {
            List strings = AssistService.queryAssistParams((String)"JZKC", (String)String.valueOf(customParams.get(ORGID)), (String)String.valueOf(customParams.get(SKSSQQ)), (String)String.valueOf(customParams.get(SKSSQZ)));
            BigDecimal amount8 = (CollectionUtils.isEmpty((Collection)strings) ? BigDecimal.valueOf(0.0) : new BigDecimal((String)strings.get(0))).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), amount8);
            return amount8;
        }
        if ("11".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal bigDecimal10;
            BigDecimal bigDecimal9 = this.dataMap.get(this.getKey("9", columnType));
            BigDecimal bigDecimal11 = BigDecimal.ZERO.compareTo(bigDecimal9.multiply(bigDecimal10 = this.dataMap.get(this.getKey("10", columnType)))) >= 0 ? BigDecimal.ZERO : bigDecimal9.multiply(bigDecimal10).divide(BigDecimal.valueOf(100L), 2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal11);
            return bigDecimal11;
        }
        if ("13".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal bigDecimal11;
            BigDecimal bigDecimal7 = this.dataMap.get(this.getKey("7", columnType));
            BigDecimal bigDecimal13 = bigDecimal7.compareTo(bigDecimal11 = this.dataMap.get(this.getKey("11", columnType))) > 0 ? bigDecimal11 : bigDecimal7;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal13);
            return bigDecimal13;
        }
        if ("14".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal deduct = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"14a", "14b", "14c"}));
            this.dataMap.put(this.getKey(rowType, columnType), deduct);
            return deduct;
        }
        if ("14a".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal bigDecimal11;
            BigDecimal bigDecimal6a = this.dataMap.get(this.getKey("6a", columnType));
            BigDecimal bigDecimal14a = bigDecimal6a.compareTo(bigDecimal11 = this.dataMap.get(this.getKey("11", columnType))) > 0 ? bigDecimal11 : bigDecimal6a;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal14a);
            return bigDecimal14a;
        }
        if ("14b".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal substract;
            BigDecimal bigDecimal6b = this.dataMap.get(this.getKey("6b", columnType));
            BigDecimal bigDecimal14b = bigDecimal6b.compareTo(substract = this.dataMap.get(this.getKey("11", columnType)).subtract(this.dataMap.get(this.getKey("14a", columnType)))) > 0 ? substract : bigDecimal6b;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal14b);
            return bigDecimal14b;
        }
        if ("14c".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal substract;
            BigDecimal bigDecimal6c = this.dataMap.get(this.getKey("6c", columnType));
            BigDecimal bigDecimal14c = bigDecimal6c.compareTo(substract = this.dataMap.get(this.getKey("11", columnType)).subtract(this.dataMap.get(this.getKey("14a", columnType))).subtract(this.dataMap.get(this.getKey("14b", columnType)))) > 0 ? substract : bigDecimal6c;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal14c);
            return bigDecimal14c;
        }
        if ("15".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal substract;
            BigDecimal bigDecimal5 = this.dataMap.get(this.getKey("5", columnType));
            BigDecimal bigDecimal15 = bigDecimal5.compareTo(substract = this.dataMap.get(this.getKey("11", columnType)).subtract(this.dataMap.get(this.getKey("14a", columnType))).subtract(this.dataMap.get(this.getKey("14b", columnType))).subtract(this.dataMap.get(this.getKey("14c", columnType)))) > 0 ? substract : bigDecimal5;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal15);
            return bigDecimal15;
        }
        if ("16".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal substract = this.dataMap.get(this.getKey("2", columnType)).subtract(this.dataMap.get(this.getKey("15", columnType)));
            BigDecimal bigDecimal16 = BigDecimal.ZERO.compareTo(substract) > 0 ? BigDecimal.ZERO : substract;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal16);
            return bigDecimal16;
        }
        if ("17".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal deduct = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"17a", "17b", "17c"}));
            this.dataMap.put(this.getKey(rowType, columnType), deduct);
            return deduct;
        }
        if ("17a".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal substract = this.dataMap.get(this.getKey("6b", columnType)).subtract(this.dataMap.get(this.getKey("14b", columnType)));
            BigDecimal bigDecimal17a = BigDecimal.ZERO.compareTo(substract) > 0 ? BigDecimal.ZERO : substract;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal17a);
            return bigDecimal17a;
        }
        if ("17b".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal substract = this.dataMap.get(this.getKey("6c", columnType)).subtract(this.dataMap.get(this.getKey("14c", columnType)));
            BigDecimal bigDecimal17b = BigDecimal.ZERO.compareTo(substract) > 0 ? BigDecimal.ZERO : substract;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal17b);
            return bigDecimal17b;
        }
        if ("17c".equals(rowType) && MONEY.equals(columnType)) {
            BigDecimal substract = this.dataMap.get(this.getKey("5", columnType)).subtract(this.dataMap.get(this.getKey("15", columnType)));
            BigDecimal bigDecimal17c = BigDecimal.ZERO.compareTo(substract) > 0 ? BigDecimal.ZERO : substract;
            this.dataMap.put(this.getKey(rowType, columnType), bigDecimal17c);
            return bigDecimal17c;
        }
        return result;
    }

    private BigDecimal getOne(String rowType, String columnType, String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObject object = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = object != null ? object.getBigDecimal(alias) : BigDecimal.ZERO;
        this.dataMap.put(this.getKey(rowType, columnType), result);
        return result;
    }

    private BigDecimal getSumCurYearAmount(String columnType, List<String> rows) {
        return rows.stream().map(s -> this.dataMap.getOrDefault(this.getKey((String)s, columnType), BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    private String getPreYearSbbid(Map<String, Object> customParams) {
        QFilter declareStatusFilter;
        QFilter typeFilter;
        Date skssqz;
        String start;
        LocalDate parse;
        int year;
        Date skssqq;
        QFilter dateFilter;
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        DynamicObjectCollection temp = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{orgFilter, dateFilter = new QFilter(SKSSQQ, "=", (Object)(skssqq = LocalDateUtils.localDate2Date(LocalDate.of(year = (year = (parse = LocalDate.parse(start = (String)customParams.get(SKSSQQ), DateTimeFormatter.ofPattern("yyyy-MM-dd"))).getYear() - 1) > 2020 ? 2020 : year, 1, 1)))).and(new QFilter(SKSSQZ, "=", (Object)(skssqz = LocalDateUtils.localDate2Date(LocalDate.of(year, 12, 31))))), typeFilter = new QFilter("type", "=", (Object)"qysdsnb"), declareStatusFilter = new QFilter("declarestatus", "=", (Object)"declared")});
        if (CollectionUtils.isEmpty((Collection)temp)) {
            return "";
        }
        return ((DynamicObject)temp.get(0)).getString("id");
    }

    private void initData() {
        this.getModel().deleteEntryData(ENTITY_NAME);
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
        DynamicObjectType dynamicObjectType = treeEntryEntity.getDynamicObjectType();
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        String selectFields = "itemno,name,itemtype,money,mypkid,myparentid,orgid,skssqq,skssqz";
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_B105021_SUM, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        int[] indexs = this.getModel().batchCreateNewEntryRow(ENTITY_NAME, this.itemTypes.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
        for (int index : indexs) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            DynamicObject object = query.stream().filter(s -> s.getString(ITEM_NO).equals(this.itemTypes.get(index))).findFirst().get();
            dynamicObject.set("id", (Object)object.getLong(MYPKID));
            dynamicObject.set("pid", (Object)object.getLong(MYPARENTID));
            dynamicObject.set(ITEM_NO, (Object)object.getString(ITEM_NO));
            dynamicObject.set(ITEM_NAME, (Object)object.getString(ITEM_NO));
            dynamicObject.set(MONEY, (Object)this.formatData(object, this.itemTypes.get(index), MONEY));
            dynamicObject.set("itemnumber", (Object)object.getString(ITEM_TYPE));
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTITY_NAME);
        treeEntryGrid.setCollapse(false);
        List rows1 = Lists.newArrayList((Object[])new String[]{"6", "14", "17"}).stream().map(s -> this.itemTypes.indexOf(s)).collect(Collectors.toList());
        treeEntryGrid.collapse(rows1.stream().mapToInt(Integer::intValue).toArray());
    }

    private String formatData(DynamicObject object, String rowType, String columnType) {
        StringBuilder builder = new StringBuilder("<nolink>");
        if ("10".equals(rowType)) {
            BigDecimal rate = object.getBigDecimal(columnType);
            return builder.append(rate.setScale(2, 4)).append('%').toString();
        }
        if ("1".equals(rowType) || "8".equals(rowType) || "12".equals(rowType)) {
            return builder.toString();
        }
        if ("2".equals(rowType) || "3".equals(rowType) || "4".equals(rowType) || "6a".equals(rowType) || "6b".equals(rowType) || "6c".equals(rowType)) {
            return DataFormat.formatMicrometer(object.getBigDecimal(columnType).setScale(2, 4).toString());
        }
        return builder.append(DataFormat.formatMicrometer(object.getBigDecimal(columnType).setScale(2, 4).toString())).toString();
    }

    private BigDecimal getSixAbc(String rowType, String columnType, Map<String, Object> customParams) {
        QFilter itemFilter = new QFilter("ewblxh", "=", (Object)this.mapRef.get(rowType));
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)this.getPreYearSbbid(customParams));
        BigDecimal amount = this.getOne(rowType, columnType, "tccit_qysds_a105070", "kjzyhndkcdjze", new QFilter[]{itemFilter, sbbidFilter}, "kjzyhndkcdjze");
        return amount;
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private Long getPkId(String itemType) {
        Long pkId = this.itemTypes.indexOf(itemType) + 1;
        this.keyIds.put(itemType, pkId);
        return pkId;
    }

    private Long getParentId(String id) {
        if (level1.contains(id)) {
            return 0L;
        }
        if (level2.contains(id)) {
            return this.keyIds.get(pattern.matcher(id).replaceAll(""));
        }
        return 0L;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemnumber = String.valueOf(itemsEntity.getModel().getValue("itemnumber"));
        String itemno = String.valueOf(itemsEntity.getModel().getValue(ITEM_NO));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entrytype", this.ITEMNO_ENTRYTYPE_MAPPER.get(itemno));
        customParams.put("columnType", evt.getFieldName());
        customParams.put("itemnumber", itemnumber);
        customParams.put("entryname", "tccit_dg_b105021_det");
        customParams.put("originalamount_" + itemnumber, this.getSixAbc(itemno, evt.getFieldName(), customParams));
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype) {
        return this.getCellAmount(customParams, null, entrytype, null, "3010401", null, "tccit_dg_b105021_det");
    }

    protected DynamicObject getAdjustAmount(Map<String, Object> customParams, String itemnumber, String entrytype) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Object orgid = customParams.get(ORGID);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        qFilters.add(new QFilter("org", "=", (Object)Long.parseLong((String)orgid)));
        qFilters.add(new QFilter(SKSSQQ, "=", (Object)skssqq));
        qFilters.add(new QFilter(SKSSQZ, "=", (Object)skssqz));
        qFilters.add(new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_"))));
        qFilters.add(new QFilter("entrytype", "=", (Object)entrytype));
        return QueryServiceHelper.queryOne((String)"tccit_adjust_detail", (String)"id,amount,totalamount,adjustamount", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public String getEntryName() {
        return ENTITY_NAME;
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{MONEY});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemnumber = row.getString("itemnumber");
        String itemno = row.getString(ITEM_NO);
        customParams.put("entryname", "tccit_dg_b105021_det");
        customParams.put("entrytype", this.ITEMNO_ENTRYTYPE_MAPPER.get(itemno));
        customParams.put("columnType", column);
        customParams.put("itemnumber", itemnumber);
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(XekcgyxFormPlugin.class.getSimpleName(), Collections.singletonList(A100000_1_DGFormPlugin.class.getSimpleName()));
            }
        };
    }
}

