/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.engine.YearAccEngine;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.DeductPreferentialSummaryPlugin;

public class YhTaxCreditFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    private static Log logger = LogFactory.getLog(YhTaxCreditFormPlugin.class);
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String SUMMARY_ENTRY_NAME = "tccit_yh_taxcredit_sum";
    public static final String RULE_DETAIL_ENTRY_NAME = "tccit_yh_taxcredit_det";
    private static final String DMQYN_AMOUNT = "dmqynamount";
    private static final String SJDM_AMOUNT = "sjdmamount";
    private static final String YN_AMOUNT = "ynamount";
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String ITEM_NAME = "itemname";
    private static final String NAME = "name";
    private static final String RULE_ID = "ruleid";
    private static final String ZZJE = "zzje";
    private static final String TAX_AMOUNT = "taxamount";
    private static final String NSTZJE = "nstzje";
    private static final String ND = "nd";
    private static final String BNDMQYNSE = "bndmqynse";
    private static final String BNYXDMDZYSBTZE = "bnyxdmdzysbtze";
    private static final String QWNDDME = "qwnddme";
    private static final String QSINDDME = "qsinddme";
    private static final String QSNDDME = "qsnddme";
    private static final String QENDDME = "qenddme";
    private static final String QYNDDME = "qynddme";
    private static final String KDMSE = "kdmse";
    private static final String XJ = "xj";
    private static final String BNKDMSE = "bnkdmse";
    private static final String BNSJDMDGNDSE = "bnsjdmdgndse";
    private static final String KJZYHNDDMDSE = "kjzyhnddmdse";
    private Set<String> itemTypes = YearAccEngine.getEntityItemMapping().get("tccit_yh_taxcredit_det").stream().collect(Collectors.toSet());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams, SUMMARY_ENTRY_NAME, this.itemTypes, RULE_DETAIL_ENTRY_NAME, RuleTypeEnum.SSYH);
        }
        this.initData(customParams, SUMMARY_ENTRY_NAME, this.itemTypes);
        this.initCalc(customParams);
    }

    private void initCalc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"7");
        DynamicObjectCollection list = QueryServiceHelper.query((String)"tccit_setz_jmyhhz_summary", (String)"amountorratio", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        BigDecimal dmqynAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            dmqynAmount = ((DynamicObject)list.get(0)).getBigDecimal("amountorratio");
            logger.info("\u83b7\u53d6\u672c\u5e74\u51cf\u514d\u4f18\u60e0\u6c47\u603b\u5e95\u7a3f->\u51cf\u514d\u540e\u5e94\u7eb3\u6240\u5f97\u7a0e\u989d:" + dmqynAmount);
        }
        this.getView().getModel().setValue(DMQYN_AMOUNT, (Object)dmqynAmount);
        if (this.canReCalc(customParams).booleanValue()) {
            this.createTaxCredit(customParams, dmqynAmount);
        }
        this.initTaxCreditData(dmqynAmount);
        BigDecimal sjdmamount = this.getSjdmamount(DateUtils.getYearOfDate((Date)skssqq));
        this.getView().getModel().setValue(SJDM_AMOUNT, (Object)sjdmamount);
        BigDecimal subtract = dmqynAmount.subtract(sjdmamount);
        this.getView().getModel().setValue(YN_AMOUNT, (Object)(subtract.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : subtract));
    }

    private BigDecimal getSjdmamount(int currentYear) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate2((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate2((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter ndFilter = new QFilter(ND, "=", (Object)String.valueOf(currentYear));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_yh_taxcredit_data", (String)SJDM_AMOUNT, (QFilter[])new QFilter[]{orgFilter, dateFilter, ndFilter});
        return object != null ? object.getBigDecimal(SJDM_AMOUNT) : BigDecimal.ZERO;
    }

    private DynamicObjectCollection createTaxCredit(Map<String, Object> customParams, BigDecimal dmqynAmount) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        int sbYear = DateUtils.getYearOfDate((Date)skssqq);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter itemtypeFilter = new QFilter("type", "=", (Object)"qysdsnb");
        DynamicObjectCollection sum = new DynamicObjectCollection();
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.addYear((Date)skssqq, (int)-1)).and(new QFilter("skssqz", "=", (Object)DateUtils.addYear((Date)skssqz, (int)-1)));
        DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_declare_main", (String)"id", (QFilter[])new QFilter[]{orgFilter, dateFilter, itemtypeFilter});
        for (int i = 5; i >= 1; --i) {
            DynamicObject hisDynObj = null;
            if (!CollectionUtils.isEmpty((Collection)list)) {
                long ssbId = ((DynamicObject)list.get(0)).getLong("id");
                hisDynObj = this.getQysdsBySbbId(ssbId, i);
            }
            DynamicObject dynamicObject = this.buildForFiveYear(hisDynObj, dmqynAmount, i, sbYear, orgid, sum, skssqq, skssqz);
            sum.add((Object)dynamicObject);
        }
        DynamicObject dynamicObject = this.buildCurrYear(customParams, dmqynAmount, sum, sbYear, orgid, skssqq, skssqz);
        sum.add((Object)dynamicObject);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private DynamicObject buildForFiveYear(DynamicObject hisDynObj, BigDecimal dmqynAmount, int index, long sbYear, long orgid, DynamicObjectCollection list, Date skssqq, Date skssqz) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_yh_taxcredit_data");
        dynamicObject.set(ND, (Object)(sbYear - (long)index));
        dynamicObject.set(ITEM_NO, (Object)(6 - index));
        dynamicObject.set("orgid", (Object)orgid);
        if (null != hisDynObj) {
            BigDecimal bndmqynse = hisDynObj.getBigDecimal(BNDMQYNSE);
            dynamicObject.set(BNDMQYNSE, (Object)bndmqynse);
            BigDecimal bnyxdmdzysbtze = hisDynObj.getBigDecimal(BNYXDMDZYSBTZE);
            dynamicObject.set(BNYXDMDZYSBTZE, (Object)bnyxdmdzysbtze);
            BigDecimal qwnddme = BigDecimal.ZERO;
            BigDecimal qsinddme = BigDecimal.ZERO;
            BigDecimal qsnddme = BigDecimal.ZERO;
            BigDecimal qenddme = BigDecimal.ZERO;
            BigDecimal qynddme = BigDecimal.ZERO;
            if (5 == index) {
                qwnddme = hisDynObj.getBigDecimal(QSINDDME);
                qsinddme = hisDynObj.getBigDecimal(QSNDDME);
                qsnddme = hisDynObj.getBigDecimal(QENDDME);
                qenddme = hisDynObj.getBigDecimal(QYNDDME);
                qynddme = hisDynObj.getBigDecimal(BNSJDMDGNDSE);
            } else if (4 == index) {
                qsinddme = hisDynObj.getBigDecimal(QSNDDME);
                qsnddme = hisDynObj.getBigDecimal(QENDDME);
                qenddme = hisDynObj.getBigDecimal(QYNDDME);
                qynddme = hisDynObj.getBigDecimal(BNSJDMDGNDSE);
            } else if (3 == index) {
                qsnddme = hisDynObj.getBigDecimal(QENDDME);
                qenddme = hisDynObj.getBigDecimal(QYNDDME);
                qynddme = hisDynObj.getBigDecimal(BNSJDMDGNDSE);
            } else if (2 == index) {
                qenddme = hisDynObj.getBigDecimal(QYNDDME);
                qynddme = hisDynObj.getBigDecimal(BNSJDMDGNDSE);
            } else if (1 == index) {
                qynddme = hisDynObj.getBigDecimal(BNSJDMDGNDSE);
            }
            dynamicObject.set(QWNDDME, (Object)qwnddme);
            dynamicObject.set(QSINDDME, (Object)qsinddme);
            dynamicObject.set(QSNDDME, (Object)qsnddme);
            dynamicObject.set(QENDDME, (Object)qenddme);
            dynamicObject.set(QYNDDME, (Object)qynddme);
            BigDecimal kdmse = bnyxdmdzysbtze.multiply(new BigDecimal("0.1"));
            dynamicObject.set(KDMSE, (Object)kdmse);
            BigDecimal xj = qwnddme.add(qsinddme).add(qsnddme).add(qenddme).add(qynddme);
            xj = xj.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : xj;
            dynamicObject.set(XJ, (Object)xj);
            BigDecimal bnkdmse = kdmse.compareTo(xj) >= 0 ? kdmse.subtract(xj) : new BigDecimal(0);
            dynamicObject.set(BNKDMSE, (Object)bnkdmse);
            BigDecimal bd = new BigDecimal("0");
            for (DynamicObject dyn : list) {
                bd = bd.add(dyn.getBigDecimal(BNSJDMDGNDSE));
            }
            BigDecimal temp = bnkdmse.compareTo(dmqynAmount = dmqynAmount.subtract(bd)) < 0 ? bnkdmse : dmqynAmount;
            BigDecimal bnsjdmdgndse = temp.compareTo(new BigDecimal("0")) >= 0 ? temp : new BigDecimal(0);
            dynamicObject.set(BNSJDMDGNDSE, (Object)bnsjdmdgndse);
            BigDecimal kjzyhnddmdse = bnkdmse.subtract(bnsjdmdgndse);
            dynamicObject.set(KJZYHNDDMDSE, (Object)kjzyhnddmdse);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
        }
        return dynamicObject;
    }

    private DynamicObject buildCurrYear(Map<String, Object> customParams, BigDecimal dmqynAmount, DynamicObjectCollection list, long sbYear, long orgid, Date skssqq, Date skssqz) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_yh_taxcredit_data");
        dynamicObject.set(ND, (Object)sbYear);
        dynamicObject.set("orgid", (Object)orgid);
        dynamicObject.set(ITEM_NO, (Object)6);
        BigDecimal bndmqynse = dmqynAmount;
        dynamicObject.set(BNDMQYNSE, (Object)bndmqynse);
        String amount = customParams.get(TAX_AMOUNT) == null || StringUtil.isEmpty((CharSequence)String.valueOf(customParams.get(TAX_AMOUNT))) ? "0" : String.valueOf(customParams.get(TAX_AMOUNT));
        BigDecimal bnyxdmdzysbtze = new BigDecimal(amount);
        dynamicObject.set(BNYXDMDZYSBTZE, (Object)bnyxdmdzysbtze);
        BigDecimal kdmse = bnyxdmdzysbtze.multiply(new BigDecimal("0.1"));
        dynamicObject.set(KDMSE, (Object)kdmse);
        BigDecimal bnkdmse = kdmse;
        dynamicObject.set(BNKDMSE, (Object)bnkdmse);
        BigDecimal bd = new BigDecimal("0");
        for (DynamicObject dyn : list) {
            bd = bd.add(dyn.getBigDecimal(BNSJDMDGNDSE));
        }
        BigDecimal dmqynAmountTmp = dmqynAmount.subtract(bd);
        BigDecimal temp = bnkdmse.compareTo(dmqynAmountTmp) < 0 ? bnkdmse : dmqynAmountTmp;
        BigDecimal bnsjdmdgndse = temp.compareTo(new BigDecimal("0")) >= 0 ? temp : new BigDecimal(0);
        dynamicObject.set(BNSJDMDGNDSE, (Object)bnsjdmdgndse);
        BigDecimal kjzyhnddmdse = bnkdmse.subtract(bnsjdmdgndse);
        dynamicObject.set(KJZYHNDDMDSE, (Object)kjzyhnddmdse);
        BigDecimal bnsjdmdgndseTotal = bd.add(bnsjdmdgndse).compareTo(dmqynAmount) <= 0 ? bd.add(bnsjdmdgndse) : dmqynAmount;
        customParams.put(BNSJDMDGNDSE, bnsjdmdgndseTotal.toString());
        dynamicObject.set(SJDM_AMOUNT, (Object)bnsjdmdgndseTotal);
        dynamicObject.set(YN_AMOUNT, (Object)dmqynAmount.subtract(bnsjdmdgndseTotal));
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        return dynamicObject;
    }

    private DynamicObject getQysdsBySbbId(long ssbId, int index) {
        DynamicObjectCollection list = QueryServiceHelper.query((String)"tccit_qysds_a107050", (String)"bndmqynse,bnyxdmdzysbtze,bnsjdmdgndse,qwnddme,qsinddme,qsnddme,qenddme,qynddme", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(ssbId)), new QFilter("ewblxh", "=", (Object)String.valueOf(7 - index))});
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }

    public void initData(Map<String, Object> customParams, String summaryEntryName, Set<String> itemTypes) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,ruleid,itemname,taxamount";
        DynamicObjectCollection list = QueryServiceHelper.query((String)summaryEntryName, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", list.size() + 1);
        int rowIndex = 0;
        ArrayList<BigDecimal> taxAmountList = new ArrayList<BigDecimal>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)list.get(i);
            model.setValue(ITEM_NO, (Object)dynamicObject.getString(ITEM_NO), rowIndex);
            model.setValue(ITEM_NAME, (Object)dynamicObject.getString(ITEM_NAME), rowIndex);
            Long ruleId = dynamicObject.getLong(RULE_ID);
            model.setValue(RULE_ID, (Object)ruleId, rowIndex);
            model.setValue(TAX_AMOUNT, (Object)this.formatData(dynamicObject.getBigDecimal(TAX_AMOUNT), TAX_AMOUNT, ruleId), rowIndex);
            taxAmountList.add(dynamicObject.getBigDecimal(TAX_AMOUNT));
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.appendRow(customParams, model, rowIndex, taxAmountList);
    }

    public void initTaxCreditData(BigDecimal dmqynAmount) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DynamicObjectCollection list = QueryServiceHelper.query((String)"tccit_yh_taxcredit_data", (String)MetadataUtil.getAllFieldToQuery((String)"tccit_yh_taxcredit_data"), (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)"nd asc");
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity1");
        model.batchCreateNewEntryRow("entryentity1", list.size() + 1);
        int rowIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)list.get(i);
            model.setValue("seqno", (Object)(i + 1), rowIndex);
            model.setValue(ND, (Object)dynamicObject.getString(ND), rowIndex);
            model.setValue(BNDMQYNSE, (Object)this.formatAmount(dynamicObject.getBigDecimal(BNDMQYNSE)), rowIndex);
            model.setValue(BNYXDMDZYSBTZE, (Object)this.formatAmount(dynamicObject.getBigDecimal(BNYXDMDZYSBTZE)), rowIndex);
            model.setValue(QWNDDME, (Object)this.formatAmount(dynamicObject.getBigDecimal(QWNDDME)), rowIndex);
            model.setValue(QSINDDME, (Object)this.formatAmount(dynamicObject.getBigDecimal(QSINDDME)), rowIndex);
            model.setValue(QSNDDME, (Object)this.formatAmount(dynamicObject.getBigDecimal(QSNDDME)), rowIndex);
            model.setValue(QENDDME, (Object)this.formatAmount(dynamicObject.getBigDecimal(QENDDME)), rowIndex);
            model.setValue(QYNDDME, (Object)this.formatAmount(dynamicObject.getBigDecimal(QYNDDME)), rowIndex);
            model.setValue(KDMSE, (Object)this.formatAmount(dynamicObject.getBigDecimal(KDMSE)), rowIndex);
            model.setValue(XJ, (Object)this.formatAmount(dynamicObject.getBigDecimal(XJ)), rowIndex);
            model.setValue(BNKDMSE, (Object)this.formatAmount(dynamicObject.getBigDecimal(BNKDMSE)), rowIndex);
            model.setValue(BNSJDMDGNDSE, (Object)this.formatAmount(dynamicObject.getBigDecimal(BNSJDMDGNDSE)), rowIndex);
            model.setValue(KJZYHNDDMDSE, (Object)(i == 0 ? "*" : this.formatAmount(dynamicObject.getBigDecimal(KJZYHNDDMDSE))), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity1");
        this.appendTaxCreditRow(model, rowIndex, list, dmqynAmount);
    }

    private void appendTaxCreditRow(IDataModel model, int rowIndex, DynamicObjectCollection list, BigDecimal dmqynAmount) {
        model.setValue("seqno", (Object)(rowIndex + 1), rowIndex);
        model.setValue(ND, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"YhTaxCreditFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue(QWNDDME, (Object)this.getSumText(list, QWNDDME), rowIndex);
        model.setValue(QSINDDME, (Object)this.getSumText(list, QSINDDME), rowIndex);
        model.setValue(QSNDDME, (Object)this.getSumText(list, QSNDDME), rowIndex);
        model.setValue(QENDDME, (Object)this.getSumText(list, QENDDME), rowIndex);
        model.setValue(QYNDDME, (Object)this.getSumText(list, QYNDDME), rowIndex);
        model.setValue(KDMSE, (Object)this.getSumText(list, KDMSE), rowIndex);
        model.setValue(XJ, (Object)this.getSumText(list, XJ), rowIndex);
        model.setValue(BNKDMSE, (Object)this.getSumText(list, BNKDMSE), rowIndex);
        BigDecimal bnsjdmdgndse = this.getSum(list, BNSJDMDGNDSE);
        bnsjdmdgndse = bnsjdmdgndse.compareTo(dmqynAmount) <= 0 ? bnsjdmdgndse : dmqynAmount;
        model.setValue(BNSJDMDGNDSE, (Object)this.formatAmount(bnsjdmdgndse), rowIndex);
        model.setValue(KJZYHNDDMDSE, (Object)this.getSumText(list, KJZYHNDDMDSE), rowIndex);
    }

    private String formatData(BigDecimal data, String columnType, Long ruleId) {
        StringBuilder link = new StringBuilder("<nolink>");
        String amount = data.setScale(2, 4).toString();
        if (0L == ruleId) {
            if (columnType.equals(NSTZJE)) {
                return DataFormat.formatMicrometer(amount);
            }
            return link.append(DataFormat.formatMicrometer(amount)).toString();
        }
        return DataFormat.formatMicrometer(amount);
    }

    private String formatAmount(BigDecimal data) {
        String amount = data.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(amount);
    }

    public DynamicObjectCollection calc(Map<String, Object> customParams, String summaryEntryName, Set<String> itemTypes, String ruleDetailEntryName, RuleTypeEnum typeEnum) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz, summaryEntryName, itemTypes);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("taxcredit")) {
            return null;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), typeEnum);
        sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && itemTypes.contains(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList());
        for (DynamicObject dynamicObject : sellRuleList) {
            DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)summaryEntryName);
            String itemNumber = dynamicObject.getDynamicObject("item").getString("number");
            String itemName = dynamicObject.getDynamicObject("item").getString(NAME);
            dynamicObject2.set(ITEM_TYPE, (Object)itemNumber);
            dynamicObject2.set(ITEM_NAME, (Object)itemName);
            dynamicObject2.set(NAME, (Object)dynamicObject.getString(NAME));
            dynamicObject2.set(RULE_ID, (Object)dynamicObject.getString("id"));
            dynamicObject2.set(TAX_AMOUNT, (Object)this.calcAmount(dynamicObject.getString("id"), TAX_AMOUNT, customParams, ruleDetailEntryName, itemNumber));
            dynamicObject2.set("orgid", (Object)orgid);
            dynamicObject2.set("skssqq", (Object)skssqq);
            dynamicObject2.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject2);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])this.mergeDyn(sum).toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private DynamicObjectCollection mergeDyn(DynamicObjectCollection list) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : list) {
            String itemNumber = dynamicObject.getString(ITEM_TYPE);
            DynamicObject dyn = (DynamicObject)map.get(itemNumber);
            if (null == dyn) {
                map.put(itemNumber, dynamicObject);
                continue;
            }
            dynamicObject.set(TAX_AMOUNT, (Object)dyn.getBigDecimal(TAX_AMOUNT).add(dynamicObject.getBigDecimal(TAX_AMOUNT)));
            map.put(itemNumber, dynamicObject);
        }
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            dynamicObject.set(ITEM_NO, (Object)(++index));
            sum.add((Object)dynamicObject);
        }
        return sum;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz, String summaryEntryName, Set<String> itemTypes) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)summaryEntryName, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        DeleteServiceHelper.delete((String)"tccit_yh_taxcredit_data", (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private void appendRow(Map<String, Object> customParams, IDataModel model, int rowIndex, List<BigDecimal> list) {
        customParams.put(TAX_AMOUNT, this.getSum(list).toString());
        model.setValue(ITEM_NO, (Object)(rowIndex + 1), rowIndex);
        model.setValue(ITEM_NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"YhTaxCreditFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue(TAX_AMOUNT, (Object)this.formatData(this.getSum(list), "", 0L), rowIndex);
    }

    private BigDecimal getSum(List<BigDecimal> list) {
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal value : list) {
            sum = sum.add(value);
        }
        return sum;
    }

    private BigDecimal getSum(DynamicObjectCollection list, String key) {
        BigDecimal sum = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : list) {
            sum = sum.add(dynamicObject.getBigDecimal(key));
        }
        return sum;
    }

    private String getSumText(DynamicObjectCollection list, String key) {
        BigDecimal sum = this.getSum(list, key);
        String amount = sum.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(amount);
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, String ruleDetailEntryName, String itemNumber) {
        if (TAX_AMOUNT.equals(columnType)) {
            BigDecimal taxAmount = this.getAmount(rowType, customParams, columnType, "bnyxdmdtze", ruleDetailEntryName);
            return taxAmount;
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(String ruleid, Map<String, Object> customParams, String columnType, String entrytype, String ruleDetailEntryName) {
        return this.getCellAmount(customParams, columnType, entrytype, null, null, Long.valueOf(ruleid), ruleDetailEntryName);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULE_ID));
        if (ruleid.equals("0")) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", "bnyxdmdtze");
        customParams.put(RULE_ID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams, SUMMARY_ENTRY_NAME, this.itemTypes, RULE_DETAIL_ENTRY_NAME, RuleTypeEnum.SSYH);
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"7");
        DynamicObjectCollection list = QueryServiceHelper.query((String)"tccit_setz_jmyhhz_summary", (String)"amountorratio", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        BigDecimal dmqynAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            dmqynAmount = ((DynamicObject)list.get(0)).getBigDecimal("amountorratio");
        }
        this.createTaxCredit(customParams, dmqynAmount);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, SUMMARY_ENTRY_NAME, this.itemTypes);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{TAX_AMOUNT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULE_ID);
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", "bnyxdmdtze");
        customParams.put("columnType", column);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(YhTaxCreditFormPlugin.class.getSimpleName(), Collections.singletonList(DeductPreferentialSummaryPlugin.class.getSimpleName()));
            }
        };
    }
}

