/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.dto.DraftAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class ZczjtxFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ITEM_NO = "itemno";
    public static final String RULEID = "ruleid";
    public static final String ITEM_NAME = "itemname";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ORGID = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    private static final String ZCLX = "zclx";
    private static final String JSZJTXLX = "jszjtxlx";
    private static final String KJZCYZ = "zczzyz";
    private static final String BNKJZJTX = "bnzjtxzzje";
    private static final String LJKJZJTX = "ljzjtxzzje";
    private static final String JSJC = "zcjsjc";
    private static final String BNSWJZTX = "bnsszjtxze";
    private static final String LJSWZJTX = "ljsszjtxje";
    private static final String NSTZ = "nstz";
    private static final String XSJSZJZCDZCASS = "bnxsjszc";
    private static final String JSZJTXTJE = "jszjtxtxtje";
    private static final String BNJSZJTXJE = "bnjszjtxje";
    private static final String LJJSZJTXJE = "ljjszjtxje";
    private static final String SHEETNAME = "sheetname";
    private static final String TREEENTRY_ENTITY = "entryentity";
    private static final LinkedHashSet<Long> JSZJTXLX_NUMBER_ID = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new Long[]{1047847042044562432L, 1047847042044562433L, 1047847042044562434L, 1047847042044562435L, 1047847042044562436L, 1047847042044562437L, 1047847042044562438L, 1047847042044562439L, 1077499487422929920L, 1077499487422929921L, 1077499487422929922L, 1077499487422929923L, 1077499487422929924L, 1387672323133332480L, 1387672323133332481L, 1387672323133332482L, 1387672323133332483L, 1635569381629077504L, 1635569381629077505L, 1635570807944215552L, 1635570807944215553L, 1635570807944215554L, 1635570807944215555L, 1635570807944215556L, 1635570807944215557L, 1635570807944215558L, 1635570807944215559L}));
    private static final LinkedHashSet<Long> ZCLX_NUMBER_ID = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new Long[]{1047826637544131584L, 1047830549621804032L, 1047831307624811520L, 1047831592359332864L, 1047832511733992448L, 1047832511733992449L, 1047833159166757888L, 1047833159166757889L, 1047836115488377856L, 1047836115488377857L, 1047836115488377858L, 1047836115488377859L, 1047836115488377860L, 1047836115488377861L, 1047836115488377862L, 1047836115488377863L, 1047844198574885888L, 1047844862667426816L, 1047844862667426817L, 1047844862667426818L, 1047844862667426819L, 1047845521374481408L, 1047845521374481409L}));
    public final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"1", "701020101", "701020102", "701020103", "701020104", "701020105", "701020106", "2", "701020201", "701020202", "3", "701020301", "701020302", "701020303", "701020304", "701020305", "701020306", "701020307", "701020308", "4", "701020401", "701020402", "701020403", "701020404", "701020405", "5", "701020501", "6", "701020502"});
    private final List<String> fixedRowList = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6"});
    private static final Map<String, String> fixedRowMap = new HashMap<String, String>(16);
    private static final Map<String, List<String>> fixedRowItemMap = new HashMap<String, List<String>>(16);
    private String sheetname;

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREEENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public ZczjtxFormPlugin() {
    }

    public ZczjtxFormPlugin(String sheetname) {
        this.sheetname = sheetname;
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        QFilter sheetFilter = new QFilter(SHEETNAME, "=", (Object)this.sheetname);
        String selectFields = "itemno, itemname, itemtype, zczzyz, bnzjtxzzje, ljzjtxzzje, zcjsjc, bnsszjtxze,ljsszjtxje,nstz,bnxsjszc,bnjszjtxje,ljjszjtxje,jszjtxtxtje,orgid, skssqq, skssqz,ruleid,sheetname";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_zczjtx_summary", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter, sheetFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(TREEENTRY_ENTITY);
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(TREEENTRY_ENTITY);
        DynamicObjectType dynamicObjectType = treeEntryEntity.getDynamicObjectType();
        if ("B105046".equals(this.sheetname)) {
            this.initTreeData(query, model, dynamicObjectType);
        } else {
            this.initData(model, query, dynamicObjectType);
        }
    }

    private void initTreeData(DynamicObjectCollection query, IDataModel model, DynamicObjectType dynamicObjectType) {
        long pid = 0L;
        int itemno = 1;
        int parentItemno = 0;
        ArrayList<Integer> parentItemnoList = new ArrayList<Integer>();
        for (String itemType : this.itemTypes) {
            DynamicObject keyObject;
            if (this.fixedRowList.contains(itemType)) {
                keyObject = new DynamicObject(dynamicObjectType);
                Optional<DynamicObject> isPresentObj = query.stream().filter(e -> fixedRowItemMap.get(itemType).contains(e.getString(ITEM_TYPE))).findFirst();
                if (!isPresentObj.isPresent()) continue;
                int index = this.getModel().createNewEntryRow(TREEENTRY_ENTITY, keyObject);
                keyObject.set("id", (Object)Long.parseLong(itemType));
                keyObject.set("pid", (Object)0L);
                pid = Long.parseLong(itemType);
                this.appendFixedRow(query, model, index, itemType, String.valueOf(++parentItemno));
                parentItemnoList.add(index);
                itemno = 1;
                continue;
            }
            List objects = query.stream().filter(e -> itemType.equals(e.getString(ITEM_TYPE))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(objects)) continue;
            for (DynamicObject dynamicObject : objects) {
                keyObject = new DynamicObject(dynamicObjectType);
                int index = this.getModel().createNewEntryRow(TREEENTRY_ENTITY, keyObject);
                keyObject.set("id", (Object)Long.parseLong(itemType));
                keyObject.set("pid", (Object)pid);
                model.setValue(ITEM_NO, (Object)(parentItemno + "-" + itemno), index);
                model.setValue(RULEID, (Object)dynamicObject.getLong(RULEID), index);
                model.setValue(ITEM_NAME, (Object)dynamicObject.getString(ITEM_NAME), index);
                model.setValue(ZCLX, (Object)dynamicObject.getString(ITEM_TYPE), index);
                model.setValue(BNSWJZTX, (Object)this.formatData(dynamicObject.getBigDecimal(BNSWJZTX)), index);
                model.setValue(LJSWZJTX, (Object)this.formatData(dynamicObject.getBigDecimal(LJSWZJTX)), index);
                model.setValue(NSTZ, (Object)this.formatData(dynamicObject.getBigDecimal(NSTZ)), index);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{JSZJTXLX, XSJSZJZCDZCASS, JSZJTXTJE});
                model.setValue(KJZCYZ, (Object)this.formatData(dynamicObject.getBigDecimal(KJZCYZ)), index);
                model.setValue(BNKJZJTX, (Object)this.formatData(dynamicObject.getBigDecimal(BNKJZJTX)), index);
                model.setValue(LJKJZJTX, (Object)this.formatData(dynamicObject.getBigDecimal(LJKJZJTX)), index);
                model.setValue(JSJC, (Object)this.formatData(dynamicObject.getBigDecimal(JSJC)), index);
                ++itemno;
            }
        }
        model.endInit();
        this.appendCountRow(query, model, model.createNewEntryRow(TREEENTRY_ENTITY), parentItemno);
        this.getView().updateView(TREEENTRY_ENTITY);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRY_ENTITY);
        treeEntryGrid.setCollapse(false);
        treeEntryGrid.collapse(parentItemnoList.stream().mapToInt(Integer::intValue).toArray());
    }

    private void initData(IDataModel model, DynamicObjectCollection query, DynamicObjectType dynamicObjectType) {
        for (DynamicObject dynamicObject : query) {
            DynamicObject keyObject = new DynamicObject(dynamicObjectType);
            int rowIndex = this.getModel().createNewEntryRow(TREEENTRY_ENTITY, keyObject);
            model.setValue(ITEM_NO, (Object)dynamicObject.getString(ITEM_NO), rowIndex);
            model.setValue(RULEID, (Object)dynamicObject.getLong(RULEID), rowIndex);
            model.setValue(ITEM_NAME, (Object)dynamicObject.getString(ITEM_NAME), rowIndex);
            model.setValue(JSZJTXLX, (Object)dynamicObject.getString(ITEM_TYPE), rowIndex);
            model.setValue(BNSWJZTX, (Object)this.formatData(dynamicObject.getBigDecimal(BNJSZJTXJE)), rowIndex);
            model.setValue(XSJSZJZCDZCASS, (Object)this.formatData(dynamicObject.getBigDecimal(XSJSZJZCDZCASS)), rowIndex);
            model.setValue(JSZJTXTJE, (Object)this.formatData(dynamicObject.getBigDecimal(JSZJTXTJE)), rowIndex);
            model.setValue(LJSWZJTX, (Object)this.formatData(dynamicObject.getBigDecimal(LJJSZJTXJE)), rowIndex);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ZCLX, NSTZ});
            model.setValue(KJZCYZ, (Object)this.formatData(dynamicObject.getBigDecimal(KJZCYZ)), rowIndex);
            model.setValue(BNKJZJTX, (Object)this.formatData(dynamicObject.getBigDecimal(BNKJZJTX)), rowIndex);
            model.setValue(LJKJZJTX, (Object)this.formatData(dynamicObject.getBigDecimal(LJKJZJTX)), rowIndex);
            model.setValue(JSJC, (Object)this.formatData(dynamicObject.getBigDecimal(JSJC)), rowIndex);
        }
        model.endInit();
        this.appendCountRow(query, model, model.createNewEntryRow(TREEENTRY_ENTITY), query.size());
        this.getView().updateView(TREEENTRY_ENTITY);
    }

    private void appendFixedRow(DynamicObjectCollection query, IDataModel model, int rowIndex, String itemType, String itemno) {
        model.setValue(ITEM_NO, (Object)itemno, rowIndex);
        model.setValue(RULEID, (Object)0L, rowIndex);
        model.setValue(ITEM_NAME, (Object)fixedRowMap.get(itemType), rowIndex);
        if ("B105046".equals(((DynamicObject)query.get(0)).getString(SHEETNAME))) {
            model.setValue(ZCLX, (Object)"*", rowIndex);
            model.setValue(BNSWJZTX, (Object)("<nolink>" + this.formatData(this.getSum(query, BNSWJZTX, fixedRowItemMap.get(itemType)))), rowIndex);
            model.setValue(LJSWZJTX, (Object)("<nolink>" + this.formatData(this.getSum(query, LJSWZJTX, fixedRowItemMap.get(itemType)))), rowIndex);
            model.setValue(NSTZ, (Object)this.formatData(this.getSum(query, NSTZ, fixedRowItemMap.get(itemType))), rowIndex);
        } else {
            model.setValue(JSZJTXLX, (Object)"*", rowIndex);
            model.setValue(XSJSZJZCDZCASS, (Object)("<nolink>" + this.formatData(this.getSum(query, XSJSZJZCDZCASS, fixedRowItemMap.get(itemType)))), rowIndex);
            model.setValue(JSZJTXTJE, (Object)this.formatData(this.getSum(query, JSZJTXTJE, fixedRowItemMap.get(itemType))), rowIndex);
            model.setValue(BNSWJZTX, (Object)("<nolink>" + this.formatData(this.getSum(query, BNJSZJTXJE, fixedRowItemMap.get(itemType)))), rowIndex);
            model.setValue(LJSWZJTX, (Object)("<nolink>" + this.formatData(this.getSum(query, LJJSZJTXJE, fixedRowItemMap.get(itemType)))), rowIndex);
        }
        model.setValue(KJZCYZ, (Object)("<nolink>" + this.formatData(this.getSum(query, KJZCYZ, fixedRowItemMap.get(itemType)))), rowIndex);
        model.setValue(BNKJZJTX, (Object)("<nolink>" + this.formatData(this.getSum(query, BNKJZJTX, fixedRowItemMap.get(itemType)))), rowIndex);
        model.setValue(LJKJZJTX, (Object)("<nolink>" + this.formatData(this.getSum(query, LJKJZJTX, fixedRowItemMap.get(itemType)))), rowIndex);
        model.setValue(JSJC, (Object)("<nolink>" + this.formatData(this.getSum(query, JSJC, fixedRowItemMap.get(itemType)))), rowIndex);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex, int parentItemno) {
        model.setValue(ITEM_NO, (Object)(++parentItemno), rowIndex);
        model.setValue(RULEID, (Object)0L, rowIndex);
        model.setValue(ITEM_NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ZczjtxFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        if ("B105046".equals(((DynamicObject)query.get(0)).getString(SHEETNAME))) {
            model.setValue(ZCLX, (Object)"*", rowIndex);
            model.setValue(BNSWJZTX, (Object)("<nolink>" + this.formatData(this.getSum(query, BNSWJZTX))), rowIndex);
            model.setValue(LJSWZJTX, (Object)("<nolink>" + this.formatData(this.getSum(query, LJSWZJTX))), rowIndex);
            model.setValue(NSTZ, (Object)this.formatData(this.getSum(query, NSTZ)), rowIndex);
        } else {
            model.setValue(JSZJTXLX, (Object)"*", rowIndex);
            model.setValue(XSJSZJZCDZCASS, (Object)("<nolink>" + this.formatData(this.getSum(query, XSJSZJZCDZCASS))), rowIndex);
            model.setValue(JSZJTXTJE, (Object)this.formatData(this.getSum(query, JSZJTXTJE)), rowIndex);
            model.setValue(BNSWJZTX, (Object)("<nolink>" + this.formatData(this.getSum(query, BNJSZJTXJE))), rowIndex);
            model.setValue(LJSWZJTX, (Object)("<nolink>" + this.formatData(this.getSum(query, LJJSZJTXJE))), rowIndex);
        }
        model.setValue(KJZCYZ, (Object)("<nolink>" + this.formatData(this.getSum(query, KJZCYZ))), rowIndex);
        model.setValue(BNKJZJTX, (Object)("<nolink>" + this.formatData(this.getSum(query, BNKJZJTX))), rowIndex);
        model.setValue(LJKJZJTX, (Object)("<nolink>" + this.formatData(this.getSum(query, LJKJZJTX))), rowIndex);
        model.setValue(JSJC, (Object)("<nolink>" + this.formatData(this.getSum(query, JSJC))), rowIndex);
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name, List<String> itemList) {
        return query.stream().filter(e -> itemList.contains(e.getString(ITEM_TYPE))).map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String formatData(BigDecimal data) {
        String text = data.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(text);
    }

    public DynamicObjectCollection calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String sheetname = (String)customParams.get(SHEETNAME);
        this.clearCurrentPeriod(orgid, skssqq, skssqz, sheetname);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("asset1")) {
            return null;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<DynamicObject> sellRuleListTotal = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.ASSETS);
        List<Object> sellRuleList = new ArrayList();
        if ("B105046".equals(sheetname)) {
            sellRuleList = sellRuleListTotal.stream().filter(p -> p.get("item") != null && ZCLX_NUMBER_ID.contains(p.getDynamicObject("item").getPkValue())).collect(Collectors.toList());
        } else if ("B105046-1".equals(sheetname)) {
            sellRuleList = sellRuleListTotal.stream().filter(p -> p.get("item") != null && JSZJTXLX_NUMBER_ID.contains(p.getDynamicObject("item").getPkValue())).collect(Collectors.toList());
        }
        int index = 0;
        List<String> entryTypeList = Arrays.asList(KJZCYZ, BNKJZJTX, LJKJZJTX, JSJC, BNSWJZTX, LJSWZJTX, BNJSZJTXJE, LJJSZJTXJE, XSJSZJZCDZCASS);
        List<Long> ruleList = sellRuleList.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        List<DraftAmountDto> amountList = this.getCellAmountList(customParams, entryTypeList, null, ruleList, "tccit_zczjtx_detail");
        for (DynamicObject dynamicObject : sellRuleList) {
            DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)"tccit_zczjtx_summary");
            dynamicObject2.set(ITEM_NO, (Object)(++index));
            dynamicObject2.set(ITEM_NAME, (Object)dynamicObject.getString("name"));
            dynamicObject2.set(RULEID, (Object)dynamicObject.getLong("id"));
            dynamicObject2.set(ITEM_TYPE, (Object)dynamicObject.getDynamicObject("item").getString("number"));
            dynamicObject2.set(SHEETNAME, (Object)sheetname);
            dynamicObject2.set(KJZCYZ, (Object)this.getAmount(amountList, KJZCYZ, dynamicObject.getString("id")));
            BigDecimal bnkjzjtx = this.getAmount(amountList, BNKJZJTX, dynamicObject.getString("id"));
            dynamicObject2.set(BNKJZJTX, (Object)bnkjzjtx);
            dynamicObject2.set(LJKJZJTX, (Object)this.getAmount(amountList, LJKJZJTX, dynamicObject.getString("id")));
            dynamicObject2.set(JSJC, (Object)this.getAmount(amountList, JSJC, dynamicObject.getString("id")));
            if ("B105046".equals(sheetname)) {
                BigDecimal bnswjztx = this.getAmount(amountList, BNSWJZTX, dynamicObject.getString("id"));
                dynamicObject2.set(BNSWJZTX, (Object)bnswjztx);
                dynamicObject2.set(LJSWZJTX, (Object)this.getAmount(amountList, LJSWZJTX, dynamicObject.getString("id")));
                dynamicObject2.set(NSTZ, (Object)bnkjzjtx.subtract(bnswjztx).setScale(2, 4));
            } else {
                BigDecimal bnjszjtxje = this.getAmount(amountList, BNJSZJTXJE, dynamicObject.getString("id"));
                dynamicObject2.set(BNJSZJTXJE, (Object)bnjszjtxje);
                dynamicObject2.set(BNSWJZTX, (Object)bnjszjtxje);
                dynamicObject2.set(LJJSZJTXJE, (Object)this.getAmount(amountList, LJJSZJTXJE, dynamicObject.getString("id")));
                BigDecimal xsjszjzcdzcass = this.getAmount(amountList, XSJSZJZCDZCASS, dynamicObject.getString("id"));
                dynamicObject2.set(XSJSZJZCDZCASS, (Object)xsjszjzcdzcass);
                dynamicObject2.set(JSZJTXTJE, (Object)bnjszjtxje.subtract(xsjszjzcdzcass).setScale(2, 4));
            }
            dynamicObject2.set(ORGID, (Object)orgid);
            dynamicObject2.set(SKSSQQ, (Object)skssqq);
            dynamicObject2.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject2);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private BigDecimal getAmount(List<DraftAmountDto> amountList, String entryType, String ruleId) {
        if (CollectionUtils.isEmpty(amountList)) {
            return BigDecimal.ZERO;
        }
        return amountList.stream().filter(e -> e.getRuleId().equals(ruleId) && e.getEntrytype().equals(entryType)).map(s -> s.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz, String sheetname) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter sheetFilter = new QFilter(SHEETNAME, "=", (Object)sheetname);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_zczjtx_summary", (QFilter[])new QFilter[]{orgFilter, dateFilter, sheetFilter});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.sheetname = (String)customParams.get(SHEETNAME);
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, String ruleid) {
        return this.getCellAmount(customParams, null, entrytype, null, null, Long.valueOf(ruleid), "tccit_zczjtx_detail");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULEID));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String sheetname = (String)customParams.get(SHEETNAME);
        String fieldName = evt.getFieldName();
        customParams.put("entrytype", fieldName);
        if (sheetname.equals("B105046-1")) {
            if (BNSWJZTX.equals(fieldName)) {
                customParams.put("entrytype", BNJSZJTXJE);
            } else if (LJSWZJTX.equals(fieldName)) {
                customParams.put("entrytype", LJJSZJTXJE);
            }
        }
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", "tccit_zczjtx_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        ArrayList sheetnames = Lists.newArrayList((Object[])new String[]{"B105046", "B105046-1"});
        for (String sheetname : sheetnames) {
            Long orgid = Long.parseLong(model.getOrgId());
            Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
            Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
            this.clearCurrentPeriod(orgid, skssqq, skssqz, sheetname);
        }
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{KJZCYZ, BNKJZJTX, LJKJZJTX, JSJC, BNSWJZTX, XSJSZJZCDZCASS, JSZJTXTJE, LJSWZJTX});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULEID);
        customParams.put("entryname", "tccit_zczjtx_detail");
        customParams.put("entrytype", this.getEntryType(customParams, column));
        customParams.put("columnType", column);
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }

    private String getEntryType(Map<String, Object> customParams, String column) {
        String entrytype = column;
        String sheetname = (String)customParams.get(SHEETNAME);
        if (sheetname.equals("B105046-1")) {
            if (BNSWJZTX.equals(column)) {
                customParams.put("entrytype", BNJSZJTXJE);
                entrytype = BNJSZJTXJE;
            } else if (LJSWZJTX.equals(column)) {
                customParams.put("entrytype", LJJSZJTXJE);
                entrytype = LJJSZJTXJE;
            }
        }
        return entrytype;
    }

    static {
        fixedRowMap.put("1", ResManager.loadKDString((String)"\u56fa\u5b9a\u8d44\u4ea7", (String)"ZczjtxFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        fixedRowMap.put("2", ResManager.loadKDString((String)"\u751f\u4ea7\u6027\u751f\u7269", (String)"ZczjtxFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
        fixedRowMap.put("3", ResManager.loadKDString((String)"\u65e0\u5f62\u8d44\u4ea7", (String)"ZczjtxFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
        fixedRowMap.put("4", ResManager.loadKDString((String)"\u957f\u671f\u5f85\u644a\u8d39", (String)"ZczjtxFormPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
        fixedRowMap.put("5", ResManager.loadKDString((String)"\u6cb9\u6c14\u52d8\u63a2\u6295", (String)"ZczjtxFormPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
        fixedRowMap.put("6", ResManager.loadKDString((String)"\u6cb9\u6c14\u5f00\u53d1\u6295", (String)"ZczjtxFormPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
        fixedRowItemMap.put("1", Lists.newArrayList((Object[])new String[]{"701020101", "701020102", "701020103", "701020104", "701020105", "701020106"}));
        fixedRowItemMap.put("2", Lists.newArrayList((Object[])new String[]{"701020201", "701020202"}));
        fixedRowItemMap.put("3", Lists.newArrayList((Object[])new String[]{"701020301", "701020302", "701020303", "701020304", "701020305", "701020306", "701020307", "701020308"}));
        fixedRowItemMap.put("4", Lists.newArrayList((Object[])new String[]{"701020401", "701020402", "701020403", "701020404", "701020405"}));
        fixedRowItemMap.put("5", Lists.newArrayList((Object[])new String[]{"701020501"}));
        fixedRowItemMap.put("6", Lists.newArrayList((Object[])new String[]{"701020502"}));
    }
}

