/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class ZeroRatingFormPlugin
extends AbstractEngine
implements Observer {
    public static final String BIZNO = "bizno";
    public static final String INCOME_DATE = "incomedate";
    public static final String TYPE = "type";
    public static final String FISCAL_AMOUNT = "fiscalamount";
    public static final String ZERO_RATING_AMOUNT = "zeroratingamount";
    public static final String YEAR = "year";
    public static final String INCOME_DATE_YEAR = "incomedateyear";
    public static final String INCOME_AMOUNT = "incomeamount";
    public static final String PAYAMOUNT = "payamount";
    public static final String EXPENSING_AMOUNT = "expensingamount";
    public static final String BALANCE_AMOUNT = "balanceamount";
    public static final String FINANCIAL_AMOUNT = "financialamount";
    public static final String INCLUDED_TAX_AMOUNT = "includedtaxamount";
    public static final String ORGID = "orgid";
    public static final String PARENT_ORGID = "parentorgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    private static final String SUMMARY_ENTITY_NAME = "tccit_zero_rating_summary";
    private static final String SUM_INCOME_AMOUNT = "sumincomeamount";
    private static final String SUM_PAYAMOUNT = "sumpayamount";
    private static final String SUM_INCLUDED_AMOUNT = "sumincludedamount";
    private static final String BILLLISTAP = "billlistap";

    public void initialize() {
        super.initialize();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        final QFilter orgFilter = new QFilter(PARENT_ORGID, "=", (Object)orgid);
        final QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        int currentYear = DateUtils.getYearOfDate((Date)skssqq);
        final QFilter yearFilter = new QFilter("entryentity.year", "<=", (Object)currentYear);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                setFilterEvent.addCustomQFilter(orgFilter);
                setFilterEvent.addCustomQFilter(dateFilter);
                setFilterEvent.addCustomQFilter(yearFilter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgidFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        int currentYear = DateUtils.getYearOfDate((Date)skssqq);
        List<DynamicObject> list = this.querySummeryData(SUMMARY_ENTITY_NAME, orgidFilter, dateFilter);
        this.setValue(list, currentYear);
    }

    private List<DynamicObject> querySummeryData(String entityName, QFilter orgidFilter, QFilter dateFilter) {
        DynamicObjectCollection ids = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{dateFilter, orgidFilter});
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            DynamicObject[] levelData = BusinessDataServiceHelper.load((Object[])ids.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
            return Arrays.asList(levelData);
        }
        return new ArrayList<DynamicObject>();
    }

    private void setValue(List<DynamicObject> list, int currentYear) {
        this.getModel().setValue(SUM_INCOME_AMOUNT, (Object)this.getCurretYearSum(list, INCOME_AMOUNT, currentYear).multiply(new BigDecimal("-1")));
        this.getModel().setValue(SUM_PAYAMOUNT, (Object)this.getCurretYearSum(list, EXPENSING_AMOUNT, currentYear));
        this.getModel().setValue(SUM_INCLUDED_AMOUNT, (Object)this.getCurretYearSum(list, INCLUDED_TAX_AMOUNT, currentYear));
    }

    private BigDecimal getCurretYearSum(List<DynamicObject> list, String field, int year) {
        if (CollectionUtils.isEmpty(list)) {
            return BigDecimal.ZERO;
        }
        return list.stream().flatMap(s -> s.getDynamicObjectCollection("entryentity").stream().filter(e -> e.getInt(YEAR) == year)).map(s -> s.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private DynamicObjectCollection calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("income9")) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List<DynamicObject> middList = this.queryZeroRatingMidd(customParams);
        if (CollectionUtils.isEmpty(middList)) {
            return null;
        }
        List<DynamicObject> filterList = middList.stream().filter(s -> this.getEnableBizNos(middList).contains(s.getString(BIZNO))).collect(Collectors.toList());
        Map<String, List<DynamicObject>> groupMap = filterList.stream().collect(Collectors.groupingBy(s -> s.getString(BIZNO)));
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> values = entry.getValue();
            DynamicObject first = values.get(0);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)SUMMARY_ENTITY_NAME);
            dynamicObject.set(INCOME_DATE, (Object)first.getDate(INCOME_DATE));
            dynamicObject.set(TYPE, (Object)first.getString(TYPE));
            dynamicObject.set(FISCAL_AMOUNT, (Object)first.getBigDecimal(FISCAL_AMOUNT));
            BigDecimal zeroRatingAmount = first.getBigDecimal(ZERO_RATING_AMOUNT);
            dynamicObject.set(ZERO_RATING_AMOUNT, (Object)zeroRatingAmount);
            dynamicObject.set(ORGID, (Object)first.getLong(ORGID));
            dynamicObject.set(PARENT_ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            dynamicObject.set(INCOME_DATE_YEAR, (Object)DateUtils.getYearOfDate((Date)first.getDate(INCOME_DATE)));
            for (DynamicObject middle : values) {
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObject row = entryEntity.addNew();
                int year = middle.getInt(YEAR);
                String bizNo = middle.getString(BIZNO);
                row.set(YEAR, (Object)year);
                row.set(INCOME_AMOUNT, (Object)middle.getBigDecimal(INCOME_AMOUNT));
                row.set(PAYAMOUNT, (Object)middle.getBigDecimal(PAYAMOUNT));
                row.set(EXPENSING_AMOUNT, (Object)middle.getBigDecimal(EXPENSING_AMOUNT));
                row.set(BALANCE_AMOUNT, this.getBalanceamount(zeroRatingAmount, year, bizNo, filterList));
                row.set(FINANCIAL_AMOUNT, (Object)middle.getBigDecimal(FINANCIAL_AMOUNT));
                row.set(INCLUDED_TAX_AMOUNT, (Object)middle.getBigDecimal(INCLUDED_TAX_AMOUNT));
            }
            sum.add((Object)dynamicObject);
        }
        if (!CollectionUtils.isEmpty((Collection)sum)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        }
        return sum;
    }

    private Set<String> getEnableBizNos(List<DynamicObject> middList) {
        List biznos = middList.stream().map(s -> s.getString(BIZNO)).collect(Collectors.toList());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_zero_rating_inout", (String)"billstatus,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", biznos), new QFilter("billstatus", "in", (Object)"1")});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return Sets.newHashSet();
        }
        return query.stream().map(s -> s.getString("billno")).collect(Collectors.toSet());
    }

    private Object getBalanceamount(BigDecimal zeroRatingAmount, int year, String number, List<DynamicObject> list) {
        BigDecimal sumPayAmount = list.stream().filter(s -> s.getString(BIZNO).equals(number) && s.getInt(YEAR) <= year).map(s -> s.getBigDecimal(PAYAMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return zeroRatingAmount.subtract(sumPayAmount);
    }

    private List<DynamicObject> queryZeroRatingMidd(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        List<Long> orgIds = OrgGroupService.getOrgIds(orgid, skssqq, skssqz);
        QFilter orgFilter = new QFilter(ORGID, "in", orgIds);
        String selectFields = "orgid,bizno,incomedate,type,fiscalamount,zeroratingamount,year,incomeamount,payamount,expensingamount,balanceamount,financialamount,includedtaxamount";
        DynamicObjectCollection middList = QueryServiceHelper.query((String)"tccit_zero_rating_middle", (String)selectFields, (QFilter[])new QFilter[]{orgFilter});
        int currentYear = DateUtils.getYearOfDate((Date)skssqq);
        int beforeFiveYear = currentYear - 5;
        return middList.stream().filter(s -> {
            int incomeDate = DateUtils.getYearOfDate((Date)s.getDate(INCOME_DATE));
            return incomeDate <= currentYear && incomeDate >= beforeFiveYear;
        }).collect(Collectors.toList());
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(PARENT_ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)SUMMARY_ENTITY_NAME, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }
}

