/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.apphome;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TccitAppHomePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TccitAppHomePlugin.class);
    private Map<Integer, String> monthMap = new HashMap<Integer, String>(){
        {
            this.put(1, "january");
            this.put(2, "february");
            this.put(3, "march");
            this.put(4, "april");
            this.put(5, "may");
            this.put(6, "june");
            this.put(7, "july");
            this.put(8, "august");
            this.put(9, "september");
            this.put(10, "october");
            this.put(11, "november");
            this.put(12, "december");
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        List hasPermOrgList = OrgCheckUtil.hasPermOrgList((HasPermOrgResult)hasPermOrgs);
        this.getPageCache().put("orgList", SerializationUtils.toJsonString((Object)hasPermOrgList));
        Object object = this.getModel().getValue("org");
        Long orgid = null;
        if (object == null) {
            orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (List)hasPermOrgList);
            if (null == orgid) {
                return;
            }
            if (OrgCheckUtil.check((IFormView)this.getView(), (String)String.valueOf(orgid), (String)"tccit", (String)"qysds")) {
                orgid = null;
            }
        } else {
            orgid = ((DynamicObject)object).getLong("id");
        }
        this.getModel().setValue("org", (Object)orgid);
        this.refreshCache();
    }

    private void refreshCache() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getPageCache().remove("org");
            return;
        }
        this.getPageCache().put("org", org.getString("id"));
        if (this.getPageCache().get("period_" + org.getPkValue()) != null) {
            return;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
        if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData()) || ((DynamicObject)result.getData()).getLong("registeraddress") == 0L) {
            return;
        }
        DynamicObject registerAddress = this.getAdmindivision(((DynamicObject)result.getData()).getLong("registeraddress"));
        if (registerAddress == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u7ef4\u62a4\u8be5\u7ec4\u7ec7\uff08%s\uff09\u6ce8\u518c\u767b\u8bb0\u533a\u57df", (String)"TccitAppHomePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), org.getString("name")));
            return;
        }
        long level = registerAddress.getLong("basedatafield");
        long provinceid = 0L;
        long cityid = -1L;
        if (level == 1L) {
            provinceid = registerAddress.getLong("id");
        } else if (level == 2L) {
            cityid = registerAddress.getLong("id");
            provinceid = registerAddress.getLong("parent");
        } else if (level == 3L) {
            cityid = registerAddress.getLong("parent");
            DynamicObject city = this.getAdmindivision(cityid);
            provinceid = city.getLong("parent");
        }
        QFilter provinceFilter = new QFilter("entryentity.provinces", "=", (Object)provinceid);
        QFilter cityFilter = new QFilter("entryentity.city", "=", (Object)cityid);
        QFilter taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"2");
        QFilter methodsFilter = new QFilter("entryentity.methods", "=", (Object)"1");
        Date now = new Date();
        int year = now.getYear() + 1900;
        int month = now.getMonth() + 1;
        QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
        DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)"tpo_tax_calendar", (String)("id, entryentity." + this.monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{provinceFilter, cityFilter, taxtypeFilter, methodsFilter, yearFilter});
        if (dynamicObjects == null) {
            dynamicObjects = QueryServiceHelper.queryOne((String)"tpo_tax_calendar", (String)("id, entryentity." + this.monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{provinceFilter, taxtypeFilter, methodsFilter, yearFilter});
        }
        if (dynamicObjects != null) {
            String datestr = dynamicObjects.getString("date");
            try {
                Date date = DateUtils.stringToDate((String)String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s", (String)"TccitAppHomePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), year, datestr), (String)DateUtils.YYYYMMDD_CHINESE);
                String period = now.after(date) ? DateUtils.formatMonth((Date)now) : DateUtils.getLastMonthFirstDateStr((String)"yyyy-MM");
                this.getPageCache().put("period_" + org.getPkValue(), period);
            }
            catch (Exception e) {
                logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private DynamicObject getAdmindivision(Long id) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id, parent, basedatafield", (QFilter[])new QFilter[]{idFilter});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("org".equals(e.getProperty().getName())) {
            ChangeData[] changeData = e.getChangeSet();
            if (changeData != null && changeData.length > 0) {
                DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                if (null == newOrg) {
                    this.getView().getModel().setValue("org", (Object)this.getPageCache().get("org"));
                    return;
                }
                String neworgid = newOrg.getString("id");
                String appid = this.getView().getFormShowParameter().getAppId();
                if (OrgCheckUtil.check((IFormView)this.getView(), (String)neworgid, (String)appid, (String)"qysds")) {
                    this.getView().getModel().setValue("org", (Object)this.getPageCache().get("org"));
                }
            }
            this.refreshCache();
            this.refreshView();
        }
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshView();
        }
    }
}

