/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.apphome;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.taxdeclare.address.AddressUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TccitCalendarInComePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TccitCalendarInComePlugin.class);
    private static final String entity = "tctb_tax_main";
    private static final String REGISTER_ADDR = "registeraddress";
    private static final String ENTITY_CATEGORY = "categoryentryentity";
    private static final String ENABLE_FIELD = "enable";
    private static final String ENTITY_CALENDAR = "tpo_tax_calendar";
    private static final String TAX_TYPE = "taxtype";
    private static final String PAYMENT_PERIOD = "deadline";
    private static Map<Integer, String> monthMap = new HashMap<Integer, String>();
    private String[] heads = new String[]{ResManager.loadKDString((String)"\u65e5", (String)"TccitCalendarInComePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"TccitCalendarInComePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"TccitCalendarInComePlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"TccitCalendarInComePlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"TccitCalendarInComePlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"TccitCalendarInComePlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"TccitCalendarInComePlugin_6", (String)"taxc-tccit", (Object[])new Object[0])};
    private static Map<String, String> CATEGORY_MAP;
    private static Map<String, String> METHOD_MAP;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flexleft", "flexright"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("datefield".equals(e.getProperty().getName())) {
            try {
                Date date = (Date)this.getModel().getValue("datefield");
                this.setDateFlex(date);
            }
            catch (Exception e1) {
                logger.error(e1.getMessage());
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        Date date = (Date)this.getModel().getValue("datefield");
        if (date == null) {
            return;
        }
        int day = 0;
        if ("flexleft".equals(key)) {
            day = -1;
        } else if ("flexright".equals(key)) {
            day = 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, day);
        calendar.set(5, 1);
        Date d = calendar.getTime();
        this.getModel().setValue("datefield", (Object)d);
    }

    public void createNewData(BizDataEventArgs e) {
        try {
            Date date = new Date();
            this.setDateFlex(date);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage());
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.addhead();
    }

    private void addhead() {
        Container head = (Container)this.getView().getControl("flex_head");
        ArrayList<Map> list = new ArrayList<Map>();
        for (String titleString : this.heads) {
            FlexPanelAp flexAp = this.getFlexPanelAp(titleString);
            flexAp.getItems().add(this.getLabelAp(titleString));
            flexAp.setStyle(this.getStyle(this.getMargin()));
            list.add(flexAp.createControl());
        }
        head.addControls(list);
    }

    private Style getStyle(Margin margin) {
        Style style = new Style();
        style.setMargin(margin);
        return style;
    }

    private Margin getMargin() {
        Margin margin = new Margin();
        margin.setBottom("2px");
        margin.setTop("2px");
        margin.setLeft("2px");
        margin.setRight("2px");
        return margin;
    }

    private LabelAp getLabelAp(String titleString) {
        LabelAp title = new LabelAp();
        title.setKey(titleString);
        title.setName(new LocaleString(titleString));
        title.setTextAlign("center");
        title.setFontSize(12);
        return title;
    }

    private FlexPanelAp getFlexPanelAp(String titleString) {
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey("panel" + titleString);
        flexAp.setDirection("column");
        flexAp.setAlignItems("center");
        flexAp.setGrow(1);
        flexAp.setJustifyContent("flex-start");
        flexAp.setShrink(1);
        return flexAp;
    }

    private Map<String, String> getTaxInfos(Date date) {
        long orgId;
        try {
            Object value = this.getView().getParentView().getModel().getValue("org");
            orgId = value != null ? ((DynamicObject)value).getLong("id") : 0L;
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
        QFilter q1 = new QFilter("orgid", "=", (Object)orgId);
        QFilter q2 = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
        DynamicObject dynamic = BusinessDataServiceHelper.loadSingle((String)entity, (String)StringUtils.join((Object[])new String[]{REGISTER_ADDR, "id"}, (String)","), (QFilter[])new QFilter[]{q1, q2});
        if (dynamic == null) {
            return null;
        }
        DynamicObject dobj = BusinessDataServiceHelper.loadSingle((Object)dynamic.getLong("id"), (String)entity);
        if (dobj == null) {
            return null;
        }
        DynamicObject datedobj = AddressUtils.getAdmindivision((Long)dynamic.getLong(REGISTER_ADDR));
        if (datedobj == null) {
            return null;
        }
        long level = datedobj.getLong("basedatafield.level");
        long provinceid = 0L;
        long cityid = -1L;
        if (level == 1L) {
            provinceid = datedobj.getLong("id");
        } else if (level == 2L) {
            cityid = datedobj.getLong("id");
            provinceid = datedobj.getLong("parent");
        } else if (level == 3L) {
            cityid = datedobj.getLong("parent");
            DynamicObject city = AddressUtils.getAdmindivision((Long)cityid);
            provinceid = city.getLong("parent");
        } else if (level > 3L) {
            long streetid = 0L;
            streetid = datedobj.getLong("parent");
            DynamicObject area = AddressUtils.getAdmindivision((Long)streetid);
            cityid = area.getLong("parent");
            DynamicObject city = AddressUtils.getAdmindivision((Long)cityid);
            provinceid = city.getLong("parent");
        }
        QFilter provinceFilter = new QFilter("entryentity.provinces", "=", (Object)provinceid);
        QFilter cityFilter = new QFilter("entryentity.city", "=", (Object)cityid);
        HashMap<String, String> targetMap = new HashMap<String, String>();
        DynamicObjectCollection cateColl = dobj.getDynamicObjectCollection(ENTITY_CATEGORY);
        if (cateColl != null && !cateColl.isEmpty()) {
            for (DynamicObject d : cateColl) {
                if (!"1".equals(d.getString(ENABLE_FIELD))) continue;
                QFilter taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)CATEGORY_MAP.get(d.getString(TAX_TYPE)));
                QFilter methodsFilter = null;
                if ("zzs".equals(d.getString(TAX_TYPE)) || "qysds".equals(d.getString(TAX_TYPE))) {
                    methodsFilter = new QFilter("entryentity.methods", "=", (Object)METHOD_MAP.get(d.getString(PAYMENT_PERIOD)));
                }
                Date methodDate = this.getInfoFromCalendar(provinceFilter, cityFilter, taxtypeFilter, methodsFilter, date);
                targetMap.put(d.getString(TAX_TYPE), DateUtils.format((Date)methodDate));
            }
        }
        return targetMap;
    }

    private Date getInfoFromCalendar(QFilter provinceFilter, QFilter cityFilter, QFilter taxtypeFilter, QFilter methodsFilter, Date taxmethod) {
        String datestr;
        int year = taxmethod.getYear() + 1900;
        int month = taxmethod.getMonth() + 1;
        QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
        Date date = null;
        DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)ENTITY_CALENDAR, (String)("id, entryentity." + monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{provinceFilter, cityFilter, taxtypeFilter, methodsFilter, yearFilter});
        if (dynamicObjects == null) {
            dynamicObjects = QueryServiceHelper.queryOne((String)ENTITY_CALENDAR, (String)("id, entryentity." + monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{provinceFilter, taxtypeFilter, methodsFilter, yearFilter});
        }
        if (dynamicObjects != null && (datestr = dynamicObjects.getString("date")) != null && datestr.indexOf(ResManager.loadKDString((String)"\u6708", (String)"TccitCalendarInComePlugin_7", (String)"taxc-tccit", (Object[])new Object[0])) > 0 && datestr.indexOf(ResManager.loadKDString((String)"\u65e5", (String)"TccitCalendarInComePlugin_0", (String)"taxc-tccit", (Object[])new Object[0])) > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, year);
            calendar.set(2, Integer.parseInt(datestr.substring(0, datestr.indexOf(ResManager.loadKDString((String)"\u6708", (String)"TccitCalendarInComePlugin_7", (String)"taxc-tccit", (Object[])new Object[0])))) - 1);
            calendar.set(5, Integer.parseInt(datestr.substring(datestr.indexOf(ResManager.loadKDString((String)"\u6708", (String)"TccitCalendarInComePlugin_7", (String)"taxc-tccit", (Object[])new Object[0])) + 1, datestr.indexOf(ResManager.loadKDString((String)"\u65e5", (String)"TccitCalendarInComePlugin_0", (String)"taxc-tccit", (Object[])new Object[0])))));
            date = calendar.getTime();
        }
        return date;
    }

    private void setDateFlex(Date date) {
        Date current = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int week = calendar.get(7);
        int max = calendar.getActualMaximum(5);
        calendar.add(5, 0 - week);
        int index = 0;
        SimpleDateFormat dfdd = new SimpleDateFormat("dd");
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cdar = Calendar.getInstance();
        cdar.setTime(date);
        cdar.set(5, 15);
        Map<String, String> infoMap = this.getTaxInfos(date);
        Container flexpanelap = (Container)this.getView().getControl("flexcontent");
        flexpanelap.deleteControls(new String[]{"row0", "row1", "row2", "row3", "row4", "row5"});
        ArrayList<Map> listitem = new ArrayList<Map>();
        for (int i = 0; i < 6 && index < 42; ++i) {
            FlexPanelAp flexRow = this.getFlexPanelAp(i);
            for (int j = 0; j <= 6 && index < 42; ++index, ++j) {
                calendar.add(5, 1);
                FlexPanelAp flexAp = new FlexPanelAp();
                flexAp.setKey("panel_day" + dfdd.format(calendar.getTime()));
                flexAp.setDirection("column");
                flexAp.setAlignItems("center");
                flexAp.setAlignSelf("stretch");
                flexAp.setGrow(1);
                flexAp.setShrink(1);
                flexAp.setHeight(new LocaleString("100%"));
                LabelAp title = new LabelAp();
                title.setKey("day" + dfdd.format(calendar.getTime()));
                if (dfnyr.format(current.getTime()).equals(dfnyr.format(calendar.getTime()))) {
                    title.setName(new LocaleString(ResManager.loadKDString((String)"\u4eca", (String)"TccitCalendarInComePlugin_8", (String)"taxc-tccit", (Object[])new Object[0])));
                    title.setBackColor("#5F89F3");
                    title.setForeColor("rgba(255,255,255,1)");
                } else {
                    String value;
                    title.setName(new LocaleString(dfdd.format(calendar.getTime())));
                    if (infoMap != null && !infoMap.isEmpty() && StringUtils.trimToEmpty((String)(value = infoMap.get("qysds"))).equals(dfnyr.format(calendar.getTime()))) {
                        title.setBackColor("#FC8555");
                        title.setForeColor("rgba(255,255,255,1)");
                    }
                }
                title.setTextAlign("center");
                title.setFontSize(12);
                title.setRadius("50%");
                flexAp.getItems().add(title);
                Margin customMargin = this.getCustomMargin();
                Padding padding = new Padding();
                padding.setTop("5px");
                padding.setBottom("5px");
                padding.setLeft("7px");
                padding.setRight("7px");
                Style style = new Style();
                style.setPadding(padding);
                flexAp.setBackColor("#ffffff");
                title.setStyle(style);
                if (index < week - 1) {
                    flexAp.setForeColor("#ccc");
                }
                if (index - week - max + 2 > 0) {
                    flexAp.setForeColor("#ccc");
                }
                flexRow.getItems().add(flexAp);
                flexAp.setClickable(true);
                this.addClickListeners(new String[]{flexAp.getKey()});
            }
            listitem.add(flexRow.createControl());
        }
        flexpanelap.addControls(listitem);
    }

    private Margin getCustomMargin() {
        Margin margin = new Margin();
        margin.setTop("1px");
        margin.setLeft("1px");
        return margin;
    }

    private FlexPanelAp getFlexPanelAp(int i) {
        FlexPanelAp flexRow = new FlexPanelAp();
        flexRow.setKey("row" + i);
        flexRow.setBackColor("#ffffff");
        flexRow.setAlignSelf("stretch");
        return flexRow;
    }

    static {
        monthMap.put(1, "january");
        monthMap.put(2, "february");
        monthMap.put(3, "march");
        monthMap.put(4, "april");
        monthMap.put(5, "may");
        monthMap.put(6, "june");
        monthMap.put(7, "july");
        monthMap.put(8, "august");
        monthMap.put(9, "september");
        monthMap.put(10, "october");
        monthMap.put(11, "november");
        monthMap.put(12, "december");
        CATEGORY_MAP = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("zzs", "1");
                this.put("qysds", "2");
                this.put("yhs", "3");
            }
        };
        METHOD_MAP = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("ajsb", "1");
                this.put("aysb", "2");
                this.put("aqhz", "5");
                this.put("hdzs", "4");
            }
        };
    }
}

