/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.apphome;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.draft.DeadlineService;

public class TcurrentSituationPlugin
extends AbstractFormPlugin {
    private static final String INCOME = "income";
    private static final String TAXLIMIT = "taxlimit";
    private static final String YBTSDSE = "ybtsdse";
    private static final String FZJGBQFTYBTSDSE = "fzjgbqftybtsdse";
    private static final String BQFSE = "bqfse";
    private static final String MSSR = "mssr";
    private static final String GDZCJSZJKCTJE = "gdzcjszjkctje";
    private static final String SJLRE = "sjlre";
    private static final String YNSDSE = "ynsdse";
    private static final String JMSDSE = "jmsdse";
    private static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String QYSDS_ZB = "tccit_qysds_zb";
    private static final String PROFIT_SUMMARY = "tccit_profit_summary";
    private static final String SEASON = "season";
    private static final String MONTH = "month";

    public void createNewData(BizDataEventArgs e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = parentView.getPageCache();
            String orgId = pageCache.get("org") != null ? pageCache.get("org") : "0";
            Boolean isAjflag = DeadlineService.getDeadline(orgId);
            Date now = new Date();
            if (isAjflag.booleanValue()) {
                Date lastSeason = DateUtils.addMonth((Date)now, (int)-3);
                Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)lastSeason);
                Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)firstDateOfSeason);
                Date ssSeason = DateUtils.addMonth((Date)firstDateOfSeason, (int)-3);
                Date ssFirstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)ssSeason);
                Date ssLastDateOfSeason = DateUtils.getLastDateOfSeason((Date)ssSeason);
                String declareType = DeclareCompanyTypeService.getDeclareCompanyType(orgId, DateUtils.format((Date)lastDateOfSeason));
                this.refreshSituationLabel(declareType, firstDateOfSeason, lastDateOfSeason, ssFirstDateOfSeason, ssLastDateOfSeason, orgId, SEASON);
            } else {
                Date lastMonth = DateUtils.addMonth((Date)now, (int)-1);
                Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)lastMonth);
                Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)lastMonth);
                Date ssMonth = DateUtils.addMonth((Date)firstDateOfMonth, (int)-1);
                Date ssFirstDate = DateUtils.getFirstDateOfMonth((Date)ssMonth);
                Date ssLastDate = DateUtils.getLastDateOfMonth((Date)ssMonth);
                String declareType = DeclareCompanyTypeService.getDeclareCompanyType(orgId, DateUtils.format((Date)lastDateOfMonth));
                this.refreshSituationLabel(declareType, firstDateOfMonth, lastDateOfMonth, ssFirstDate, ssLastDate, orgId, MONTH);
            }
        }
    }

    private void refreshSituationLabel(String declareType, Date skssqq, Date skssqz, Date sqkssqq, Date sqkssqz, String orgId, String type) {
        if (declareType != null) {
            String sbbidStr = this.getSbbidStr(skssqq, skssqz, orgId, type);
            DynamicObject qysdsZbResult = this.queryQysdsZb(sbbidStr, YBTSDSE, FZJGBQFTYBTSDSE, MSSR, GDZCJSZJKCTJE, SJLRE, YNSDSE, JMSDSE);
            switch (declareType) {
                case "100": 
                case "210": 
                case "220": 
                case "230": {
                    this.refreshSflLabel(skssqq, skssqz, orgId, this.getBigDecimalOrElseZero(qysdsZbResult, YBTSDSE));
                    this.refreshDepreAmount11Label(this.getBigDecimalOrElseZero(qysdsZbResult, YBTSDSE));
                    this.refreshDepreAmount111Label(this.getSbbidStr(sqkssqq, sqkssqz, orgId, type), qysdsZbResult);
                    break;
                }
                case "311": {
                    this.refreshSflLabel(skssqq, skssqz, orgId, this.getBigDecimalOrElseZero(qysdsZbResult, FZJGBQFTYBTSDSE));
                    this.refreshDepreAmount11Label(this.getBigDecimalOrElseZero(qysdsZbResult, FZJGBQFTYBTSDSE));
                    break;
                }
            }
        }
        this.getView().updateView();
    }

    private void refreshSflLabel(Date skssqq, Date skssqz, String orgId, BigDecimal yb) {
        DynamicObjectCollection bqfse = QueryServiceHelper.query((String)PROFIT_SUMMARY, (String)BQFSE, (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)INCOME), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)skssqz)), new QFilter("org", "=", (Object)Long.parseLong(orgId))});
        BigDecimal bq = BigDecimal.ZERO;
        if (bqfse != null && !bqfse.isEmpty()) {
            bq = ((DynamicObject)bqfse.get(0)).getBigDecimal(BQFSE);
        }
        BigDecimal sfl = BigDecimal.ZERO;
        if (bq.compareTo(BigDecimal.ZERO) > 0) {
            sfl = yb.divide(bq, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
        }
        if (sfl.compareTo(BigDecimal.ZERO) >= 0) {
            String sflStr = BigDecimalUtil.format((Object)sfl, (String)"0.00#") + "%";
            Label sflLabel = (Label)this.getControl("sfl");
            sflLabel.setText(sflStr);
        }
    }

    private void refreshDepreAmount11Label(BigDecimal ybtsdse) {
        BigDecimal depreAmount11 = ybtsdse.divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP);
        String depreAmount11Str = BigDecimalUtil.format((Object)depreAmount11, (String)"0.00#");
        if (depreAmount11.compareTo(BigDecimal.ZERO) >= 0) {
            Label sflLabel = (Label)this.getControl("depre_amount11");
            sflLabel.setText(depreAmount11Str);
        }
    }

    private void refreshDepreAmount111Label(String sSbbid, DynamicObject nowData) {
        BigDecimal depreAmount111;
        DynamicObject lastData;
        BigDecimal dqjmse = BigDecimal.ZERO;
        BigDecimal sqjmse = BigDecimal.ZERO;
        if (nowData != null) {
            dqjmse = nowData.getBigDecimal(MSSR).add(nowData.getBigDecimal(GDZCJSZJKCTJE)).add(nowData.getBigDecimal(SJLRE)).multiply(BigDecimal.valueOf(0.25)).subtract(nowData.getBigDecimal(YNSDSE)).add(nowData.getBigDecimal(JMSDSE));
        }
        if (sSbbid != null && (lastData = this.queryQysdsZb(sSbbid, MSSR, GDZCJSZJKCTJE, SJLRE, YNSDSE, JMSDSE)) != null) {
            sqjmse = lastData.getBigDecimal(MSSR).add(lastData.getBigDecimal(GDZCJSZJKCTJE)).add(lastData.getBigDecimal(SJLRE)).multiply(BigDecimal.valueOf(0.25)).subtract(lastData.getBigDecimal(YNSDSE)).add(lastData.getBigDecimal(JMSDSE));
        }
        if ((depreAmount111 = dqjmse.subtract(sqjmse).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) >= 0) {
            String depreAmount111Str = BigDecimalUtil.format((Object)depreAmount111, (String)"0.00#");
            Label sflLabel = (Label)this.getControl("depre_amount111");
            sflLabel.setText(depreAmount111Str);
        }
    }

    private String getSbbidStr(Date skssqq, Date skssqz, String orgId, String type) {
        DynamicObjectCollection sbbid = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)"id", (QFilter[])new QFilter[]{new QFilter(TAXLIMIT, "=", (Object)type), new QFilter("type", "=", (Object)"qysdsjb"), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)skssqz)), new QFilter("org", "=", (Object)Long.parseLong(orgId))});
        if (null != sbbid && !sbbid.isEmpty()) {
            return String.valueOf(((DynamicObject)sbbid.get(0)).getLong("id"));
        }
        return null;
    }

    private DynamicObject queryQysdsZb(String sbbidStr, String ... queryColumns) {
        DynamicObjectCollection ybtsdse;
        String selectFields;
        if (sbbidStr != null && (selectFields = (String)Stream.of(queryColumns).reduce((s1, s2) -> s1 + "," + s2).orElse(null)) != null && (ybtsdse = QueryServiceHelper.query((String)QYSDS_ZB, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbidStr)})) != null && !ybtsdse.isEmpty()) {
            return (DynamicObject)ybtsdse.get(0);
        }
        return null;
    }

    private BigDecimal getBigDecimalOrElseZero(DynamicObject dyObj, String name) {
        BigDecimal bd = BigDecimal.ZERO;
        if (dyObj != null) {
            bd = dyObj.getBigDecimal(name);
        }
        return bd;
    }
}

