/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.branch;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.SeasonCalcObserver;
import kd.taxc.tccit.business.draft.BranchCalcPageService;

public class BranchCalcPagePlugin
extends AbstractFormPlugin
implements SeasonCalcObserver {
    private static final String BUSINESS_TYPE = "businesstype";
    private static final String ITEM_NO = "itemno";
    private static final String NAME = "name";
    private static final String SUM_AMOUNT = "sumamount";
    private static final String ENTITY_NAME = "treeentryentity";
    private BranchCalcPageService branchCalcPageService = new BranchCalcPageService();
    public final List<String> branchItemTypes = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"});

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String businesstype = DeclareCompanyTypeUtils.getBusinesstype((String)orgid, (String)skssqq, (String)skssqz);
        customParams.put(BUSINESS_TYPE, businesstype);
        this.calc(customParams);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        DynamicObject dataEntity = changeSet[0].getDataEntity();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        String itemNo = dataEntity.getString(ITEM_NO);
        if (Lists.newArrayList((Object[])new String[]{"3"}).contains(itemNo)) {
            if (((BigDecimal)newValue).compareTo(BigDecimal.ZERO) < 0 || ((BigDecimal)newValue).compareTo(new BigDecimal("100")) > 0) {
                this.rollbackPropertyChange(e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u51650~100\u4ee5\u5185\u7684\u6570\u503c", (String)"BranchCalcPagePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
            QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
            QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
            this.branchCalcPageService.putDataMap(itemNo, SUM_AMOUNT, (BigDecimal)newValue);
            this.branchCalcPageService.updateData(orgFilter, skssqqFilter, skssqzFilter, itemNo, (BigDecimal)newValue, "2");
            this.calc(customParams);
            this.getView().updateView(ENTITY_NAME);
            this.getView().sendFormAction(this.getView());
            this.setLockRows();
            LocaleString msg = new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7a0d\u7b49", (String)"BranchCalcPagePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            this.getView().showLoading(msg, 2000);
        }
    }

    private void calc(Map<String, Object> customParams) {
        DynamicObject[] dynamicObjects = this.branchCalcPageService.buildBranchOfficeSummary(customParams);
        this.queryBranchData(dynamicObjects);
        this.setLockRows();
    }

    private void setLockRows() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
        int index = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            if ("3".equals(dynamicObject.getString(ITEM_NO))) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{SUM_AMOUNT});
            } else {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{SUM_AMOUNT});
            }
            ++index;
        }
    }

    private void queryBranchData(DynamicObject[] query) {
        this.getModel().deleteEntryData(ENTITY_NAME);
        for (String itemType : this.branchItemTypes) {
            DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
            DynamicObjectType dynamicObjectType = treeEntryEntity.getDynamicObjectType();
            DynamicObject object = Arrays.stream(query).filter(s -> s.getString("itemType").equals(itemType)).findFirst().get();
            DynamicObject keyObject = new DynamicObject(dynamicObjectType);
            keyObject.set("id", (Object)object.getLong("mypkid"));
            keyObject.set("pid", (Object)object.getLong("myparentid"));
            this.getModel().createNewEntryRow(ENTITY_NAME, keyObject);
            keyObject.set(ITEM_NO, (Object)object.getString(ITEM_NO));
            keyObject.set(NAME, (Object)object.getString(NAME));
            keyObject.set(SUM_AMOUNT, (Object)object.getBigDecimal(SUM_AMOUNT));
        }
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String businesstype = DeclareCompanyTypeUtils.getBusinesstype((String)orgid, (String)skssqq, (String)skssqz);
        customParams.put(BUSINESS_TYPE, businesstype);
        this.branchCalcPageService.buildBranchOfficeSummary(customParams);
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }
}

