/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.branch;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;

public class BranchTaxpayFormPlugin
extends AbstractAccountPlugin
implements HyperLinkClickListener {
    private static final String ENTITY_SUMMARY = "tccit_profit_summary";
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private final Map<String, String> MAP = new LinkedHashMap<String, String>(){
        {
            this.put("income", "011");
            this.put("jcost", "012");
            this.put("profit", "013");
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        DynamicObject[] adjustAmount = this.getAdjustAmount(customParams);
        IDataModel model = this.getModel();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_SUMMARY, (String)"id,type,bqfse,bqlje,sqfse,sqlje", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter}, (String)"id");
        if (adjustAmount.length > 0) {
            dynamicObjects = this.mergeSaveData(dynamicObjects, adjustAmount);
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", 3);
        model.setValue("type", (Object)"income", 0);
        model.setValue("type", (Object)"jcost", 1);
        model.setValue("type", (Object)"profit", 2);
        model.setValue("bqfse", (Object)BigDecimalUtil.toBigDecimal((Object)dynamicObjects[0].get("bqfse")), 0);
        model.setValue("bqfse", (Object)BigDecimalUtil.toBigDecimal((Object)dynamicObjects[1].get("bqfse")), 1);
        model.setValue("bqfse", (Object)BigDecimalUtil.toBigDecimal((Object)dynamicObjects[2].get("bqfse")), 2);
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    private DynamicObject[] mergeSaveData(DynamicObject[] dynamicObjects, DynamicObject[] adjustAmounts) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            String type = this.MAP.get(dynamicObject.getString("type"));
            DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("itemnumber").equals(type) || s.getString("itemnumber").equals(type + "_")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            if (collect.size() <= 0) continue;
            BigDecimal adjustAmount = collect.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            dynamicObject.set("bqfse", (Object)adjustAmount);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        return dynamicObjects;
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getFieldName().equals("bqfse")) {
            String key = ((Control)evt.getSource()).getKey();
            EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
            String type = String.valueOf(itemsEntity.getModel().getValue("type"));
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("columnType", evt.getFieldName());
            customParams.put("entrytype", "profits");
            customParams.put("itemnumber", this.MAP.get(type));
            customParams.put("entryname", "tccit_yj_profits_accdet");
            this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
        }
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private DynamicObject[] getAdjustAmount(Map<String, Object> customParams) {
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", ">=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)skssqz));
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)"profits");
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter};
        String selectPrope = "ruleid,entrytype,adjustamount,totalamount,itemnumber";
        DynamicObject[] adjustDetails = BusinessDataServiceHelper.load((String)"tccit_adjust_detail", (String)selectPrope, (QFilter[])filters);
        return adjustDetails;
    }
}

