/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.branch;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.AbstractDeclareReportPlugin;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tccit.business.sbb.SbbQueryService;

public class TccitBranchDeclarationPlugin
extends AbstractDeclareReportPlugin {
    private static final String TYPE = "type";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    protected void viewDraft() {
        QFilter endFilter;
        QFilter startFilter;
        QFilter templateFilter;
        String orgid = this.getPageCache().get("orgid");
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"id,type", (QFilter[])new QFilter[]{orgFilter, templateFilter = new QFilter("templatetype", "=", (Object)"draft_qysdsnb"), startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startDate)), endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)endDate))});
        if (dynamicObject == null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("viewdraft", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TccitBranchDeclarationPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TccitBranchDeclarationPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String orgName = org != null ? org.getString("name") : "";
            String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5c1a\u672a\u7f16\u5236\u8ba1\u7a0e\u5e95\u7a3f\uff0c\u662f\u5426\u524d\u5f80\u7f16\u5236\uff1f", (String)"TccitBranchDeclarationPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), orgName);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("orgid", orgid);
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", endDate);
            customParams.put(TYPE, dynamicObject.getString(TYPE));
            customParams.put("templatetype", "qysdsnb_fzjg");
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tccit_mainpage", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    protected void calStaticData() {
        String orgid = this.getPageCache().get("orgid");
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        Date skssqq = DateUtils.stringToDate((String)startDate);
        Date skssqz = DateUtils.stringToDate((String)endDate);
        String sbbid = SbbQueryService.getSbbidStr(skssqq, skssqz, orgid, "qysdsnb_fzjg");
        String declareCompanyType = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgid, (String)startDate);
        this.getPageCache().put("declareCompanyType", declareCompanyType);
        if (DeclareCompanyTypeUtils.noNeedApply((String)declareCompanyType, (String)orgid, (String)startDate, (String)endDate).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u4e0d\u5c31\u5730\u5e74\u62a5\u6240\u5f97\u7a0e\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u72ec\u7acb\u586b\u62a5\u7533\u62a5\u8868\u3002", (String)"TccitBranchDeclarationPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"summary1", "tabcontent"});
            return;
        }
        this.getModel().setValue("ynssde", (Object)this.getYnssde(orgid, skssqq, skssqz));
        this.getModel().setValue("fpbl", (Object)this.getFpbl(orgid, skssqq, skssqz));
        this.getModel().setValue("fpsdse", (Object)this.getFpsdse(orgid, skssqq, skssqz));
        BigDecimal ybtsdse = this.getYbtsdse(orgid, skssqq, skssqz);
        BigDecimal sjsdse = this.getSjsdse(orgid, skssqq, skssqz);
        BigDecimal bqybtse = sjsdse.compareTo(BigDecimal.ZERO) == 0 ? ybtsdse : sjsdse;
        SbbQueryService.updateTaxDeclareMainBySbbid(sbbid, bqybtse);
    }

    private BigDecimal getFpsdse(String orgid, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryBranchObjects(skssqq, skssqz, orgid)).map(s -> s.getBigDecimal("fpse")).orElseGet(() -> BigDecimal.ZERO);
    }

    private BigDecimal getFpbl(String orgid, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryBranchObjects(skssqq, skssqz, orgid)).map(s -> s.getBigDecimal("fpbl")).orElseGet(() -> BigDecimal.ZERO);
    }

    private BigDecimal getYnssde(String orgId, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryZjgObjects(skssqq, skssqz, orgId)).map(s -> s.getBigDecimal("ynsdse")).orElseGet(() -> BigDecimal.ZERO);
    }

    private BigDecimal getYbtsdse(String orgId, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryZbObjects(skssqq, skssqz, orgId)).map(s -> s.getBigDecimal("fzjgbqftybtsdse")).orElseGet(() -> BigDecimal.ZERO);
    }

    private BigDecimal getSjsdse(String orgId, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryZbObjects(skssqq, skssqz, orgId)).map(s -> s.getBigDecimal("fsjybsdse")).orElseGet(() -> BigDecimal.ZERO);
    }

    protected String[] getTaxLimits() {
        return new String[]{"year"};
    }

    public void init() {
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        return "qysdsnb_fzjg";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
        this.calStaticData();
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        this.initStartAndEndDate(true);
    }
}

