/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.branch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.formplugin.policy.AbstractPolicyPlugin;
import org.apache.commons.collections.CollectionUtils;

public class YearBranchPolicyEdit
extends AbstractPolicyPlugin {
    private static final String RULE_CONFIG = "tccit_rule_config";
    private static final String POLICY_ENTITY = "tccit_branch_confpolicy";
    private Set<String> changeFields = new LinkedHashSet<String>(Arrays.asList("prepaytype", "illegal", "suittype"));

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(RULE_CONFIG)) {
            // empty if block
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
        String startDate = (String)customParams.get("skssqq");
        String endDate = (String)customParams.get("skssqz");
        this.initCommonData(POLICY_ENTITY, orgid, startDate, endDate, Boolean.FALSE);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssnewqz")));
        if (skssqq != null && skssqz != null && DateUtils.getMonthOfDate((Date)skssqq) == DateUtils.getMonthOfDate((Date)skssqz)) {
            this.getModel().setValue("taxperiod", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))));
        }
        this.initSuitType();
        this.setChildVisible();
    }

    private void initSuitType() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("apitudeentryentity");
        boolean exists = !CollectionUtils.isEmpty((Collection)entryEntity) && entryEntity.stream().anyMatch(s -> "1".equals(s.getString("apitudetype")));
        this.getView().setVisible(Boolean.valueOf(exists), new String[]{"suittype"});
        FieldEdit control = (FieldEdit)this.getControl("suittype");
        control.setMustInput(exists);
        FieldProp property = (FieldProp)this.getModel().getProperty("suittype");
        property.setMustInput(exists);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (this.changeFields.contains(name)) {
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)POLICY_ENTITY, (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                String orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
                String startDate = (String)customParams.get("skssqq");
                String endDate = (String)customParams.get("skssqz");
                StatusUtils.updateStatus((String)"draft_qysdsjb", (String)orgid, (String)startDate, (String)endDate, (String)"1", (String)"nssb");
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"YearBranchPolicyEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
                DeclareStepsUtils.resetParentSteps((int)TaxStepsConstant.getTccitSeasonal().size(), (String)"1", (String)"1", (IFormView)this.getView());
            } else {
                this.getView().getParentView().showErrorNotification(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
            }
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    @Override
    public void initCustom(String orgid, String startDate, String endDate) {
    }

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        String startDate = model.getStartDate();
        String endDate = model.getEndDate();
        QFilter q1 = new QFilter("orgid", "=", (Object)orgId);
        QFilter q2 = new QFilter("startdate", "=", (Object)startDate);
        QFilter q3 = new QFilter("enddate", "=", (Object)endDate);
        DeleteServiceHelper.delete((String)POLICY_ENTITY, (QFilter[])new QFilter[]{q1, q2, q3});
    }
}

