/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.declare;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.PageIdUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.policy.YearPolicyService;
import kd.taxc.tccit.business.sbb.SbbQueryService;
import kd.taxc.tccit.common.utils.OpenDeclareUtils;

public class DeclarePluginSbb
extends AbstractFormPlugin {
    private static String TAB_NUMBER = "A199998";
    private static String TAB_NUMBER_ORIGIN = "A199999";
    private String TAB_NAME = ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7eb3\u7a0e\u7533\u62a5\u8868\u5c01\u9762", (String)"DeclarePluginSbb_0", (String)"taxc-tccit", (Object[])new Object[0]);
    private String TAB_NAME_ORIGIN = ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7eb3\u7a0e\u7533\u62a5\u8868\u586b\u62a5\u8868", (String)"DeclarePluginSbb_1", (String)"taxc-tccit", (Object[])new Object[0]);
    protected static final String TEMPLATE_TYPE = "qysdsnb";
    protected static final String ORGID_KEY = "orgid";

    public void afterCreateNewData(EventObject e) {
        String sourceFrom = this.getView().getParentView() != null ? (String)this.getView().getParentView().getFormShowParameter().getCustomParam("datatype") : null;
        this.loadTree((String)this.getView().getFormShowParameter().getCustomParam("sheetname"), sourceFrom);
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if (argsMap != null) {
            if (TAB_NUMBER.equals(argsMap.get("number"))) {
                OpenDeclareUtils.openDeclarePage(this.getView(), this.TAB_NAME, "false");
            } else if (TAB_NUMBER_ORIGIN.equals(argsMap.get("number"))) {
                OpenDeclareUtils.openDeclarePage(this.getView(), this.TAB_NAME_ORIGIN, "false");
            } else {
                OpenDeclareUtils.openDeclarePage(this.getView(), (String)argsMap.get("number"), "false");
            }
        }
    }

    public void loadTree(String selectNode, String sourceFrom) {
        DynamicObject policy;
        QFilter qFilter = new QFilter("type", "=", (Object)"sbb");
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"tpo_qysds_types", (String)"id,name,title,number,parent", (QFilter[])new QFilter[]{qFilter}, (String)"order");
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        Map showParameter = this.getView().getFormShowParameter().getCustomParams();
        String skssqq = (String)showParameter.get("skssqq");
        String skssqz = (String)showParameter.get("skssqz");
        String orgId = (String)showParameter.get(ORGID_KEY);
        ArrayList<String> declareidList = new ArrayList();
        DynamicObject draft = StatusUtils.queryOne((String)"draft_qysdsnb", (String)orgId, (String)skssqq, (String)skssqz, (String)"nssb");
        if (draft != null && (policy = YearPolicyService.getPolicy(Long.parseLong(orgId), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz))) != null) {
            declareidList = policy.getDynamicObjectCollection("entryentity").stream().map(s -> s.getDynamicObject("declareid").getString("id")).collect(Collectors.toList());
        }
        DynamicObjectCollection apitudeEntryEntity = ApitudeService.getApitudeEntryEntity(Long.valueOf(orgId));
        Boolean showCard = ApitudeService.show(apitudeEntryEntity, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz));
        String selectNumber = this.TAB_NAME_ORIGIN;
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (DynamicObject obj : dcs) {
            String name;
            String number;
            TreeNode leftRoot = new TreeNode();
            String id = obj.getString("id");
            if (!this.show(sourceFrom, declareidList, id, number = obj.getString("number"), showCard).booleanValue()) continue;
            if (selectNode != null && selectNode.equalsIgnoreCase(number)) {
                selectNumber = number;
            }
            if (StringUtils.isEmpty((CharSequence)(name = obj.getString("name")))) {
                name = obj.getString("title");
            }
            String parentid = obj.getString("parent");
            leftRoot.setId(id);
            leftRoot.setText(name);
            leftRoot.setType(number);
            leftRoot.setParentid(parentid);
            nodeList.add(leftRoot);
        }
        List treeNodes = TreeUtils.buildWithChildren(nodeList);
        CustomControl s2 = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("treeData", treeNodes);
        data.put("pageid", PageIdUtils.getPageId((IFormView)this.getView()));
        if (StringUtils.isNotEmpty((CharSequence)selectNode)) {
            data.put("selected", selectNumber);
        }
        s2.setData(data);
        String refresh = (String)showParameter.get("refresh");
        OpenDeclareUtils.openDeclarePage(this.getView(), selectNumber, refresh);
    }

    Boolean show(String sourceFrom, List<String> declareidList, String id, String number, Boolean showCard) {
        ArrayList whiteList = Lists.newArrayList((Object[])new String[]{TAB_NUMBER, TAB_NUMBER_ORIGIN});
        Boolean notSelect = StringUtils.equals((CharSequence)sourceFrom, (CharSequence)"2") || declareidList.size() == 0;
        if (showCard.booleanValue() && "A107041".equals(number)) {
            return Boolean.TRUE;
        }
        if (notSelect.booleanValue()) {
            return Boolean.TRUE;
        }
        if (declareidList.contains(id) || whiteList.contains(number)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        this.calStaticData();
    }

    protected void calStaticData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get(ORGID_KEY);
        String startDate = (String)customParams.get("skssqq");
        String endDate = (String)customParams.get("skssqz");
        Date skssqq = DateUtils.stringToDate((String)startDate);
        Date skssqz = DateUtils.stringToDate((String)endDate);
        String declareCompanyType = DeclareCompanyTypeService.getDeclareCompanyType(orgid, endDate);
        this.getPageCache().put("declareCompanyType", declareCompanyType);
        BigDecimal sjynsdse = this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "sjynsdse");
        this.getModel().setValue("bqybtse", (Object)this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "sjynsdse"));
        this.getModel().setValue("ynssde", (Object)this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "bnljsjyyjsdse"));
        BigDecimal bqjmse = this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "bnybtsdse");
        this.getModel().setValue("bqjmse", (Object)bqjmse);
        BigDecimal yysr = this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "yysr");
        if (BigDecimal.ZERO.compareTo(yysr) == 0) {
            this.getModel().setValue("fpbl", (Object)"0.00%");
        } else {
            String concat = sjynsdse.multiply(BigDecimal.valueOf(100L)).divide(yysr, 2, 4).toString().concat("%");
            this.getModel().setValue("fpbl", (Object)concat);
        }
        SbbQueryService.updateTaxDeclareMain(orgid, skssqq, skssqz, bqjmse);
    }

    private BigDecimal getBqybtse(String orgid, Date skssqq, Date skssqz, String declareCompanyType, String column) {
        String sbbid = SbbQueryService.getCurrentSbbid(orgid, skssqq, skssqz, 0);
        if (declareCompanyType.equals("100") || declareCompanyType.equals("220") || declareCompanyType.equals("230") || declareCompanyType.equals("210")) {
            return SbbQueryService.getQysdsA100000(sbbid, column);
        }
        return BigDecimal.ZERO;
    }
}

