/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.declare;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.DeclareCellDataParamsDto;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareCellServiceHelper;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPluginNew;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.draft.DraftService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.policy.YearReportPreSelectService;
import kd.taxc.tccit.business.sbb.SbbQueryService;
import kd.taxc.tccit.common.utils.DateRangeUtils;
import org.apache.commons.collections.CollectionUtils;

public class NewTccitMainSbbPlugin
extends AbstractDeclareReportPluginNew {
    public static final String INIT_START_AND_END_DATE = "initStartAndEndDate";

    public void init() {
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        this.initStartAndEndDate(true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void loadData(Date startDate, Date endDate, Boolean needMsg) {
        super.loadData(startDate, endDate, Boolean.FALSE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date newValue;
        String initStartAndEndDate;
        String name = e.getProperty().getName();
        ChangeData change = e.getChangeSet()[0];
        if ((name.equals("skssqq") || name.equals("skssqz")) && !"true".equals(initStartAndEndDate = this.getPageCache().get(INIT_START_AND_END_DATE)) && (newValue = (Date)change.getNewValue()) != null) {
            Map<String, Date> dateRange = DateRangeUtils.getDateRange(this.getTaxLimits()[0], newValue);
            this.getModel().setValue("skssqq", (Object)dateRange.get("startdate"));
            this.getModel().setValue("skssqz", (Object)dateRange.get("enddate"));
        }
        if (name.equals("skssqq") || name.equals("org")) {
            super.propertyChanged(e);
        }
    }

    public void orgCheckResultHandle(String oldorgid, String orgid, boolean checkResult) {
        if (checkResult) {
            this.getModel().setValue("org", (Object)oldorgid);
        } else {
            this.getPageCache().put("orgid", orgid);
            this.getPageCache().put("oldorgid", orgid);
            this.getPageCache().put(INIT_START_AND_END_DATE, "true");
            this.initStartAndEndDate(true);
            this.getPageCache().put(INIT_START_AND_END_DATE, "false");
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), Boolean.FALSE);
        }
    }

    protected void showDeclareForm(Map<String, Object> customParams, String orgid, String startDate, String endDate, String operationStatus) {
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("declareRequestData")), DeclareRequestModel.class);
        if (requestModel == null || !requestModel.getRefresh().booleanValue()) {
            super.showDeclareForm(customParams, orgid, startDate, endDate, operationStatus);
            return;
        }
        Date startDateTime = DateUtils.stringToDate2((String)startDate);
        Date endDateTime = DateUtils.stringToDate2((String)endDate);
        String lastYearStartDate = DateUtils.format((Date)DateUtils.addYear((Date)startDateTime, (int)-1));
        String lastYearEndDate = DateUtils.format((Date)DateUtils.addYear((Date)endDateTime, (int)-1));
        DynamicObject yearDraft = DraftService.getYearDgBill(Long.parseLong(orgid), startDateTime, endDateTime);
        if (yearDraft != null) {
            super.showDeclareForm(customParams, orgid, startDate, endDate, operationStatus);
            return;
        }
        HashMap<String, String> extendParams = new HashMap<String, String>(16);
        extendParams.put("declarestatus", "declared");
        DynamicObject declareResult = YbnsrServiceHelper.queryYbnsrWithEx((String)orgid, (String)"qysdsnb", (String)lastYearStartDate, (String)lastYearEndDate, extendParams);
        if (declareResult == null) {
            super.showDeclareForm(customParams, orgid, startDate, endDate, operationStatus);
            return;
        }
        String reportId = String.valueOf(declareResult.get("id"));
        this.getPageCache().put("reportId", reportId);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"formShowParam", customParams);
        this.getPageCache().put("operationStatus", operationStatus);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("select", (IFormPlugin)this);
        String msg1 = ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u6839\u636e\u4e0a\u5e74\u7533\u62a5\u4e8b\u9879\u5bf9\u586b\u62a5\u8868\u5355\u8fdb\u884c\u9884\u52fe\u9009\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417 \uff1f", (String)"NewTccitMainSbbPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
        this.getView().showConfirm(msg1, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    protected Map<String, String> bussinessUpdateMap(Map<String, String> currentMap) {
        if (currentMap == null) {
            return new HashMap<String, String>(0);
        }
        List<String> cellKeyList = YearReportPreSelectService.cellKeyList;
        HashMap<String, String> updaMap = new HashMap<String, String>(cellKeyList.size());
        cellKeyList.forEach(e -> {
            String cfr_ignored_0 = (String)updaMap.put((String)e, (String)currentMap.get(e));
        });
        return updaMap;
    }

    public String getTaxType() {
        return "qysds";
    }

    protected String[] getTaxLimits() {
        return new String[]{"year"};
    }

    public String getTemplateType() {
        String orgid = this.getPageCache().get("orgid");
        String skssqz = this.getPageCache().get("skssqz");
        String declaretype = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgid, (String)skssqz);
        this.getPageCache().put("sds_declaretype", declaretype);
        if ("311".equals(declaretype)) {
            return "qysdsnb_fzjg";
        }
        return "qysdsnb";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
        String declaretype = this.getPageCache().get("sds_declaretype");
        if (this.getModel().getValue("skssqq") == null || this.getModel().getValue("skssqz") == null || this.getModel().getValue("org") == null) {
            return;
        }
        if ("311".equals(declaretype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"summary2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"summary1"});
            this.calStaticDataFzjg();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"summary2"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"summary1"});
            this.calStaticDataZjg();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        String orgid = this.getPageCache().get("orgid");
        if (orgid == null || startdate == null || enddate == null) {
            return;
        }
        String declaretype = this.getPageCache().get("declaretype");
        if ("311".equals(declaretype)) {
            this.getPageCache().put("orgType", "branch");
        } else {
            this.getPageCache().put("orgType", "head");
        }
        String sbbid = YbnsrService.queryYbnsrPre((String)orgid, (String)"qysdsnb", (String)startdate, (String)enddate, (int)0);
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("recalc".equals(callBackId) && StringUtils.isNotEmpty((CharSequence)sbbid)) {
            SbbQueryService.deleteDeclareHistoryByCell(sbbid);
        }
        if ("select".equals(callBackId)) {
            Map param = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"formShowParam", Map.class);
            String operationStatus = this.getPageCache().get("operationStatus");
            if ("Yes".equalsIgnoreCase(e.getResultValue())) {
                Long reportId = Long.parseLong(this.getPageCache().get("reportId"));
                DeclareCellDataParamsDto paramsDto = new DeclareCellDataParamsDto();
                paramsDto.setSbbId(reportId);
                paramsDto.setCellKeys(YearReportPreSelectService.cellKeyList);
                TaxResult result = DeclareCellServiceHelper.getDeclareCellValueStr((DeclareCellDataParamsDto)paramsDto);
                HashMap data = new HashMap((Map)result.getData());
                DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)String.valueOf(param.get("declareRequestData")), DeclareRequestModel.class);
                requestModel.getBusinessMap().putAll(data);
                param.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
                super.showDeclareForm(param, orgid, startdate, enddate, operationStatus);
                String msg = ResManager.loadKDString((String)"\u586b\u62a5\u8868\u5355\u9884\u52fe\u9009\u5b8c\u6210\u3002", (String)"NewTccitMainSbbPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
            } else {
                super.showDeclareForm(param, orgid, startdate, enddate, operationStatus);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String orgid;
        String key = evt.getItemKey();
        super.beforeItemClick(evt);
        if ("save".equals(key) && null != (orgid = this.getPageCache().get("orgid")) && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(orgid)).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"NewTccitMainSbbPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        if (orgid != null && skssqz != null) {
            DynamicObjectCollection orgGroupList;
            String registertypeNumber;
            String declareCompanyType = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgid, (String)skssqz);
            if ("312".equals(declareCompanyType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u4e0d\u5c31\u5730\u5e74\u62a5\u6240\u5f97\u7a0e\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u72ec\u7acb\u7533\u62a5\uff01", (String)"NewTccitMainSbbPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                return false;
            }
            DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgid)).getData();
            String string = registertypeNumber = taxMain != null ? taxMain.getString("registertype.longnumber") : "";
            if (StringUtils.isNotEmpty((CharSequence)registertypeNumber) && registertypeNumber.startsWith("400")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u529f\u80fd\u672a\u5411\u4e2a\u4f53\u7ecf\u8425\u4f01\u4e1a\u5f00\u653e\uff0c\u8bf7\u5728\u57fa\u7840\u8d44\u6599\u4fee\u6539\u4f01\u4e1a\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b", (String)"NewTccitMainSbbPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
                return false;
            }
            if (taxMain != null) {
                boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tccit", (String)"zerodeclare", (long)Long.parseLong(orgid));
                DynamicObject qysdsCard = OrgGroupService.getQysdsCard(orgid);
                if (zerodeclare && qysdsCard != null && "hdzs".equals(qysdsCard.getString("levytype"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5f53\u524d\u5f81\u6536\u65b9\u5f0f\u4e0d\u652f\u6301\u6838\u5b9a\u96f6\u7533\u62a5\u3002", (String)"NewTccitMainSbbPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
                    return false;
                }
            }
            if ((orgGroupList = OrgGroupService.getOrgGroupDynamicObjects(orgid, skssqz, "qysds", "2")).size() > 0) {
                Optional<DynamicObject> first = orgGroupList.stream().filter(s -> "2".equals(s.get("declare"))).findFirst();
                if (first.isPresent() && QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)first.get().getLong("orgrow.orgid")), new QFilter("istaxpayer", "=", (Object)"0")})) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u603b\u7ec4\u7ec7\u4e3a\u975e\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u4fdd\u5b58\u5931\u8d25, \u8bf7\u4fee\u6539\u6c47\u603b\u65b9\u6848\u3002", (String)"NewTccitMainSbbPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
                    return false;
                }
                DynamicObjectCollection bastaxTaxorgList = QueryServiceHelper.query((String)"bastax_taxorg", (String)"status,org.name as name,org.id as id", (QFilter[])new QFilter[]{new QFilter("id", "in", orgGroupList.stream().map(s -> s.get("orgrow.orgid")).collect(Collectors.toList())), new QFilter("status", "=", (Object)"0")});
                List thirdOrgs = orgGroupList.stream().filter(e -> "3".equals(e.getString("levelname"))).map(s -> s.getLong("orgrow.orgid")).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty((Collection)bastaxTaxorgList)) {
                    Optional<DynamicObject> exists = bastaxTaxorgList.stream().filter(e -> !thirdOrgs.contains(e.getLong("id"))).findFirst();
                    if (exists.isPresent()) {
                        StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728", (String)"NewTccitMainSbbPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]));
                        for (DynamicObject object : bastaxTaxorgList) {
                            builder.append(String.format(ResManager.loadKDString((String)"\u3010%s\u3011", (String)"NewTccitMainSbbPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]), object.getString("name")));
                        }
                        builder.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7981\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u4fee\u6539\u6c47\u603b\u65b9\u6848\u540e\u540c\u6b65\u66f4\u65b0\u5206\u652f\u673a\u6784\u5206\u644a\u53f0\u8d26", (String)"NewTccitMainSbbPlugin_10", (String)"taxc-tccit", (Object[])new Object[0]));
                        this.getView().showErrorNotification(builder.toString());
                        return false;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6c47\u603b\u65b9\u6848\u4e0b\u7684\u4e09\u7ea7\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u5b58\u5728\u66f4\u65b0\u53d8\u52a8\uff0c\u5efa\u8bae\u7ef4\u62a4\u6c47\u603b\u65b9\u6848\uff0c\u5e76\u6838\u5b9e\u5206\u652f\u673a\u6784\u7a0e\u6b3e\u5206\u644a\u56e0\u7d20\u53f0\u8d26\u7684\u6570\u636e\u51c6\u786e\u6027", (String)"NewTccitMainSbbPlugin_12", (String)"taxc-tccit", (Object[])new Object[0]));
                }
            }
        }
        return true;
    }

    protected void calStaticDataFzjg() {
        String orgid = this.getPageCache().get("orgid");
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        Date skssqq = DateUtils.stringToDate((String)startDate);
        Date skssqz = DateUtils.stringToDate((String)endDate);
        String sbbid = SbbQueryService.getSbbidStr(skssqq, skssqz, orgid, "qysdsnb_fzjg");
        String declareCompanyType = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgid, (String)startDate);
        this.getPageCache().put("declareCompanyType", declareCompanyType);
        if (DeclareCompanyTypeUtils.noNeedApply((String)declareCompanyType, (String)orgid, (String)startDate, (String)endDate).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u4e0d\u5c31\u5730\u5e74\u62a5\u6240\u5f97\u7a0e\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u72ec\u7acb\u586b\u62a5\u7533\u62a5\u8868\u3002", (String)"NewTccitMainSbbPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"summary1", "tabcontent"});
            return;
        }
        this.getModel().setValue("ynssde", (Object)this.getYnssde(orgid, skssqq, skssqz));
        this.getModel().setValue("fpbl", (Object)this.getFpbl(orgid, skssqq, skssqz));
        this.getModel().setValue("fpsdse", (Object)this.getFpsdse(orgid, skssqq, skssqz));
        BigDecimal ybtsdse = this.getYbtsdse(orgid, skssqq, skssqz);
        BigDecimal sjsdse = this.getSjsdse(orgid, skssqq, skssqz);
        BigDecimal bqybtse = sjsdse.compareTo(BigDecimal.ZERO) == 0 ? ybtsdse : sjsdse;
        SbbQueryService.updateTaxDeclareMainBySbbid(sbbid, bqybtse);
    }

    protected void calStaticDataZjg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        String endDate = DateUtils.format((Date)skssqz);
        String orgid = org.getString("id");
        String declareCompanyType = DeclareCompanyTypeService.getDeclareCompanyType(orgid, endDate);
        this.getPageCache().put("declareCompanyType", declareCompanyType);
        BigDecimal sjynsdse = this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "sjynsdse");
        this.getModel().setValue("bqybtse", (Object)this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "sjynsdse"));
        this.getModel().setValue("ynssde", (Object)this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "bnljsjyyjsdse"));
        BigDecimal bqjmse = this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "bnybtsdse");
        this.getModel().setValue("bqjmse", (Object)bqjmse);
        BigDecimal yysr = this.getBqybtse(orgid, skssqq, skssqz, declareCompanyType, "yysr");
        if (BigDecimal.ZERO.compareTo(yysr) == 0) {
            this.getModel().setValue("fpbl", (Object)"0.00%");
        } else {
            String concat = sjynsdse.multiply(BigDecimal.valueOf(100L)).divide(yysr, 2, 4).toString().concat("%");
            this.getModel().setValue("fpbl", (Object)concat);
        }
        SbbQueryService.updateTaxDeclareMain(orgid, skssqq, skssqz, bqjmse);
    }

    private BigDecimal getBqybtse(String orgid, Date skssqq, Date skssqz, String declareCompanyType, String column) {
        String sbbid = SbbQueryService.getCurrentSbbid(orgid, skssqq, skssqz, 0);
        if (declareCompanyType.equals("100") || declareCompanyType.equals("220") || declareCompanyType.equals("230") || declareCompanyType.equals("210")) {
            return SbbQueryService.getQysdsA100000(sbbid, column);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getFpsdse(String orgid, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryBranchObjects(skssqq, skssqz, orgid)).map(s -> s.getBigDecimal("fpse")).orElseGet(() -> BigDecimal.ZERO);
    }

    private BigDecimal getFpbl(String orgid, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryBranchObjects(skssqq, skssqz, orgid)).map(s -> s.getBigDecimal("fpbl")).orElseGet(() -> BigDecimal.ZERO);
    }

    private BigDecimal getYnssde(String orgId, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryZjgObjects(skssqq, skssqz, orgId)).map(s -> s.getBigDecimal("ynsdse")).orElseGet(() -> BigDecimal.ZERO);
    }

    private BigDecimal getYbtsdse(String orgId, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryZbObjects(skssqq, skssqz, orgId)).map(s -> s.getBigDecimal("fzjgbqftybtsdse")).orElseGet(() -> BigDecimal.ZERO);
    }

    private BigDecimal getSjsdse(String orgId, Date skssqq, Date skssqz) {
        return Optional.ofNullable(SbbQueryService.queryZbObjects(skssqq, skssqz, orgId)).map(s -> s.getBigDecimal("fsjybsdse")).orElseGet(() -> BigDecimal.ZERO);
    }

    protected String getUniKey(String orgId, String skssqq, String skssqz, String templateType) {
        return String.format("%1s_%2s_%3s_%4s", orgId, skssqq, skssqz, templateType);
    }
}

