/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.draft;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.CalAmount;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.enums.DraftSummaryEnum;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public abstract class AbstractSummaryPlugin
extends AbstractEngine
implements Observer,
CalAmount {
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String ITEMNO = "itemno";
    protected static final String ITEMTYPE = "itemtype";
    protected static final String AMOUNT = "amount";
    protected static final String ORGID = "orgid";
    protected static final String SKSSQQ = "skssqq";
    protected static final String SKSSQZ = "skssqz";
    protected Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(128);

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    protected void packageData(PackageDataEvent e) {
    }

    protected ArrayList<String> getItemTypes() {
        return this.getDraftSummaryEnum().getItemTypes();
    }

    protected String getSummaryName() {
        return this.getDraftSummaryEnum().getBill();
    }

    protected BigDecimal getOne(String rowType, String columnType, String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObject object = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = object != null ? object.getBigDecimal(alias) : BigDecimal.ZERO;
        this.dataMap.put(AbstractSummaryPlugin.getKey(rowType, columnType), result);
        return result;
    }

    protected BigDecimal getSum(String rowType, String columnType, String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = query == null || query.size() == 0 ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal(alias);
        this.dataMap.put(AbstractSummaryPlugin.getKey(rowType, columnType), result);
        return result;
    }

    protected BigDecimal getSum(String rowType, String columnType, String entityName, String selectFields, QFilter[] filters, ArrayList<String> alias) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = BigDecimal.ZERO;
        if (EmptyCheckUtils.isNotEmpty((Object)query)) {
            for (String s : alias) {
                result = result.add(((DynamicObject)query.get(0)).getBigDecimal(s));
            }
        }
        this.dataMap.put(AbstractSummaryPlugin.getKey(rowType, columnType), result);
        return result;
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.buildForm();
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    private void buildForm() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter itemtypeFilter = new QFilter(ITEMTYPE, "in", this.getItemTypes());
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.getSummaryName(), (String)" * ", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)"itemtype asc");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        List<DynamicObject> collect = this.dataSort(query);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryentity = model.getEntryEntity(ENTRYENTITY);
        int rowIndex = 0;
        boolean isNew = entryentity.size() <= 0;
        for (DynamicObject object : collect) {
            DynamicObject row = isNew ? entryentity.addNew() : (DynamicObject)entryentity.get(rowIndex);
            String itemType = object.getString(ITEMTYPE);
            row.set(ITEMNO, (Object)itemType);
            row.set(ITEMTYPE, (Object)itemType);
            row.set(AMOUNT, (Object)object.getBigDecimal(AMOUNT));
            ++rowIndex;
        }
        this.getView().updateView(ENTRYENTITY);
    }

    protected List<DynamicObject> dataSort(DynamicObjectCollection query) {
        ArrayList<String> itemTypes = this.getItemTypes();
        return query.stream().sorted((a, b) -> itemTypes.indexOf(a.getString(ITEMTYPE)) > itemTypes.indexOf(b.getString(ITEMTYPE)) ? 1 : -1).collect(Collectors.toList());
    }

    protected void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        DynamicObjectCollection sum = new DynamicObjectCollection();
        ArrayList<String> itemTypes = this.getItemTypes();
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.getSummaryName());
            dynamicObject.set(ITEMNO, (Object)itemType);
            dynamicObject.set(ITEMTYPE, (Object)itemType);
            dynamicObject.set(AMOUNT, this.calcCellAmount(itemType, AMOUNT, customParams));
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        this.clearCurrentPeriod(orgid, skssqq, skssqz, this.getSummaryName());
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    protected ArrayList<QFilter> getBaseQfilters(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        return Lists.newArrayList((Object[])new QFilter[]{orgFilter, dateFilter});
    }

    protected static String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public Object calcCellAmount(String rowType, String columnType, Map<String, Object> customParams) {
        Object amount = this.calcAmount(rowType, columnType, customParams);
        if (amount instanceof BigDecimal) {
            this.dataMap.put(AbstractSummaryPlugin.getKey(rowType, columnType), (BigDecimal)amount);
        }
        return amount;
    }

    @Override
    public Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        return BigDecimal.ZERO;
    }

    public abstract DraftSummaryEnum getDraftSummaryEnum();

    protected void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz, String entityName) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    protected BigDecimal getSum(ArrayList<String> strings, String columnType) {
        BigDecimal amount = BigDecimal.ZERO;
        for (String string : strings) {
            String key = AbstractSummaryPlugin.getKey(string, columnType);
            amount = amount.add(this.dataMap.get(key) == null ? BigDecimal.ZERO : this.dataMap.get(key));
        }
        return amount;
    }
}

