/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.draft;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.tccit.business.declare.servicehelper.TaxDeclareServiceHelper;
import kd.taxc.tccit.business.draft.CitrtaService;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.draft.PeriodService;
import kd.taxc.tccit.business.org.OrgGroupService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CitrtaEditMultiPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CitrtaEditMultiPlugin.class);
    private static final String ID = "id";
    private static final String ORG = "org";
    private CitrtaService service = new CitrtaService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    private boolean isFzjg(Long orgId, Date endDate) {
        boolean fzjg = OrgGroupService.isFzjg(orgId, endDate);
        if (fzjg) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u7f16\u5236\u5e95\u7a3f\u3002", (String)"TccitDeclarationPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        return fzjg;
    }

    public String getSubmitMainTable() {
        return "tccit_citrta_query";
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (ORG.equals(name)) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = this.getView().getEntityId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<Long> orgList = this.service.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
            evt.getCustomQFilters().add(new QFilter(ID, "in", orgList));
        }
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        Date date = null;
        if (customParams != null) {
            date = (Date)customParams.get("date");
        }
        Map<String, Date> nssb = date == null ? PeriodService.getPreTaxPeriod("nssb", orgId, new Date()) : PeriodService.getNowTaxPeriod("nssb", orgId, date);
        Date startDate = nssb.get("startDate");
        Date endDate = DateUtils.getLastDateOfMonth2((Date)nssb.get("endDate"));
        Long org = Long.parseLong(orgId);
        if (this.isFzjg(org, endDate)) {
            return;
        }
        String declareLimit = TaxDeclareServiceHelper.getOrgLimit(org);
        String jtzq = DeadlineService.getCurrentTaxCycle(org);
        if ("aysb".equals(declareLimit) && "season".equals(jtzq) && !this.checkPeriod(startDate, endDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5141\u8bb8\u6bd4\u5bf9\u671f\u95f4\u4e3a\uff1a3\u30016\u30019\u300112\u6708\u3002", (String)"CitrtaEditMultiPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        getModel.setValue("skssqq", (Object)startDate);
        getModel.setValue("skssqz", (Object)endDate);
        getPageCache.put("skssqq", DateUtils.format((Date)startDate));
        getPageCache.put("skssqz", DateUtils.format((Date)endDate));
    }

    private boolean checkPeriod(Date startDate, Date endDate) {
        List<String> monthList = Arrays.asList("03", "06", "09", "12");
        int year = DateUtils.getYearOfDate((Date)startDate);
        for (String month : monthList) {
            String date = String.valueOf(year) + "-" + month;
            Date firstDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate2((String)date, (String)"yyyy-MM"));
            Date lastDate = DateUtils.getLastDateOfMonth1((Date)DateUtils.stringToDate2((String)date, (String)"yyyy-MM"));
            if (startDate.compareTo(firstDate) != 0 || endDate.compareTo(lastDate) != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        String appId = this.getView().getFormShowParameter().getAppId();
        String entity = this.getView().getEntityId();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TccitMainPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]));
            return false;
        }
        String orgId = org.getString(ID);
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (org == null || skssqq == null || skssqz == null) {
            return false;
        }
        if (!this.checkNewAddReportPermis(appId, entity, orgId, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6bd4\u5bf9\u5e95\u7a3f\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CitrtaEditMultiPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"recalc", "audit", "newjtd", "baritemap", "viewflowchart"});
            return false;
        }
        return true;
    }

    protected boolean isDefaultOrg() {
        return false;
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        return orgid != null && skssqq != null && skssqz != null;
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "season"};
    }

    public void init() {
        String id;
        if (StringUtils.isBlank((Object)this.getModel().getValue("billno")) && this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
        }
        if (StringUtils.isNotBlank((CharSequence)(id = this.getPageCache().get("cache_sbbid")))) {
            this.getModel().setValue(ID, (Object)id);
            DynamicObject vatRta = this.service.loadSingleVatRta(Long.parseLong(id));
            if (vatRta != null) {
                this.getModel().setValue("generatebusinessdoc", vatRta.get("generatebusinessdoc"));
            }
        }
    }

    protected void doAfterSuccessSave() {
        super.doAfterSuccessSave();
        String billno = (String)this.getModel().getValue("billno");
        DynamicObject dyo = this.service.queryOneVatRtaByBillno(billno);
        if (dyo != null) {
            this.getModel().setValue(ID, dyo.get(ID));
            this.getModel().setValue("generatebusinessdoc", dyo.get("generatebusinessdoc"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Date endDate;
        boolean fzjg;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TccitMainPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long orgId = org.getLong(ID);
        if (args.getSource() instanceof Donothing) {
            String billno;
            DynamicObject obj;
            String operation = ((Donothing)args.getSource()).getOperateKey();
            if (Arrays.asList("save", "recalc").contains(operation)) {
                String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
                boolean checkResult = CitrtaService.orgCheck(this.getView(), String.valueOf(orgId), appid, TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
                if (checkResult) {
                    args.setCancel(true);
                    return;
                }
                Date skssqq = (Date)this.getModel().getValue("skssqq");
                Date skssqz = (Date)this.getModel().getValue("skssqz");
                if (skssqq == null || skssqz == null) {
                    args.setCancel(true);
                    return;
                }
                String declareLimit = TaxDeclareServiceHelper.getOrgLimit(orgId);
                String jtzq = DeadlineService.getCurrentTaxCycle(orgId);
                if ("aysb".equals(declareLimit) && "season".equals(jtzq) && !this.checkPeriod(skssqq, skssqz)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5141\u8bb8\u6bd4\u5bf9\u671f\u95f4\u4e3a\uff1a3\u30016\u30019\u300112\u6708\u3002", (String)"CitrtaEditMultiPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if ("unaudit".equals(operation) && (obj = this.service.queryOneVatRtaByBillno(billno = (String)this.getModel().getValue("billno"))) != null && obj.getBoolean("generatebusinessdoc")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u751f\u6210\u8ba1\u63d0\u5355\u7684\u6570\u636e\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"TccitDeclarationPlugin_39", (String)"taxc-tccit", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (fzjg = OrgGroupService.isFzjg(orgId, endDate = (Date)this.getModel().getValue("skssqz"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u7f16\u5236\u5e95\u7a3f\u3002", (String)"TccitDeclarationPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        FormOperate operate = (FormOperate)args.getSource();
        String entityId = operate.getEntityId();
        String operateName = operate.getOperateName().getLocaleValue();
        if ("viewjtdraft".equals(operateKey) || "viewsbb".equals(operateKey) || "viewsjjnd".equals(operateKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            if (org == null || skssqq == null || skssqz == null) {
                return;
            }
            if ("viewjtdraft".equals(operateKey)) {
                String templatetype = "draft_qysdsjb";
                List<Long> ids = this.service.querySjjtDraftIds(org.getLong(ID), templatetype, skssqq, skssqz);
                HashMap<String, Object> cusMap = new HashMap<String, Object>();
                cusMap.put("draftpurpose", "sjjt");
                cusMap.put("drafttype", "qysdsjb");
                this.showJointSearch("tccit_sjjt_list", ids, cusMap);
                OperatorDialogUtils.operateDialog((String)"CITRTA", (String)entityId, (String)operateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u8ba1\u63d0\u5e95\u7a3f\u6210\u529f\u3002", (String)"CitrtaEditMultiPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), this.getPageCache().get("billno")));
            } else if ("viewsbb".equals(operateKey)) {
                String oldPageId = this.getPageCache().get("declarepageid");
                IFormView childView = this.getView().getView(oldPageId);
                IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
                DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareData", DeclareResponseModel.class);
                List<Long> ids = this.service.querySbbIdsByCache(org.getLong(ID), "qysdsjb", skssqq, skssqz, responseModel);
                HashMap<String, Object> cusMap = new HashMap<String, Object>();
                cusMap.put("querytype", "qysdsjb");
                this.showJointSearch("tccit_query_report", ids, cusMap);
                OperatorDialogUtils.operateDialog((String)"CITRTA", (String)entityId, (String)operateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u7533\u62a5\u8868\u6210\u529f\u3002", (String)"CitrtaEditMultiPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), this.getPageCache().get("billno")));
            } else {
                String oldPageId = this.getPageCache().get("declarepageid");
                IFormView childView = this.getView().getView(oldPageId);
                IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
                DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareData", DeclareResponseModel.class);
                List<Long> sbbids = this.service.querySbbIdsByCache(org.getLong(ID), "qysdsjb", skssqq, skssqz, responseModel);
                List<Long> ids = this.service.queryPayRecordIds(org.getLong(ID), "qysdsjb", skssqq, skssqz, sbbids);
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("menu", "pay");
                customParams.put("declaretype", "qysdsjb");
                this.showJointSearch("bdtaxr_pay_record", ids, customParams);
                OperatorDialogUtils.operateDialog((String)"CITRTA", (String)entityId, (String)operateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u7a0e\u91d1\u7f34\u7eb3\u5355\u6210\u529f\u3002", (String)"CitrtaEditMultiPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), this.getPageCache().get("billno")));
            }
        } else if ("viewflowchart".equals(operateKey)) {
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            try {
                WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)this.getModel().getValue(ID), (OpenStyle)openStyle);
                OperatorDialogUtils.operateDialog((String)"CITRTA", (String)entityId, (String)operateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u6d41\u7a0b\u56fe\u6210\u529f\u3002", (String)"CitrtaEditMultiPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), this.getPageCache().get("billno")));
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"CitrtaEditMultiPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        } else if ("newjtd".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)args.getOperateKey(), (String)"tccit_citrta_query", (Object[])new Object[]{this.getModel().getValue(ID)}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                this.getView().showOperationResult(operationResult);
                return;
            }
            String msg = this.service.processJtdMsg(operationResult, entityId, operateName);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showSuccessNotification(msg);
            }
            this.getModel().setValue("generatebusinessdoc", (Object)true);
        } else if ("deletejtd".equals(operateKey) && args.getOperationResult().isSuccess()) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)args.getOperateKey(), (String)"tccit_citrta_query", (Object[])new Object[]{this.getModel().getValue(ID)}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                this.getView().showOperationResult(operationResult);
                return;
            }
            String msg = this.service.processJtdMsg(operationResult, entityId, operateName);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showSuccessNotification(msg);
            }
            this.getModel().setValue("generatebusinessdoc", (Object)false);
        } else if (StringUtil.equals((CharSequence)operateKey, (CharSequence)"checkjtd") && args.getOperationResult().isSuccess()) {
            Object id = this.getModel().getValue(ID);
            if (ObjectUtils.isNotEmpty((Object)id)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tccit_citrta_query");
                String appId = this.getView().getFormShowParameter().getAppId();
                ListShowParameter parameter = this.service.getProvistonBillPageParameter(appId, dynamicObject.getString("org.id"), dynamicObject.getString("taxsystem.id"), dynamicObject.getString("billno"), dynamicObject.getString("taxtype.number"));
                this.getView().showForm((FormShowParameter)parameter);
                String billEntity = dynamicObject.getDataEntityType().getName();
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"CitRtaListPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), this.getModel().getValue("billno"));
                OperatorDialogUtils.operateDialog((String)"zzs", (String)billEntity, (String)operateName, (String)operateDescription);
            } else {
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"CitRtaListPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), this.getModel().getValue("billno"));
                OperatorDialogUtils.operateDialog((String)"zzs", (String)entityId, (String)operateName, (String)operateDescription);
            }
        } else {
            super.afterDoOperation(args);
        }
    }

    private void showJointSearch(String entityName, List<Long> linkQueryPkIds, Map<String, Object> customParams) {
        if (CollectionUtils.isNotEmpty(linkQueryPkIds)) {
            this.getView().showForm((FormShowParameter)this.service.getJointSearchParameter(entityName, linkQueryPkIds, customParams));
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\u3002", (String)"CitRtaListPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]);
            if ("tccit_sjjt_list".equals(entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u67e5\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u201c\u5df2\u5ba1\u6838\u201d\u8ba1\u63d0\u5e95\u7a3f\u3002", (String)"CitRtaListPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]);
            }
            if ("tccit_query_report".equals(entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u67e5\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u201c\u7533\u62a5\u6210\u529f\u201d\u7533\u62a5\u8868\u3002", (String)"CitRtaListPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]);
            }
            this.getView().showErrorNotification(errorMsg);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TccitMainPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        Long orgId = org.getLong(ID);
        if (e.getProperty().getName().equals(ORG)) {
            super.propertyChanged(e);
            if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().getDate("skssqz") == null) {
                this.getPageCache().put("orgid", this.getModel().getDataEntity().getString("org.id"));
                return;
            }
            Object object = changeData[0].getNewValue();
            String orgid = StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue() ? ((DynamicObject)changeData[0].getOldValue()).get(ID).toString() : org.getString(ID);
            if (!this.checkArgsBeforeOpenInnerPage()) {
                return;
            }
            boolean checkResult = CitrtaService.orgCheck(this.getView(), orgid, appid, TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (checkResult) {
                this.getModel().beginInit();
                this.getModel().setValue(ORG, null);
                this.getModel().endInit();
                this.getView().updateView(ORG);
                return;
            }
            orgid = org.getString(ID);
            this.getPageCache().put("orgid", orgid);
            DynamicObject oldValueObj = (DynamicObject)changeData[0].getOldValue();
            this.getPageCache().put("oldorgid", null == oldValueObj ? null : oldValueObj.getString(ID));
            this.getModel().setValue(ID, null);
            this.getModel().setValue("generatebusinessdoc", (Object)false);
            this.getModel().setValue("billstatus", (Object)"A");
            this.initPeriod(this.getModel(), this.getPageCache(), orgid, null);
            if (this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
                this.getPageCache().remove("billno");
                this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
                this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
            }
        }
        if (this.isFzjg(org.getLong(ID), (Date)this.getModel().getValue("skssqz"))) {
            return;
        }
        if (e.getProperty().getName().equals("skssqq") || e.getProperty().getName().equals("skssqz")) {
            Date startDate = (Date)this.getModel().getValue("skssqq");
            Date endDate = (Date)this.getModel().getValue("skssqz");
            if (startDate == null || endDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77\u6216\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TccitMainPlugin_13", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            if (!this.checkArgsBeforeOpenInnerPage()) {
                return;
            }
            String declareLimit = TaxDeclareServiceHelper.getOrgLimit(orgId);
            String jtzq = DeadlineService.getCurrentTaxCycle(orgId);
            if ("aysb".equals(declareLimit) && "season".equals(jtzq) && !this.checkPeriod(startDate, endDate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5141\u8bb8\u6bd4\u5bf9\u671f\u95f4\u4e3a\uff1a3\u30016\u30019\u300112\u6708\u3002", (String)"CitrtaEditMultiPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            this.propertyChangedSq(e.getProperty().getName(), org.getString(ID));
        }
        this.init();
    }

    private void propertyChangedSq(String propertyName, String orgId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("date", this.getModel().getValue(propertyName));
        this.initPeriod(this.getModel(), this.getPageCache(), orgId, customParams);
        if (this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getPageCache().remove("billno");
            this.loadData(Long.valueOf(orgId), this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
        }
    }

    private void getDraftNumber(String sksqq, String sksqz) {
        String billno = this.getBillNumber(sksqq, sksqz);
        this.getModel().setValue("billno", (Object)billno);
        this.getModel().setDataChanged(false);
        this.getPageCache().put("billno", billno);
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        return "CITRTA";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(1);
        bizParamsMap.put("taxtype", "3");
        this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
        return bizParamsMap;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        ListView pView;
        List orgFilter;
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        Long orgId = RequestContext.get().getOrgId();
        if (parentView instanceof ListView && CollectionUtils.isNotEmpty((Collection)(orgFilter = (pView = (ListView)parentView).getControlFilters().getFilter("org.id"))) && StringUtils.isNotBlank((CharSequence)((String)orgFilter.get(0)))) {
            orgId = Long.valueOf((String)orgFilter.get(0));
        }
        long userId = RequestContext.get().getCurrUserId();
        String entityid = view.getEntityId();
        String appid = view.getFormShowParameter().getAppId();
        List<Long> orgList = this.service.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
        if (CollectionUtils.isNotEmpty(orgList)) {
            if (orgList.contains(orgId)) {
                this.getPageCache().put("orgid", orgId.toString());
                return orgId;
            }
            return orgList.get(0);
        }
        return null;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String billno = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        this.getModel().setValue("billno", (Object)billno);
        this.getPageCache().put("billno", billno);
        return customParams;
    }

    protected QFilter getDeclareMainQueryParams() {
        return null;
    }

    protected String getUniKey() {
        logger.info("getUniKey");
        String orgId = this.getPageCache().get("orgid");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        return String.format("%1s_%2s_%3s_%4s", orgId, skssq, skssz, this.getTemplateType());
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        if (StringUtils.isNotBlank((CharSequence)billstatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritemap", "viewflowchart"});
            if (Arrays.asList("new", "A", "B").contains(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"newjtd"});
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"newjtd"});
            }
            if (!"new".equals(billstatus)) {
                this.getModel().setValue("billstatus", (Object)billstatus);
            }
        }
    }

    protected boolean viewDialog() {
        return false;
    }

    private String getBillNumber(String skssqq, String skssqz) {
        DynamicObject dynamicObject = this.checkRecordIsExist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), this.getPageCache().get("orgid"), this.getTemplateType(), skssqq, skssqz);
        if (dynamicObject == null) {
            return this.createNumber();
        }
        return dynamicObject.getString("billno");
    }

    private String createNumber() {
        String billno = this.getPageCache().get("billno");
        if (StringUtils.isNotBlank((CharSequence)billno)) {
            return billno;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (org == null || skssqq == null || skssqz == null) {
            return null;
        }
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"tccit_citrta_query");
        object.set(ORG, (Object)org);
        object.set("skssqq", (Object)skssqq);
        object.set("skssqz", (Object)skssqz);
        return DeclareServiceHelper.generateSBBNo((String)"tccit_citrta_query", (DynamicObject)object, (String)org.getString(ID));
    }

    private DynamicObject checkRecordIsExist(String maintable, String orgid, String type, String startDate, String endDate) {
        if (ObjectUtils.anyNull((Object[])new Object[]{maintable, orgid, type, startDate, endDate})) {
            return null;
        }
        return YbnsrService.queryMultiDeclareMain((String)maintable, (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)this.getDeclareMainQueryParams());
    }

    private boolean checkNewAddReportPermis(String appId, String entity, String orgid, String skssqq, String skssqz) {
        Long orgId;
        List<Long> allPermOrgs;
        DynamicObject dynamicObject = this.checkRecordIsExist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), orgid, this.getTemplateType(), skssqq, skssqz);
        return dynamicObject != null || (allPermOrgs = OrgGroupService.getAllPermOrgs(appId, entity, "47156aff000000ac")).contains(orgId = Long.valueOf(Long.parseLong(orgid)));
    }
}

