/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.draft;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.PageIdUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.draft.TypesProviderService;
import kd.taxc.tccit.business.policy.YearPolicyService;

public class DraftPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        Date startDate = DateUtils.stringToDate((String)skssqq);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        DynamicObject policy = YearPolicyService.getPolicy(Long.parseLong(orgid), startDate, endDate);
        if (policy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u653f\u7b56\u786e\u8ba4\u672a\u5b8c\u6210\u3002", (String)"DraftPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        Object category = customParams.get("category");
        DynamicObjectCollection dcs = TypesProviderService.getTypes(policy, category, "dg", "order");
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(32);
        for (DynamicObject obj : dcs) {
            if ("A100000-5".equals(obj.getString("number")) || "A105001".equals(obj.getString("number")) || "A105002".equals(obj.getString("number")) || "A100000-6".equals(obj.getString("number")) || "B105059".equals(obj.getString("number"))) continue;
            TreeNode leftRoot = new TreeNode();
            String id = obj.getString("id");
            String title = obj.getString("title");
            String number = obj.getString("number");
            String parentid = obj.getString("parent");
            leftRoot.setId(id);
            leftRoot.setText(title);
            leftRoot.setType(number);
            leftRoot.setParentid(parentid);
            nodeList.add(leftRoot);
        }
        List treeNodes = TreeUtils.buildWithChildren(nodeList);
        CustomControl s = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("treeData", treeNodes);
        data.put("pageid", PageIdUtils.getPageId((IFormView)this.getView()));
        Object sheetName = customParams.get("sheetname");
        if (StringUtils.isBlank(sheetName) && !CollectionUtils.isEmpty((Collection)treeNodes)) {
            sheetName = ((TreeNode)treeNodes.get(0)).getType();
        }
        data.put("selected", sheetName);
        s.setData(data);
    }

    public void customEvent(CustomEventArgs e) {
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)e.getEventArgs(), Map.class);
        String number = (String)argsMap.get("number");
        this.getPageCache().put("sheetname", number);
        OpenDraftService.openDraftPage(this.getView(), number);
    }

    public void showDetailDialog(String cellid, JSONObject params) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (Map.Entry entry : params.entrySet()) {
            customParams.put(entry.getKey(), entry.getValue());
        }
        customParams.put("cellid", cellid);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tccit_detail_tz_dialog", (IFormView)this.getView(), (Map)customParams, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        if ("tccit_detail_tz_dialog".equals(event.getActionId()) && (returnData = (Map)event.getReturnData()) != null) {
            String cellid = (String)returnData.get("cellid");
            String adjustsumamount = (String)returnData.get("adjustsumamount");
            IPageCache cache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            FormulaService.cal((IPageCache)cache, (String)cellid, (String)adjustsumamount);
            FormulaService.save((IPageCache)cache);
            OpenDraftService.openDraftPage(this.getView(), this.getPageCache().get("sheetname"));
        }
    }
}

