/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.draft;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import org.apache.commons.lang3.StringUtils;

public class JobDispatchFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_JOBDISPATCH = "btnjobdispatch";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_JOBDISPATCH});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_JOBDISPATCH, (CharSequence)source.getKey())) {
            this.dispatch();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void dispatch() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("tccit");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("test job");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.taxc.tccit.business.calc.MyTask");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("time", 80);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"JobDispatchFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.taxc.tccit.business.calc.YearCalcTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            this.getView().showMessage(data);
        }
    }
}

