/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.draft;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.DraftPluginDto;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.AbstractDraftPlugin;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.YearCalcTask;
import kd.taxc.tccit.business.draft.DraftService;
import kd.taxc.tccit.business.engine.BranchTaxpayEngine;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.policy.YearPolicyService;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;
import kd.taxc.tccit.common.utils.DateRangeUtils;
import org.apache.commons.collections.CollectionUtils;

public class TccitMainPlugin
extends AbstractDraftPlugin {
    private static Log logger = LogFactory.getLog(TccitMainPlugin.class);
    protected static final String TEMPLATE_TYPE = "draft_qysdsnb";
    public static final String DECLARETYPE = "declaretype";
    public static final String ORG_LIST = "orglist";
    public static final String CONTENT = "tabcontent";
    private static final List<IEngine> engineListyj = new ArrayList<IEngine>();
    private static final Map<String, String> STEP_CATEGORY;

    public TccitMainPlugin() {
        super.setDeclarePageMap(TaxStepsConstant.getTccitYear());
    }

    public String getTemplateType() {
        return TEMPLATE_TYPE;
    }

    protected void loadData(Date startDate, Date endDate) {
        String orgId = this.getPageCache().get("orgid");
        DynamicObject object = this.queryDynamicObject("1", TEMPLATE_TYPE, orgId, DateUtils.format((Date)startDate), DateUtils.format((Date)endDate));
        String declaretype = object != null ? object.getString(DECLARETYPE) : this.getDeclaretype();
        String focuspage = this.getPageCache().get("focuspage");
        if ("311".equals(declaretype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fzflexap"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"fzflexap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"hzflexap"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"recalc", "refetch", CONTENT});
            this.showInnerTbPage("6", this.getPageCache().get("orgid"));
        } else {
            if ("312".equals(declaretype)) {
                if (null == focuspage) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"fzflexap"});
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u4e0d\u5c31\u5730\u5e74\u62a5\u6240\u5f97\u7a0e\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u72ec\u7acb\u7533\u62a5\uff01", (String)"TccitMainPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"recalc", "refetch", "forward", "next", "createsbb"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"hzflexap", CONTENT});
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"fzflexap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"hzflexap"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"hzflexap"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"recalc", "refetch"});
            this.showInnerTbPage("1", this.getPageCache().get("orgid"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date newValue;
        String name = e.getProperty().getName();
        if ((name.equals("skssqq") || name.equals("skssqz")) && (newValue = (Date)e.getChangeSet()[0].getNewValue()) != null) {
            Map<String, Date> dateRange = DateRangeUtils.getDateRange(this.getTaxLimits()[0], newValue);
            this.getModel().setValue("skssqq", (Object)dateRange.get("startdate"));
            this.getModel().setValue("skssqz", (Object)dateRange.get("enddate"));
        }
        super.propertyChanged(e);
    }

    public Map<String, Object> createCustomParams(String orgId, String startdate, String enddate, String status, String focuspage) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        if (Integer.parseInt(status) < Integer.parseInt(focuspage)) {
            customParams.put("refresh", Boolean.TRUE.toString());
            if (Integer.parseInt(focuspage) != 2) {
                StatusUtils.updateStatus((String)this.getTemplateType(), (String)orgId, (String)startdate, (String)enddate, (String)focuspage, (String)"nssb");
            }
        }
        if ("2".equals(focuspage) || "3".equals(focuspage) || "4".equals(focuspage)) {
            customParams.put("category", STEP_CATEGORY.get(focuspage));
            customParams.put("ParentCache", "true");
            Date startDate = DateUtils.stringToDate((String)startdate);
            Date endDate = DateUtils.stringToDate((String)enddate);
            List<String> orglist = new ArrayList<String>();
            DynamicObject policy = YearPolicyService.getPolicy(Long.parseLong(orgId), startDate, endDate);
            if (policy != null) {
                DynamicObjectCollection treeentryentity = policy.getDynamicObjectCollection("treeentryentity");
                orglist = treeentryentity.stream().map(e -> e.getString("taxorg_id")).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(orglist)) {
                orglist.add(orgId);
            }
            customParams.put(ORG_LIST, orglist);
        } else if ("5".equals(focuspage)) {
            customParams.put("templatetype", this.getTemplateType());
            customParams.put("ParentCache", "true");
        } else if ("6".equals(focuspage) || "7".equals(focuspage)) {
            customParams.put("category", STEP_CATEGORY.get(focuspage));
            customParams.put("ParentCache", "true");
            ArrayList<String> orglist = new ArrayList<String>();
            orglist.add(orgId);
            customParams.put(ORG_LIST, orglist);
        }
        return customParams;
    }

    public boolean checkBeforeNextStep(String orgId, String startdate, String enddate, String status, String focusPage) {
        if (StringUtil.isBlank((CharSequence)startdate) || StringUtil.isBlank((CharSequence)enddate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77\u6216\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TccitMainPlugin_13", (String)"taxc-tccit", (Object[])new Object[0]));
            return false;
        }
        if ("1".equals(status) && "2".equals(focusPage) || "6".equals(status) && "7".equals(focusPage)) {
            DataResultVo dataResultVo;
            String declaretype;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TccitMainPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                return false;
            }
            IFormView policyview = this.getView().getView(this.getPageCache().get("declarepageid"));
            DynamicObject registertype = (DynamicObject)policyview.getModel().getValue("registertype");
            if (registertype != null && registertype.getString("longnumber").startsWith("400")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u529f\u80fd\u672a\u5411\u4e2a\u4f53\u7ecf\u8425\u4f01\u4e1a\u5f00\u653e\uff0c\u8bf7\u5728\u57fa\u7840\u8d44\u6599\u4fee\u6539\u4f01\u4e1a\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b", (String)"TccitMainPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
                return false;
            }
            DynamicObject policy = this.queryDynamicObject("1", TEMPLATE_TYPE, orgId, startdate, enddate);
            String string = declaretype = policy != null ? policy.getString(DECLARETYPE) : this.getDeclaretype();
            if (!"311".equals(declaretype)) {
                Optional<DynamicObject> exists;
                DynamicObjectCollection treeentryentity = policyview.getModel().getEntryEntity("treeentryentity");
                Optional<DynamicObject> first = treeentryentity.stream().filter(s -> "2".equals(s.get("declaration"))).findFirst();
                if (first.isPresent() && QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("id", "=", first.get().get("taxorg.id")), new QFilter("istaxpayer", "=", (Object)"0")})) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u603b\u7ec4\u7ec7\u4e3a\u975e\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u4fdd\u5b58\u5931\u8d25, \u8bf7\u4fee\u6539\u6c47\u603b\u65b9\u6848\u3002", (String)"TccitMainPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                    return false;
                }
                DynamicObjectCollection bastaxTaxorgList = QueryServiceHelper.query((String)"bastax_taxorg", (String)"status,org.name as name,org.id as id", (QFilter[])new QFilter[]{new QFilter("id", "in", treeentryentity.stream().map(s -> s.get("taxorg.id")).collect(Collectors.toList())), new QFilter("status", "=", (Object)"0")});
                List thirdOrgs = treeentryentity.stream().filter(e -> "312".equals(e.getString("kdqjyqylx"))).map(s -> s.getLong("taxorg.id")).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty((Collection)bastaxTaxorgList) && (exists = bastaxTaxorgList.stream().filter(e -> !thirdOrgs.contains(e.getLong("id"))).findFirst()).isPresent()) {
                    StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728", (String)"TccitMainPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
                    for (DynamicObject object : bastaxTaxorgList) {
                        builder.append(String.format(ResManager.loadKDString((String)"\u3010%s\u3011", (String)"TccitMainPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), object.getString("name")));
                    }
                    builder.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7981\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u4fee\u6539\u6c47\u603b\u65b9\u6848\u540e\u540c\u6b65\u66f4\u65b0\u5206\u652f\u673a\u6784\u5206\u644a\u53f0\u8d26", (String)"TccitMainPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.getView().showErrorNotification(builder.toString());
                    return false;
                }
            }
            if (!(dataResultVo = BranchTaxbookBusinessService.checkBrankShare(Long.parseLong(orgId), DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate))).getSuccess().booleanValue()) {
                this.getView().showErrorNotification(dataResultVo.getMessage());
                return false;
            }
            if (StringUtil.isNotBlank((CharSequence)dataResultVo.getMessage())) {
                this.getView().showTipNotification(dataResultVo.getMessage());
            }
        }
        return true;
    }

    protected DynamicObject queryDynamicObject(String focuspage, String templateType, String orgId, String startdate, String enddate) {
        Date startDate = DateUtils.stringToDate((String)startdate);
        Date endDate = DateUtils.stringToDate((String)enddate);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter[] filters = new QFilter[]{orgFilter, skssqqzFilter};
        DynamicObject object = Optional.ofNullable(QueryServiceHelper.queryOne((String)"tccit_branch_confpolicy", (String)"id,declaretype", (QFilter[])filters)).orElseGet(() -> QueryServiceHelper.queryOne((String)"tccit_policy_confirm", (String)"id,declaretype", (QFilter[])filters));
        return object;
    }

    protected void deleteAllDraftData(String templateType, String orgId, String startdate, String enddate) {
        Date startDate = DateUtils.stringToDate((String)startdate);
        Date endDate = DateUtils.stringToDate((String)enddate);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        DeleteServiceHelper.delete((String)"tccit_branch_confpolicy", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tccit_policy_confirm", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        QFilter typeFilter = new QFilter("templatetype", "=", (Object)templateType);
        DynamicObject dgobject = QueryServiceHelper.queryOne((String)"tccit_year_dg_bill", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgId)), skssqqzFilter, typeFilter});
        if (dgobject != null) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dgobject.get("id"), (String)"tccit_year_dg_bill");
            object.set("ismodified", (Object)0);
            object.set("fetchstatus", (Object)"0");
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
        long orgid = Long.parseLong(orgId != null && !"".equals(orgId) ? orgId : "0");
        TemplateUtils.deleteReport((Long)orgid, (String)"qysdsnb_dg", (Date)DateUtils.stringToDate((String)startdate), (Date)DateUtils.stringToDate((String)enddate), null);
    }

    protected String[] getTaxLimits() {
        return new String[]{"year"};
    }

    protected void setButtonVisible(String focuspage) {
        if ("6".equals(focuspage)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"forward", "edit", "submit", "createsbb", "save", "cancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"next", "refresh"});
            super.setButtonVisible("1");
        } else if ("8".equals(focuspage)) {
            if ("A".equals(this.getPageCache().get("cache_billstatus")) || StringUtils.isBlank((CharSequence)this.getPageCache().get("cache_billstatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"next"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"submit", "recalc", "refetch", "createsbb", "refresh"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"next", "submit", "edit", "save", "cancel", "recalc", "refetch"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb", "forward", "refresh"});
            }
            super.setButtonVisible(focuspage);
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
        } else if ("2".equals(focuspage)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"forward"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"next"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
            super.setButtonVisible(focuspage);
        } else if ("5".equals(focuspage)) {
            if ("A".equals(this.getPageCache().get("cache_billstatus")) || StringUtils.isBlank((CharSequence)this.getPageCache().get("cache_billstatus"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submit", "unsubmit", "recalc", "recalc", "refetch"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"audit", "unaudit", "viewflowchart"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"submit"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"unsubmit"});
            } else if ("B".equals(this.getPageCache().get("cache_billstatus"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submit", "unsubmit", "audit", "unaudit", "viewflowchart"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"recalc", "refetch"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"unsubmit", "audit"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"submit", "unaudit"});
            } else if ("C".equals(this.getPageCache().get("cache_billstatus"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submit", "unsubmit", "audit", "unaudit", "viewflowchart"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"recalc", "refetch"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"unaudit"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"submit", "unsubmit", "audit"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb", "forward"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "next", "save", "cancel"});
        } else {
            super.setButtonVisible(focuspage);
        }
        if ("B".equals(this.getPageCache().get("cache_billstatus")) || "C".equals(this.getPageCache().get("cache_billstatus"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb"});
            if ("B".equals(this.getPageCache().get("cache_declarestatus")) || "C".equals(this.getPageCache().get("cache_declarestatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit", "unsubmit", "audit", "unaudit", "createsbb"});
                if ("5".equals(focuspage)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb"});
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String itemKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (itemKey = afterDoOperationEventArgs.getOperateKey()) {
            case "unsubmit": 
            case "unaudit": {
                this.setBtnStatus();
            }
        }
    }

    private void setBtnStatus() {
        if ("5".equals(this.getPageCache().get("focuspage"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"submit", "unsubmit", "recalc"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"audit", "unaudit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"createsbb"});
        }
    }

    protected String getJobName() {
        return ResManager.loadKDString((String)"\u5e74\u62a5\u91cd\u65b0\u8ba1\u7b97\u4efb\u52a1", (String)"TccitMainPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    protected String getTaskClassName() {
        return YearCalcTask.class.getName();
    }

    public void taskEndCallBack(TaskInfo taskInfo) {
        String data = taskInfo.getData();
        Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        String calcType = (String)customs.get("calcType");
        String orgId = (String)customs.get("orgid");
        String startdate = (String)customs.get("skssqq");
        String enddate = (String)customs.get("skssqz");
        String focuspage = (String)customs.get("focuspage");
        DynamicObject yearDgBill = DraftService.getYearDgBill(Long.parseLong(orgId), DateUtils.stringToDate2((String)startdate), DateUtils.stringToDate2((String)enddate));
        yearDgBill.set("fetchstatus", (Object)"2");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearDgBill});
        if ("refetch".equals(calcType)) {
            try {
                String pageid = this.getPageCache().get("declarepageid");
                IFormView childView = this.getView().getView(pageid);
                childView.invokeOperation("refresh");
                this.getView().sendFormAction(childView);
            }
            catch (Exception e) {
                this.showInnerTbPage(focuspage, (String)customs.get("orgid"));
                logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        } else {
            this.showInnerTbPage("2", (String)customs.get("orgid"));
        }
    }

    protected void runEngineBeforeNextStep(DraftPluginDto draftPluginDto) {
        String orgId = draftPluginDto.getOrgId();
        String startdate = draftPluginDto.getStartDate();
        String enddate = draftPluginDto.getEndDate();
        String status = draftPluginDto.getStatus();
        String focusPage = draftPluginDto.getFocusPage();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject yearDgBill = DraftService.getYearDgBill(Long.parseLong(orgId), DateUtils.stringToDate2((String)startdate), DateUtils.stringToDate2((String)enddate));
        String fetchstatus = Optional.ofNullable(yearDgBill).filter(s -> StringUtil.isNotBlank((CharSequence)s.getString("fetchstatus"))).map(s -> s.getString("fetchstatus")).orElseGet(() -> "0");
        if (Integer.parseInt(status) == 1 && Integer.parseInt(focusPage) == 2 && "0".equals(fetchstatus)) {
            String declaretype = this.getPageCache().get(DECLARETYPE);
            draftPluginDto.setAsyn("1");
            this.dispatch(orgId, startdate, enddate, declaretype, "recalc", Boolean.TRUE, focusPage);
        } else if (Integer.parseInt(focusPage) == 7) {
            customParams.put("orgid", orgId);
            customParams.put("skssqq", startdate);
            customParams.put("skssqz", enddate);
            ArrayList<Long> orglist = new ArrayList<Long>();
            orglist.add(Long.parseLong(orgId));
            customParams.put(ORG_LIST, orglist);
            customParams.put(DECLARETYPE, this.getPageCache().get(DECLARETYPE));
            EngineModel engineModel = this.createEngineModel(customParams, orgId, startdate, enddate);
            try (TXHandle h = TX.required();){
                try {
                    for (IEngine engine : engineListyj) {
                        engine.deleteData(engineModel);
                        engine.runEngine(engineModel);
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw t;
                }
            }
        }
    }

    private EngineModel createEngineModel(Map<String, Object> customParams, String orgid, String startdate, String enddate) {
        EngineModel engineModel = new EngineModel(orgid, startdate, enddate);
        String declaretype = (String)customParams.get(DECLARETYPE);
        engineModel.addCustom(ORG_LIST, customParams.get(ORG_LIST));
        engineModel.addCustom(DECLARETYPE, (Object)declaretype);
        return engineModel;
    }

    protected String getNumberPrefix() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        String billType = DeclareCompanyTypeUtils.getDgType((String)org.getString("id"), (String)DateUtils.format((Date)skssqz), (String)"year");
        return "CIT-" + billType;
    }

    protected String getMsg() {
        return ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u5c06\u5bfc\u81f4\u539f\u6709\u5e95\u7a3f\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"TccitMainPlugin_12", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("recalc".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            String orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(o -> o.getString("id")).orElseGet(() -> null);
            String startdate = Optional.ofNullable((Date)this.getModel().getValue("skssqq")).map(date -> DateUtils.format((Date)date)).orElseGet(() -> "");
            String enddate = Optional.ofNullable((Date)this.getModel().getValue("skssqz")).map(date -> DateUtils.format((Date)date)).orElseGet(() -> "");
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TccitMainPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            String templateType = this.getTemplateType();
            EngineHandler handler = EngineHandlerFactory.createHandler((String)TemplateEnum.getEnumByDraftType((String)templateType).getDeclareType());
            EngineModel engineModel = new EngineModel(orgId, startdate, enddate);
            engineModel.getCustom().put("remove_adjust_by_hand", Boolean.TRUE);
            handler.getEngineList().forEach(engine -> engine.deleteData(engineModel));
            this.deleteAllDraftData(templateType, orgId, startdate, enddate);
            String declaretype = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgId, (String)enddate);
            if ("311".equals(declaretype)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fzflexap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"hzflexap"});
                this.deletefzdata(orgId, startdate, enddate);
                StatusUtils.updateStatus((String)templateType, (String)orgId, (String)startdate, (String)enddate, (String)"6", (String)"nssb");
                this.showInnerTbPage("6", orgId);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"fzflexap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"hzflexap"});
                StatusUtils.updateStatus((String)templateType, (String)orgId, (String)startdate, (String)enddate, (String)"1", (String)"nssb");
                this.showInnerTbPage("1", orgId);
            }
        } else {
            super.confirmCallBack(e);
        }
    }

    private void deletefzdata(String orgId, String startdate, String enddate) {
        Date startDate = DateUtils.stringToDate((String)startdate);
        Date endDate = DateUtils.stringToDate((String)enddate);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter endFilter = new QFilter("skssqz", "=", (Object)endDate);
        DeleteServiceHelper.delete((String)"tccit_seasonal_calc_det", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
    }

    private String getDeclaretype() {
        String orgId = this.getPageCache().get("orgid");
        String enddate = this.getPageCache().get("skssqz");
        String declaretype = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgId, (String)enddate);
        return declaretype;
    }

    public String getAttachmentFieldName() {
        return "attachmentpanelap";
    }

    public String getAttachmentPanelName() {
        return "flexpanelapat";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    static {
        engineListyj.add(new BranchTaxpayEngine());
        STEP_CATEGORY = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("2", "qrlr");
                this.put("3", "sdstz");
                this.put("4", "sejs");
            }
        };
    }
}

